/**
 * \ingroup pack
 *
 * \file common.h
 */
#ifndef __COMMON_H
#define __COMMON_H
#include <stdint.h>
#define SDU_HDR_LEN (3)
#define MINREQBKLEN (2048)
#define MSGID_AND_LEN    (4)
#define MSGID_DONT_CARE (0xffff)

#ifndef UNUSEDPARAM
#define UNUSEDPARAM( x ) (void)x
#endif 

#define DEAULT_LOC_TIMEOUT_IN_SEC 2
#define SDK_VALIDATE_INPUT_PACK_PARAM(pCtx, pBuf, pLen ) \
    if ((pCtx == NULL) || (pBuf == NULL) || (pLen == NULL) ) \
        {\
        libpack_log(eLOG_DEBUG,"[  pack] %s parameter NULL\n",__func__); \
        return eQCWWAN_ERR_INVALID_ARG; \
        }

typedef void (* logger)(uint8_t lvl, const char* buff);

extern logger glog;
extern uint8_t gloglvl;

/**
 * log levels
 */
enum eLOG_LEVEL{
    eLOG_INFO,
    eLOG_DEBUG,
    eLOG_WARN,
    eLOG_FATAL
};

/**
 *  eTimeout
 **/
enum eTimeout
{
    eTIMEOUT_2_S        = 2000,
    eTIMEOUT_5_S        = 5000,
    eTIMEOUT_8_S        = 8000,
    eTIMEOUT_10_S       = 10000,
    eTIMEOUT_20_S       = 20000,
    eTIMEOUT_30_S       = 30000,
    eTIMEOUT_60_S       = 60000,
    eTIMEOUT_300_S      = 300000,
    eTIMEOUT_DEFAULT    = eTIMEOUT_8_S
};

/**
 * qmi service
 */
enum eQMI_SVC{
    eCTL,
    eWDS,
    eDMS,
    eNAS=3,
    eQOS,
    eSMS=5,
    eUIM=0x0B,
    eLOC=0x10,
    eSWIOMA=240,
    eSWILOC=246,
};

/**
 * qmi message type
 */
enum msgtype{
    eREQ=0,
    eRSP=2,
    eIND=4
};

/**
 * qmi request context
 * @param[in] xid transaction id
 * @param[out] timeout timeout recommended in seconds
 * @param[out] msgid message id
 * @param[out] svc qmi service
 */
typedef struct{
    uint16_t    xid;
    int         timeout;
    uint16_t    msgid;
    uint8_t     svc;
} pack_qmi_t;

/**
 * qmi response context
 * @param[out] type message type
 * @param[out] msgid message id
 * @param[out] xid transaction id
 */
typedef struct{
    enum msgtype    type;
    uint16_t        msgid;
    uint16_t        xid;
} unpack_qmi_t;

uint16_t helper_get_xid(uint8_t *qmi_resp);

/**
 * extract msgid/xid/type from modem reply
 * @param[in] svc qmi service
 * @param[in] pbuf qmi response/indication
 * @param[in] len response/indication length
 * @param[out] pCtx unpacked context
 * @return qmi message string
 */
const char* helper_get_resp_ctx(
        uint8_t svc,
        uint8_t *pbuf,
        uint32_t len,
        unpack_qmi_t *pCtx
        );

/**
 * common handler for unpacking response with TLV type 0x02 only
 */
unsigned unpack_result_code_only(
        uint8_t  *pMdmResp);

/**
 * set log function
 */
int helper_set_log_func(logger func);

void libpack_log(
        uint8_t lvl,
        const char* fmt, ...
        );

/**
 * set log level
 */
int helper_set_log_lvl(uint8_t lvl);

//internal helper for pack/unpack function
void fill_sdu_hdr(
        pack_qmi_t *pCtx,
        uint8_t *pReqBuf
        );

void fill_pack_ctx(
        pack_qmi_t *pCtx,
        uint8_t *pReqBuf,
        uint16_t *pLen,
        uint8_t svc,
        int timeout
        );
/**
 * @return version string
 */
char* get_version();
#endif
