#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "packingdemo.h"

#include "wds.h"

#define PKT_STAT_STAT_MASK 0X0000003F
#define BYT_STAT_STAT_MASK 0X000000C0

#define QMI_WDS_CURRENT_CALL_DB_MASK 0x01
#define QMI_WDS_LAST_CALL_DB_MASK    0x02


#define QMI_WDS_MSG_MAX QMI_MSG_MAX

#define PROFILEID_1 1
#define PROFILEID_3 3

enum {
    eProfile1Slot=0,
    eProfile3Slot=1,
};

int wds=-1;
uint8_t g_profileIndex;

uint16_t setdfltpfl_xid;
uint16_t getbytestotal_xid;

void *wds_read_thread(void* ptr);


unpack_wds_SLQSGetRuntimeSettings_t runtimeinfo;
unpack_wds_GetSessionState_t stateinfo;
unpack_wds_GetConnectionRate_t connrate;
unpack_wds_GetSessionDuration_t sessionduration;
unpack_wds_GetDormancyState_t   dormancystate;
unpack_wds_SLQSGet3GPPConfigItem_t  get3GPPconfigitem = {
   {0},
   0,
   0,
   {0},
   MAX_WDS_3GPP_CONF_LTE_ATTACH_PROFILE_LIST_SIZE,
};
unpack_wds_GetMobileIP_t  mipMode;
unpack_wds_SLQSGetCurrDataSystemStat_t dataStat;
unpack_wds_GetLastMobileIPError_t mobileIPError;


void dump_GetSessionState(void* ptr)
{
    /* expected result */
    unpack_wds_GetSessionState_t *psessionstate =
        (unpack_wds_GetSessionState_t*) ptr;
    printf("sessionstate: %d\n", psessionstate->connectionStatus);
    
#if DEBUG_LOG_TO_FILE
    FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        uint32_t connection_status = 2; /* connected */
        fprintf(fp, "%-10s\n", ((connection_status==psessionstate->connectionStatus) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_wds_SLQSCreateProfile(void* ptr)
{
    unpack_wds_SLQSCreateProfile_t *result =
        (unpack_wds_SLQSCreateProfile_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s profile id: %d\n",__FUNCTION__, *result->pProfileID);

#if DEBUG_LOG_TO_FILE
    FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* expected result, profile id should not equal to 0 */
        fprintf(fp, "%-10s\n", ((0 !=  *result->pProfileID )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_wds_SLQSGetProfileSettings(void* ptr)
{
    unpack_wds_SLQSGetProfileSettings_t *result =
        (unpack_wds_SLQSGetProfileSettings_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    if(result->pProfileSettings->curProfile.SlqsProfile3GPP.pAPNName==NULL)
        printf("%s APN: NULL\n",__FUNCTION__);
    else
    {
        char *szString = (char*)result->pProfileSettings->curProfile.SlqsProfile3GPP.pAPNName;
    printf("%s APN: %s:%d\n",__FUNCTION__,
        szString,
        (int)*(result->pProfileSettings->curProfile.SlqsProfile3GPP.pAPNnameSize));
    }

#if DEBUG_LOG_TO_FILE
    FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* expected result, profile id should not equal to 0 */
        fprintf(fp, "%-10s\n", ((NULL != result->pProfileSettings->curProfile.SlqsProfile3GPP.pAPNName )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_wds_SLQSModifyProfile(void* ptr)
{
    UNUSEDPARAM(ptr);
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
    }

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_wds_SLQSSetWdsEventCallback(void* ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_wds_SLQSStartDataSession(void* ptr)
{
    unpack_wds_SLQSStartDataSession_t *pstartdatas =
        (unpack_wds_SLQSStartDataSession_t*) ptr;

    printf("%s Data\n",__FUNCTION__);
    printf("Data Session ID: 0x%X\n", *pstartdatas->psid);
    printf("failure reason: %u\n", *pstartdatas->pFailureReason);
    printf("verbose failure reason type: %u\n", *pstartdatas->pVerboseFailReasonType);
    printf("verbose failure reason : %u\n", *pstartdatas->pVerboseFailureReason);

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}
void dump_wds_SLQSStopDataSession(void* ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_GetConnectionRate(void* ptr)
{
    unpack_wds_GetConnectionRate_t *pconnrate =
        (unpack_wds_GetConnectionRate_t*) ptr;
    printf("current ch tx rate: 0x%X\n", pconnrate->currentChannelTXRate);
    printf("current ch rx rate: 0x%X\n", pconnrate->currentChannelRXRate);
    printf("max tx rate: 0x%X\n", pconnrate->maxChannelTXRate);
    printf("max rx rate: 0x%X\n", pconnrate->maxChannelRXRate);
#if DEBUG_LOG_TO_FILE
    FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* expected result, max connection rate should be larger than 0 */
        fprintf(fp, "%-10s\n", ((0 < pconnrate->maxChannelTXRate )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_GetSessionDuration(void* ptr)
{

    unpack_wds_GetSessionDuration_t *psessionduration =
        (unpack_wds_GetSessionDuration_t*) ptr;
    printf("session duration: %lld\n", (unsigned long long) psessionduration->callDuration);
#if DEBUG_LOG_TO_FILE
    FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* expected result, duration should be larger than 0 */
        fprintf(fp, "%-10s\n", ((0 < psessionduration->callDuration )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif 
}

void dump_GetDormancyState(void* ptr)
{
    /* expected result, dormancy status should be 2 (channel active) */
    unpack_wds_GetDormancyState_t *pdormancystate =
        (unpack_wds_GetDormancyState_t*) ptr;
    printf("dormancy state: %d\n", pdormancystate->dormancyState);

#if DEBUG_LOG_TO_FILE
    FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        uint32_t state = 2; /* channel active */
        fprintf(fp, "%-10s\n", ((state==pdormancystate->dormancyState) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSSet3GPPConfigItem(void* ptr)
{
   UNUSEDPARAM(ptr);
#if DEBUG_LOG_TO_FILE
   FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SetDefaultProfileNum(void* ptr)
{
   UNUSEDPARAM(ptr);
#if DEBUG_LOG_TO_FILE
   FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_GetDefaultProfileNum(void* ptr)
{
    unpack_wds_GetDefaultProfileNum_t *p =
        (unpack_wds_GetDefaultProfileNum_t*) ptr;
    printf("default profile number: %d\n", p->index);
#if DEBUG_LOG_TO_FILE
   FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSGet3GPPConfigItem(void* ptr)
{
    unpack_wds_SLQSGet3GPPConfigItem_t *p3gppconfigitem =
        (unpack_wds_SLQSGet3GPPConfigItem_t*) ptr;
    uint8_t    count;
    for( count = 0; count < 4; count++ )
     {
         printf( "\n\tprofileList[%d] : %d",
                  count,
                  p3gppconfigitem->profileList[count] );
     }
    printf( "\nDefault PDN enabled : %d",
            p3gppconfigitem->defaultPDNEnabled );
    printf( "\n3gppRelease : %d\n",
            p3gppconfigitem->_3gppRelease );

    printf("LTE attach profile list: %d", p3gppconfigitem->LTEAttachProfileListLen);
    for( count = 0; count < p3gppconfigitem->LTEAttachProfileListLen; count++ )
     {
         printf( "\n\tLTEAttachProfileList[%d] : %d",
                  count,
                  p3gppconfigitem->LTEAttachProfileList[count] );
     }
    printf("\n");

#if DEBUG_LOG_TO_FILE
    /* expected result */
    unpack_wds_SLQSGet3GPPConfigItem_t config_item;
    config_item.profileList[0] = 1;
    uint8_t is_matching = 0;
    FILE *fp;

    if ( config_item.profileList[0] == p3gppconfigitem->profileList[0] )
    {
        is_matching = 1;
    }

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_GetMobileIP(void* ptr)
{   
    unpack_wds_GetMobileIP_t *pMobileIP =
        (unpack_wds_GetMobileIP_t*) ptr;

    printf("mobile IP: 0x%x\n", pMobileIP->mipMode);

    /* mobile ip mode should not larger than 2 */
#if DEBUG_LOG_TO_FILE
        FILE *fp;
    
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* mobile ip mode should not larger than 2 */
        fprintf(fp, "%-10s\n", ((2 <= pMobileIP->mipMode )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif 

}
void dump_GetLastMobileIPError(void* ptr)
{
    unpack_wds_GetLastMobileIPError_t *pMobileIPError =
        (unpack_wds_GetLastMobileIPError_t*) ptr;

    printf("last mobile IP error: 0x%x\n", pMobileIPError->error);
    /* the error code can be any value, hence treat as always correct */
#if DEBUG_LOG_TO_FILE
        FILE *fp;
    
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* mobile ip mode should not larger than 2 */
        fprintf(fp, "%-10s\n", "Correct");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif     
}
void dump_SetMobileIPProfile(void* ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}
void dump_GetMobileIPProfile(void* ptr)
{
    unpack_wds_GetMobileIPProfile_t *result =
        (unpack_wds_GetMobileIPProfile_t*) ptr;
    if(result)
    {
        printf("enabled %d\n",  result->enabled);
        printf("ip address: %x\n", result->address);
        printf("primary home address: %x\n",  result->primaryHA);
        printf("seconday home address:%x\n",  result->secondaryHA);
        printf("rev tunneling: %d\n",  result->revTunneling);
        printf("HASPI: %d\n",  result->HASPI);
        printf("NAI: %s\n",  result->NAI);
    }

#if DEBUG_LOG_TO_FILE
        FILE *fp;
    
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* expected result , NAI string should not equal to NULL  */
        if(result!=NULL)
        fprintf(fp, "%-10s\n", (('\0' != result->NAI[0] )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif 

}

void dump_RMSetTransferStatistics(void* ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSWdsSwiPDPRuntimeSettings(void* ptr)
{
    unpack_wds_SLQSWdsSwiPDPRuntimeSettings_t *result =
        (unpack_wds_SLQSWdsSwiPDPRuntimeSettings_t*) ptr;
    if(result)
    {
        int idx = 0;
        printf("context Id      : %x \n",result->contextId);
        printf("bearer Id       : %x \n",result->bearerId);
        printf("apn name        : %s \n",result->apnName);
        printf("IPv4 Address    : %x \n",result->ipv4Address);
        printf("IPv4 GW Address : %x \n",result->ipv4GWAddress);
        printf("primary DNS IPv4 address   : %x \n",result->prDNSIPv4Address);
        printf("secondary DNS IPv4 address : %x \n",result->seDNSIPv4Address);

        printf("Primary DNS V6   : ");
        for (idx = 0; idx < 8; idx++)
            printf("%hx ", result->prDNSIPv6Address[idx] );
            printf("\n");

        printf("Secondary DNS V6 : ");
        for (idx = 0; idx < 8; idx++)
            printf("%hx ", result->seDNSIPv6Address[idx] );
            printf("\n");

        printf("IPAddressV6 Information\n");
        printf("\tIPAddressV6 Address   :");
        for (idx = 0; idx < 8; idx++)
            printf("%hx ",
                         result->ipv6Address.IPAddressV6[idx] );
        printf( "\n");
        printf("\tIPAddressV6 Length    : %d\n",
                    result->ipv6Address.IPV6PrefixLen );

        printf("IPV6 Gateway Address Information\n");
        printf("\tIPV6 Gateway Address   :");
        for (idx = 0; idx < 8; idx++)
            printf("%hx ",
                        result->ipv6GWAddress.IPAddressV6[idx] );
        printf( "\n");
        printf("\tIPV6 Gateway Address Length    : %d\n",
                    result->ipv6GWAddress.IPV6PrefixLen );

        
        
        printf("Primary PCSCF IPv6 Address (%d)  : ",result->prPCSCFIPv4Address);
        if(result->prPCSCFIPv4Address > 0)
        {
            for ( idx = 0 ; idx  < IPV6_ADDRESS_ARRAY_SIZE ; idx++ )
            {
                printf( "%x ",result->prPCSCFIPv6Address[idx]);
            }
        }
        printf("\n");
        
        printf("Secondary PCSCF IPv6 Address (%d): ",result->sePCSCFIPv4Address);
        if(result->sePCSCFIPv4Address > 0)
        {
            for ( idx = 0 ; idx < IPV6_ADDRESS_ARRAY_SIZE ; idx++ )
            {
                printf("%x ",result->sePCSCFIPv6Address[idx]);
            }
        }
        printf("\n");
        
    }

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    uint8_t is_matching = 1;
    fp = fopen("./TestResults/testlog.txt", "a");
    /* expected result */
    if(result!=NULL)
    {
        if ((result->bearerId == 0) ||
            (result->apnName == NULL) ||
            (result->ipv4Address == 0) ||
            (result->ipv4GWAddress == 0 ))
        {
            is_matching = 0;
        }
    }
    if ( fp )
    {
        /* NAI string should not equal to NULL  */
        fprintf(fp, "%-10s\n", (( is_matching == 1 )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}


void dump_SLQSGetCurrDataSystemStat(void* ptr)
{
    unpack_wds_SLQSGetCurrDataSystemStat_t *pDataStat =
        (unpack_wds_SLQSGetCurrDataSystemStat_t*) ptr;
    uint8_t lCtr;

    printf("current data system status\n" );
    printf("preferred network      : 0x%x\n", pDataStat->prefNetwork );
    printf("network info length    : 0x%x\n", pDataStat->networkInfoLen );

    printf("network information data\n\n" );
    for( lCtr = 0; lCtr < pDataStat->networkInfoLen; lCtr++ )
    {
        printf("\nnetwork info set: 0x%x\n", lCtr );
        printf("network          : 0x%x\n",  pDataStat->currNetworkInfo[lCtr].NetworkType );
        printf("RAT mask         : 0x%x\n", pDataStat->currNetworkInfo[lCtr].RATMask );
        printf("SO mask          : 0x%x\n", pDataStat->currNetworkInfo[lCtr].SOMask );
    }

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* expected result, RAT Mask should not equal to 0 */
    if ( (pDataStat->prefNetwork  > 1)  || 
       (pDataStat->currNetworkInfo[0].NetworkType > 1) ||
       (pDataStat->currNetworkInfo[0].RATMask == 0))
    {
        is_matching = 0;
    }

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        /* mobile ip mode should not larger than 2 */
        fprintf(fp, "%-10s\n", ((1== is_matching)? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif 
}

void dump_wds_GetPacketStatus( void *ptr)
{
    unpack_wds_GetPacketStatus_t *pStatus =
        (unpack_wds_GetPacketStatus_t*) ptr;

    printf("\ttx packet successes %d\n", pStatus->tXPacketSuccesses);
    printf("\trx packet successes %d\n", pStatus->rXPacketSuccesses);
    printf("\ttx packet error %d\n", pStatus->tXPacketErrors);
    printf("\trx packet error %d\n", pStatus->rXPacketErrors);
    printf("\ttx packet overflows %d\n", pStatus->tXPacketOverflows);
    printf("\trx packet overflows %d\n", pStatus->rXPacketOverflows);
    printf("\ttx ok bytes count %llu\n", (unsigned long long)pStatus->tXOkBytesCount);
    printf("\trx ok bytes count %llu\n", (unsigned long long)pStatus->rXOkBytesCount);
    printf("\ttx ok bytes last call %llu\n", (unsigned long long)pStatus->tXOKBytesLastCall);
    printf("\trx ok bytes last call %llu\n", (unsigned long long)pStatus->rXOKBytesLastCall);
    printf("\ttx dropped count %d\n", pStatus->tXDroppedCount);
    printf("\trx dropped count %d\n", pStatus->rXDroppedCount);

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    uint8_t is_matching = 1;
    fp = fopen("./TestResults/testlog.txt", "a");
    /* expected result */
    if (pStatus->tXPacketSuccesses == 0)
    {
        is_matching = 0;
    }
    if ( fp )
    {
        /* packet success counter and bytes ok count should not equal to 0 */
        fprintf(fp, "%-10s\n", (( is_matching == 1 )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}


void dump_wds_SLQSGetRuntimeSettings(void* ptr)
{
    unpack_wds_SLQSGetRuntimeSettings_t *runtime =
        (unpack_wds_SLQSGetRuntimeSettings_t*) ptr;

    struct in_addr ip_addr;
    struct in_addr gw_addr;
    struct in_addr subnet;
    int idx=0;
    int8_t count;

    ip_addr.s_addr = htonl(runtime->IPv4);
    gw_addr.s_addr = htonl(runtime->GWAddressV4);
    subnet.s_addr = htonl(runtime->SubnetMaskV4);
    
    printf("\tipv4 %s\n", inet_ntoa(ip_addr));
    printf("\tgateway addr %s\n", inet_ntoa(gw_addr));
    printf("\tsubnet mask %s\n", inet_ntoa(subnet));
    printf("\tprofile name %s\n",runtime->ProfileName);
    printf("\tpdp type %d\n",runtime->PDPType);
    printf("\tapn name %s\n",runtime->APNName);
    printf("\tProfile ID:\n\t\tIndex:%d, ProfileType:%d\n",runtime->ProfileID.profileIndex,runtime->ProfileID.profileType);
    printf("\tIP Family Preference : %d\n",runtime->IPFamilyPreference);
    printf("\tMTU : %d\n",runtime->Mtu);
    
    printf("\tPrimary DNS V6   : ");
    for (idx = 0; idx < 8; idx++)
        printf("%hx ", runtime->PrimaryDNSV6[idx] );
        printf("\n");
    printf("\tSecondary DNS V6 : ");
    for (idx = 0; idx < 8; idx++)
        printf("%hx ", runtime->SecondaryDNSV6[idx] );
        printf("\n");
    printf("\tIPAddressV6 Information\n");
    printf("\t\tIPAddressV6 Address   :");
    for (idx = 0; idx < 8; idx++)
        printf("%hx ",
                     runtime->IPV6AddrInfo.IPAddressV6[idx] );
    printf( "\n");
    printf("\t\tIPAddressV6 Length    : %d\n",
                runtime->IPV6AddrInfo.IPV6PrefixLen );
    printf("\tIPV6 Gateway Address Information\n");
    printf("\t\tIPV6 Gateway Address  :");
    for (idx = 0; idx < 8; idx++)
        printf("%hx ",
                    runtime->IPV6GWAddrInfo.gwAddressV6[idx] );
    printf( "\n");
    printf("\t\tIPV6 Gateway Address Length    : %d\n",
                runtime->IPV6GWAddrInfo.gwV6PrefixLen );
    printf("\n");
    printf("\tIPAddressV6 Address    ");
    for (count = 0; count < 8; count++)
        printf("%hx:",
             runtime->IPV6AddrInfo.IPAddressV6[count] );
    printf("\b \b\n");

    printf("\tIPV6 Gateway Address   ");
    for (count = 0; count < 8; count++)
        printf("%hx:",
                runtime->IPV6GWAddrInfo.gwAddressV6[count] );
    printf("\b \b\n");

    printf("\tIPV6 Primary DNS       ");
    for (count = 0; count < 8; count++)
        printf("%hx:",
                runtime->PrimaryDNSV6[count] );
    printf("\b \b\n");

    printf("\tIPV6 Secondary DNS     ");
    for (count = 0; count < 8; count++)
        printf("%hx:",
                runtime->SecondaryDNSV6[count] );
    printf("\b \b\n");


#if DEBUG_LOG_TO_FILE
    FILE *fp;
    uint8_t is_matching = 1;
    fp = fopen("./TestResults/testlog.txt", "a");
    /* expected result, ipv4 address should not equal to 0 */
    if ((inet_ntoa(ip_addr) == NULL) ||
       (inet_ntoa(gw_addr) == NULL) ||
        (runtime->APNName == NULL ))
    {
        is_matching = 0;
    }
    if ( fp )
    {
        fprintf(fp, "%-10s\n", (( is_matching == 1 )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_wds_GetDefaultProfile( void *ptr)
{
    unpack_wds_GetDefaultProfile_t *defprofile =
        (unpack_wds_GetDefaultProfile_t*) ptr;

    printf("received profile details are as follows:");
    printf("\npdpype :%x",defprofile->pdptype);
    printf("\nipaddress :%x",defprofile->ipaddr);
    printf("\nprimarydns :%x",defprofile->pridns);
    printf("\nsecondarydns :%x",defprofile->secdns);
    printf("\nauthentication :%x",defprofile->auth);
    printf("\nname : %s",defprofile->name);
    printf("\napnname :%s",defprofile->apnname);
    printf("\nusername :%s\n",defprofile->username);

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    uint8_t is_matching = 1;
    fp = fopen("./TestResults/testlog.txt", "a");
    /* expected result, ipv4 address should not equal to 0 */
    if ((defprofile->name == NULL) ||
        (defprofile->apnname == NULL) )
    {
        is_matching = 0;
    }
    if ( fp )
    {
        fprintf(fp, "%-10s\n", (( is_matching == 1 )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}
                        
void dump_wds_SLQSGetDataBearerTechnology ( void *ptr)
{
    unpack_wds_SLQSGetDataBearerTechnology_t *dbTech =
    (unpack_wds_SLQSGetDataBearerTechnology_t*) ptr;

    printf("DataBearerMask: 0x%x\n",
            dbTech->dataBearerMask );
    if (dbTech->dataBearerMask & QMI_WDS_CURRENT_CALL_DB_MASK)
    {
        printf("Current data bearer details\n" );
        printf("Network: %d\n",
             dbTech->curDataBearerTechnology.currentNetwork );
        printf("Rat Mask: %d\n", dbTech->curDataBearerTechnology.ratMask);
        printf("So Mask:  %d\n", dbTech->curDataBearerTechnology.soMask );
    }
    if (dbTech->dataBearerMask & QMI_WDS_LAST_CALL_DB_MASK)
    {
        printf("Last Call data bearer details\n" );
        printf("Network:  %d\n",
                dbTech->lastCallDataBearerTechnology.currentNetwork );
        printf("Rat Mask: %d\n", dbTech->lastCallDataBearerTechnology.ratMask);
        printf("So Mask:  %d\n", dbTech->lastCallDataBearerTechnology.soMask );
    }

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    uint8_t is_matching = 1;
    fp = fopen("./TestResults/testlog.txt", "a");
    /* expected result, current RAT_MASK should be presented */
    if ((dbTech->curDataBearerTechnology.currentNetwork == 0) ||
        (dbTech->curDataBearerTechnology.ratMask == 0))
    {
        is_matching = 0;
    }
    if ( fp )
    {
        fprintf(fp, "%-10s\n", (( is_matching == 1 )? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif    
}

void dump_wds_SLQSDeleteProfile ( void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_wds_SLQSSetIPFamilyPreference ( void *ptr)
{
    unpack_wds_SLQSSetIPFamilyPreference_t *result =
    (unpack_wds_SLQSSetIPFamilyPreference_t*) ptr;
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
    printf("Result:%d\n",result->Tlvresult);
}

uint8_t wds_profileType = 0; // 3GPP profile
uint8_t wds_ProfileId = 15;
uint8_t wds_pdpType = 0x00;

#define WDS_DEFAULT_PROFILE_NAME "profile1"
#define WDS_DEFAULT_PROFILE_NAME_LENGTH (sizeof(WDS_DEFAULT_PROFILE_NAME))
#define WDS_DEFAULT_APN_NAME "internet"
#define WDS_DEFAULT_APN_NAME_LENGTH (sizeof(WDS_DEFAULT_APN_NAME))
#define WDS_DEFAULT_USER_NAME "sierra"
#define WDS_DEFAULT_USER_NAME_LENGTH (sizeof(WDS_DEFAULT_USER_NAME))
#define WDS_DEFAULT_PASSWORD "123456"
#define WDS_DEFAULT_PASSWORD_LENGTH (sizeof(WDS_DEFAULT_PASSWORD))

 
uint8_t   wds_profilename[]=WDS_DEFAULT_PROFILE_NAME;
uint16_t  wds_profilename_length=WDS_DEFAULT_PROFILE_NAME_LENGTH;
uint8_t   wds_pdpHdrCompType = 2;
uint8_t   wds_pdpDataCompType = 3;
uint8_t   wds_APNname[]=WDS_DEFAULT_APN_NAME;
uint16_t   wds_APNnameLength=WDS_DEFAULT_APN_NAME_LENGTH;
uint32_t  wds_priDNSIPv4AddPref = 0;
uint32_t  wds_secDNSIPv4AddPref = 0;
uint8_t   wds_username[]=WDS_DEFAULT_USER_NAME;
uint16_t   wds_usernamelength=WDS_DEFAULT_USER_NAME_LENGTH;
uint8_t   wds_password[]=WDS_DEFAULT_PASSWORD;
uint16_t   wds_passwordlength=WDS_DEFAULT_PASSWORD_LENGTH;
uint8_t   wds_resp_profileType = 1;




wds_profileInfo wdsprofileInfo={
    {
        wds_profilename,//uint8_t                    *pProfilename;
        &wds_profilename_length,//uint16_t                   *pProfilenameSize;
        &wds_pdpType,//uint8_t                    *pPDPtype;
        &wds_pdpHdrCompType,//uint8_t                    *pPdpHdrCompType;
        &wds_pdpDataCompType,//uint8_t                    *pPdpDataCompType;
        wds_APNname,//uint8_t                    *pAPNName;
        &wds_APNnameLength,//uint16_t                   *pAPNnameSize;
        &wds_priDNSIPv4AddPref,//uint32_t                   *pPriDNSIPv4AddPref;
        &wds_secDNSIPv4AddPref,//uint32_t                   *pSecDNSIPv4AddPref;
        0,//LibPackUMTSQoS             *pUMTSReqQoS;
        0,//LibPackUMTSQoS             *pUMTSMinQoS;
        0,//LibPackGPRSRequestedQoS    *pGPRSRequestedQos;
        0,//LibPackGPRSRequestedQoS    *pGPRSMinimumQoS;
        wds_username,//uint8_t                    *pUsername;
        &wds_usernamelength,//uint16_t                    *pUsernameSize;
        wds_password,//uint8_t                    *pPassword;
        &wds_passwordlength,//uint16_t                   *pPasswordSize;
        0,//uint8_t                    *pAuthenticationPref;
        0,//uint32_t                   *pIPv4AddrPref;
        0,//uint8_t                    *pPcscfAddrUsingPCO;
        0,//uint8_t                    *pPdpAccessConFlag;
        0,//uint8_t                    *pPcscfAddrUsingDhcp;
        0,//uint8_t                    *pImCnFlag;
        0,//struct wds_TFTIDParams         *pTFTID1Params;
        0,//struct wds_TFTIDParams         *pTFTID2Params;
        0,//uint8_t                    *pPdpContext;
        0,//uint8_t                    *pSecondaryFlag;
        0,//uint8_t                    *pPrimaryID;
        0,//uint16_t                   *pIPv6AddPref;
        0,//LibPackUMTSReqQoSSigInd    *pUMTSReqQoSSigInd;
        0,//.LibPackUMTSReqQoSSigInd    *pUMTSMinQosSigInd;
        0,//uint16_t                   *pPriDNSIPv6addpref;
        0,//uint16_t                   *pSecDNSIPv6addpref;
        0,//uint8_t                    *pAddrAllocPref;
        0,//LibPackQosClassID          *pQosClassID;
        0,//uint8_t                    *pAPNDisabledFlag;
        0,//uint32_t                   *pPDNInactivTimeout;
        0,//uint8_t                    *pAPNClass;
    }
};
uint8_t wds_profileTypeResp = 255; // 3GPP profile
uint8_t wds_ProfileIdResp = 255;
uint8_t wds_pdpTypeResp = 0xff;

LibPackprofile_3GPP wds_profile3GPPResp;
uint8_t   wds_profilenameResp[255]={0};
uint16_t  wds_profilename_lengthResp=255;
uint8_t   wds_pdpHdrCompTypeResp = 0;
uint8_t   wds_pdpDataCompTypeResp = 0;
uint8_t   wds_APNnameResp[255]={0};
uint16_t   wds_APNnameLengthResp=255;
uint32_t  wds_priDNSIPv4AddPrefResp = 0;
uint32_t  wds_secDNSIPv4AddPrefResp = 0;
uint8_t   wds_usernameResp[255]={0};
uint16_t   wds_usernamelengthResp=255;
uint8_t   wds_passwordResp[255]={0};
uint16_t   wds_passwordlengthResp=255;
uint8_t   wds_resp_profileTypeResp = 0;

wds_profileInfo wdsprofileInforesp={
    {
        wds_profilenameResp,//uint8_t                    *pProfilename;
        &wds_profilename_lengthResp,//uint16_t                   *pProfilenameSize;
        &wds_pdpTypeResp,//uint8_t                    *pPDPtype;
        &wds_pdpHdrCompTypeResp,//uint8_t                    *pPdpHdrCompType;
        &wds_pdpDataCompTypeResp,//uint8_t                    *pPdpDataCompType;
        wds_APNnameResp,//uint8_t                    *pAPNName;
        &wds_APNnameLengthResp,//uint16_t                   *pAPNnameSize;
        &wds_priDNSIPv4AddPrefResp,//uint32_t                   *pPriDNSIPv4AddPref;
        &wds_secDNSIPv4AddPrefResp,//uint32_t                   *pSecDNSIPv4AddPref;
        0,//LibPackUMTSQoS             *pUMTSReqQoS;
        0,//LibPackUMTSQoS             *pUMTSMinQoS;
        0,//LibPackGPRSRequestedQoS    *pGPRSRequestedQos;
        0,//LibPackGPRSRequestedQoS    *pGPRSMinimumQoS;
        wds_usernameResp,//uint8_t                    *pUsername;
        &wds_usernamelengthResp,//uint16_t                    *pUsernameSize;
        wds_passwordResp,//uint8_t                    *pPassword;
        &wds_passwordlengthResp,//uint16_t                   *pPasswordSize;
        0,//uint8_t                    *pAuthenticationPref;
        0,//uint32_t                   *pIPv4AddrPref;
        0,//uint8_t                    *pPcscfAddrUsingPCO;
        0,//uint8_t                    *pPdpAccessConFlag;
        0,//uint8_t                    *pPcscfAddrUsingDhcp;
        0,//uint8_t                    *pImCnFlag;
        0,//struct wds_TFTIDParams         *pTFTID1Params;
        0,//struct wds_TFTIDParams         *pTFTID2Params;
        0,//uint8_t                    *pPdpContext;
        0,//uint8_t                    *pSecondaryFlag;
        0,//uint8_t                    *pPrimaryID;
        0,//uint16_t                   *pIPv6AddPref;
        0,//LibPackUMTSReqQoSSigInd    *pUMTSReqQoSSigInd;
        0,//.LibPackUMTSReqQoSSigInd    *pUMTSMinQosSigInd;
        0,//uint16_t                   *pPriDNSIPv6addpref;
        0,//uint16_t                   *pSecDNSIPv6addpref;
        0,//uint8_t                    *pAddrAllocPref;
        0,//LibPackQosClassID          *pQosClassID;
        0,//uint8_t                    *pAPNDisabledFlag;
        0,//uint32_t                   *pPDNInactivTimeout;
        0,//uint8_t                    *pAPNClass;
    }
};


pack_wds_SLQSCreateProfile_t tSLQSCreateProfile = {
    &wds_ProfileId,&wds_profileType,&wdsprofileInfo
};

PackCreateProfileOut profile_out;
uint8_t profile_id_out;
unpack_wds_SLQSCreateProfile_t tunpack_create_profile = {
    &profile_out, &profile_id_out, 0
};

pack_wds_SLQSGetProfileSettings_t tSLQSGetProfileSettings ={
    3,// 1-16
    0
};
uint16_t SLQSGetProfileSettingsExtErrCode = 0;
wds_profileInfo SLQSGetProfileSettingsCurProfile;
uint16_t uResult;

#if 1
uint8_t unPackGetProfileSettingOutProfilenameResp[255]={0};
uint16_t unPackGetProfileSettingOutProfilenameSizeResp=255;
uint8_t unPackGetProfileSettingOutAPNNameResp[255]={0};
uint16_t unPackGetProfileSettingOutAPNNameSizeResp=255;
uint8_t unPackGetProfileSettingDPtypeResp;

uint8_t unPackGetProfileSettingOutPasswordResp[255]={0};
uint16_t unPackGetProfileSettingOutPasswordSizeResp=255;
uint8_t unPackGetProfileSettingOutUserResp[255]={0};
uint16_t unPackGetProfileSettingOutUserSizeResp=255;
uint32_t unPackGetProfileSettingOutIPv4AddrPrefResp=255;
uint32_t unPackGetProfileSettingOutDNSPriAddrPrefResp=255;
uint32_t unPackGetProfileSettingOutDNSSecAddrPrefResp=255;
uint8_t unPackGetProfileSettingOutAuthenticationPrefResp=255;
uint8_t unPackGetProfileSettingOutAPNClassResp=255;

uint8_t unPackGetProfileSettingOutPdpHdrCompTypeResp=255;
uint8_t unPackGetProfileSettingOutPdpDataCompTypeResp=255;
LibPackUMTSQoS          unPackGetProfileSettingOutUMTSReqQoS;
LibPackUMTSQoS          unPackGetProfileSettingOutUMTSMinQoS;
LibPackGPRSRequestedQoS unPackGetProfileSettingOutGPRSRequestedQos;
LibPackGPRSRequestedQoS unPackGetProfileSettingOutGPRSMinimumQoS;
uint8_t unPackGetProfileSettingOutPcscfAddrUsingPCO=255;

#endif
uint16_t unPackGetProfileSettingExtErrCodeResp;
uint8_t                    unPackGetProfileSettingOutPdpAccessConFlag;
uint8_t                    unPackGetProfileSettingOutPcscfAddrUsingDhcp;
uint8_t                    unPackGetProfileSettingOutImCnFlag;
LibPackTFTIDParams      unPackGetProfileSettingOutTFTID1Params;
LibPackTFTIDParams      unPackGetProfileSettingOutTFTID2Params;
uint8_t                    unPackGetProfileSettingOutPdpContext;
uint8_t                    unPackGetProfileSettingOutSecondaryFlag;
uint8_t                    unPackGetProfileSettingOutPrimaryID;
uint16_t                  unPackGetProfileSettingOutIPv6AddPref;
LibPackUMTSReqQoSSigInd unPackGetProfileSettingOutUMTSReqQoSSigInd;
LibPackUMTSReqQoSSigInd unPackGetProfileSettingOutUMTSMinQosSigInd;
uint16_t                  unPackGetProfileSettingOutPriDNSIPv6addpref;
uint16_t                  unPackGetProfileSettingOutSecDNSIPv6addpref;
uint8_t                    unPackGetProfileSettingOutAddrAllocPref;
LibPackQosClassID       unPackGetProfileSettingOutQosClassID;
uint8_t                    unPackGetProfileSettingOutAPNDisabledFlag;
uint32_t                   unPackGetProfileSettingOutPDNInactivTimeout;


UnPackGetProfileSettingOut unPackGetProfileSettingOut={
    { //UnpackQmiProfileInfo
        { //LibpackProfile3GPP
        unPackGetProfileSettingOutProfilenameResp, //uint8_t                    *pProfilename;
        &unPackGetProfileSettingOutProfilenameSizeResp, //uint16_t                    *pProfilenameSize;
        &unPackGetProfileSettingDPtypeResp, // uint8_t                    *pPDPtype;
        &unPackGetProfileSettingOutPdpHdrCompTypeResp, // uint8_t                    *pPdpHdrCompType;
        &unPackGetProfileSettingOutPdpDataCompTypeResp, // uint8_t                    *pPdpDataCompType;
        unPackGetProfileSettingOutAPNNameResp, //uint8_t                    *pAPNName;
        &unPackGetProfileSettingOutAPNNameSizeResp, //uint16_t                    *pAPNnameSize;
        &unPackGetProfileSettingOutDNSPriAddrPrefResp, // uint32_t                   *pPriDNSIPv4AddPref;
        &unPackGetProfileSettingOutDNSSecAddrPrefResp, // uint32_t                   *pSecDNSIPv4AddPref;
        &unPackGetProfileSettingOutUMTSReqQoS, // LibPackUMTSQoS          *pUMTSReqQoS;
        &unPackGetProfileSettingOutUMTSMinQoS, // LibPackUMTSQoS          *pUMTSMinQoS;
        &unPackGetProfileSettingOutGPRSRequestedQos, // LibPackGPRSRequestedQoS *pGPRSRequestedQos;
        &unPackGetProfileSettingOutGPRSMinimumQoS, // LibPackGPRSRequestedQoS *pGPRSMinimumQoS;
        unPackGetProfileSettingOutUserResp, // uint8_t                    *pUsername;
        &unPackGetProfileSettingOutUserSizeResp, // uint16_t                    *pUsernameSize;
        unPackGetProfileSettingOutPasswordResp, // uint8_t                    *pPassword;
        &unPackGetProfileSettingOutPasswordSizeResp, // uint16_t                    *pPasswordSize;
        &unPackGetProfileSettingOutAuthenticationPrefResp, // uint8_t                    *pAuthenticationPref;
        &unPackGetProfileSettingOutIPv4AddrPrefResp, // uint32_t                   *pIPv4AddrPref;
        &unPackGetProfileSettingOutPcscfAddrUsingPCO, // uint8_t                    *pPcscfAddrUsingPCO;
        &unPackGetProfileSettingOutPdpAccessConFlag, // uint8_t                    *pPdpAccessConFlag;
        &unPackGetProfileSettingOutPcscfAddrUsingDhcp, // uint8_t                    *pPcscfAddrUsingDhcp;
        &unPackGetProfileSettingOutImCnFlag, // uint8_t                    *pImCnFlag;
        &unPackGetProfileSettingOutTFTID1Params, // LibPackTFTIDParams      *pTFTID1Params;
        &unPackGetProfileSettingOutTFTID2Params, // LibPackTFTIDParams      *pTFTID2Params;
        &unPackGetProfileSettingOutPdpContext, // uint8_t                    *pPdpContext;
        &unPackGetProfileSettingOutSecondaryFlag, // uint8_t                    *pSecondaryFlag;
        &unPackGetProfileSettingOutPrimaryID, // uint8_t                    *pPrimaryID;
        &unPackGetProfileSettingOutIPv6AddPref, // uint16_t                  *pIPv6AddPref;
        &unPackGetProfileSettingOutUMTSReqQoSSigInd, //LibPackUMTSReqQoSSigInd *pUMTSReqQoSSigInd;
        &unPackGetProfileSettingOutUMTSMinQosSigInd, // LibPackUMTSReqQoSSigInd *pUMTSMinQosSigInd;
        &unPackGetProfileSettingOutPriDNSIPv6addpref, // uint16_t                  *pPriDNSIPv6addpref;
        &unPackGetProfileSettingOutSecDNSIPv6addpref, // uint16_t                  *pSecDNSIPv6addpref;
        &unPackGetProfileSettingOutAddrAllocPref, // uint8_t                    *pAddrAllocPref;
        &unPackGetProfileSettingOutQosClassID, // LibPackQosClassID       *pQosClassID;
        &unPackGetProfileSettingOutAPNDisabledFlag, // uint8_t                    *pAPNDisabledFlag;
        &unPackGetProfileSettingOutPDNInactivTimeout, // uint32_t                   *pPDNInactivTimeout;
        &unPackGetProfileSettingOutAPNClassResp // uint8_t                    *pAPNClass;
        }
    },
    &unPackGetProfileSettingExtErrCodeResp //pExtErrCode
};
unpack_wds_SLQSGetProfileSettings_t tSLQSGetProfileSettingsRsp ={&unPackGetProfileSettingOut,0,0};

uint8_t wdsModiflyprofileType = 0; // 3GPP profile
uint8_t wdsModiflyProfileId = 3;
uint8_t wdsModiflypdpType = 0x00;

uint8_t ModifyProfileFileName[]="newProfile";
uint16_t ModifyProfileFileNameSize=10;
uint8_t ModifyProfileAPNName[]="internet";
uint16_t ModifyProfileAPNNameSize=8;

pack_wds_SetDefaultProfileNum_t tpack_wds_SetDefaultProfileNum = {0, 0, 3};
pack_wds_GetDefaultProfileNum_t tpack_wds_GetDefaultProfileNum = {0, 0};
unpack_wds_GetDefaultProfileNum_t tunpack_wds_GetDefaultProfileNum;

pack_wds_SLQSSet3GPPConfigItem_t tpack_wds_SLQSSet3GPPConfigItem  = {
   {1,2,3,4},
   1,
   7,
   {1},
   1
};

pack_wds_SLQSModifyProfile_t tpack_wds_SLQSModifyProfile={
    &wdsModiflyProfileId,//Profile ID
    &wdsModiflyprofileType,//Profile Type
    {
        {
            ModifyProfileFileName,//uint8_t                    *pProfilename;
            &ModifyProfileFileNameSize,//uint16_t                   *pProfilenameSize;
            &wdsModiflypdpType,//uint8_t                    *pPDPtype;
            0,//uint8_t                    *pPdpHdrCompType;
            0,//uint8_t                    *pPdpDataCompType;
            ModifyProfileAPNName,//uint8_t                    *pAPNName;
            &ModifyProfileAPNNameSize,//uint16_t                   *pAPNnameSize;
            0,//uint32_t                   *pPriDNSIPv4AddPref;
            0,//uint32_t                   *pSecDNSIPv4AddPref;
            0,//LibPackUMTSQoS             *pUMTSReqQoS;
            0,//LibPackUMTSQoS             *pUMTSMinQoS;
            0,//LibPackGPRSRequestedQoS    *pGPRSRequestedQos;
            0,//LibPackGPRSRequestedQoS    *pGPRSMinimumQoS;
            0,//uint8_t                    *pUsername;
            0,//uint16_t                    *pUsernameSize;
            0,//uint8_t                    *pPassword;
            0,//uint16_t                   *pPasswordSize;
            0,//uint8_t                    *pAuthenticationPref;
            0,//uint32_t                   *pIPv4AddrPref;
            0,//uint8_t                    *pPcscfAddrUsingPCO;
            0,//uint8_t                    *pPdpAccessConFlag;
            0,//uint8_t                    *pPcscfAddrUsingDhcp;
            0,//uint8_t                    *pImCnFlag;
            0,//struct wds_TFTIDParams         *pTFTID1Params;
            0,//struct wds_TFTIDParams         *pTFTID2Params;
            0,//uint8_t                    *pPdpContext;
            0,//uint8_t                    *pSecondaryFlag;
            0,//uint8_t                    *pPrimaryID;
            0,//uint16_t                   *pIPv6AddPref;
            0,//LibPackUMTSReqQoSSigInd    *pUMTSReqQoSSigInd;
            0,//.LibPackUMTSReqQoSSigInd    *pUMTSMinQosSigInd;
            0,//uint16_t                   *pPriDNSIPv6addpref;
            0,//uint16_t                   *pSecDNSIPv6addpref;
            0,//uint8_t                    *pAddrAllocPref;
            0,//LibPackQosClassID          *pQosClassID;
            0,//uint8_t                    *pAPNDisabledFlag;
            0,//uint32_t                   *pPDNInactivTimeout;
            0,//uint8_t                    *pAPNClass;
        }
    }
};
unpack_wds_SLQSModifyProfile_t tunpack_wds_SLQSModifyProfile;

uint32_t tpack_wds_SLQSStartDataSessionProfileid3gpp[]={PROFILEID_1,PROFILEID_3};
pack_wds_SLQSStartDataSession_t tpack_wds_SLQSStartDataSession[]={
    {
        NULL,
        &tpack_wds_SLQSStartDataSessionProfileid3gpp[eProfile1Slot],
        NULL,
        NULL,
        NULL,
        NULL},
    {
        NULL,
        &tpack_wds_SLQSStartDataSessionProfileid3gpp[eProfile3Slot],
        NULL,
        NULL,
        NULL,
        NULL}
};

uint32_t tpack_wds_GetRuntimeSettings=0xFFFFFFFF;
pack_wds_SLQSGetRuntimeSettings_t tpack_wds_SLQSGetRuntimeSettings={
    &tpack_wds_GetRuntimeSettings
};

uint32_t tunpack_wds_SLQSStartDataSessionsid=0;
uint32_t tunpack_wds_SLQSStartDataSessionFailureReason=0;
uint32_t tunpack_wds_SLQSStartDataSessionVerboseFailReasonType=0;
uint32_t tunpack_wds_SLQSStartDataSessionVerboseFailureReason=0;
unpack_wds_SLQSStartDataSession_t tunpack_wds_SLQSStartDataSession={
    &tunpack_wds_SLQSStartDataSessionsid, &tunpack_wds_SLQSStartDataSessionFailureReason,
    &tunpack_wds_SLQSStartDataSessionVerboseFailReasonType,
    &tunpack_wds_SLQSStartDataSessionVerboseFailureReason
};

uint32_t tpack_wds_SLQSStopDataSessionsid=0;
pack_wds_SLQSStopDataSession_t tpack_wds_SLQSStopDataSession={
    &tunpack_wds_SLQSStartDataSessionsid
};

uint8_t  tpack_wds_SetMobileIPProfileEnabled = 1;
uint32_t tpack_wds_SetMobileIPProfileAddress = 0xFFFFFFFF;
uint32_t tpack_wds_SetMobileIPProfilePrimaryHA  = 0xFFFFFFFF;
uint32_t tpack_wds_SetMobileIPProfileSecondaryHA = 0xFFFFFFFF;
uint8_t  tpack_wds_SetMobileIPProfileRevTunneling = 1;
uint32_t tpack_wds_SetMobileIPProfileHASPI = 0xFFFFFFFF;
uint32_t tpack_wds_SetMobileIPProfileAAASPI = 0xFFFFFFFF;
int8_t   tpack_wds_SetMobileIPProfileNAI[] = "www.sierrawireless.com";
int8_t   tpack_wds_SetMobileIPProfileMNHA[] = "test";
int8_t   tpack_wds_SetMobileIPProfileMNAAA[] = "test";


pack_wds_SetMobileIPProfile_t tpack_wds_SetMobileIPProfile={
    {0},
    1,
    &tpack_wds_SetMobileIPProfileEnabled,
    &tpack_wds_SetMobileIPProfileAddress,
    &tpack_wds_SetMobileIPProfilePrimaryHA,
    &tpack_wds_SetMobileIPProfileSecondaryHA,
    &tpack_wds_SetMobileIPProfileRevTunneling,
    tpack_wds_SetMobileIPProfileNAI,
    &tpack_wds_SetMobileIPProfileHASPI,
    &tpack_wds_SetMobileIPProfileAAASPI,
    tpack_wds_SetMobileIPProfileMNHA,
    tpack_wds_SetMobileIPProfileMNAAA,
};

pack_wds_GetMobileIPProfile_t tpack_wds_GetMobileIPProfile={
    0
};
unpack_wds_GetMobileIPProfile_t tunpack_wds_GetMobileIPProfile ={
    0,
    0,
    0,
    0,
    0,
    0,
    {0},
    0,
    0,
    0,
    0
};


pack_wds_RMSetTransferStatistics_t  tpack_wds_RMSetTransferStatistics={
        {0x00,0x00000000}
};

pack_wds_SLQSWdsSwiPDPRuntimeSettings_t tpack_wds_SLQSWdsSwiPDPRuntimeSettings[]={
    {PROFILEID_1,0},
    {PROFILEID_3,0}
};
unpack_wds_SLQSWdsSwiPDPRuntimeSettings_t tunpack_wds_SLQSWdsSwiPDPRuntimeSettings={
    0,//uint8_t                   contextId;
    0,//uint8_t                   bearerId;
    {0},//int8_t                    apnName[100];
    0,//uint32_t                  ipv4Address;
    0,//uint32_t                  ipv4GWAddress;
    0,//uint32_t                  prDNSIPv4Address;
    0,//uint32_t                  seDNSIPv4Address;
    {0,{0}},//struct ipv6AddressInfo    ipv6Address;
    {0,{0}},//struct ipv6AddressInfo    ipv6GWAddress;
    {0},//uint16_t                  prDNSIPv6Address[IPV6_ADDRESS_ARRAY_SIZE];
    {0},//uint16_t                  seDNSIPv6Address[IPV6_ADDRESS_ARRAY_SIZE];
      0,//uint32_t                  prPCSCFIPv4Address;
      0,//uint32_t                  sePCSCFIPv4Address;
    {0},//uint16_t                  prPCSCFIPv6Address[IPV6_ADDRESS_ARRAY_SIZE];
    {0},//uint16_t                  sePCSCFIPv6Address[IPV6_ADDRESS_ARRAY_SIZE];

};
pack_wds_SLQSSetWdsEventCallback_t tpack_wds_SLQSSetWdsEventCallback = {
    1,
    1,
    1,
    1,
    1,
    1,
    2
};

pack_wds_GetPacketStatus_t tpack_wds_GetPacketStatus = {
    PKT_STAT_STAT_MASK
};

unpack_wds_GetPacketStatus_t tunpack_wds_GetPacketStatus = {
    0, // uint32_t    tXPacketSuccesses - Tx Packets OK
    0, // uint32_t    rXPacketSuccesses - Rx Packets OK
    0, // uint32_t    tXPacketErrors Tx - Packet Errors
    0, // uint32_t    rXPacketErrors Rx - Packet Errors
    0, // uint32_t    tXPacketOverflows - Tx Overflows
    0, // uint32_t    rXPacketOverflows - Rx Overflows
    0, // uint64_t    tXOkBytesCount Tx - Bytes OK
    0, // uint64_t    rXOkBytesCount Rx - Bytes OK
    0, // uint64_t    tXOKBytesLastCall - Last call Tx Bytes OK
    0, // uint64_t    rXOKBytesLastCall - Last call Rx Bytes OK
    0, // uint32_t    tXDroppedCount Tx - Packets Dropped
    0  // uint32_t    rXDroppedCount Rx - Packets Dropped
};

pack_wds_GetDefaultProfile_t tpack_wds_GetDefaultProfile  = {
    0 // PDP profile type, IPV4
};

unpack_wds_GetDefaultProfile_t tunpack_wds_GetDefaultProfile = {
    0, // uint32_t    pdptype pdp type
    0, // uint32_t    ipaddr ip address
    0, // uint32_t    pridns primary dns
    0, // uint32_t    secdns secondry dns
    0, // uint16_t    ipaddrv6 ip address v6     
    0, // uint16_t    pridnsv6 primary dns v6
    0, // uint16_t    secdnsv6 secondry dns v6
    0, // uint32_t    auth; authentication type
    0, // uint8_t     namesize profile name size
    {0}, // int8_t    name profile name
    0, //uint8_t      apnsize apn size
    {0}, // int8_t    apnname apn name
    0, // uint8_t     usersize username size
    {0} // int8_t     username username
};

unpack_wds_SLQSGetDataBearerTechnology_t tunpack_wds_SLQSGetDataBearerTechnology = {
    0, // uint8_t    dataBearerMask  bit mask indicates bearer info is for current and/or last call
    {0, 0, 0}, // curDataBearerTechnology current data bearer technology value
    {0, 0, 0}  // lastCallDataBearerTechnology last call data bearer technology value
};

pack_wds_SLQSDeleteProfile_t tpack_wds_SLQSDeleteProfile = {
    0, // uint8_t    profileType  - profile type
    2  // uint8_t    profileIndex - profile index
};

pack_wds_SLQSSetIPFamilyPreference_t pack_wds_SLQSSetIPFamilyPreference_IPV4 ={
    PACK_WDS_IPV4
};
pack_wds_SLQSSetIPFamilyPreference_t pack_wds_SLQSSetIPFamilyPreference_IPV6 ={
    PACK_WDS_IPV6
};
unpack_wds_SLQSSetIPFamilyPreference_t unpack_wds_SLQSSetIPFamilyPreference_result ={
    0
};
testitem_t wdstotest[] = {
    {
        (pack_func) pack_wds_SetDefaultProfileNum, "pack_wds_SetDefaultProfileNum",
        &tpack_wds_SetDefaultProfileNum,
        (unpack_func) unpack_wds_SetDefaultProfileNum, "unpack_wds_SetDefaultProfileNum",
        NULL, dump_SetDefaultProfileNum
    },
    {
        (pack_func) pack_wds_GetDefaultProfileNum, "pack_wds_GetDefaultProfileNum",
        &tpack_wds_GetDefaultProfileNum,
        (unpack_func) unpack_wds_GetDefaultProfileNum, "unpack_wds_GetDefaultProfileNum",
        &tunpack_wds_GetDefaultProfileNum, dump_GetDefaultProfileNum
    },
    {
        (pack_func) pack_wds_SLQSSet3GPPConfigItem, "pack_wds_SLQSSet3GPPConfigItem",
        &tpack_wds_SLQSSet3GPPConfigItem,
        (unpack_func) unpack_wds_SLQSSet3GPPConfigItem, "unpack_wds_SLQSSet3GPPConfigItem",
        NULL, dump_SLQSSet3GPPConfigItem
    },
    {
        (pack_func) pack_wds_SLQSGet3GPPConfigItem, "pack_wds_SLQSGet3GPPConfigItem",
        NULL,
        (unpack_func) unpack_wds_SLQSGet3GPPConfigItem, "unpack_wds_SLQSGet3GPPConfigItem",
        &get3GPPconfigitem, dump_SLQSGet3GPPConfigItem
    },

    {
        (pack_func) pack_wds_SLQSSetWdsEventCallback, "pack_wds_SLQSSetWdsEventCallback",
        &tpack_wds_SLQSSetWdsEventCallback,
        (unpack_func) unpack_wds_SLQSSetWdsEventCallback, "unpack_wds_SLQSSetWdsEventCallback",
        NULL, dump_wds_SLQSSetWdsEventCallback
    },
    {
        (pack_func) pack_wds_GetDefaultProfile, "pack_wds_GetDefaultProfile",
        &tpack_wds_GetDefaultProfile,
        (unpack_func) unpack_wds_GetDefaultProfile, "unpack_wds_GetDefaultProfile",
        &tunpack_wds_GetDefaultProfile, dump_wds_GetDefaultProfile
    },

    {
        (pack_func) pack_wds_SLQSStartDataSession, "pack_wds_SLQSStartDataSession",
        &tpack_wds_SLQSStartDataSession[eProfile1Slot],
        (unpack_func) unpack_wds_SLQSStartDataSession, "unpack_wds_SLQSStartDataSession",
        &tunpack_wds_SLQSStartDataSession, dump_wds_SLQSStartDataSession
    },
    {
        (pack_func) pack_wds_GetSessionState, "pack_wds_GetSessionState",
        NULL,
        (unpack_func) unpack_wds_GetSessionState, "unpack_wds_GetSessionState",
        &stateinfo, dump_GetSessionState
    },
    {
        (pack_func) pack_wds_SLQSGetRuntimeSettings, "pack_wds_SLQSGetRuntimeSettings",
        &tpack_wds_SLQSGetRuntimeSettings,
        (unpack_func) unpack_wds_SLQSGetRuntimeSettings, "unpack_wds_SLQSGetRuntimeSettings",
        &runtimeinfo, dump_wds_SLQSGetRuntimeSettings
    },
    {
        (pack_func) pack_wds_GetSessionDuration, "pack_wds_GetSessionDuration",
        NULL,
        (unpack_func) unpack_wds_GetSessionDuration, "unpack_wds_GetSessionDuration",
        &sessionduration, dump_GetSessionDuration
    },
    {
        (pack_func) pack_wds_GetPacketStatus, "pack_wds_GetPacketStatus",
        &tpack_wds_GetPacketStatus,
        (unpack_func) unpack_wds_GetPacketStatus, "unpack_wds_GetPacketStatus",
        &tunpack_wds_GetPacketStatus, dump_wds_GetPacketStatus
    },
    {
        (pack_func) pack_wds_GetDormancyState, "pack_wds_GetDormancyState",
        NULL,
        (unpack_func) unpack_wds_GetDormancyState, "unpack_wds_GetDormancyState",
        &dormancystate, dump_GetDormancyState
    },
    {
        (pack_func) pack_wds_SLQSGetDataBearerTechnology, "pack_wds_SLQSGetDataBearerTechnology",
        NULL,
        (unpack_func) unpack_wds_SLQSGetDataBearerTechnology, "unpack_wds_SLQSGetDataBearerTechnology",
        &tunpack_wds_SLQSGetDataBearerTechnology, dump_wds_SLQSGetDataBearerTechnology
    },
    {
        (pack_func) pack_wds_GetConnectionRate, "pack_wds_GetConnectionRate",
        NULL,
        (unpack_func) unpack_wds_GetConnectionRate, "unpack_wds_GetConnectionRate",
        &connrate, dump_GetConnectionRate
    },
    {
        (pack_func) pack_wds_SLQSSet3GPPConfigItem, "pack_wds_SLQSSet3GPPConfigItem",
        &tpack_wds_SLQSSet3GPPConfigItem,
        (unpack_func) unpack_wds_SLQSSet3GPPConfigItem, "unpack_wds_SLQSSet3GPPConfigItem",
        NULL, dump_SLQSSet3GPPConfigItem
    },
    {
        (pack_func) pack_wds_SLQSGet3GPPConfigItem, "pack_wds_SLQSGet3GPPConfigItem",
        NULL,
        (unpack_func) unpack_wds_SLQSGet3GPPConfigItem, "unpack_wds_SLQSGet3GPPConfigItem",
        &get3GPPconfigitem, dump_SLQSGet3GPPConfigItem
    },
    {
        (pack_func) pack_wds_GetMobileIP, "pack_wds_GetMobileIP",
        NULL,
        (unpack_func) unpack_wds_GetMobileIP, "unpack_wds_GetMobileIP",
        &mipMode, dump_GetMobileIP
    },

    {
        (pack_func) pack_wds_SLQSGetCurrDataSystemStat, "pack_wds_SLQSGetCurrDataSystemStat",
        NULL,
        (unpack_func) unpack_wds_SLQSGetCurrDataSystemStat, "unpack_wds_SLQSGetCurrDataSystemStat",
        &dataStat, dump_SLQSGetCurrDataSystemStat
    },

    {
        (pack_func) pack_wds_SLQSStopDataSession, "pack_wds_SLQSStopDataSession",
        &tpack_wds_SLQSStopDataSession,
        (unpack_func) unpack_wds_SLQSStopDataSession, "unpack_wds_SLQSStopDataSession",
        NULL, dump_wds_SLQSStopDataSession
    },
    {
        (pack_func) pack_wds_GetLastMobileIPError, "pack_wds_GetLastMobileIPError",
        NULL,
        (unpack_func) unpack_wds_GetLastMobileIPError, "unpack_wds_GetLastMobileIPError",
        &mobileIPError, dump_GetLastMobileIPError
    },
    {
        (pack_func) pack_wds_SetMobileIPProfile, "pack_wds_SetMobileIPProfile",
        &tpack_wds_SetMobileIPProfile,
        (unpack_func) unpack_wds_SetMobileIPProfile, "unpack_wds_SetMobileIPProfile",
        NULL, dump_SetMobileIPProfile
    },
    {
        (pack_func) pack_wds_GetMobileIPProfile, "pack_wds_GetMobileIPProfile",
        &tpack_wds_GetMobileIPProfile,
        (unpack_func) unpack_wds_GetMobileIPProfile, "unpack_wds_GetMobileIPProfile",
        &tunpack_wds_GetMobileIPProfile, dump_GetMobileIPProfile
    },
    {
        (pack_func) pack_wds_RMSetTransferStatistics, "pack_wds_RMSetTransferStatistics",
        &tpack_wds_RMSetTransferStatistics,
        (unpack_func) unpack_wds_RMSetTransferStatistics, "unpack_wds_RMSetTransferStatistics",
        NULL, dump_RMSetTransferStatistics
    },
    {
        (pack_func) pack_wds_SLQSWdsSwiPDPRuntimeSettings, "pack_wds_SLQSWdsSwiPDPRuntimeSettings",
        &tpack_wds_SLQSWdsSwiPDPRuntimeSettings[eProfile1Slot],
        (unpack_func) unpack_wds_SLQSWdsSwiPDPRuntimeSettings, "unpack_wds_SLQSWdsSwiPDPRuntimeSettings",
        &tunpack_wds_SLQSWdsSwiPDPRuntimeSettings, dump_SLQSWdsSwiPDPRuntimeSettings
    },
    {
        (pack_func) pack_wds_SLQSCreateProfile, "pack_wds_SLQSCreateProfile",
        &tSLQSCreateProfile,
        (unpack_func) unpack_wds_SLQSCreateProfile, "unpack_wds_SLQSCreateProfile",
        &tunpack_create_profile, dump_wds_SLQSCreateProfile
    },
    {
        (pack_func) pack_wds_SLQSGetProfileSettings, "pack_wds_SLQSGetProfileSettings",
        &tSLQSGetProfileSettings,
        (unpack_func) unpack_wds_SLQSGetProfileSettings, "unpack_wds_SLQSGetProfileSettings",
        &tSLQSGetProfileSettingsRsp, dump_wds_SLQSGetProfileSettings
    },
    {
        (pack_func) pack_wds_SLQSModifyProfile, "pack_wds_SLQSModifyProfile",
        &tpack_wds_SLQSModifyProfile,
        (unpack_func) unpack_wds_SLQSModifyProfile, "unpack_wds_SLQSModifyProfile",
        &tunpack_wds_SLQSModifyProfile, dump_wds_SLQSModifyProfile
    },
    {
        (pack_func) pack_wds_SLQSDeleteProfile, "pack_wds_SLQSDeleteProfile",
        &tpack_wds_SLQSDeleteProfile,
        (unpack_func) unpack_wds_SLQSDeleteProfile, "unpack_wds_SLQSDeleteProfile",
        NULL, dump_wds_SLQSDeleteProfile
    },
    // Profile 1 IPV6
    {
        (pack_func) pack_wds_SLQSSetIPFamilyPreference, "pack_wds_SLQSSetIPFamilyPreference",
        &pack_wds_SLQSSetIPFamilyPreference_IPV6,
        (unpack_func) unpack_wds_SLQSSetIPFamilyPreference, "unpack_wds_SLQSSetIPFamilyPreference",
        &unpack_wds_SLQSSetIPFamilyPreference_result, dump_wds_SLQSSetIPFamilyPreference
    },
    {
        (pack_func) pack_wds_SLQSStartDataSession, "pack_wds_SLQSStartDataSession",
        &tpack_wds_SLQSStartDataSession[eProfile1Slot],
        (unpack_func) unpack_wds_SLQSStartDataSession, "unpack_wds_SLQSStartDataSession",
        &tunpack_wds_SLQSStartDataSession, dump_wds_SLQSStartDataSession
    },
    {
        (pack_func) pack_wds_SLQSGetRuntimeSettings, "pack_wds_SLQSGetRuntimeSettings",
        &tpack_wds_SLQSGetRuntimeSettings,
        (unpack_func) unpack_wds_SLQSGetRuntimeSettings, "unpack_wds_SLQSGetRuntimeSettings",
        &runtimeinfo, dump_wds_SLQSGetRuntimeSettings
    },
    {
        (pack_func) pack_wds_SLQSStopDataSession, "pack_wds_SLQSStopDataSession",
        &tpack_wds_SLQSStopDataSession,
        (unpack_func) unpack_wds_SLQSStopDataSession, "unpack_wds_SLQSStopDataSession",
        NULL, dump_wds_SLQSStopDataSession
    },
    // Profile 1 IPV4
    {
        (pack_func) pack_wds_SLQSSetIPFamilyPreference, "pack_wds_SLQSSetIPFamilyPreference",
        &pack_wds_SLQSSetIPFamilyPreference_IPV4,
        (unpack_func) unpack_wds_SLQSSetIPFamilyPreference, "unpack_wds_SLQSSetIPFamilyPreference",
        &unpack_wds_SLQSSetIPFamilyPreference_result, dump_wds_SLQSSetIPFamilyPreference
    },
    {
        (pack_func) pack_wds_SLQSStartDataSession, "pack_wds_SLQSStartDataSession",
        &tpack_wds_SLQSStartDataSession[eProfile1Slot],
        (unpack_func) unpack_wds_SLQSStartDataSession, "unpack_wds_SLQSStartDataSession",
        &tunpack_wds_SLQSStartDataSession, dump_wds_SLQSStartDataSession
    },
    {
        (pack_func) pack_wds_SLQSGetRuntimeSettings, "pack_wds_SLQSGetRuntimeSettings",
        &tpack_wds_SLQSGetRuntimeSettings,
        (unpack_func) unpack_wds_SLQSGetRuntimeSettings, "unpack_wds_SLQSGetRuntimeSettings",
        &runtimeinfo, dump_wds_SLQSGetRuntimeSettings
    },
    {
        (pack_func) pack_wds_SLQSStopDataSession, "pack_wds_SLQSStopDataSession",
        &tpack_wds_SLQSStopDataSession,
        (unpack_func) unpack_wds_SLQSStopDataSession, "unpack_wds_SLQSStopDataSession",
        NULL, dump_wds_SLQSStopDataSession
    },
    // Profile 3 IPV6
    {
        (pack_func) pack_wds_SLQSSetIPFamilyPreference, "pack_wds_SLQSSetIPFamilyPreference",
        &pack_wds_SLQSSetIPFamilyPreference_IPV6,
        (unpack_func) unpack_wds_SLQSSetIPFamilyPreference, "unpack_wds_SLQSSetIPFamilyPreference",
        &unpack_wds_SLQSSetIPFamilyPreference_result, dump_wds_SLQSSetIPFamilyPreference
    },
    {
        (pack_func) pack_wds_SLQSStartDataSession, "pack_wds_SLQSStartDataSession",
        &tpack_wds_SLQSStartDataSession[eProfile3Slot],
        (unpack_func) unpack_wds_SLQSStartDataSession, "unpack_wds_SLQSStartDataSession",
        &tunpack_wds_SLQSStartDataSession, dump_wds_SLQSStartDataSession
    },
    {
        (pack_func) pack_wds_SLQSGetRuntimeSettings, "pack_wds_SLQSGetRuntimeSettings",
        &tpack_wds_SLQSGetRuntimeSettings,
        (unpack_func) unpack_wds_SLQSGetRuntimeSettings, "unpack_wds_SLQSGetRuntimeSettings",
        &runtimeinfo, dump_wds_SLQSGetRuntimeSettings
    },
    {
        (pack_func) pack_wds_SLQSStopDataSession, "pack_wds_SLQSStopDataSession",
        &tpack_wds_SLQSStopDataSession,
        (unpack_func) unpack_wds_SLQSStopDataSession, "unpack_wds_SLQSStopDataSession",
        NULL, dump_wds_SLQSStopDataSession
    },
    // Profile 3 IPV4
    {
        (pack_func) pack_wds_SLQSSetIPFamilyPreference, "pack_wds_SLQSSetIPFamilyPreference",
        &pack_wds_SLQSSetIPFamilyPreference_IPV4,
        (unpack_func) unpack_wds_SLQSSetIPFamilyPreference, "unpack_wds_SLQSSetIPFamilyPreference",
        &unpack_wds_SLQSSetIPFamilyPreference_result, dump_wds_SLQSSetIPFamilyPreference
    },
    {
        (pack_func) pack_wds_SLQSStartDataSession, "pack_wds_SLQSStartDataSession",
        &tpack_wds_SLQSStartDataSession[eProfile3Slot],
        (unpack_func) unpack_wds_SLQSStartDataSession, "unpack_wds_SLQSStartDataSession",
        &tunpack_wds_SLQSStartDataSession, dump_wds_SLQSStartDataSession
    },
    {
        (pack_func) pack_wds_SLQSGetRuntimeSettings, "pack_wds_SLQSGetRuntimeSettings",
        &tpack_wds_SLQSGetRuntimeSettings,
        (unpack_func) unpack_wds_SLQSGetRuntimeSettings, "unpack_wds_SLQSGetRuntimeSettings",
        &runtimeinfo, dump_wds_SLQSGetRuntimeSettings
    },
    {
        (pack_func) pack_wds_SLQSStopDataSession, "pack_wds_SLQSStopDataSession",
        &tpack_wds_SLQSStopDataSession,
        (unpack_func) unpack_wds_SLQSStopDataSession, "unpack_wds_SLQSStopDataSession",
        NULL, dump_wds_SLQSStopDataSession
    },
};

void wds_indication_handler(uint16_t msgid, uint8_t *msg, uint32_t rlen)
{
    unpack_wds_SLQSSetWdsEventCallback_ind_t event;
    unpack_wds_SLQSSetPacketSrvStatusCallback_t stats;
    uint8_t count;
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    int is_matching = 1;
#endif
    memset(&event,0,sizeof(unpack_wds_SLQSSetWdsEventCallback_ind_t));
    memset(&stats,0,sizeof(unpack_wds_SLQSSetPacketSrvStatusCallback_t));

    switch(msgid)
    {
        case eQMI_WDS_SET_EVENT:
            unpack_wds_SLQSSetWdsEventCallback_ind( msg, rlen, &event);
            //it is normal that indication unpack returns eQCWWAN_ERR_INVALID_QMI_RSP(0x11)
            //which simply indicate absense of result code TLV(0x02).
            //Result code TLV is only available on Response
            printf("WDS SET EVENT Callback Info\n");
            if (event.xferStatAvail)
            {
                printf("tx_bytes = %lld\n", (unsigned long long)event.tx_bytes);
                printf("rx_bytes = %lld\n", (unsigned long long)event.rx_bytes);
                printf("tx_pkts = %lld\n",  (unsigned long long)event.tx_pkts);
                printf("rx_pkts = %lld\n",  (unsigned long long)event.rx_pkts);
            }
            if (event.mipstatAvail)
                printf("mip status = %d\n", event.mipStatus);
            if (event.dBTechAvail)
                printf("Data Bearer technology = %d\n", event.dBTechnology);
            if (event.dormancyStatAvail)
                printf("Dormancy Status = %d\n", event.dormancyStatus);
            if (event.currDBTechAvail)
            {
                printf("RAT Mask = %d\n", event.ratMask);
                printf("SO Mask = %d\n", event.soMask);
            }
            if (event.dataSysStatAvail)
            {
                printf("Preferred Network = %d\n", event.prefNetwork);
                for(count=0;count<event.netInfoLen; count++)
                {
                    printf("Network Type = %d\n", event.currNWInfo[count].NetworkType);
                    printf("RAT Mask = %d\n", event.currNWInfo[count].RATMask);
                    printf("SO Mask = %d\n", event.currNWInfo[count].SOMask);
                }
            }

            #if DEBUG_LOG_TO_FILE
            fp = fopen("./TestResults/testlog.txt", "a");
            if ( (event.tx_bytes == 0) ||
                (event.tx_pkts == 0))
            {
                is_matching = 0;
            }
            if ( fp )
            {
                fprintf(fp, "%-60s%-20s%-s\n", "unpack_wds_SLQSSetWdsEventCallback_ind", "N/A",\
                ((is_matching ==1) ? "Correct": "Wrong"));
            }
            else
            {
                fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
            }
            if(fp)
                fclose(fp);
        #endif

            break;

        case eQMI_WDS_GET_PKT_STATUS:
            unpack_wds_SLQSSetPacketSrvStatusCallback( msg, rlen, &stats);
            printf("WDS GET PKT STATUS Callback Info\n");
            printf("connection status:%d\n", stats.conn_status);
            printf("reconfiguration required:%d\n", stats.reconfigReqd);
            printf("Session end reason:%d\n", stats.sessionEndReason);
            printf("Verbose session end reason type:%d\n", stats.verboseSessnEndReasonType);
            printf("Verbose session end reason:%d\n", stats.verboseSessnEndReason);
            printf("IP family:%d\n", stats.ipFamily);
            printf("technology name:%d\n", stats.techName);
            printf("bearer id:%d\n", stats.bearerID);
        
        #if DEBUG_LOG_TO_FILE
            fp = fopen("./TestResults/testlog.txt", "a");
            /* expected result, connection status can be some value except 0 & reconfigReqd should be 0 or 1 */
            if (( stats.conn_status == 0) ||
                    ( stats.reconfigReqd >1))
            {
                is_matching = 0;
            }
            if ( fp )
            {
                fprintf(fp, "%-60s%-20s%-s\n", "unpack_wds_SLQSSetPacketSrvStatusCallback", "N/A",\
                ((is_matching ==1) ? "Correct": "Wrong"));
            }
            else
            {
                fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
            }
            if(fp)
                fclose(fp);
        #endif

            break;
    }
}

void wds_test_pack_unpack_loop()
{
    unsigned i, j;
    printf("======WDS pack/unpack test===========\n");
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    mkdir("./TestResults/",0777);
    fp = fopen("./TestResults/testlog.txt", "w");
    if (fp != NULL)
    {
        fprintf(fp, "================WDS pack/unpack test================\n");
        fprintf(fp, "%-60s%-20s%-s\n\n", "Pack/UnPack API Name", "Status", "Unpack Payload Parsing");
    }
    else
    {
        printf("cannot open testlog.txt\n");
    }
    if(fp)
        fclose(fp);
#endif

    unsigned xid =1;
    for(i=0; i<sizeof(wdstotest)/sizeof(testitem_t); i++)
    {
        unpack_qmi_t rsp_ctx;
        int rtn;
        pack_qmi_t req_ctx;
        uint8_t rsp[QMI_MSG_MAX];
        uint8_t req[QMI_MSG_MAX];
        uint16_t rspLen, reqLen;
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid = xid;
        rtn = wdstotest[i].pack(&req_ctx, req, &reqLen,wdstotest[i].pack_ptr);

    #if DEBUG_LOG_TO_FILE
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-60s%-20s%-s\n", wdstotest[i].pack_func_name, (rtn==eQCWWAN_ERR_NONE ? "Success": "Fail"), "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
    #endif

        if(rtn!=eQCWWAN_ERR_NONE)
        {
            printf("pack fail %d \n", rtn);
            continue;
        }
        if(wds<0)
            wds = client_fd(eWDS);
        rtn = write(wds, req, reqLen);
        if (rtn!=reqLen)
            printf("write %d wrote %d\n", reqLen, rtn);

        while (1)
        {
            rspLen = read(wds, rsp, QMI_MSG_MAX);

            if ((rspLen > 0) && (rspLen != 0xffff))
            {
                printf("read %d\n", rspLen);
                helper_get_resp_ctx(eWDS, rsp, rspLen, &rsp_ctx);

                printf("<< receiving\n");
                for (j = 0; j < rspLen; j++)
                {
                    printf("%02x ", rsp[j]);
                    if ((j+1)%16 == 0)
                    {
                        printf("\n");
                    }
                }
                printf("\n");
                if (rsp_ctx.type == eRSP)
                {
                    printf("WDS RSP: ");
                    printf("msgid 0x%x\n", rsp_ctx.msgid);
                    if (rsp_ctx.xid == xid)
                    {
                        printf("run unpack %d\n",xid);
                        rtn = wdstotest[i].unpack(rsp, rspLen, wdstotest[i].unpack_ptr);
    
                    #if DEBUG_LOG_TO_FILE
                        fp = fopen("./TestResults/testlog.txt", "a");
                        if ( fp )
                        {
                            fprintf(fp, "%-60s%-20s%-s", wdstotest[i].unpack_func_name, (rtn==eQCWWAN_ERR_NONE ? "Success": "Fail"), "");
                        }
                        else
                        {
                            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
                        }
                        if(fp)
                            fclose(fp);
                    #endif
    
                        wdstotest[i].dump(wdstotest[i].unpack_ptr);
                        /* sleep 3 seconds for next write */
                        sleep(3);
                        /* skip the while loop so that the the next API can be invoked */
                        break;
                    }
                    else
                    {
                        /* the response is not belongs to this API, skip it and read again */
                        printf("xid %d\n",xid);
                        sleep(1);
                    }
                }
                else if (rsp_ctx.type == eIND)
                {
                    printf("WDS IND: msgid 0x%x\n", rsp_ctx.msgid);
                    wds_indication_handler(rsp_ctx.msgid, rsp,  rspLen);
                }
            }
            else
            {
                /* read nothing, sleep 1 second and read again */
                sleep(1);
            }
        }
        xid++;
    }
    if(wds>=0)
        close(wds);
    wds=-1;
}

