#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "packingdemo.h"
#include "uim.h"

int msqid = -1;
int uim=-1;

#define BIT_CARD_STATUS (1)
#define BIT_PHY_SLOT_STATUS (1<<4)


pack_uim_SLQSUIMEventRegister_t st_ch = { BIT_CARD_STATUS | BIT_PHY_SLOT_STATUS };
unpack_uim_SLQSUIMEventRegister_t st_ch_ed;

slots_t UimSlotsStatus[3];
uint8_t    NumberOfPhySlot = sizeof(UimSlotsStatus)/sizeof(slots_t);
unpack_uim_SLQSUIMGetSlotsStatus_t tslot_stats = {&NumberOfPhySlot, UimSlotsStatus} ;

pack_uim_SLQSUIMSwitchSlot_t tswitch_slot = {1, 1};

uim_cardStatus CardStatus;
uim_hotSwapStatus HotSwapStatus;
unpack_uim_GetCardStatus_t GetCardStatus = {&CardStatus,&HotSwapStatus,0};

uim_remainingRetries RemainingRetries;
uim_encryptedPIN1    EncryptedPIN1;
uint32_t             IndicationToken;
unpack_uim_VerifyPin_t VerifyPin ={&RemainingRetries,&EncryptedPIN1,&IndicationToken,0};

unpack_uim_UnblockPin_t UnblockPin= {&RemainingRetries,&EncryptedPIN1,&IndicationToken,0};

unpack_uim_SetPinProtection_t SetPinProtection = {&RemainingRetries,&EncryptedPIN1,&IndicationToken,0};;

uim_encryptedPIN1 test_pack_uim_VerifyPin_uim_encryptedPIN1={0,{0}};
uint8_t test_pack_uim_VerifyPin_KeyReferenceID = 1;
uint32_t test_pack_uim_IndicationToken=5;

pack_uim_VerifyPin_t VerifyPinReq[]={
    {
        NULL,//{0,{0}}, //uim_encryptedPIN1    EncryptedPIN1;
        NULL,//  &test_pack_uim_IndicationToken,//uint32_t IndicationToken;
        NULL,//1,//uint8_t KeyReferenceID;
        { 0x00, 0x01, "1" },//uim_sessionInformation sessionInfo;
        { 0x01, 0x04, "1234" },//uim_verifyUIMPIN      verifyPIN;
        0//uint16_t Tlvresult;
    },
    {
        (uim_encryptedPIN1*)&test_pack_uim_VerifyPin_uim_encryptedPIN1,//{0,{0}}, //uim_encryptedPIN1    EncryptedPIN1;
        NULL,// &test_pack_uim_IndicationToken,//uint32_t IndicationToken;
        &test_pack_uim_VerifyPin_KeyReferenceID,//1,//uint8_t KeyReferenceID;
        { 0x00, 0x01, "1" },//uim_sessionInformation sessionInfo;
        { 0x01, 0x04, "1234" },//uim_verifyUIMPIN      verifyPIN;
        0//uint16_t Tlvresult;
    },
};
uint32_t IndicationToken = 5;
uint8_t KeyReferenceID  = 1;

pack_uim_UnblockPin_t UnblockPinReq={
    {0,{0}}, //uim_encryptedPIN1    EncryptedPIN1;
    NULL,//  &IndicationToken,//uint32_t IndicationToken;
    NULL,
    { 0x00, 0x01, "1" },//uim_sessionInformation sessionInfo;
    { 0x01, 0x08, "35311082", 0x04, "1234" },//Smartone LTE SIM (RED)
    //{ 0x01, 0x08, "64159849", 0x04, "1234" },//Smartone 3G SIM (WHITE)
    //{ 0x01, 0x08, "20624355", 0x04, "1234" },//Three LTE SIM
    //{ 0x01, 0x08, "79915593", 0x04, "1234" },//Three 3G SIM
    0//uint16_t Tlvresult;
};

pack_uim_SetPinProtection_t SetPinProtectionReq[]={
    {
        //Enable Pin Protect
        {0,{0}}, //uim_encryptedPIN1    EncryptedPIN1;
        NULL,//&IndicationToken,//uint32_t IndicationToken;
        NULL,//uint8_t KeyReferenceID;
        { 0x00, 0x01, "1" },//uim_sessionInformation sessionInfo;
        { 0x01, 0x00, 0x04, "1234" },//setPINProtection      pinProtection;
        0,//uint16_t Tlvresult;
    },
    {
        //Disable Pin Protect
        {0,{0}}, //uim_encryptedPIN1    EncryptedPIN1;
        NULL,//&IndicationToken,//uint32_t IndicationToken;
        NULL,//uint8_t KeyReferenceID;
        { 0x00, 0x01, "1" },//uim_sessionInformation sessionInfo;
        { 0x01, 0x01, 0x04, "1234" },//setPINProtection      pinProtection;
        0,//uint16_t Tlvresult;
    },
    
};


/////////////////////////////////////////////////////////////
void dump_eventReg(void * ptr)
{
    unpack_uim_SLQSUIMEventRegister_t *result =
            (unpack_uim_SLQSUIMEventRegister_t *) ptr;

    printf("event mask returned %x\n", result->eventMask);
}

void dump_SLQSUIMSwitchSlot(void * ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s done\n", __func__);
}

void dump_SLQSUIMGetSlotsStatus(void * ptr)
{
    unpack_uim_SLQSUIMGetSlotsStatus_t *result =
            (unpack_uim_SLQSUIMGetSlotsStatus_t*) ptr;

    uint8_t i = 0, j = 0;
    printf("Physical Slot Status Length:%d\n",*(result->pNumberOfPhySlot));
    for( i = 0; i < *(result->pNumberOfPhySlot); i++)
    {
        printf("\t%d. Physical Card Status :%u\n",i+1,result->pUimSlotsStatus->uimSlotStatus[i].uPhyCardStatus);
        printf("\t%d. Physical Slot Status :%u\n",i+1,result->pUimSlotsStatus->uimSlotStatus[i].uPhySlotStatus);
        printf("\t%d. Logical Slot :%d\n",i+1,result->pUimSlotsStatus->uimSlotStatus[i].bLogicalSlot);
        printf("\t%d. ICCID Length :%d\n",i+1,result->pUimSlotsStatus->uimSlotStatus[i].bICCIDLength);
        printf("\t%d. ICCID :",i+1);
        for(j=0;j<result->pUimSlotsStatus->uimSlotStatus[i].bICCIDLength;j++)
            printf("0x%02X ",result->pUimSlotsStatus->uimSlotStatus[i].bICCID[j]);
        printf("\n");
    }
}

void dump_GetCardStatus(void * ptr)
{
    unpack_uim_GetCardStatus_t *result =
            (unpack_uim_GetCardStatus_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    int lcount,lIcount1,lIcount;
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("Index of the primary GW   : %x\n",
                         result->pCardStatus->indexGwPri);
    printf("Index of the primary 1X   : %x\n",
                         result->pCardStatus->index1xPri);
    printf("Index of the secondary GW : %x\n",
                         result->pCardStatus->indexGwSec);
    printf("Index of the secondary 1X : %x\n",
                         result->pCardStatus->index1xSec);
    printf("Slots Available           : %x\n",
                         result->pCardStatus->numSlot);
    for ( lcount=0 ; lcount < result->pCardStatus->numSlot; lcount++ )
    {
        uim_slotInfo *temp = &result->pCardStatus->SlotInfo[lcount];
        printf( "\tInformation for SLOT%d\n ",lcount+1);
        printf( "\tState of the Card         : %x\n", temp->cardState);
        printf( "\tState of the UPIN         : %x\n", temp->upinState);
        printf( "\tRetries Remaining(UPIN)   : %d\n", temp->upinRetries);
        printf( "\tRetries Remaining(UPUK)   : %d\n", temp->upukRetries);
        printf( "\tReason For Error          : %x\n", temp->errorState);
        printf( "\tNo. of Apps Allowed       : %d\n", temp->numApp);
        for ( lIcount=0 ; lIcount < temp->numApp; lIcount++ )
        {
            uim_appStatus *lresp = &temp->AppStatus[lIcount];
            printf( "\t\tApplication Status Information for App%d\n ",lIcount+1);
            printf( "\t\tType of Application       : %x\n", lresp->appType);
            printf( "\t\tState of Application      : %x\n", lresp->appState);
            printf( "\t\tState of perso for App    : %x\n", lresp->persoState);
            printf( "\t\tIndicates perso feature   : %x\n", lresp->persoFeature);
            printf( "\t\tRetries Remaining(Perso BL): %d\n",
                                 lresp->persoRetries);
            printf( "\t\tRetries Remaining(Perso UB): %d\n",
                                 lresp->persoUnblockRetries);
            printf( "\t\tApplication Identifier Len: %d\n", lresp->aidLength);
            printf( "\t\tApplication Identifier Value : ");
            for ( lIcount1=0 ; lIcount1 < lresp->aidLength; lIcount1++ )
            {
                printf( "%c", lresp->aidVal[lIcount1]);
            }
            printf("\n");
            printf( "\t\tIndication for UPIN       : %x\n", lresp->univPin);
            printf( "\t\tIndicates State of Pin1   : %x\n", lresp->pin1State);
            printf( "\t\tRetries Remaining(PIN1)   : %d\n", lresp->pin1Retries);
            printf( "\t\tRetries Remaining(PUK1)   : %d\n", lresp->puk1Retries);
            printf( "\t\tIndicates State of Pin2   : %x\n", lresp->pin2State);
            printf( "\t\tRetries Remaining(PIN2)   : %d\n", lresp->pin2Retries);
            printf( "\t\tRetries Remaining(PUK2)   : %d\n", lresp->puk2Retries);
        }
    }
}

void dump_VerifyPin(void * ptr)
{
    unpack_uim_VerifyPin_t *result =
            (unpack_uim_VerifyPin_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
     printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_UnblockPin(void * ptr)
{
    unpack_uim_UnblockPin_t *result =
            (unpack_uim_UnblockPin_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
     printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_SetPinProtection(void * ptr)
{
    unpack_uim_SetPinProtection_t *result =
            (unpack_uim_SetPinProtection_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
     printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}



testitem_t totestuim[] = {
    {
        (pack_func) pack_uim_SLQSUIMSwitchSlot, "pack_uim_SLQSUIMSwitchSlot",
        &tswitch_slot,
        (unpack_func) unpack_uim_SLQSUIMSwitchSlot, "unpack_uim_SLQSUIMSwitchSlot",
        NULL, dump_SLQSUIMSwitchSlot
    },
    {
        (pack_func) pack_uim_SLQSUIMGetSlotsStatus, "pack_uim_SLQSUIMGetSlotsStatus",
        NULL,
        (unpack_func) unpack_uim_SLQSUIMGetSlotsStatus, "unpack_uim_SLQSUIMGetSlotsStatus",
        &tslot_stats, dump_SLQSUIMGetSlotsStatus
    },
    {
        (pack_func) pack_uim_SLQSUIMEventRegister, "pack_uim_SLQSUIMEventRegister",
        &st_ch, 
        (unpack_func) unpack_uim_SLQSUIMEventRegister, "unpack_uim_SLQSUIMEventRegister",
        &st_ch_ed, dump_eventReg
    },
    {
        (pack_func) pack_uim_GetCardStatus, "pack_uim_GetCardStatus",
        NULL, 
        (unpack_func) unpack_uim_GetCardStatus, "unpack_uim_GetCardStatus",
        NULL, dump_GetCardStatus
    },

    {
        (pack_func) pack_uim_GetCardStatus, "pack_uim_GetCardStatus",
        NULL, 
        (unpack_func) unpack_uim_GetCardStatus, "unpack_uim_GetCardStatus",
        &GetCardStatus, dump_GetCardStatus
    },
#if 0
    {
        (pack_func) pack_uim_VerifyPin, "pack_uim_VerifyPin",
        NULL, 
        (unpack_func) unpack_uim_VerifyPin, "unpack_uim_VerifyPin",
        &VerifyPin, dump_VerifyPin
    },
#endif
    {
        (pack_func) pack_uim_VerifyPin, "pack_uim_VerifyPin",
        &VerifyPinReq[0], 
        (unpack_func) unpack_uim_VerifyPin, "unpack_uim_VerifyPin",
        &VerifyPin, dump_VerifyPin
    },
#if 0
    {
        (pack_func) pack_uim_VerifyPin, "pack_uim_VerifyPin",
        &VerifyPinReq[1], 
        (unpack_func) unpack_uim_VerifyPin, "unpack_uim_VerifyPin",
        &VerifyPin, dump_VerifyPin
    },
#endif
    {
        (pack_func) pack_uim_UnblockPin, "pack_uim_UnblockPin",
        &UnblockPinReq, 
        (unpack_func) unpack_uim_UnblockPin, "unpack_uim_UnblockPin",
        &UnblockPin, dump_UnblockPin
    },
    {
        (pack_func) pack_uim_SetPinProtection, "pack_uim_SetPinProtection",
        &SetPinProtectionReq[0], 
        (unpack_func) unpack_uim_SetPinProtection, "unpack_uim_SetPinProtection",
        &SetPinProtection, dump_SetPinProtection
    },
    {
        (pack_func) pack_uim_SetPinProtection, "pack_uim_SetPinProtection",
        &SetPinProtectionReq[1], 
        (unpack_func) unpack_uim_SetPinProtection, "unpack_uim_SetPinProtection",
        &SetPinProtection, dump_SetPinProtection
    },
};

/////////////////////////////////////////////////////////////

void
hexdump(uint8_t *rsp, uint16_t len)
{
    int j;
    for(j=0 ;j<len; j++)
        printf("%02x ", rsp[j]);
    printf("\n");
}

void
dump_slot_stats( unpack_uim_SetUimSlotStatusChangeCallback_ind_t* pslot_stat )
{
    int i = 0;
    int slotcount = 0;
    printf(">>%s\n", __func__);
    printf("NumberOfPhySlots:%d\n",pslot_stat->bNumberOfPhySlots);

    for(slotcount=0;slotcount<pslot_stat->bNumberOfPhySlots;slotcount++)
    {
        printf("Slot:%d\n",slotcount+1);
        printf("\tPhysical Card Status:%u\n",pslot_stat->slotsstatusChange.uimSlotStatus[slotcount].uPhyCardStatus);
        printf("\tPhysical Slot Status:%u\n",pslot_stat->slotsstatusChange.uimSlotStatus[slotcount].uPhySlotStatus);
        printf("\tLogicalSlot:%d\n",pslot_stat->slotsstatusChange.uimSlotStatus[slotcount].bLogicalSlot);
        printf("\tICCIDLength:%d\n",pslot_stat->slotsstatusChange.uimSlotStatus[slotcount].bICCIDLength);
        printf("\tICCID: ");
        for(i=0;i<pslot_stat->slotsstatusChange.uimSlotStatus[slotcount].bICCIDLength;i++)
            printf("0x%02X ",pslot_stat->slotsstatusChange.uimSlotStatus[slotcount].bICCID[i]);
        printf("\n" );
    }
}

void
dump_stats( unpack_uim_SLQSUIMSetStatusChangeCallBack_ind_t* pstat )
{
    int i,j,k;
    printf(">>%s\n", __func__);
    printf("\tindexGwPri 0x%04x\n", pstat->pCardStatus->indexGwPri);
    printf("\tindex1xPri 0x%04x\n", pstat->pCardStatus->index1xPri);
    printf("\tindexGwSec 0x%04x\n", pstat->pCardStatus->indexGwSec);
    printf("\tindex1xSec 0x%04x\n", pstat->pCardStatus->index1xSec);
    printf("\tnumSlot %d\n", pstat->pCardStatus->numSlot);
    for(i=0; i<pstat->pCardStatus->numSlot; i++)
    {
        printf("\t\tslot[%d]: card state %d\n", i, pstat->pCardStatus->SlotInfo[i].cardState);
        printf("\t\tslot[%d]: upin state %d\n", i, pstat->pCardStatus->SlotInfo[i].upinState);
        printf("\t\tslot[%d]: upin retries %d\n", i, pstat->pCardStatus->SlotInfo[i].upinRetries);
        printf("\t\tslot[%d]: upuk retries %d\n", i, pstat->pCardStatus->SlotInfo[i].upukRetries);
        printf("\t\tslot[%d]: error state %d\n", i, pstat->pCardStatus->SlotInfo[i].errorState);
        printf("\t\tslot[%d]: num app %d\n", i, pstat->pCardStatus->SlotInfo[i].numApp);
        for(j=0; j<pstat->pCardStatus->SlotInfo[i].numApp; j++)
        {
            printf("\t\t\tapp[%d]: type %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].appType);
            printf("\t\t\tapp[%d]: state %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].appState);
            printf("\t\t\tapp[%d]: perso state %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].persoState);
            printf("\t\t\tapp[%d]: perso feateure %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].persoFeature);
            printf("\t\t\tapp[%d]: perso retries %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].persoRetries);
            printf("\t\t\tapp[%d]: perso unblock retries %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].persoUnblockRetries);
            printf("\t\t\tapp[%d]: aid len %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].aidLength);
            printf("\t\t\tapp[%d]: aid vals:\n\t\t\t\t", j);
            for(k=0; k<pstat->pCardStatus->SlotInfo[i].AppStatus[j].aidLength; k++)
                printf("%d ", pstat->pCardStatus->SlotInfo[i].AppStatus[j].aidVal[k]);
            printf("\n");
            printf("\t\t\tapp[%d]: univ pin %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].univPin);
            printf("\t\t\tapp[%d]: pin1 state %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].pin1State);
            printf("\t\t\tapp[%d]: pin1 retries %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].pin1Retries);
            printf("\t\t\tapp[%d]: puk1 retries %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].puk1Retries);
            printf("\t\t\tapp[%d]: pin2 state %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].pin2State);
            printf("\t\t\tapp[%d]: pin2 retries %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].pin2Retries);
            printf("\t\t\tapp[%d]: puk1 retries %d\n", j, pstat->pCardStatus->SlotInfo[i].AppStatus[j].puk1Retries);
        }
    }
}

void* readthread(void* ptr)
{
    unsigned *running = (unsigned*) ptr;
    uint8_t rsp[QMI_MSG_MAX];
    uint16_t rspLen;
    int rtn;
    uim_cardStatus changeStatus;
    unpack_uim_SLQSUIMSetStatusChangeCallBack_ind_t stats= {&changeStatus};
    unpack_uim_SetUimSlotStatusChangeCallback_ind_t slot_stats;

    while(*running)
    {
        rspLen = read(uim, rsp, QMI_MSG_MAX);
        if (rspLen > 0)
        {
            if (rsp[0] == eRSP)//non empty response
            {
                msgsnd(msqid, rsp, rspLen, 0);
            }
            else if (rsp[0] == eIND)
            {
                switch (rsp[3]) //FIXME high byte ignore
                {
                    case eQMI_UIM_STATUS_CHANGE_IND:
                        rtn = unpack_uim_SLQSUIMSetStatusChangeCallBack_ind(
                                rsp, rspLen, &stats);
                        if (!rtn)
                            dump_stats(&stats);
                        break;

                    case eQMI_UIM_SLOT_STATUS_IND:
                        rtn = unpack_uim_SetUimSlotStatusChangeCallback_ind(
                                rsp, rspLen, &slot_stats);
                        if (!rtn)
                            dump_slot_stats(&slot_stats);
                        break;
                }
            }
            else
                hexdump(rsp, rspLen);
        }
    }
    return NULL;
}


void uim_test_pack_unpack_loop()
{
    unsigned i;
    unsigned xid =1;
    pthread_attr_t attr;
    unsigned running = 1;
    pthread_t tid;
    if(uim<0)
        uim = client_fd(eUIM);
    key_t key;

    key = ftok("/dev/random", 'c');
    msqid = msgget(key, 0666 | IPC_CREAT);
    memset(&attr, 0, sizeof(attr));
    pthread_create(&tid, &attr, readthread, &running);

    printf("======UIM pack/unpack test===========\n");
    for(i=0; i<sizeof(totestuim)/sizeof(testitem_t); i++)
    {
        unpack_qmi_t rsp_ctx;
        int rtn;
        pack_qmi_t req_ctx;
        uint8_t rsp[QMI_MSG_MAX];
        uint8_t req[QMI_MSG_MAX];
        uint16_t rspLen, reqLen;
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid = xid;
        rtn = totestuim[i].pack(&req_ctx, req, &reqLen,totestuim[i].pack_ptr);
        if(rtn!=eQCWWAN_ERR_NONE)
        {
            continue;
        }
        rtn = write(uim, req, reqLen);
        if (rtn!=reqLen)
            printf("write %d wrote %d\n", reqLen, rtn);
        rspLen = QMI_MSG_MAX; //TODO not really use further, set to max for now
        msgrcv(msqid, &rsp, sizeof(rsp), 0, 0);
        helper_get_resp_ctx(eUIM, rsp, rspLen, &rsp_ctx);

        if (rsp_ctx.xid == xid)
        {
            totestuim[i].unpack(rsp, rspLen, totestuim[i].unpack_ptr);
            totestuim[i].dump(totestuim[i].unpack_ptr);
        }
        xid++;
    }
    printf("wait 10s for uim indication, try insert/remove sim...\n");
    sleep(10);
    running = 0;
    msgctl(msqid, IPC_RMID, NULL);
    if(uim>=0)
        close(uim);
    uim = -1;
}

void uim_test()
{    
    pack_qmi_t req_ctx;    
    int rtn;

    uint8_t qmi_req[QMI_MSG_MAX];
    uint16_t qmi_req_len;
    uint8_t rsp[QMI_MSG_MAX];
    uint16_t rspLen;
    unpack_qmi_t rsp_ctx;
    if(uim<0)
        uim = client_fd(11);

    /* UIM_READ_TRANSPARENT :This parameter contains the file information for ICCID Elementary File */
    uim_UIMSessionInformation sessionInfo_ICCID = { 0x00, 0x00, "" };
    uim_fileInfo             fileEF_ICCID  = { 0x2FE2, 0x02, {0x3F00} };
    uim_readTransparentInfo  readtp_ICCID   = { 0, 0 };

    uim_cardResult   CardResult;
    uim_readResult   ReadResult;
    uint32_t        IndicationToken = 0xffffffff;
    uint8_t         EncryptedData = 0xff;

    pack_uim_ReadTransparent_t req;
    unpack_uim_ReadTransparent_t output;
    uint16_t count;

    memset(&req,0,sizeof(req));
    memset(&output,0,sizeof(output));

    memset(&CardResult,0,sizeof(CardResult));
    memset(&ReadResult,0,sizeof(ReadResult));

    memcpy(&(req.sessionInfo),&sessionInfo_ICCID,sizeof(uim_UIMSessionInformation));
    memcpy(&(req.fileIndex),&fileEF_ICCID,sizeof(uim_fileInfo));
    memcpy(&(req.readTransparent),&readtp_ICCID,sizeof(uim_readTransparentInfo));   
    req.pIndicationToken = NULL;
    req.pEncryptData     = NULL;

    output.pCardResult      = &CardResult;
    output.pEncryptedData   = &EncryptedData;
    output.pIndicationToken = &IndicationToken;
    output.pReadResult      = &ReadResult;

    memset(qmi_req, 0, QMI_MSG_MAX);
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = 300;

    
    printf("starting read uim transparent ...\n");
    rtn = pack_uim_ReadTransparent(&req_ctx, qmi_req, &qmi_req_len, (void*)&req);
    rtn = write(uim, qmi_req, qmi_req_len);
    if (rtn != qmi_req_len)
        printf("write %d wrote %d\n", qmi_req_len, rtn);

    rspLen = read(uim, rsp, QMI_MSG_MAX);
    helper_get_resp_ctx(eUIM, rsp, rspLen, &rsp_ctx);

    if (rsp_ctx.xid == req_ctx.xid) {
        rtn = unpack_uim_ReadTransparent( rsp, rspLen,&output);
        printf("rtn %d\n", rtn);
        if ( NULL != output.pCardResult )
        {
            printf("SW1 received from card :%x\n", output.pCardResult->sw1 );
            printf("SW2 received from card :%x\n", output.pCardResult->sw2 );
        }

        if ( NULL != output.pReadResult)
        {
            printf("ICCID No: ");
            for(count=0; count < output.pReadResult->contentLen; count++)
            {
                if(count)/*Skip the first nibble */
                    printf("%x",output.pReadResult->content[count] & 0x0f);
                printf("%x", (output.pReadResult->content[count]>>4) & 0x0f);
            }
            printf("\n");
        }
    }
    if(uim>=0)
        close(uim);
    uim=-1;
}


