#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "swioma.h"
#include "packingdemo.h"

#define QMI_SWIOMA_MSG_MAX QMI_MSG_MAX

// FUNCTION PROTOTYPES
int client_fd(uint8_t svc);

// SWIOMA GLOBALS
volatile int enSwiOmaThread;
int swioma_fd;
pthread_t swioma_tid;
pthread_attr_t swioma_attr;

// TEST VALUES
#ifdef SWIOMA_EVENTS_DEBUG
uint8_t swioma_event_sample[] = {};
#endif //SWIOMA_EVENTS_DEBUG

void swioma_loop_exit(void)
{
    void *pthread_rtn_value;
    printf("\nkilling SWIOMA read thread...\n");
    enSwiOmaThread = 0;
    UNUSEDPARAM(pthread_rtn_value);
    //pthread_join(swioma_tid, &pthread_rtn_value);
    pthread_cancel(swioma_tid);    
    sleep(1);
     if(swioma_fd>=0)
        close(swioma_fd);
    swioma_fd=-1;
    return;
}

void _print_swioma_event(unpack_swioma_SLQSOMADMAlertCallback_ind_t SwiOmaAlert)
{
    printf("SwiOma Alert Type: %u\n", SwiOmaAlert.eventType);
    switch(SwiOmaAlert.eventType)
    {
    case 0x00: //SWIOMA-DM FOTA 
        printf ("SWIOMA-DM FOTA\n");
        printf ("==============\n");
        printf ("   state                : %u\n",SwiOmaAlert.SessionInfoFota.state);
        printf ("   userInputReq         : %u\n",SwiOmaAlert.SessionInfoFota.userInputReq);
        printf ("   userInputTimeout     : %u\n",SwiOmaAlert.SessionInfoFota.userInputTimeout);
        printf ("   fwdloadsize          : %u\n",SwiOmaAlert.SessionInfoFota.fwdloadsize);
        printf ("   fwloadComplete       : %u\n",SwiOmaAlert.SessionInfoFota.fwloadComplete);
        printf ("   updateCompleteStatus : %u\n",SwiOmaAlert.SessionInfoFota.updateCompleteStatus);
        printf ("   severity             : %u\n",SwiOmaAlert.SessionInfoFota.severity);
        printf ("   version              : %s\n",SwiOmaAlert.SessionInfoFota.version);
        printf ("   package_name         : %s\n",SwiOmaAlert.SessionInfoFota.package_name);
        printf ("   description          : %s\n",SwiOmaAlert.SessionInfoFota.description);
        printf ("   sessionType          : %u\n",SwiOmaAlert.SessionInfoFota.sessionType);
        break;
    case 0x01: //SWIOMA-DM Config 
        printf ("SWIOMA-DM Config\n");
        printf ("================\n");
        printf ("   state            : %u\n",SwiOmaAlert.SessionInfoConfig.state);
        printf ("   userInputReq     : %u\n",SwiOmaAlert.SessionInfoConfig.userInputReq);
        printf ("   userInputTimeout : %u\n",SwiOmaAlert.SessionInfoConfig.userInputTimeout);
        printf ("   alertmsg         : %s\n",SwiOmaAlert.SessionInfoConfig.alertmsg);
        break;
    case 0x02: //SWIOMA-DM Notification 
        printf ("SWIOMA-DM Notification\n");
        printf ("======================\n");
        printf ("   notification  : %u\n",SwiOmaAlert.SessionInfoNotification.notification);
        printf ("   sessionStatus : %u\n",SwiOmaAlert.SessionInfoNotification.sessionStatus);
        break;        
    }
}

void _print_swioma_session_info(unpack_swioma_SLQSOMADMGetSessionInfo_t  SwiOmaSessionInfo)
{
    printf ("Status               : %u\n",SwiOmaSessionInfo.Status);
    printf ("UpdateCompleteStatus : %u\n",SwiOmaSessionInfo.UpdateCompleteStatus);
    printf ("Severity             : %u\n",SwiOmaSessionInfo.Severity);
    printf ("SourceLength         : %u\n",SwiOmaSessionInfo.SourceLength);
    printf ("Source               : %s\n",SwiOmaSessionInfo.Source);
    printf ("PkgNameLength        : %u\n",SwiOmaSessionInfo.PkgNameLength);
    printf ("PkgName              : %s\n",SwiOmaSessionInfo.PkgName);
    printf ("PkgDescLength        : %u\n",SwiOmaSessionInfo.PkgDescLength);
    printf ("PkgDescription       : %s\n",SwiOmaSessionInfo.PkgDescription);
    printf ("DateLength           : %u\n",SwiOmaSessionInfo.DateLength);
    printf ("Date                 : %s\n",SwiOmaSessionInfo.Date);
    printf ("TimeLength           : %u\n",SwiOmaSessionInfo.TimeLength);
    printf ("Time                 : %s\n",SwiOmaSessionInfo.Time);
    printf ("SessionType          : %u\n",SwiOmaSessionInfo.SessionType);
    printf ("SessionState         : %u\n",SwiOmaSessionInfo.SessionState);
    printf ("RetryCount           : %u\n",SwiOmaSessionInfo.RetryCount);
}

void *swioma_read_thread(void* ptr)
{
    UNUSEDPARAM(ptr);
    const char *qmi_msg;
    unpack_qmi_t rsp_ctx;
    uint8_t  buffer[QMI_SWIOMA_MSG_MAX]={'0'};

    int rtn;
    ssize_t rlen;
    printf ("SWIOMA read thread\n");
    while(enSwiOmaThread)
    {
        //TODO select multiple file and read them
        memset (buffer,0,QMI_SWIOMA_MSG_MAX);
        rlen = read(swioma_fd, buffer, QMI_SWIOMA_MSG_MAX);
        if (rlen > 0)
        {
            qmi_msg = helper_get_resp_ctx(eSWIOMA, buffer, rlen, &rsp_ctx);
            printf("<< receiving %s, Len: %zu\n", qmi_msg, rlen);

            if (eIND == rsp_ctx.type)
                printf("SWIOMA IND: ");
            else if (eRSP == rsp_ctx.type)
                printf("SWIOMA RSP: ");
            printf("msgid 0x%02x\n", rsp_ctx.msgid);

            switch(rsp_ctx.msgid)
            {
                /** eQMI_SWIOMA_EVENT_IND **/
                case eQMI_SWIOMA_EVENT_IND:
                    if (eIND == rsp_ctx.type)
                    {
                        unpack_swioma_SLQSOMADMAlertCallback_ind_t SwiOmaInd;
                        memset (&SwiOmaInd,0,sizeof(SwiOmaInd));
                        rtn = unpack_swioma_SLQSOMADMAlertCallback_ind (buffer, rlen, &SwiOmaInd);
                        printf("unpack_swioma_SLQSOMADMAlertCallback_ind return: %d\n", rtn);
                        _print_swioma_event(SwiOmaInd);
                    }
                    else if (eRSP == rsp_ctx.type)
                    {
                        rtn = unpack_swioma_SLQSOMADMAlertCallback (buffer, rlen);
                        printf("unpack_swioma_SLQSOMADMAlertCallback return: %d\n", rtn);
                    }                    
                    break; //eQMI_SWIOMA_EVENT_IND
                
                /** eQMI_SWIOMA_SET_EVENT **/
                case eQMI_SWIOMA_SET_EVENT:
                    {
                        rtn = unpack_swioma_SLQSOMADMAlertCallback (buffer, rlen);
                        printf("unpack_swioma_SLQSOMADMAlertCallback return: %d\n", rtn);
                    } 
                    break;//eQMI_SWIOMA_SET_EVENT
                    
                /** eQMI_SWIOMA_START_SESSION **/
                case eQMI_SWIOMA_START_SESSION:
                    {
                        unpack_swioma_SLQSOMADMStartSession_t SwiOmaRsp={0};
                        rtn = unpack_swioma_SLQSOMADMStartSession (buffer, rlen, &SwiOmaRsp);
                        printf("unpack_swioma_SLQSOMADMStartSession return: %d\n", rtn);
                        printf("\tFW Available: %u\n", SwiOmaRsp.FwAvailability);
                    }
                    break; //eQMI_SWIOMA_START_SESSION
                
                /** eQMI_SWIOMA_CANCEL_SESSION **/
                case eQMI_SWIOMA_CANCEL_SESSION:
                    {
                        rtn = unpack_swioma_SLQSOMADMCancelSession (buffer, rlen);
                        printf("unpack_swioma_SLQSOMADMCancelSession return: %d\n", rtn);
                    }
                    break; //eQMI_SWIOMA_CANCEL_SESSION
                    
                /** eQMI_SWIOMA_SET_SETTINGS **/
                case eQMI_SWIOMA_SET_SETTINGS:
                    {
                        rtn = unpack_swioma_SLQSOMADMSetSettings (buffer, rlen);
                        printf("unpack_swioma_SLQSOMADMSetSettings return: %d\n", rtn);
                    }
                    break; //eQMI_SWIOMA_SET_SETTINGS
                
                /** eQMI_SWIOMA_GET_SETTINGS **/
                case eQMI_SWIOMA_GET_SETTINGS:
                    {
                        unpack_swioma_SLQSOMADMGetSettings_t SwiOmaRsp={0,0,0,0,0};
                        rtn = unpack_swioma_SLQSOMADMGetSettings (buffer, rlen, &SwiOmaRsp);
                        printf("unpack_swioma_SLQSOMADMGetSettings return: %d\n", rtn);
                        printf("  OMADMEnabled: %u\n", SwiOmaRsp.OMADMEnabled);
                        printf("  FOTAdownload: %u\n", SwiOmaRsp.FOTAdownload);
                        printf("  FOTAUpdate  : %u\n", SwiOmaRsp.FOTAUpdate);
                        printf("  Autosdm     : %u\n", SwiOmaRsp.Autosdm);
                        printf("  FwAutoCheck : %u\n", SwiOmaRsp.FwAutoCheck);
                    }
                    break; //eQMI_SWIOMA_GET_SETTINGS
                    
                /** eQMI_SWIOMA_SEND_SELECTION **/
                case eQMI_SWIOMA_SEND_SELECTION:
                    {
                        rtn = unpack_swioma_SLQSOMADMSendSelection (buffer, rlen);
                        printf("unpack_swioma_SLQSOMADMSendSelection return: %d\n", rtn);
                    }
                    break; //eQMI_SWIOMA_SEND_SELECTION
                    
                /** eQMI_SWIOMA_GET_SESSION_INFO **/
                case eQMI_SWIOMA_GET_SESSION_INFO:
                    {
                        unpack_swioma_SLQSOMADMGetSessionInfo_t SwiOmaRsp;
                        memset (&SwiOmaRsp,0,sizeof(unpack_swioma_SLQSOMADMGetSessionInfo_t));
                        SwiOmaRsp.SourceLength  = LIBPACK_MAX_SWIOMA_STR_LEN;
                        SwiOmaRsp.PkgNameLength = LIBPACK_MAX_SWIOMA_STR_LEN;
                        SwiOmaRsp.PkgDescLength = LIBPACK_MAX_SWIOMA_STR_LEN;
                        SwiOmaRsp.DateLength    = LIBPACK_MAX_SWIOMA_STR_LEN;
                        SwiOmaRsp.TimeLength    = LIBPACK_MAX_SWIOMA_STR_LEN;
                        
                        rtn = unpack_swioma_SLQSOMADMGetSessionInfo (buffer, rlen, &SwiOmaRsp);
                        printf("unpack_swioma_SLQSOMADMGetSessionInfo return: %d\n", rtn);
                        _print_swioma_session_info(SwiOmaRsp);
                    }
                    break; //eQMI_SWIOMA_GET_SESSION_INFO
                    
                default:
                    break;
            }
        }
    }    
    return NULL;
}

void swioma_loop(void)
{
    uint8_t  buffer[QMI_SWIOMA_MSG_MAX]={'0'};
    uint16_t reqLen = QMI_SWIOMA_MSG_MAX;
    pack_qmi_t req_ctx;
    uint16_t   txID = 0x101;
    int rtn = -1;
    // Get SWIOMA FD
    swioma_fd = client_fd(eSWIOMA); 
    sleep(1);
    // Start SWIOMA read thread
    memset(&swioma_attr, 0, sizeof(swioma_attr));
    enSwiOmaThread = 1;
    pthread_create(&swioma_tid, &swioma_attr, swioma_read_thread, NULL);

    sleep(1);
    // Register for SWIOMA event notification
    {
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = txID;
    txID++;
    rtn = pack_swioma_SLQSOMADMAlertCallback (&req_ctx,buffer,&reqLen);
    fprintf (stderr, "pack_swioma_SLQSOMADMAlertCallback ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(swioma_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);
    }

    sleep(5);
    // Start CI-PRL Session
    {
    pack_swioma_SLQSOMADMStartSession_t swioma_req;
    swioma_req.sessionType = 0x03; //CI PRL
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = txID;
    txID++;
    reqLen = QMI_SWIOMA_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn =  pack_swioma_SLQSOMADMStartSession(&req_ctx,buffer,&reqLen,swioma_req);
    fprintf (stderr, "pack_swioma_SLQSOMADMStartSession (CI-PRL) ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(swioma_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);
    }

    sleep(2);
    // OMA Get Session Info
    {
    pack_swioma_SLQSOMADMGetSessionInfo_t swioma_req;
    swioma_req.SessionType     = 0xFF; // Any active OMADM session
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = txID;
    txID++;
    reqLen = QMI_SWIOMA_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn = pack_swioma_SLQSOMADMGetSessionInfo(&req_ctx,buffer,&reqLen,swioma_req);
    fprintf (stderr, "pack_swioma_SLQSOMADMGetSessionInfo ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(swioma_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);
    }        
    
    sleep(1);
    // Cancel CI-PRL Session
    {
    pack_swioma_SLQSOMADMCancelSession_t swioma_req;
    swioma_req.sessionType = 0xFF; //Any OMA session
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = txID;
    txID++;
    reqLen = QMI_SWIOMA_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn =  pack_swioma_SLQSOMADMCancelSession(&req_ctx,buffer,&reqLen,swioma_req);
    fprintf (stderr, "pack_swioma_SLQSOMADMCancelSession (Any OMA) ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(swioma_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);
    }
    
    sleep(7);
    // OMA Set Settings
    {
    uint8_t Autosdm     = 0;
    uint8_t FwAutoCheck = 0;
    pack_swioma_SLQSOMADMSetSettings_t swioma_req;
    swioma_req.FOTAdownload = 0;
    swioma_req.FOTAUpdate   = 0;
    swioma_req.pAutosdm     = &Autosdm;
    swioma_req.pFwAutoCheck = &FwAutoCheck;
    
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = txID;
    txID++;
    reqLen = QMI_SWIOMA_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn = pack_swioma_SLQSOMADMSetSettings(&req_ctx,buffer,&reqLen,swioma_req);
    fprintf (stderr, "pack_swioma_SLQSOMADMSetSettings ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(swioma_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);
    }    
    
    sleep(30);
    // OMA Get Settings
    {
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = txID;
    txID++;
    reqLen = QMI_SWIOMA_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn = pack_swioma_SLQSOMADMGetSettings(&req_ctx,buffer,&reqLen);
    fprintf (stderr, "pack_swioma_SLQSOMADMGetSettings ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(swioma_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);
    }    

    sleep(5);
    // OMA Send Selection
    {
    uint32_t  DeferTime    = 0;
    uint32_t  RejectReason = 1; // Just some value
    pack_swioma_SLQSOMADMSendSelection_t  swioma_req;
    swioma_req.selection     = 0x01; // Accept
    swioma_req.pDeferTime    = &DeferTime;
    swioma_req.pRejectReason = &RejectReason;
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = txID;
    txID++;
    reqLen = QMI_SWIOMA_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn = pack_swioma_SLQSOMADMSendSelection(&req_ctx,buffer,&reqLen,swioma_req);
    fprintf (stderr, "pack_swioma_SLQSOMADMSendSelection ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(swioma_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);
    }
    sleep(5);
    return;
}
