#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "packingdemo.h"

#include "swiloc.h"

int swiloc=-1;

unpack_swiloc_SwiLocGetAutoStart_t tunpack_swiloc_SwiLocGetAutoStart;
pack_swiloc_SwiLocSetAutoStart_t tpack_swiloc_SwiLocSetAutoStart = {
   2, 1,
   1, 1,
   255, 1,
   1000, 1,
   1, 1
};

void dump_swiloc_SwiLocGetAutoStart(void *ptr)
{
   unpack_swiloc_SwiLocGetAutoStart_t *resp =
      (unpack_swiloc_SwiLocGetAutoStart_t*) ptr;

   if (resp->function_reported)
      printf("\tfunction: %d\n", resp->function );
   if (resp->fix_type_reported)
      printf("\tfix_type: %d \n", resp->fix_type);
   if (resp->max_time_reported)
      printf("\tmax_time: %d\n", resp->max_time);
   if (resp->max_dist_reported)
      printf("\tmax_dist: %d\n", resp->max_dist);
   if (resp->fix_rate_reported)
      printf("\tfix_rate: %d\n", resp->fix_rate);

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_swiloc_SwiLocSetAutoStart(void *ptr)
{
   UNUSEDPARAM(ptr);
#if DEBUG_LOG_TO_FILE
   FILE *fp;
   fp = fopen("./TestResults/testlog.txt", "a");
   if ( fp )
   {
      fprintf(fp, "%-10s\n", "N/A");
   }
   else
   {
      fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
   }
   if(fp)
    fclose(fp);
#endif
}

testitem_t swiloctotest[] = {
    {
        (pack_func) pack_swiloc_SwiLocGetAutoStart, "pack_swiloc_SwiLocGetAutoStart",
        NULL,
        (unpack_func) unpack_swiloc_SwiLocGetAutoStart, "unpack_swiloc_SwiLocGetAutoStart",
        &tunpack_swiloc_SwiLocGetAutoStart, dump_swiloc_SwiLocGetAutoStart
    },
    {
        (pack_func) pack_swiloc_SwiLocSetAutoStart, "pack_swiloc_SwiLocSetAutoStart",
        &tpack_swiloc_SwiLocSetAutoStart,
        (unpack_func) unpack_swiloc_SwiLocSetAutoStart, "unpack_swiloc_SwiLocGetAutoStart",
        NULL, dump_swiloc_SwiLocSetAutoStart
    },
};

void swiloc_test_pack_unpack_loop()
{
    unsigned i, j;
    printf("======SWI LOC pack/unpack test===========\n");
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    mkdir("./TestResults/",0777);
    fp = fopen("./TestResults/testlog.txt", "w");
    if (fp != NULL)
    {
        fprintf(fp, "================SWI LOC pack/unpack test================\n");
        fprintf(fp, "%-60s%-20s%-s\n\n", "Pack/UnPack API Name", "Status", "Unpack Payload Parsing");
    }
    else
    {
        printf("cannot open testlog.txt\n");
    }
    if(fp)
        fclose(fp);
#endif

    unsigned xid =1;
    for(i=0; i<sizeof(swiloctotest)/sizeof(testitem_t); i++)
    {
        unpack_qmi_t rsp_ctx;
        int rtn;
        pack_qmi_t req_ctx;
        uint8_t rsp[QMI_MSG_MAX];
        uint8_t req[QMI_MSG_MAX];
        uint16_t rspLen, reqLen;
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid = xid;
        rtn = swiloctotest[i].pack(&req_ctx, req, &reqLen, swiloctotest[i].pack_ptr);

    #if DEBUG_LOG_TO_FILE
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-60s%-20s%-s\n", swiloctotest[i].pack_func_name, (rtn==eQCWWAN_ERR_NONE ? "Success": "Fail"), "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
    #endif

        if(rtn!=eQCWWAN_ERR_NONE)
        {
            printf("pack fail %d \n", rtn);
            continue;
        }
        if(swiloc<0)
            swiloc = client_fd(eSWILOC);
        rtn = write(swiloc, req, reqLen);
        if (rtn!=reqLen)
            printf("write %d wrote %d\n", reqLen, rtn);

        while (1)
        {
            rspLen = read(swiloc, rsp, QMI_MSG_MAX);

            if ((rspLen > 0) && (rspLen != 0xffff))
            {
                printf("read %d\n", rspLen);
                helper_get_resp_ctx(eSWILOC, rsp, rspLen, &rsp_ctx);

                printf("<< receiving\n");
                for (j = 0; j < rspLen; j++)
                {
                    printf("%02x ", rsp[j]);
                    if ((j+1)%16 == 0)
                    {
                        printf("\n");
                    }
                }
                printf("\n");
                if (rsp_ctx.type == eRSP)
                {
                    printf("SWI LOC RSP: ");
                    printf("msgid 0x%x\n", rsp_ctx.msgid);
                    if (rsp_ctx.xid == xid)
                    {
                        printf("run unpack on xid %d\n",xid);
                        rtn = swiloctotest[i].unpack(rsp, rspLen, swiloctotest[i].unpack_ptr);
    
                    #if DEBUG_LOG_TO_FILE
                        fp = fopen("./TestResults/testlog.txt", "a");
                        if ( fp )
                        {
                            fprintf(fp, "%-60s%-20s%-s", swiloctotest[i].unpack_func_name, (rtn==eQCWWAN_ERR_NONE ? "Success": "Fail"), "");
                        }
                        else
                        {
                            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
                        }
                        if(fp)
                            fclose(fp);
                    #endif
    
                        swiloctotest[i].dump(swiloctotest[i].unpack_ptr);
                        /* sleep 3 seconds for next write */
                        sleep(3);
                        /* skip the while loop so that the the next API can be invoked */
                        break;
                    }
                    else
                    {
                        /* the response is not belongs to this API, skip it and read again */
                        printf("xid %d\n",xid);
                        sleep(1);
                    }
                }
                else if (rsp_ctx.type == eIND)
                {
                    printf("SWI LOC IND: msgid 0x%x\n", rsp_ctx.msgid);
                    //swiloc_indication_handler(rsp_ctx.msgid, rsp,  rspLen);
                }
            }
            else
            {
                /* read nothing, sleep 1 second and read again */
                sleep(1);
            }
        }
        xid++;
    }
}
