#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "packingdemo.h"

#include "sms.h"
#include "helper_sms.h"

#define PHONE_NUM "96818255"


volatile int enSmsThread;
int sms = -1;
pthread_attr_t sms_attr;
pthread_t sms_tid;

void dump_SLQSGetSMS(void* ptr)
{
    unpack_sms_SLQSGetSMS_t  *result =
        (unpack_sms_SLQSGetSMS_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    if(result)
    {


    }
    printf("%s Done\n",__FUNCTION__);
}

void dump_SLQSGetSMSList(void* ptr)
{
    unpack_sms_SLQSGetSMSList_t  *result =
        (unpack_sms_SLQSGetSMSList_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    if(result)
    {


    }
    printf("%s Done\n",__FUNCTION__);
}

void dump_SLQSModifySMSStatus(void* ptr)
{
    unpack_sms_SLQSModifySMSStatus_t  *result =
        (unpack_sms_SLQSModifySMSStatus_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    if(result)
    {


    }
    printf("%s Done\n",__FUNCTION__);
}

void dump_SLQSDeleteSMS(void* ptr)
{
    unpack_sms_SLQSDeleteSMS_t  *result =
        (unpack_sms_SLQSDeleteSMS_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    if(result)
    {


    }
    printf("%s Done\n",__FUNCTION__);
}

void dump_SLQSSendSMS(void* ptr)
{
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Done\n",__FUNCTION__);
}


void dump_SetNewSMSCallback(void* ptr)
{
    if(ptr==NULL)
    {
        
    }
    printf("%s Done\n",__FUNCTION__);
}

uint8_t tpack_sms_SLQSGetSMSmessageMode =0x01;//GW mode

pack_sms_SLQSGetSMS_t tpack_sms_SLQSGetSMS={
    0x00, //UIM
    0x00,
    &tpack_sms_SLQSGetSMSmessageMode
};
unpack_sms_SLQSGetSMS_t tunpack_sms_SLQSGetSMS={
    0xFFFFFFFF,
    0xFFFFFFFF,
    MAX_SMS_MESSAGE_SIZE,
    {0}
};
uint8_t tpack_sms_SLQSGetSMSListmessageModelist = 0x01;//GW mode
uint32_t tpack_sms_SLQSGetSMSListmessagerequestedTag = 0x00;//MT Read

#if 1

pack_sms_SLQSGetSMSList_t tpack_sms_SLQSGetSMSList={
    0x00, //UIM
    &tpack_sms_SLQSGetSMSListmessagerequestedTag,
    &tpack_sms_SLQSGetSMSListmessageModelist
};

unpack_sms_SLQSGetSMSList_t tunpack_sms_SLQSGetSMSList={
    MAX_SMS_LIST_SIZE,
    {{0,0}}
};
#endif
uint8_t tpack_sms_SLQSModifySMSStatusmessageModeStat = 0x01;//GW


pack_sms_SLQSModifySMSStatus_t tpack_sms_SLQSModifySMSStatus={
    0x00, //UIM
    (uint32_t)1,//Index
    0x01, //MT Not Read
    &tpack_sms_SLQSModifySMSStatusmessageModeStat
};

uint32_t  tpack_sms_SLQSDeleteSMSmessageIndex= 0x00;
uint8_t tpack_sms_SLQSDeleteSMSmessageModeDel  = 0x01;//GW

pack_sms_SLQSDeleteSMS_t tpack_sms_SLQSDeleteSMS={
    0x00, //UIM 
    &tpack_sms_SLQSDeleteSMSmessageIndex,
    NULL,
    &tpack_sms_SLQSDeleteSMSmessageModeDel
};
uint8_t tpack_sms_SendSMSmessage[255] = {0x07, 0l, 0x19, 0x89, 0x88, 0x00, 0x99, 0x89, 0x11,
                         0x00, 0x0C, 0x91, 0x19, 0x48, 0x72, 0x02, 0x85, 0x07,
                         0x00, 0x00, 0xAA, 0x1A, 0xD7, 0x32, 0x7B, 0xFC, 0x6E,
                         0x97, 0x41, 0xF4, 0x37, 0x68, 0x9A, 0x2E, 0xCB, 0xE5,
                         0x61, 0xD0, 0x35, 0x2D, 0x2F, 0xB3, 0xCB, 0xF3, 0x39};
uint8_t tpack_sms_SendSMSlinktimer  = 0x03;

pack_sms_SendSMS_t tpack_sms_SendSMS={
     0x06, //GW-PP
     0xFF,
     tpack_sms_SendSMSmessage,
     &tpack_sms_SendSMSlinktimer
};

unpack_sms_SendSMS_t tunpack_sms_SendSMS={
    0,
    0
};

typedef union
{
    uint8_t u8Msg[MAX_CDMA_ENC_MO_TXT_MSG_SIZE];
    uint16_t u16Msg[MAX_CDMA_ENC_MO_TXT_MSG_SIZE/2];
}SLQSCDMAEncodeMOMessage;

SLQSCDMAEncodeMOMessage sSLQSCDMAEncodeMOTextMsg={"Welcome to Sierra Wireless"};

int8_t tpack_sms_SLQSCDMAEncodeMOTextMsgDestAddr[] = PHONE_NUM;
uint8_t tpack_sms_SLQSCDMAEncodeMOTextMsgmessage[MAX_CDMA_ENC_MO_TXT_MSG_SIZE]={0};


sms_SLQSCDMAEncodeMOTextMsg_t tpack_sms_SLQSCDMAEncodeMOTextMsg={
    250,//Msg Size
   (uint8_t*)tpack_sms_SLQSCDMAEncodeMOTextMsgmessage,//tpack_sms_SLQSCDMAEncodeMOTextMsgmessage,
   0x00,//Msg ID
   (int8_t*)tpack_sms_SLQSCDMAEncodeMOTextMsgDestAddr,//Dest Address
   NULL,//pCallBackAddrr
   26,//textMsgLength
   sSLQSCDMAEncodeMOTextMsg.u16Msg,//pTextMsg,
   NULL,//pPariority
   2,//Encode Alpha
   NULL//pRelvalidity
};


int8_t tpack_sms_SLQSWCDMAEncodeMOTextMsgDestAddr[]= PHONE_NUM;
int8_t tpack_sms_SLQSWCDMAEncodeMOTextMsgTextMsg[]="Welcome to Sierra Wireless";


sms_SLQSWCDMAEncodeMOTextMsg_t tpack_sms_SLQSWCDMAEncodeMOTextMsg={
    0,
    (int8_t*)tpack_sms_SLQSWCDMAEncodeMOTextMsgDestAddr,
    (int8_t*)tpack_sms_SLQSWCDMAEncodeMOTextMsgTextMsg,
    {0},
    0

};
uint8_t tpack_sms_SLQSCDMADecodeMTTextMsgcdmaMessage[] = {0x00, 0x00, 0x02, 0x10, 0x02, 0x04, 0x08, 0x03, 0x24, 0x61, 0x09, 0xca,
                             0x96, 0x1e, 0x80, 0x08, 0x26, 0x00, 0x03, 0x20, 0x00, 0x00, 0x01, 0x19,
                             0x10, 0xd5, 0x7c, 0xbb, 0x31, 0xef, 0xdb, 0x95, 0x07, 0x4d, 0xe8, 0x29,
                             0xe9, 0xcb, 0xcb, 0x96, 0x14, 0x15, 0xf4, 0xf2, 0xcb, 0xb3, 0x2f, 0x3e,
                             0x60, 0x05, 0x01, 0x0b, 0x08, 0x01, 0x00};

sms_SLQSCDMADecodeMTTextMsg_t tpack_sms_SLQSCDMADecodeMTTextMsg={
    (uint32_t)sizeof(tpack_sms_SLQSCDMADecodeMTTextMsgcdmaMessage),
    (uint8_t*)tpack_sms_SLQSCDMADecodeMTTextMsgcdmaMessage,
    0,
    16,
    {0},
    162,
    {0},
    0,
    0,
    0,
    {0},
    {0},
    0,
    0,
    0,
    0,
    0,
    0,
    0
};

uint8_t tpack_sms_SLQSWCDMADecodeMTTextMsgwcdmaMessage[] = {0x07, 0x91, 0x19, 0x89, 0x51, 0x50, 0x91, 0x73, 0x04, 0x0C,
                 0x91, 0x19, 0x48, 0x72, 0x02, 0x85, 0x07, 0x00, 0x00, 0x51,
                 0x01, 0x41, 0x81, 0x12, 0x33, 0x22, 0x2A, 0xC8, 0x32, 0x9B,
                 0xFD, 0x66, 0x81, 0xEE, 0x65, 0xF6, 0xF8, 0xDD, 0x2E, 0x83,
                 0xE8, 0x6F, 0xD0, 0x34, 0x5D, 0x96, 0xCB, 0xC3, 0xA0, 0x6B,
                 0x5A, 0x5E, 0x66, 0x97, 0xE7, 0xF3, 0x10, 0xE8, 0x58, 0x97,
                 0xB7, 0xCB, 0x65, 0x3A};

sms_SLQSWCDMADecodeMTTextMsg_t tpack_sms_SLQSWCDMADecodeMTTextMsg={
    (uint8_t*)tpack_sms_SLQSWCDMADecodeMTTextMsgwcdmaMessage,
    16,
    {0},
    160,
    {0},
    16,
    {0},
    {0},
    {0}
};

pack_sms_SetNewSMSCallback_t tpack_sms_SetNewSMSCallback[3]={
    {
        LIBPACK_QMI_CBK_PARAM_RESET
    },
    {
        LIBPACK_QMI_CBK_PARAM_SET
    },
    {
        LIBPACK_QMI_CBK_PARAM_NOCHANGE
    }
    
};


testitem_t smstotest[] = {
    {
        (pack_func) pack_sms_SLQSDeleteSMS, "pack_sms_SLQSDeleteSMS",
        &tpack_sms_SLQSDeleteSMS, 
        (unpack_func) unpack_sms_SLQSDeleteSMS, "unpack_sms_SLQSDeleteSMS",
        NULL, dump_SLQSDeleteSMS
    },
    {
        (pack_func) pack_sms_SLQSGetSMS, "pack_sms_SLQSGetSMS",
        &tpack_sms_SLQSGetSMS, 
        (unpack_func) unpack_sms_SLQSGetSMS, "unpack_sms_SLQSGetSMS",
        &tunpack_sms_SLQSGetSMS, dump_SLQSGetSMS
    },
    {
        (pack_func) pack_sms_SLQSGetSMSList, "pack_sms_SLQSGetSMSList",
        &tpack_sms_SLQSGetSMSList, 
        (unpack_func) unpack_sms_SLQSGetSMSList, "unpack_sms_SLQSGetSMSList",
        &tunpack_sms_SLQSGetSMSList, dump_SLQSGetSMSList
    },
    {
        (pack_func) pack_sms_SLQSModifySMSStatus, "pack_sms_SLQSModifySMSStatus",
        &tpack_sms_SLQSModifySMSStatus, 
        (unpack_func) unpack_sms_SLQSModifySMSStatus, "unpack_sms_SLQSModifySMSStatus",
        NULL, dump_SLQSModifySMSStatus
    },
    {
        (pack_func) pack_sms_SLQSDeleteSMS, "pack_sms_SLQSDeleteSMS",
        &tpack_sms_SLQSDeleteSMS, 
        (unpack_func) unpack_sms_SLQSDeleteSMS, "unpack_sms_SLQSDeleteSMS",
        NULL, dump_SLQSDeleteSMS
    },
    {
        (pack_func) pack_sms_SendSMS, "pack_sms_SendSMS",
        &tpack_sms_SendSMS, 
        (unpack_func) unpack_sms_SendSMS, "unpack_sms_SendSMS",
        &tunpack_sms_SendSMS, dump_SLQSSendSMS
    },
    {
        (pack_func) pack_sms_SetNewSMSCallback, "pack_sms_SetNewSMSCallback",
        &tpack_sms_SetNewSMSCallback[LIBPACK_QMI_CBK_PARAM_NOCHANGE], 
        (unpack_func) unpack_sms_SetNewSMSCallback, "unpack_sms_SetNewSMSCallback",
        NULL, dump_SetNewSMSCallback
    },
};

void sms_test_pack_unpack_loop()
{
    unsigned i;
    unsigned xid =1;
    for(i=0; i<sizeof(smstotest)/sizeof(testitem_t); i++)
    {
        unpack_qmi_t rsp_ctx;
        pack_qmi_t   req_ctx;
        int rtn;
        uint8_t rsp[QMI_MSG_MAX]={0};
        uint8_t req[QMI_MSG_MAX]={0};
        uint16_t rspLen, reqLen;
        printf("pack %d\n", i);
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid = xid;
        rtn = smstotest[i].pack(&req_ctx, req, &reqLen,smstotest[i].pack_ptr);
        if(rtn!=eQCWWAN_ERR_NONE)
        {
            continue;
        }
        if(sms<0)
            sms = client_fd(eSMS);
        rtn = write(sms, req, reqLen);
        if (rtn!=reqLen)
            printf("write %d wrote %d\n", reqLen, rtn);
        if(smstotest[i].unpack==NULL)
        {
            if( (smstotest[i].dump !=NULL) && 
                (smstotest[i].unpack_ptr!=NULL))
            {
                smstotest[i].dump(smstotest[i].unpack_ptr);
            }
        }
        else
        {
            rspLen = read(sms, rsp, QMI_MSG_MAX);
            if( (rspLen<QMI_MSG_MAX))
            {
                helper_get_resp_ctx(eSMS, rsp, rspLen, &rsp_ctx);
                printf("unpack %d\n", i);
                if (rsp_ctx.xid == xid)
                {
                    if(smstotest[i].unpack != NULL)
                    {
                        smstotest[i].unpack(rsp, rspLen, smstotest[i].unpack_ptr);
                    }
                    if(smstotest[i].dump !=NULL)
                    {
                        smstotest[i].dump(smstotest[i].unpack_ptr);
                    }
                }
            }
            else
            {
                printf("Error read %d > %d \n", rspLen,QMI_MSG_MAX);
            }
        }
        

        xid++;
    }
}

void send_sms_read_req (uint32_t storageType, uint32_t msgIndex, uint8_t msgMode)
{
    pack_qmi_t req_ctx;
    int rtn;
    uint8_t qmi_req[QMI_MSG_MAX];
    uint16_t qmi_req_len = QMI_MSG_MAX;    
    
    memset(&sms_attr, 0, sizeof(sms_attr));
    memset(qmi_req, 0, QMI_MSG_MAX);
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = 10;
    
    pack_sms_SLQSGetSMS_t getsms_reqParam;
    getsms_reqParam.storageType  = storageType; 
    getsms_reqParam.messageIndex = msgIndex;
    uint8_t messageMode = msgMode; 
    getsms_reqParam.pMessageMode  = &messageMode;    
    rtn = pack_sms_SLQSGetSMS(&req_ctx, qmi_req, &qmi_req_len, &getsms_reqParam);
    printf("%s: pack rtn %d\n", __func__, rtn);    
    rtn = write(sms, qmi_req, qmi_req_len);
    printf("write %d wrote %d\n", qmi_req_len, rtn);    
}

void wcdma_decode_text_msg (unpack_sms_SLQSGetSMS_t getrawsms)
{
    sms_SLQSWCDMADecodeMTTextMsg_t wcdmadctxmsg_reqParam;

    wcdmadctxmsg_reqParam.pMessage = getrawsms.message;
    wcdmadctxmsg_reqParam.scAddrLength =16;
    wcdmadctxmsg_reqParam.senderAddrLength =16;
    wcdmadctxmsg_reqParam.textMsgLength =160;

    int rtn = sms_SLQSWCDMADecodeMTTextMsg(&wcdmadctxmsg_reqParam);
    if ( !rtn )
    {
        printf("WCDMA Decoding Successful\n");
        printf("\nService Center Number = %s",wcdmadctxmsg_reqParam.scAddr);
        printf("\nSender Number = %s",wcdmadctxmsg_reqParam.senderAddr);
        printf("\nDate = %s",wcdmadctxmsg_reqParam.date);
        printf("\nTime = %s",wcdmadctxmsg_reqParam.time);
        printf("\nMessage: %s\n\n",wcdmadctxmsg_reqParam.textMsg );
    }
}

void *sms_read_thread(void* ptr)
{
    const char *qmi_msg;
    unpack_qmi_t rsp_ctx;
    unpack_sms_SLQSGetSMS_t getrawsms;
    unpack_sms_SLQSGetSMSList_t smslist;
    unpack_sms_SendSMS_t sendsms;
    unpack_sms_SLQSWmsMemoryFullCallBack_ind_t full_stat;
    unpack_sms_SetNewSMSCallback_ind_t newsmscbind;
    msgbuf msg;
    int rtn;
    ssize_t rlen;
    int Length = 0;
    int lIndex = 0;
    printf("%s param %p\n", __func__, ptr);

    while(enSmsThread)
    {
        //TODO select multiple file and read them
        rlen = read(sms, msg.buf, QMI_MSG_MAX);
        if (rlen > 0)
        {
            qmi_msg = helper_get_resp_ctx(eSMS, msg.buf, rlen, &rsp_ctx);
            printf("<< receiving %s\n", qmi_msg);

            if (rsp_ctx.type == eIND)
                printf("SMS IND: ");
            else if (rsp_ctx.type == eRSP)
                printf("SMS RSP: ");
            printf("msgid 0x%x\n", rsp_ctx.msgid);
            uint8_t count;

            switch(rsp_ctx.msgid)
            {
                case eQMI_WMS_RAW_READ:
                    rtn = unpack_sms_SLQSGetSMS( msg.buf, rlen,&getrawsms);
                    printf("rtn %d\n", rtn);
                    if(!rtn)
                    {
                        printf("SLQS Get SMS Successful\n");
                        printf("Message Tag : %d\n",getrawsms.messageTag);
                        printf("Message Format : %d\n",getrawsms.messageFormat);
                        printf("Message Size : %d\n",getrawsms.messageSize);
                        printf("Message : ");
                        for ( count=0;count < getrawsms.messageSize;count++ )
                            printf(" 0x%02X ",(getrawsms.message[count]));
                        if (6 == getrawsms.messageFormat)
                        {
                            // Decode as GSM/WCDMA PP
                            wcdma_decode_text_msg (getrawsms);
                        }
                    }
                    break;

                case eQMI_WMS_GET_MSG_LIST:
                    rtn = unpack_sms_SLQSGetSMSList( msg.buf, rlen,&smslist);
                    if(!rtn)
                    {
                        printf("MessageListSize  : %x\n", smslist.messageListSize);
                        for(count = 0; count < smslist.messageListSize; count++)
                        {
                            printf("messageIndex[%d] : %x\n",
                                    count, smslist.messageList[count].messageIndex);
                            printf("messageTag[%d] : %x\n",
                                    count, smslist.messageList[count].messageTag);
                        }
                    }
                    break;

                case eQMI_WMS_MODIFY_TAG:
                    rtn = unpack_sms_SLQSModifySMSStatus( msg.buf, rlen,NULL);
                    if(!rtn)
                        printf("SLQS Modify SMS Status Successful\n");
                    break;

                case eQMI_WMS_DELETE:
                    rtn = unpack_sms_SLQSDeleteSMS( msg.buf, rlen,NULL);
                    if(!rtn)
                        printf("SLQS Delete SMS Successful\n");
                    break;

                case eQMI_WMS_RAW_SEND:
                    rtn = unpack_sms_SendSMS( msg.buf, rlen, &sendsms);
                    if(!rtn)
                        printf("Send SMS Successful\n");
                    break;
                case eQMI_WMS_SET_EVENT:
                    if(rsp_ctx.type == eIND)
                    {
                        rtn = unpack_sms_SetNewSMSCallback_ind( msg.buf, rlen, &newsmscbind);
                        printf ("SMS IND unpacked: %d\n", rtn);
                        if (newsmscbind.NewMMTlv.TlvPresent)
                        {
                            printf ("NewMMTlv.MTMessageInfo.storageType : %d\n", newsmscbind.NewMMTlv.MTMessageInfo.storageType);
                            printf ("NewMMTlv.MTMessageInfo.messageIndex: %d\n", newsmscbind.NewMMTlv.MTMessageInfo.messageIndex);
                        }
                        if (newsmscbind.MMTlv.TlvPresent)
                        {
                            printf ("MMTlv.MessageModeInfo.messageMode : %d\n", newsmscbind.MMTlv.MessageModeInfo.messageMode);
                        }
                        if (newsmscbind.ETWSTlv.TlvPresent)
                        {
                            printf ("ETWSTlv.EtwsMessageInfo.notificationType : %d\n", newsmscbind.ETWSTlv.EtwsMessageInfo.notificationType);
                            printf ("ETWSTlv.EtwsMessageInfo.length : %d\n", newsmscbind.ETWSTlv.EtwsMessageInfo.length);
                            Length = newsmscbind.ETWSTlv.EtwsMessageInfo.length;
                            lIndex = 0;
                            while(Length--)
                            {
                                fprintf ( stderr,
                                    "%2xH",
                                    newsmscbind.ETWSTlv.EtwsMessageInfo.data[lIndex++] );
                                    if (lIndex % 16 ==0)
                                    {
                                            fprintf ( stderr, "\n");
                                    }
                            }        
                            fprintf ( stderr, "\r\n\n" );
                        }
                        if (newsmscbind.TRMessageTlv.TlvPresent)
                        {
                            printf ("TRMessageTlv.TRMessageTlv.TransferRouteMTMessageInfo.ackIndicator : %d\n", newsmscbind.TRMessageTlv.TransferRouteMTMessageInfo.ackIndicator);
                            printf ("TRMessageTlv.TRMessageTlv.TransferRouteMTMessageInfo.transactionID : %d\n", newsmscbind.TRMessageTlv.TransferRouteMTMessageInfo.transactionID);
                            printf ("TRMessageTlv.TRMessageTlv.TransferRouteMTMessageInfo.format : %d\n", newsmscbind.TRMessageTlv.TransferRouteMTMessageInfo.format);
                            printf ("TRMessageTlv.TRMessageTlv.TransferRouteMTMessageInfo.length : %d\n", newsmscbind.TRMessageTlv.TransferRouteMTMessageInfo.length);
                            Length = newsmscbind.TRMessageTlv.TransferRouteMTMessageInfo.length;
                            lIndex = 0;
                            while(Length--)
                            {
                                fprintf ( stderr,
                                    "%2xH",
                                    newsmscbind.TRMessageTlv.TransferRouteMTMessageInfo.data[lIndex++] );
                                    if (lIndex % 16 ==0)
                                    {
                                            fprintf ( stderr, "\n");
                                    }
                            }
                            fprintf ( stderr, "\r\n\n" );
                        }
                        if (newsmscbind.ETWSPLMNTlv.TlvPresent)
                        {
                            printf ("ETWSPLMNTlv.ETWSPLMNInfo.mobileCountryCode : %d\n", newsmscbind.ETWSPLMNTlv.ETWSPLMNInfo.mobileCountryCode);
                            printf ("ETWSPLMNTlv.ETWSPLMNInfo.mobileNetworkCode : %d\n", newsmscbind.ETWSPLMNTlv.ETWSPLMNInfo.mobileNetworkCode);
                        }
                        if (newsmscbind.SMSCTlv.TlvPresent)
                        {
                            printf ("SMSCTlv.SMSCInfo.length : %d\n", newsmscbind.SMSCTlv.SMSCInfo.length);
                            Length = newsmscbind.SMSCTlv.SMSCInfo.length;
                            lIndex = 0;                            
                            while(Length--)
                            {
                                fprintf ( stderr,
                                    "%2xH",
                                    newsmscbind.SMSCTlv.SMSCInfo.data[lIndex++] );
                            }
                            fprintf ( stderr, "\r\n\n" );                            
                        }
                        if (newsmscbind.IMSTlv.TlvPresent)
                        {
                            printf ("IMSTlv.IMSInfo.smsOnIMS : %d\n", newsmscbind.IMSTlv.IMSInfo.smsOnIMS);
                        }
                        send_sms_read_req (newsmscbind.NewMMTlv.MTMessageInfo.storageType, newsmscbind.NewMMTlv.MTMessageInfo.messageIndex, newsmscbind.MMTlv.MessageModeInfo.messageMode );
                    }
                    else
                    {
                        rtn = unpack_sms_SetNewSMSCallback( msg.buf, rlen,NULL);
                        if(!rtn)
                            printf(" Enabled SMS event callback\n");
                    }
                    break;

                case eQMI_WMS_MEMORY_FULL_IND:
                    unpack_sms_SLQSWmsMemoryFullCallBack_ind( msg.buf, rlen, &full_stat);
                    printf("sms store full, storage type/message mode : %d/%d\n",
                            full_stat.storageType, full_stat.messageMode);
                    break;
            }
        }
    }
   return NULL;
}



void sms_test_ind()
{
    
    pack_qmi_t req_ctx;
    int rtn;

    uint8_t qmi_req[QMI_MSG_MAX];
    uint16_t qmi_req_len = QMI_MSG_MAX;

    if(sms<0)
        sms = client_fd(eSMS);

    memset(&sms_attr, 0, sizeof(sms_attr));
    memset(qmi_req, 0, QMI_MSG_MAX);
    enSmsThread = 1;
    pthread_create(&sms_tid, &sms_attr, sms_read_thread, NULL);

    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = 10;


    pack_sms_SLQSGetSMS_t getsms_reqParam;
    getsms_reqParam.storageType  = 0x00; //UIM
    getsms_reqParam.messageIndex = 0x00;
    uint8_t messageMode = 0x01; //GW mode
    getsms_reqParam.pMessageMode  = &messageMode;

    printf("get sms raw read ...\n");
    rtn = pack_sms_SLQSGetSMS(&req_ctx, qmi_req, &qmi_req_len, &getsms_reqParam);
    rtn = write(sms, qmi_req, qmi_req_len);
    if (rtn != qmi_req_len)
        printf("write %d wrote %d\n", qmi_req_len, rtn);
    sleep(4);

    pack_sms_SLQSGetSMSList_t smslist_reqParam;
    smslist_reqParam.storageType = 0x00; //UIM
    uint8_t messageModelist = 0x01;//GW mode
    uint32_t requestedTag = 0x00; //MT Read
    smslist_reqParam.pMessageMode = &messageModelist;
    smslist_reqParam.pRequestedTag = &requestedTag;

    printf("get sms list ...\n");
    rtn = pack_sms_SLQSGetSMSList(&req_ctx, qmi_req, &qmi_req_len, &smslist_reqParam);
    rtn = write(sms, qmi_req, qmi_req_len);
    if (rtn != qmi_req_len)
        printf("write %d wrote %d\n", qmi_req_len, rtn);
    sleep(4);

    pack_sms_SLQSModifySMSStatus_t smsstatus_reqParam;
    smsstatus_reqParam.storageType = 0x00; //UIM
    smsstatus_reqParam.messageIndex = 0x00;
    smsstatus_reqParam.messageTag =  0x01; //MT Not Read
    uint8_t messageModeStat = 0x01;//GW
    smsstatus_reqParam.pMessageMode = &messageModeStat;

    printf("modify sms tag ...\n");
    rtn = pack_sms_SLQSModifySMSStatus(&req_ctx, qmi_req, &qmi_req_len, &smsstatus_reqParam);
    rtn = write(sms, qmi_req, qmi_req_len);
    if (rtn != qmi_req_len)
        printf("write %d wrote %d\n", qmi_req_len, rtn);
    sleep(4);

    pack_sms_SLQSDeleteSMS_t deletesms_reqParam;
    memset(&deletesms_reqParam, 0, sizeof(deletesms_reqParam));
    deletesms_reqParam.storageType = 0x00; //UIM
    uint32_t messageIndex = 0x00;
    uint8_t messageModeDel  = 0x01;//GW
    deletesms_reqParam.pMessageIndex = &messageIndex;
    deletesms_reqParam.pMessageMode = &messageModeDel;

    printf("delete sms  ...\n");
    rtn = pack_sms_SLQSDeleteSMS(&req_ctx, qmi_req, &qmi_req_len, &deletesms_reqParam);
    rtn = write(sms, qmi_req, qmi_req_len);
    if (rtn != qmi_req_len)
        printf("write %d wrote %d\n", qmi_req_len, rtn);
    sleep(4);

    pack_sms_SendSMS_t sendsms_reqParam;
    sendsms_reqParam.messageFormat = 0x06; //GW-PP
    sendsms_reqParam.messageSize = 0xFF;
    uint8_t message[] = {0x07, 0l, 0x19, 0x89, 0x88, 0x00, 0x99, 0x89, 0x11,
                         0x00, 0x0C, 0x91, 0x19, 0x48, 0x72, 0x02, 0x85, 0x07,
                         0x00, 0x00, 0xAA, 0x1A, 0xD7, 0x32, 0x7B, 0xFC, 0x6E,
                         0x97, 0x41, 0xF4, 0x37, 0x68, 0x9A, 0x2E, 0xCB, 0xE5,
                         0x61, 0xD0, 0x35, 0x2D, 0x2F, 0xB3, 0xCB, 0xF3, 0x39};
    sendsms_reqParam.messageSize = sizeof(message);
    sendsms_reqParam.pMessage = message;
    uint8_t linktimer  = 0x03;
    sendsms_reqParam.pLinktimer = &linktimer;

    printf("send sms  ...\n");
    rtn = pack_sms_SendSMS(&req_ctx, qmi_req, &qmi_req_len, &sendsms_reqParam);
    rtn = write(sms, qmi_req, qmi_req_len);
    if (rtn != qmi_req_len)
        printf("write %d wrote %d\n", qmi_req_len, rtn);
    sleep(4);

    sms_SLQSWCDMAEncodeMOTextMsg_t wcdmaentxmsg_reqParam;
    memset(&wcdmaentxmsg_reqParam,0,sizeof(sms_SLQSWCDMAEncodeMOTextMsg_t));
    wcdmaentxmsg_reqParam.pDestAddr = (int8_t*)PHONE_NUM;
    wcdmaentxmsg_reqParam.pTextMsg  = (int8_t*)"Welcome to Sierra Wireless";
    
    rtn = sms_SLQSWCDMAEncodeMOTextMsg(&wcdmaentxmsg_reqParam);
    if ( !rtn )
    {
        printf("Encoding of Text is Successful\n");
        printf("Encoded message : ");
        uint8_t count =0;
        for (count=0; count<wcdmaentxmsg_reqParam.messageSize; count++)
            printf(" %02x",(uint8_t)wcdmaentxmsg_reqParam.PDUMessage[count]);
     }
    printf("\n");
    sleep(4);

    sms_SLQSWCDMADecodeMTTextMsg_t wcdmadctxmsg_reqParam;
    uint8_t wcdmaMessage[] = {0x07, 0x91, 0x19, 0x89, 0x51, 0x50, 0x91, 0x73, 0x04, 0x0C,
                 0x91, 0x19, 0x48, 0x72, 0x02, 0x85, 0x07, 0x00, 0x00, 0x51,
                 0x01, 0x41, 0x81, 0x12, 0x33, 0x22, 0x2A, 0xC8, 0x32, 0x9B,
                 0xFD, 0x66, 0x81, 0xEE, 0x65, 0xF6, 0xF8, 0xDD, 0x2E, 0x83,
                 0xE8, 0x6F, 0xD0, 0x34, 0x5D, 0x96, 0xCB, 0xC3, 0xA0, 0x6B,
                 0x5A, 0x5E, 0x66, 0x97, 0xE7, 0xF3, 0x10, 0xE8, 0x58, 0x97,
                 0xB7, 0xCB, 0x65, 0x3A};

    memset(&wcdmadctxmsg_reqParam,0,sizeof(sms_SLQSWCDMADecodeMTTextMsg_t));
    wcdmadctxmsg_reqParam.pMessage = wcdmaMessage;
    wcdmadctxmsg_reqParam.scAddrLength =16;
    wcdmadctxmsg_reqParam.senderAddrLength =16;
    wcdmadctxmsg_reqParam.textMsgLength =160;

    rtn = sms_SLQSWCDMADecodeMTTextMsg(&wcdmadctxmsg_reqParam);
    if ( !rtn )
    {
        printf("WCDMA Decoding Successful\n");
        printf("\nService Center Number = %s",wcdmadctxmsg_reqParam.scAddr);
        printf("\nSender Number = %s",wcdmadctxmsg_reqParam.senderAddr);
        printf("\nDate = %s",wcdmadctxmsg_reqParam.date);
        printf("\nTime = %s",wcdmadctxmsg_reqParam.time);
        printf("\nMessage: %s\n\n",wcdmadctxmsg_reqParam.textMsg );
    }

    sms_SLQSCDMAEncodeMOTextMsg_t cdmaentxmsg_reqParam;
    uint8_t sms_SLQSCDMAEncodeMOTextMsg_t[255]={0};
    cdmaentxmsg_reqParam.messageSize = 250;
    cdmaentxmsg_reqParam.messageId = 0;
    cdmaentxmsg_reqParam.pDestAddr = (int8_t*)PHONE_NUM;
    cdmaentxmsg_reqParam.pCallbackAddr = NULL;
    cdmaentxmsg_reqParam.pTextMsg  = (uint16_t*)"Welcome to Sierra Wireless";
    cdmaentxmsg_reqParam.textMsgLength = strlen("Welcome to Sierra Wireless");
    cdmaentxmsg_reqParam.pPriority = NULL;
    cdmaentxmsg_reqParam.encodingAlphabet = 2;
    cdmaentxmsg_reqParam.pRelValidity = NULL;
    cdmaentxmsg_reqParam.pMessage = &sms_SLQSCDMAEncodeMOTextMsg_t[0];
    rtn = sms_SLQSCDMAEncodeMOTextMsg(&cdmaentxmsg_reqParam);

    if ( !rtn )
    {
        printf("Encoding of Text is Successful\n");
        printf("Encoded message : ");
        uint8_t count =0;
        for (count=0; count<cdmaentxmsg_reqParam.messageSize; count++)
            printf(" %02x ",sms_SLQSCDMAEncodeMOTextMsg_t[count]);
     }
    printf("\n");
    sleep(4);

    sms_SLQSCDMADecodeMTTextMsg_t cdmadctxmsg_reqParam;
    uint8_t cdmaMessage[] = {0x00, 0x00, 0x02, 0x10, 0x02, 0x04, 0x08, 0x03, 0x24, 0x61, 0x09, 0xca,
                             0x96, 0x1e, 0x80, 0x08, 0x26, 0x00, 0x03, 0x20, 0x00, 0x00, 0x01, 0x19,
                             0x10, 0xd5, 0x7c, 0xbb, 0x31, 0xef, 0xdb, 0x95, 0x07, 0x4d, 0xe8, 0x29,
                             0xe9, 0xcb, 0xcb, 0x96, 0x14, 0x15, 0xf4, 0xf2, 0xcb, 0xb3, 0x2f, 0x3e,
                             0x60, 0x05, 0x01, 0x0b, 0x08, 0x01, 0x00};
    cdmadctxmsg_reqParam.pMessage = cdmaMessage;
    cdmadctxmsg_reqParam.messageLength = sizeof(cdmaMessage);
    cdmadctxmsg_reqParam.textMsgLength = 162;
    cdmadctxmsg_reqParam.senderAddrLength = 16;
    rtn = sms_SLQSCDMADecodeMTTextMsg(&cdmadctxmsg_reqParam);
    if ( !rtn )
    {
        printf(" CDMA Decoding Successful\n");
        printf("Message : ");
        printf("Sender Number: %s\n",cdmadctxmsg_reqParam.senderAddr);
        printf("SMS Text: %s\n",(char*)cdmadctxmsg_reqParam.textMsg);
        printf("priority: %x\n",cdmadctxmsg_reqParam.priority);
        printf("privacy: %x\n",cdmadctxmsg_reqParam.privacy);
        printf("language: %x\n",cdmadctxmsg_reqParam.language);
        printf("relativeValidity: %x\n",
                cdmadctxmsg_reqParam.relativeValidity);
        printf("displayMode: %x\n",
                cdmadctxmsg_reqParam.displayMode);
        printf("userAcknowledgementReq: %x\n",
                cdmadctxmsg_reqParam.userAcknowledgementReq);
        printf("readAcknowledgementReq: %x\n",
                cdmadctxmsg_reqParam.readAcknowledgementReq);
        printf("alertPriority: %x\n",cdmadctxmsg_reqParam.alertPriority);
        printf("callbkAddrLength: %x\n",cdmadctxmsg_reqParam.callbkAddrLength);
        printf("callbkAddr: %x\n",cdmadctxmsg_reqParam.callbkAddr);
    }

    pack_sms_SetNewSMSCallback_t  newsmscb_reqParam;
    newsmscb_reqParam.status  = LIBPACK_QMI_CBK_PARAM_SET;

    printf("set new sMS callback ...\n");
    rtn = pack_sms_SetNewSMSCallback(&req_ctx, qmi_req, &qmi_req_len, newsmscb_reqParam);
    rtn = write(sms, qmi_req, qmi_req_len);
    if (rtn != qmi_req_len)
        printf("write %d wrote %d\n", qmi_req_len, rtn);
    sleep(4);

    printf("\nwait for 30 seconds to receive SMS indications, if any...\n");
    sleep(30);

    
}

void sms_test_ind_exit()
{
    void *pthread_rtn_value;
    enSmsThread = 0;
    printf("\nkilling SMS read thread...\n");
    UNUSEDPARAM(pthread_rtn_value);
    //pthread_join(sms_tid, &pthread_rtn_value);
    pthread_cancel(sms_tid);

    sleep(1);
    if(sms>=0)
       close(sms);
    sms = -1;
}
