#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "qos.h"

#include "packingdemo.h"

#define QMI_QOS_MSG_MAX QMI_MSG_MAX

// FUNCTION PROTOTYPES
int client_fd(uint8_t svc);

// QOS GLOBALS
volatile int enQosThread;
int qos_fd = -1;
pthread_t qos_tid;
pthread_attr_t qos_attr;

// TEST VALUES
#ifdef QOS_EVENTS_DEBUG
    uint8_t qos_event_sample[] = {
        0x04,0x00,0x00,
        0x01,0x00,0x5E +22+22+22,0x02,

        0x10,0x55,0x01,

        0x10,0x06,0x00,0x50,0x94,0xDC,0x47,0x01,0x01,

        0x14,0x95,0x00,
        0x10,0x92,0x00,
        0x23,0x02,0x00,0x01,0x02,
        0x22,0x02,0x00,0x21,0x00,
        0x15,0x02,0x00,0x58,0x78,
        0x11,0x01,0x00,0x00,
        0x12,0x08,0x00, 0xde,0xad,0xbe,0xef, 0xff,0xff,0xff,0xff,
        0x13,0x08,0x00, 0xde,0xad,0xbe,0xef, 0xff,0xff,0xff,0xff,
        0x14,0x01,0x00, 0x01,
        0x19,0x02,0x00, 0x01,0x01,
        0x1A,0x04,0x00, 0x21,0x31,0x01,0x01,
        0x25,0x04,0x00, 0x01,0x91,0xab,0x01,
        0x24,0x04,0x00, 0x51,0x82,0x01,0xd1,
        0x1E,0x04,0x00, 0x71,0x01,0xe1,0x01,
        0x21,0x04,0x00, 0x01,0x78,0xc1,0x01,
        0x1C,0x04,0x00, 0x91,0x01,0x31,0xf1,
        0x1D,0x04,0x00, 0x01,0x54,0x01,0xe1,
        0x1B,0x04,0x00, 0x01,0x01,0x41,0x01,
        0x16,0x11,0x00, 0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xff,
        0x17,0x11,0x00, 0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xff,


        0x13,0x95,0x00,
        0x10,0x92,0x00,
        0x23,0x02,0x00,0x00,0x02,
        0x22,0x02,0x00,0x20,0x00,
        0x15,0x02,0x00,0x58,0x78,
        0x11,0x01,0x00,0x00,
        0x12,0x08,0x00, 0xde,0xad,0xbe,0xef, 0xff,0xff,0xff,0xff,
        0x13,0x08,0x00, 0xde,0xad,0xbe,0xef, 0xff,0xff,0xff,0xff,
        0x14,0x01,0x00, 0x01,
        0x16,0x11,0x00, 0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xff,
        0x17,0x11,0x00, 0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xde,0xad,0xbe,0xef,0xff,0xff,0xff,0xff,0xff,
        0x19,0x02,0x00, 0x01,0x01,
        0x1A,0x04,0x00, 0x21,0x31,0x01,0x01,
        0x1B,0x04,0x00, 0x01,0x01,0x41,0x01,
        0x1C,0x04,0x00, 0x91,0x01,0x31,0xf1,
        0x1D,0x04,0x00, 0x01,0x54,0x01,0xe1,
        0x1E,0x04,0x00, 0x71,0x01,0xe1,0x01,
        0x21,0x04,0x00, 0x01,0x78,0xc1,0x01,
        0x24,0x04,0x00, 0x51,0x82,0x01,0xd1,
        0x25,0x04,0x00, 0x01,0x91,0xab,0x01,

        0x12,0x07,0x00,
        0x10,0x04,0x00,
        0x1F,0x01,0x00,0x07,

        0x11,0x07,0x00,
        0x10,0x04,0x00,
        0x1F,0x01,0x00,0x07,

        0x15 ,0x01,0x00,0x01,
        // bearer id 
        0x16, 0x01,0x00, 0xAB,

        0x10,0x07+22+22+22,0x01,
        0x10,0x06,0x00,0xB0,0x56,0xD1,0x43,0x01,0x01,

        0x14,0x16+22+22,0x00,
        0x10,0x13,0x00,
        0x23,0x02,0x00,0x01,0x00,
        0x22,0x02,0x00,0x11,0x00,
        0x15,0x02,0x00,0xA0,0xE0,
        0x11,0x01,0x00,0x04,

        0x10,0x13,0x00,
        0x23,0x02,0x00,0x04,0x00,
        0x22,0x02,0x00,0x04,0x00,
        0x15,0x02,0x00,0x04,0x00,
        0x11,0x01,0x00,0x06,

        0x10,0x13,0x00,
        0x23,0x02,0x00,0x08,0x00,
        0x22,0x02,0x00,0x08,0x00,
        0x15,0x02,0x00,0x08,0x00,
        0x11,0x01,0x00,0x08,

        0x13,0x16+22,0x00,
        0x10,0x13,0x00,
        0x23,0x02,0x00,0x00,0x00,
        0x22,0x02,0x00,0x10,0x00,
        0x15,0x02,0x00,0xA0,0xE0,
        0x11,0x01,0x00,0x04,

        0x10,0x13,0x00,
        0x23,0x02,0x00,0x5,0x00,
        0x22,0x02,0x00,0x5,0x00,
        0x15,0x02,0x00,0x5,0x5,
        0x11,0x01,0x00,0x05,

        0x12,0x61,0x00,
        0x10,0x5E,0x00,
        0x12,0x08,0x00,0x80,0x91,0x07,0x00,0x80,0x91,0x07,0x00,
        0x1F,0x01,0x00,0x01,
        0x18,0x04,0x00,0x01,0x01,0x01,0x01,
        0x1B,0x02,0x00,0x1B,0x1B,
        0x11,0x01,0x00,0x11,
        0x13,0x0C,0x00,0x11,0x11,0x01,0x00,0x11,0x11,0x01,0x00,0x11,0x11,0x01,0x00,
        0x14,0x04,0x00,0x01,0x02,0x03,0x04,
        0x15,0x04,0x00,0x01,0x01,0x01,0x01,
        0x16,0x04,0x00,0x01,0x01,0x01,0x01,
        0x17,0x04,0x00,0x01,0x01,0x01,0x01,
        0x19,0x01,0x00,0x11,
        0x1A,0x01,0x00,0x11,
        0x1C,0x01,0x00,0x11,
        0x1D,0x01,0x00,0x11,
        0x1E,0x01,0x00,0x11,

        0x11,0x61,0x00,
        0x10,0x5E,0x00,
        0x12,0x08,0x00,0x80 ,0x91,0x07,0x00,0x80,0x91,0x07,0x00,
        0x1F,0x01,0x00,0x01,
        0x18,0x04,0x00,0x01,0x01,0x01,0x01,
        0x1B,0x02,0x00,0x1B,0x1B,
        0x11,0x01,0x00,0x11,
        0x13,0x0C,0x00,0x11,0x11,0x01,0x00,0x11,0x11,0x01,0x00,0x11,0x11,0x01,0x00,
        0x14,0x04,0x00,0x01,0x02,0x03,0x04,
        0x15,0x04,0x00,0x01,0x01,0x01,0x01,
        0x16,0x04,0x00,0x01,0x01,0x01,0x01,
        0x17,0x04,0x00,0x01,0x01,0x01,0x01,
        0x19,0x01,0x00,0x11,
        0x1A,0x01,0x00,0x11,
        0x1C,0x01,0x00,0x11,
        0x1D,0x01,0x00,0x11,
        0x1E,0x01,0x00,0x11,

        0x15,0x01,0x00,0x01

    };
#endif //QOS_EVENTS_DEBUG

void qos_loop_exit(void)
{
    void *pthread_rtn_value;
    printf("\nkilling QoS read thread...\n");        
    enQosThread = 0;
    UNUSEDPARAM(pthread_rtn_value);
    
    //pthread_join(qos_tid, &pthread_rtn_value);
    pthread_cancel(qos_tid);
    if(qos_fd>=0)
        close(qos_fd);
    qos_fd=-1;
    return;
}

void _print_flow(unpack_qos_swiQosFlow_t flow)
{
    fprintf (stderr, "\t\tIndex: %d\n", flow.index);
    if (flow.is_ProfileId3GPP2_Available)
        fprintf (stderr, "\t\t3Gpp2 Profile ID: %d\n", flow.ProfileId3GPP2);
    if (flow.is_val_3GPP2Pri_Available)
        fprintf (stderr, "\t\t3Gpp2 Flow Priority: %d\n", flow.val_3GPP2Pri);
    if (flow.is_TrafficClass_Available)
        fprintf (stderr, "\t\t3Gpp2 Traffic Class: %d\n", flow.TrafficClass);
    if (flow.is_DataRate_Available)
    {
        fprintf (stderr, "\t\tData Rate\n");
        fprintf (stderr, "\t\t\tMax Rate: %d\n", flow.DataRate.dataRateMax);
        fprintf (stderr, "\t\t\tGuaranteed Rate: %d\n", flow.DataRate.guaranteedRate);
    }
    if (flow.is_TokenBucket_Available)
    {
        fprintf (stderr, "\t\tToken Bucket\n");
        fprintf (stderr, "\t\t\tPeak Rate: %d\n", flow.TokenBucket.peakRate);
        fprintf (stderr, "\t\t\tToken Rate: %d\n", flow.TokenBucket.tokenRate);    
        fprintf (stderr, "\t\t\tBucket Size: %d\n", flow.TokenBucket.bucketSz);    
    }
    if (flow.is_Latency_Available)
        fprintf (stderr, "\t\tLatency: %d\n", flow.Latency);
    if (flow.is_Jitter_Available)
        fprintf (stderr, "\t\tJitter: %d\n", flow.Jitter);
    if (flow.is_PktErrRate_Available)
    {
        fprintf (stderr, "\t\tPacket Error Rate\n");
        fprintf (stderr, "\t\t\tMultiplier: %d\n", flow.PktErrRate.multiplier);
        fprintf (stderr, "\t\t\tExponent: %d\n", flow.PktErrRate.exponent);    
    }
    if (flow.is_MinPolicedPktSz_Available)
        fprintf (stderr, "\t\tMinimum Pkt Size: %d\n", flow.MinPolicedPktSz);
    if (flow.is_MaxAllowedPktSz_Available)
        fprintf (stderr, "\t\tMax Pkt Size: %d\n", flow.MaxAllowedPktSz);
    if (flow.is_val_3GPPResResidualBER_Available)
        fprintf (stderr, "\t\t3GPP residual bit error rate: %d\n", flow.val_3GPPResResidualBER);
    if (flow.is_val_3GPPTraHdlPri_Available)
        fprintf (stderr, "\t\tTraffic handling priority: %d\n", flow.val_3GPPTraHdlPri);
    if (flow.is_val_3GPPImCn_Available)
        fprintf (stderr, "\t\t3GPP IM CN flag: %d\n", flow.val_3GPPImCn);
    if (flow.is_val_3GPPSigInd_Available)
        fprintf (stderr, "\t\t3GPP signaling indication: %d\n", flow.val_3GPPSigInd);
    if (flow.is_LteQci_Available)
        fprintf (stderr, "\t\tLTE QCI: %d\n", flow.LteQci);
    return;
}

void _print_filter(unpack_qos_swiQosFilter_t filter)
{
    fprintf (stderr, "\t\tIndex      : %d\n", filter.index);
    fprintf (stderr, "\t\tversion    : %d\n", filter.version);
    if (filter.is_Id_Available)
        fprintf (stderr, "\t\tID         : %d(0x%02x)\n", filter.Id,filter.Id);    
    if (filter.is_Precedence_Available)
        fprintf (stderr, "\t\tPrecedence : %d(0x%02x)\n", filter.Precedence,filter.Precedence);
    if (filter.is_IPv6Label_Available)
        fprintf (stderr, "\t\tIPv6 Label : %d\n", filter.IPv6Label);
    if (filter.is_EspSpi_Available)
        fprintf (stderr, "\t\tESP filter security policy index : %d\n", filter.EspSpi);    
    if (filter.is_NxtHdrProto_Available)
        fprintf (stderr, "\t\tNext Header Protocol             : %d\n", filter.NxtHdrProto);
    
    if (filter.is_IPv4SrcAddr_Available)
    {
        fprintf (stderr, "\t\tIPv4 Src Addr\n");
        fprintf (stderr, "\t\t\tAddress    : %u\n", filter.IPv4SrcAddr.addr);
        fprintf (stderr, "\t\t\tSubnet Mask: %u\n", filter.IPv4SrcAddr.subnetMask);
    }
    if (filter.is_IPv4DstAddr_Available)
    {
        fprintf (stderr, "\t\tIPv4 Dest Addr\n");
        fprintf (stderr, "\t\t\tAddress    : %u\n", filter.IPv4DstAddr.addr);
        fprintf (stderr, "\t\t\tSubnet Mask: %u\n",   filter.IPv4DstAddr.subnetMask);
    }
    if (filter.is_IPv4Tos_Available)
    {
        fprintf (stderr, "\t\tIPv4 ToS\n");
        fprintf (stderr, "\t\t\tValue  : %u(0x%02x)\n", filter.IPv4Tos.val,filter.IPv4Tos.val);
        fprintf (stderr, "\t\t\tMask   : %u(0x%02x)\n", filter.IPv4Tos.mask,filter.IPv4Tos.mask);
    }
    if (filter.is_IPv6SrcAddr_Available)
    {
        fprintf (stderr, "\t\tIPv6 Src Addr\n");
        fprintf (stderr, "\t\t\tAddress     : %s\n", (char *)filter.IPv6SrcAddr.addr);
        fprintf (stderr, "\t\t\tPrefix Len  : %u\n",   filter.IPv6SrcAddr.prefixLen);
    }    
    if (filter.is_IPv6DstAddr_Available)
    {
        fprintf (stderr, "\t\tIPv6 Dest Addr\n");
        fprintf (stderr, "\t\t\tAddress     : %s\n", (char *)filter.IPv6DstAddr.addr);
        fprintf (stderr, "\t\t\tPrefix Len  : %u\n",   filter.IPv6DstAddr.prefixLen);
    }
    if (filter.is_IPv6TrafCls_Available)
    {
        fprintf (stderr, "\t\tIPv6 Traffic Class\n");
        fprintf (stderr, "\t\t\tValue  : %u\n", filter.IPv6TrafCls.val);
        fprintf (stderr, "\t\t\tMask   : %u\n",   filter.IPv6TrafCls.mask);
    }    
    if (filter.is_TCPSrcPort_Available)
    {
        fprintf (stderr, "\t\tTCP src port\n");
        fprintf (stderr, "\t\t\tPort  : %d\n", filter.TCPSrcPort.port);
        fprintf (stderr, "\t\t\tRange : %d\n", filter.TCPSrcPort.range);
    }    
    if (filter.is_TCPDstPort_Available)
    {
        fprintf (stderr, "\t\tTCP dest port\n");
        fprintf (stderr, "\t\t\tPort  : %d\n", filter.TCPDstPort.port);
        fprintf (stderr, "\t\t\tRange : %d\n", filter.TCPDstPort.range);
    }
    if (filter.is_UDPSrcPort_Available)
    {
        fprintf (stderr, "\t\tUDP src port\n");
        fprintf (stderr, "\t\t\tPort  : %d\n", filter.UDPSrcPort.port);
        fprintf (stderr, "\t\t\tRange : %d\n", filter.UDPSrcPort.range);
    }
    if (filter.is_UDPDstPort_Available)
    {
        fprintf (stderr, "\t\tUDP dest port\n");
        fprintf (stderr, "\t\t\tPort  : %d\n", filter.UDPDstPort.port);
        fprintf (stderr, "\t\t\tRange : %d\n", filter.UDPDstPort.range);
    }
    if (filter.is_TranSrcPort_Available)
    {
        fprintf (stderr, "\t\tTransport src port\n");
        fprintf (stderr, "\t\t\tPort  : %d\n", filter.TranSrcPort.port);
        fprintf (stderr, "\t\t\tRange : %d\n", filter.TranSrcPort.range);
    }
    if (filter.is_TranDstPort_Available)
    {
        fprintf (stderr, "\t\tTransport dest port\n");
        fprintf (stderr, "\t\t\tPort  : %d\n", filter.TranDstPort.port);
        fprintf (stderr, "\t\t\tRange : %d\n", filter.TranDstPort.range);
    }    
}

void *qos_read_thread(void* ptr)
{
    UNUSEDPARAM(ptr);
    const char *qmi_msg;
    unpack_qmi_t rsp_ctx;
    uint8_t  buffer[QMI_QOS_MSG_MAX]={'0'};

    int rtn;
    ssize_t rlen;
    printf ("QoS read thread\n");
    sleep(3);
    while(enQosThread)
    {
        //TODO select multiple file and read them
        memset (buffer,0,QMI_QOS_MSG_MAX);
        rlen = read(qos_fd, buffer, QMI_QOS_MSG_MAX);
        if (rlen > 0)
        {
            qmi_msg = helper_get_resp_ctx(eQOS, buffer, rlen, &rsp_ctx);
            printf("<< receiving %s, Len: %zu\n", qmi_msg, rlen);

            if (eIND == rsp_ctx.type)
                printf("QOS IND: ");
            else if (eRSP == rsp_ctx.type)
                printf("QOS RSP: ");
            printf("msgid 0x%02x\n", rsp_ctx.msgid);

            switch(rsp_ctx.msgid)
            {
                /** eQMI_QOS_SWI_READ_DATA_STATS **/
                case eQMI_QOS_SWI_READ_DATA_STATS:
                    {
                        uint8_t i =0;
                        unpack_qos_SLQSQosSwiReadDataStats_t QoSDataStats;
                        memset (&QoSDataStats,0,sizeof(QoSDataStats));
                        rtn = unpack_qos_SLQSQosSwiReadDataStats (buffer, rlen, &QoSDataStats);
                        printf("unpack_qos_SLQSQosSwiReadDataStats return: %d\n", rtn);
                        printf("\tAPN ID            : %d\n", QoSDataStats.apnId);
                        printf("\ttotal_tx_pkt      : %d\n", QoSDataStats.total_tx_pkt);
                        printf("\ttotal_tx_pkt_drp  : %d\n", QoSDataStats.total_tx_pkt_drp);
                        printf("\ttotal_rx_pkt      : %d\n", QoSDataStats.total_rx_pkt);
                        printf("\ttotal_tx_bytes    : %ju\n", QoSDataStats.total_tx_bytes);
                        printf("\ttoal_tx_bytes_drp : %ju\n", QoSDataStats.total_tx_bytes_drp);
                        printf("\ttotal_rx_bytes    : %ju\n", QoSDataStats.total_rx_bytes);
                        printf("\tNumber of flows   : %d\n", QoSDataStats.numQosFlow);
                        for (i=0;i<QoSDataStats.numQosFlow;i++)
                        {
                            printf("\t\tbearerId     : %u\n", QoSDataStats.qosFlow[i].bearerId);
                            printf("\t\ttx_pkt       : %u\n", QoSDataStats.qosFlow[i].tx_pkt);
                            printf("\t\ttx_pkt_drp   : %u\n", QoSDataStats.qosFlow[i].tx_pkt_drp);
                            printf("\t\ttx_bytes     : %ju\n", QoSDataStats.qosFlow[i].tx_bytes);
                            printf("\t\ttx_bytes_drp : %ju\n", QoSDataStats.qosFlow[i].tx_bytes_drp);                            
                        }
                    }
                    break; //QMI_QOS_SWI_READ_DATA_STATS
                    
                /** eQMI_QOS_SWI_READ_APN_PARAMS **/
                case eQMI_QOS_SWI_READ_APN_PARAMS:
                    {
                        unpack_qos_SLQSQosSwiReadApnExtraParams_t ExtraAPNParams;
                        memset (&ExtraAPNParams,0,sizeof(ExtraAPNParams));
                        rtn =  unpack_qos_SLQSQosSwiReadApnExtraParams (buffer, rlen, &ExtraAPNParams);
                        printf("unpack_qos_SLQSQosSwiReadApnExtraParams return: %d\n", rtn);
                        printf("\tAPN ID       : %d\n", ExtraAPNParams.apnId);
                        printf("\tambr_ul      : %d\n", ExtraAPNParams.ambr_ul);
                        printf("\tambr_dl      : %d\n", ExtraAPNParams.ambr_dl);
                        printf("\tambr_ul_ext  : %d\n", ExtraAPNParams.ambr_ul_ext);
                        printf("\tambr_dl_ext  : %d\n", ExtraAPNParams.ambr_dl_ext);
                        printf("\tambr_ul_ext2 : %d\n", ExtraAPNParams.ambr_ul_ext2);
                        printf("\tambr_dl_ext2 : %d\n", ExtraAPNParams.ambr_dl_ext2);
                        
                    }
                    break; //QMI_QOS_SWI_READ_APN_PARAMS                    
                
                /** eQMI_QOS_GET_FLOW_STATUS **/                
                case eQMI_QOS_GET_FLOW_STATUS:
                    if (eIND == rsp_ctx.type)
                    {
                        unpack_qos_SLQSSetQosStatusCallback_ind_t QoSFlowStatus;
                        memset (&QoSFlowStatus,0,sizeof(QoSFlowStatus));
                        rtn = unpack_qos_SLQSSetQosStatusCallback_ind (buffer, rlen, &QoSFlowStatus);
                        printf("unpack_qos_SLQSSetQosStatusCallback_ind return: %d\n", rtn);
                        printf("\tFlow ID    : %d\n", QoSFlowStatus.id);
                        printf("\tFlow status: %d\n", QoSFlowStatus.status);
                        printf("\tFlow event : %d\n", QoSFlowStatus.event);
                        printf("\tFlow reason: %d\n", QoSFlowStatus.reason);
                    }
                    else if (eRSP == rsp_ctx.type)
                    {
                        // Not Supported
                    }                    
                    break; //QMI_QOS_GET_FLOW_STATUS

                /** eQMI_QOS_PRIMARY_QOS_EVENT_IND **/
                case eQMI_QOS_PRIMARY_QOS_EVENT_IND:
                    if (eIND == rsp_ctx.type)
                    {
                        unpack_qos_SLQSSetQosPriEventCallback_ind_t QoSPriFlowEvent;
                        memset (&QoSPriFlowEvent,0,sizeof(QoSPriFlowEvent));
                        rtn = unpack_qos_SLQSSetQosPriEventCallback_ind ( buffer, rlen,&QoSPriFlowEvent);
                        printf("unpack_qos_SLQSSetQosPriEventCallback_ind return: %d, Event: %d\n", rtn, QoSPriFlowEvent.event );
                    }
                    break; //QMI_QOS_PRIMARY_QOS_EVENT_IND

                /** eQMI_QOS_GET_NW_STATUS **/
                case eQMI_QOS_GET_NW_STATUS:
                    if (eIND == rsp_ctx.type)
                    {
                        unpack_qos_SLQSSetQosNWStatusCallback_ind_t QoSNWStatusIndication;
                        memset (&QoSNWStatusIndication,0,sizeof(QoSNWStatusIndication));
                        rtn = unpack_qos_SLQSSetQosNWStatusCallback_ind (buffer, rlen, &QoSNWStatusIndication);
                        printf("unpack_qos_SLQSSetQosNWStatusCallback_ind return: %d, NW Status: %d\n", rtn, QoSNWStatusIndication.status);
                    }
                    else if (eRSP == rsp_ctx.type)
                    {                        
                        unpack_qos_SLQSQosGetNetworkStatus_t QoSNWStatusRsp;
                        memset (&QoSNWStatusRsp,0,sizeof(QoSNWStatusRsp));
                        rtn = unpack_qos_SLQSQosGetNetworkStatus ( buffer, rlen,&QoSNWStatusRsp);
                        printf("unpack_qos_SLQSQosGetNetworkStatus return: %d, NW Status: %d\n", rtn, QoSNWStatusRsp.NWQoSStatus );
                    }                    
                    break; //QMI_QOS_GET_NW_STATUS
                    
                /** eQMI_QOS_SET_EVENT **/                
                case eQMI_QOS_SET_EVENT:
                    if (eIND == rsp_ctx.type)
                    {
                        unpack_qos_SLQSSetQosEventCallback_ind_t QoSEventIndication;
                        #ifdef QOS_EVENTS_DEBUG
                        rtn = unpack_qos_SLQSSetQosEventCallback_ind  ( qos_event_sample, sizeof(qos_event_sample), &QoSEventIndication);
                        #else
                        rtn = unpack_qos_SLQSSetQosEventCallback_ind  ( buffer, rlen, &QoSEventIndication);
                        #endif //QOS_EVENTS_DEBUG
                        printf("unpack_qos_SLQSSetQosEventCallback_ind return: %d\n", rtn);
                        fprintf (stderr, "Num Flows: %d\n", QoSEventIndication.NumFlows);
                        int i = 0;
                        int j = 0;
                        for (i=0;i<QoSEventIndication.NumFlows;i++)
                        {
                            fprintf (stderr, "Flow Number: %d\n", (i+1));
                            fprintf (stderr, "\tBearer ID  : %d\n", QoSEventIndication.QosFlowInfo[i].BearerID);
                            fprintf (stderr, "\tQoS Flow ID: %d\n", QoSEventIndication.QosFlowInfo[i].QFlowState.id);
                            fprintf (stderr, "\tisNewFlow  : %d\n", QoSEventIndication.QosFlowInfo[i].QFlowState.isNewFlow);
                            fprintf (stderr, "\tState      : %d\n", QoSEventIndication.QosFlowInfo[i].QFlowState.state);
                            if (QoSEventIndication.QosFlowInfo[i].is_TxQFlowGranted_Available)
                            {
                                fprintf (stderr, "\tTx Flow Granted\n");
                                fprintf (stderr, "\t===============\n");
                                _print_flow(QoSEventIndication.QosFlowInfo[i].TxQFlowGranted);
                            }
                            if (QoSEventIndication.QosFlowInfo[i].is_TxQFlowGranted_Available)
                            {
                                fprintf (stderr, "\tRx Flow Granted\n");
                                fprintf (stderr, "\t===============\n");
                                _print_flow(QoSEventIndication.QosFlowInfo[i].RxQFlowGranted);
                            }
                            for (j=0;j<QoSEventIndication.QosFlowInfo[i].NumTxFilters;j++)
                            {
                                fprintf (stderr, "\tTx Filter Number: %d\n", (j+1));
                                fprintf (stderr, "\t====================\n");
                                _print_filter(QoSEventIndication.QosFlowInfo[i].TxQFilter[j]);
                            }
                            for (j=0;j<QoSEventIndication.QosFlowInfo[i].NumRxFilters;j++)
                            {
                                fprintf (stderr, "\tRx Filter Number: %d\n", (j+1));
                                fprintf (stderr, "\t====================\n");
                                _print_filter(QoSEventIndication.QosFlowInfo[i].RxQFilter[j]);
                            }        
                        }                        
                    }
                    else if (eRSP == rsp_ctx.type)
                    {                        
                        rtn = unpack_qos_SLQSSetQosEventCallback( buffer, rlen);
                        printf("SLQSSetQosEventCallback return: %d\n", rtn);
                    }                    
                    break; //QMI_QOS_SET_EVENT
                
                default:
                    break;
            }
        }
    }    
    return NULL;
}

void qos_loop(void)
{
    uint8_t  buffer[QMI_QOS_MSG_MAX]={'0'};
    uint16_t reqLen = QMI_QOS_MSG_MAX;
    pack_qmi_t req_ctx;
    int rtn = -1;
    // Get QoS FD
    if(qos_fd<0)
        qos_fd = client_fd(eQOS); 
    sleep(1);
    // Start QoS read thread
    memset(&qos_attr, 0, sizeof(qos_attr));
    enQosThread = 1;
    pthread_create(&qos_tid, &qos_attr, qos_read_thread, NULL);
    usleep(500);

    // Register for QoS event notification

    pack_qos_SLQSSetQosEventCallback_t param;
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = 0x100;
    param.enable = 1;
    rtn = pack_qos_SLQSSetQosEventCallback (&req_ctx,buffer,&reqLen,param);
    fprintf (stderr, "pack_qos_SLQSSetQosEventCallback ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(qos_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);

    // SLQSSetQosPriEventCallback does not need to be registered
    // SLQSSetQosStatusCallback does not need to be registered
    // SLQSSetQosNWStatusCallback does not need to be registered

    // Get Network status
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = 0x101;
    reqLen = QMI_QOS_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn = pack_qos_SLQSQosGetNetworkStatus (&req_ctx,buffer,&reqLen);
    fprintf (stderr, "pack_qos_SLQSQosGetNetworkStatus ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(qos_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);

    sleep(1);
    // Read extra APN params
    pack_qos_SLQSQosSwiReadApnExtraParams_t ExtraAPNParams;
    ExtraAPNParams.apnId = 3;
    memset(&req_ctx, 0, sizeof(req_ctx));
    req_ctx.xid = 0x102;
    reqLen = QMI_QOS_MSG_MAX;
    memset(buffer, 0, reqLen);
    rtn = pack_qos_SLQSQosSwiReadApnExtraParams (&req_ctx,buffer,&reqLen,ExtraAPNParams);
    fprintf (stderr, "pack_qos_SLQSQosSwiReadApnExtraParams ret: %d, Len: %d\n", rtn, reqLen);
    rtn = write(qos_fd, buffer, reqLen);
    fprintf (stderr, "Write : %d\n", rtn);    

    // Read Data stats
    pack_qos_SLQSQosSwiReadDataStats_t DataStats;
    DataStats.apnId = 3;
    int i;
    for (i=100;i<110;i++)
    {
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid += (i+1);
        reqLen = QMI_QOS_MSG_MAX;
        memset(buffer, 0, reqLen);
        rtn = pack_qos_SLQSQosSwiReadDataStats (&req_ctx,buffer,&reqLen,DataStats);
        fprintf (stderr, "pack_qos_SLQSQosSwiReadDataStats ret: %d, Len: %d\n", rtn, reqLen);
        rtn = write(qos_fd, buffer, reqLen);
        fprintf (stderr, "Write : %d\n", rtn);    
        sleep(5);
    }
    return;
}
