#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "packingdemo.h"

#include "dms.h"
#include "wds.h"
#include "nas.h"
#include "uim.h"
#include "msgid.h"
#include "loc.h"

#include "qmerrno.h"

#include <signal.h>
#include <execinfo.h>
#include <stdio.h>

#define QMI_GET_SERVICE_FILE_IOCTL  0x8BE0 + 1

uint8_t g_qmi_req[QMI_MSG_MAX];
uint8_t g_rsp[QMI_MSG_MAX];



// QOS
void qos_loop_exit(void);
void qos_loop(void);
//SWIOMA
void swioma_loop_exit(void);
void swioma_loop(void);
//WDS
extern void wds_test_pack_unpack_loop();
extern void wds_test_thread();
extern void wds_test_thread_stop();
//LOC
extern void loc_test_pack_unpack_loop();
extern void loc_test_ind();
extern void loc_test_ind_exit();
//MAS
extern void nas_test_pack_unpack_loop();
extern void nas_test_ind();
extern void nas_test_ind_exit();
//DMS
extern void dms_test_pack_unpack_loop();
extern void dms_test_ind();
extern void dms_test_ind_exit();
//UIM
extern void uim_test_pack_unpack_loop();
extern void uim_test();
//SMS
extern void sms_test_pack_unpack_loop();
extern void sms_test_ind();
extern void sms_test_ind_exit();
//SWI LOC
extern void swiloc_test_pack_unpack_loop();

int
client_fd(
        uint8_t svc
        )
{
    //TODO support first PDN only for the moment
    int fd = open("/dev/qcqmi0", O_RDWR);
    ioctl(fd, QMI_GET_SERVICE_FILE_IOCTL, svc);
    return fd;
}

void *syslog_proxy(uint8_t lvl, const char *buff)
{
    if (lvl != eLOG_DEBUG)
        return NULL;

    syslog(LOG_DEBUG, "%s", buff );
    printf("%s", buff);
    fflush(stdout);
    return NULL;
}

void packingdemo()
{
    dms_test_pack_unpack_loop();
    wds_test_pack_unpack_loop();
    nas_test_pack_unpack_loop();
    uim_test_pack_unpack_loop();
    sms_test_ind();
#if 0 // TBD
    sms_test_pack_unpack_loop();
    sms_test_ind_exit();

    dms_test_ind();
    dms_test_ind_exit();

    uim_test();




    loc_test_pack_unpack_loop();
    loc_test_ind();
    loc_test_ind_exit();
    
    swioma_loop();
    sleep(10);
    swioma_loop_exit();

    qos_loop();
    qos_loop_exit();
#endif
}

void* tracePtrs[100];
void segfault(int signo, siginfo_t* pinfo, void *pcontext)
{
    int ii;
    UNUSEDPARAM(signo);
    UNUSEDPARAM(pinfo);
    UNUSEDPARAM(pcontext);
    int count = backtrace( tracePtrs, 100 );
    printf("backtrace() returned %d addresses\n", count);
    char** funcNames = backtrace_symbols( tracePtrs, count );

    if (funcNames == NULL) {
        perror("backtrace_symbols");
        exit(EXIT_FAILURE);
    }

    // Print the stack trace
    for( ii = 0; ii < count; ii++ )
        printf( "%s\n", funcNames[ii] );

    // Free the string pointers
    free( funcNames );
    exit(-1);
}


int
main()
{
    printf("libpack version %s\n", get_version());

    struct sigaction sa;
    sa.sa_sigaction = segfault;
    sigemptyset(&sa.sa_mask);

    sa.sa_flags = SA_NODEFER | SA_SIGINFO;

    if (sigaction(SIGSEGV, &sa, NULL) < 0)
        printf("signal handler install failed");

    packingdemo();
    return 0;
}

