#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "packingdemo.h"
#include "nas.h"

#define IFPRINTF(s,p)   if( NULL != p ){ printf(s,*p); }
#define PLMN_LENGTH    3

int nas=-1;

/*  Parameters for SLQSNasIndicationRegisterExt() API */
uint8_t setInd   = 0x01;
uint8_t unsetInd = 0x00;
pack_nas_SLQSNasIndicationRegisterExt_t nasIndicationRegisterExt = {
    &setInd, // uint8_t *pSystemSelectionInd
    &setInd, // uint8_t *pDDTMInd
    &setInd, // uint8_t *pServingSystemInd
    &setInd, // uint8_t *pDualStandByPrefInd
    &setInd, // uint8_t *pSubscriptionInfoInd
    &setInd, // uint8_t *pNetworkTimeInd
    &setInd, // uint8_t *pSysInfoInd
    &setInd, // uint8_t *pSignalStrengthInd
    &setInd, // uint8_t *pErrorRateInd
    &setInd, // uint8_t *pHDRNewUATIAssInd
    &setInd, // uint8_t *pHDRSessionCloseInd
    &setInd, // uint8_t *pManagedRoamingInd
    &setInd  // uint8_t *pLTECphyCa
};

nas_SLQSSignalStrengthsIndReq sigIndReq = {
    10, // uint8_t  rxSignalStrengthDelta
    1, // uint8_t  ecioDelta
    10, // uint8_t  ioDelta
    1, // uint8_t  sinrDelta
    10, // uint8_t  rsrqDelta
    5, // uint8_t  ecioThresholdListLen
    {-10, -20, -30, -40, -50 }, // int16_t  ecioThresholdList[10]
    5, // uint8_t  sinrThresholdListLen
    {10, 20, 30, 40, 50 }, // uint8_t  sinrThresholdList[5]
    1, // uint16_t lteSnrDelta
    1 // uint8_t  lteRsrpDelta
};

pack_nas_SLQSSetSignalStrengthsCallback_t setSigStrengthCallback = {
    1, // uint8_t bEnable
    &sigIndReq
};

uint8_t setRFInfoCallback = 1;

unpack_nas_GetHomeNetwork_t homenw;
unpack_nas_GetRFInfo_t      rfinfo;
unpack_nas_SLQSNasGetSigInfo_t siginfo;

uint8_t emerMode = 0xFF;
uint16_t modePref = 0xFFFF;
uint64_t bandPref = 0xFFFFFFFFFFFFFFFFLL;
uint16_t prlPref = 0xFFFF;
uint16_t roamPref = 0xFFFF;
uint64_t lteBandPref =0xFFFFFFFFFFFFFFFFLL;
uint8_t netSelPref = 0xFF;
uint32_t srvDomainPref = 0xFFFFFFFFLL;
uint32_t gwaAcqOrderPref = 0xFFFFFFFFLL;
unpack_nas_SLQSGetSysSelectionPref_t sysSelPref = {
    &emerMode,
    &modePref,
    &bandPref,
    &prlPref,
    &roamPref,
    &lteBandPref,
    &netSelPref,
    &srvDomainPref,
    &gwaAcqOrderPref
};


uint8_t setEmerMode = 0; // OFF, normal mode
uint16_t setModePref = 0x18; // GSM, UMTS, LTE enabled
uint64_t setBandPref = 0xffffffffffffffffLL; // select all band
uint16_t setPRLPref = 0x3fff; // any available system
uint16_t setRoamPref = 0xffff; // Acquire systems, regardless of their roaming indicator
uint64_t setLTEBandPref = 0x44; // BAND 3 and BAND 7 enabled 
uint8_t setChgDuration = 0x00;
uint8_t setMNCIncPCSDigStat = 0x00;
uint32_t setSrvDomainPref = 0x00;
uint32_t setGWAcqOrderPref = 0x00;
uint32_t setSrvRegRestriction = 0x00;

pack_nas_SLQSSetSysSelectionPref_t setSysSelPref = {
    &setEmerMode,
    &setModePref,
    &setBandPref,
    &setPRLPref,
    &setRoamPref,
    &setLTEBandPref,
    NULL,
    &setChgDuration,
    &setMNCIncPCSDigStat,
    &setSrvDomainPref,
    &setGWAcqOrderPref,
    NULL,
    NULL,
    &setSrvRegRestriction,
    NULL,
    NULL
};

unpack_nas_GetServingNetwork_t getServingNW = {
    0, // uint32_t   RegistrationState
    0, // uint32_t   CSDomain
    0, // uint32_t   PSDomain
    0, // uint32_t   RAN
    0, // uint8_t    RadioIfacesSize
    {0}, // uint8_t    RadioIfaces[255]
    0, // uint32_t   Roaming
    0, // uint16_t   MCC
    0, // uint16_t   MNC
    0, // uint8_t    nameSize
    {0}, // uint8_t    Name[255]
    0, // uint8_t    DataCapsLen
    {0} // uint8_t    DataCaps[255]
};

unpack_nas_GetServingNetworkCapabilities_t getServingNwCap = {
    0, // uint8_t    DataCapsLen
    {0}, // uint8_t    DataCaps[255]
};
nas_QmiNas3GppNetworkInfo nasPerformNetworkScan3GppNetworkInfo[NAS_MAX_NUM_NETWORKS];
nas_QmiNas3GppNetworkRAT nasPerformNetworkScanRATINstance[NAS_MAX_NUM_NETWORKS];
nas_QmisNasPcsDigit  nasPerformNetworkScanPCSInstance[NAS_MAX_NUM_NETWORKS];
uint8_t u8NasPerformNetworkScan3GppNetworkInfoSize = NAS_MAX_NUM_NETWORKS;
uint8_t u8NasPerformNetworkScanGppNetworkRATSize = NAS_MAX_NUM_NETWORKS;
uint8_t u8NasPerformNetworkScanPCSInstanceSize = NAS_MAX_NUM_NETWORKS;
uint32_t u32NasPerformNetworkScanScanResult = 0;

unpack_nas_PerformNetworkScan_t performNwScan = {
    &u8NasPerformNetworkScan3GppNetworkInfoSize, // uint8_t   *p3GppNetworkInstanceSize
    (nas_QmiNas3GppNetworkInfo*)&nasPerformNetworkScan3GppNetworkInfo, // nas_QmiNas3GppNetworkInfo  *pInstances
    &u8NasPerformNetworkScanGppNetworkRATSize, // uint8_t   *pRATInstanceSize
    (nas_QmiNas3GppNetworkRAT*)&nasPerformNetworkScanRATINstance, // nas_QmiNas3GppNetworkRAT  RATINstance
    &u8NasPerformNetworkScanPCSInstanceSize, // uint8_t   *pPCSInstanceSize
    (nas_QmisNasPcsDigit*)&nasPerformNetworkScanPCSInstance,// nas_QmisNasPcsDigit  *pPCSInstance
    &u32NasPerformNetworkScanScanResult //uint32_t   *pScanResult
};

unpack_nas_SLQSSwiGetLteCQI_t swiGetLTECQI = {
    0, // uint8_t   ValidityCW0
    0, // uint8_t   CQIValueCW0
    0, // uint8_t   ValidityCW1
    0 // uint8_t   CQIValueCW1
};

nas_LTEInfo lteInfo;

unpack_nas_SLQSNasSwiModemStatus_t swiGetModemStatus = {
    { // nas_CommInfo commonInfo
        0, // int8_t temperature
        0, // uint8_t modemMode
        0, // uint8_t systemMode
        0, // uint8_t imsRegState
        0  // uint8_t psState
    },
    &lteInfo
};

unpack_nas_SLQSGetServingSystem_t getServingSystem = {
    {0,0,0,0,0,{0}}, // nas_servSystem    ServingSystem
    0,               // uint8_t           RoamIndicatorVal
    {0,{0}},         // nas_dataSrvCapabilities DataSrvCapabilities
    {0,0,0,{0}},     // nas_currentPLMN   CurrentPLMN
    0,               // uint16_t          SystemID
    0,               // uint16_t          NetworkID
    0,               // uint16_t          BasestationID
    0,               // uint32_t          BasestationLatitude
    0,               // uint32_t          BasestationLongitude
    {0,{0},{0}},     // nas_roamIndList   RoamingIndicatorList
    0,               // uint8_t           DefaultRoamInd
    {0,0,0},         // nas_qaQmi3Gpp2TimeZone Gpp2TimeZone
    0,               // uint8_t           CDMA_P_Rev
    0,               // uint8_t           GppTimeZone
    0,               // uint8_t           GppNetworkDSTAdjustment
    0,               // uint16_t          Lac
    0,               // uint32_t          CellID
    0,               // uint8_t           ConcSvcInfo
    0,               // uint8_t           PRLInd
    0,               // uint8_t           DTMInd
    {0,0,0,0,0},     // nas_detailSvcInfo DetailedSvcInfo
    {0,0},           // nas_CDMASysInfoExt CDMASystemInfoExt
    0,               // uint8_t           HdrPersonality
    0,               // uint16_t          TrackAreaCode
    {0,0}            // nas_callBarStatus CallBarStatus
};

uint16_t signalStrenghMask = 0xFF; // bit mask, request for everything

unpack_nas_SLQSGetSignalStrength_t getSignalStrength = {
    0,       // uint16_t   signalStrengthReqMask
    0,       // uint16_t   rxSignalStrengthListLen
    {{0,0}}, // nas_rxSignalStrengthListElement rxSignalStrengthList[18]
    0,       // uint16_t   ecioListLen 
    {{0,0}}, // nas_ecioListElement ecioList[18]
    0,       // int32_t    Io
    0,       // uint8_t    sinr
    0,       // uint16_t   errorRateListLen
    {{0,0}}, // nas_errorRateListElement errorRateList[18]
    {0,0},   // nas_rsrqInformation rsrqInfo
    0,       // int16_t    ltesnr
    0        // int16_t    ltersrp
};

unpack_nas_GetCDMANetworkParameters_t getCDMANetworkParameters = {
    0, // uint8_t  SCI
    0, // uint8_t  SCM
    0, // uint8_t  RegHomeSID
    0, // uint8_t  RegForeignSID
    0, // uint8_t  RegForeignNID
    0, // uint8_t  ForceRev0
    0, // uint8_t  CustomSCP
    0, // uint32_t Protocol
    0, // uint32_t Broadcast
    0, // uint32_t Application
    0  // uint32_t Roaming
};

uint32_t getANAAAStatus;

pack_nas_SetACCOLC_t setACCOLC = {
   {0}, // int8_t spc[6]
   0    // uint8_t accolc
};

uint8_t getACCOLC;

int16_t cdmaRssiThresList[2] = {-1020, -400}; /* -102dB, -40dB */
int16_t cdmaEcioThresList[2] = {-400, -310};  /* -20dB, -15.5dB */
int16_t hdrRssiThresList[2] = {-500, -150};   /* -50dB, -15dB */
int16_t hdrEcioThresList[2] = {-400, -310};   /* -20dB, -15.5dB */
uint16_t hdrSinrThresList[2] = {0x01, 0x03};   /* -6dB, -3dB */
int16_t hdrIoThresList[2] = {-1110, -730};    /* -110dB, -73dB */
int16_t gsmRssiThresList[2] = {-950, -800 };  /* -95dB, -80dB */
int16_t wcdmaRssiThreshList[2] = {-1000, -200}; /* -100dB, -20dB */
int16_t wcdmaEcioThreshList[2] = {-400, -310}; /* -20dB, -15.5dB */
int16_t lteRssiThreshList[2] = {-1000, -400}; /* -100dB, -40dB */
int16_t lteSnrThreshList[2] = {-198, -230}; /* -19.8dB, 23dB */
int16_t lteRsrqThreshList[2] = {-110, -60}; /* -11dB, -6dB */
int16_t lteRsrpThreshList[2] = {-1250, -640}; /* -125dB, -64dB */
int16_t tdscdmaRscpThreshList[2] = {-950, -800}; /* -95dB, -80dB */
float tdscdmaRssiThreshList[2] = {-950, -800}; /* -95dB, -80dB */
float tdscdmaEcioThreshList[2] = {-400, -310}; /* -20dB, -15.5dB */
float tdscdmaSinrThreshList[2] = {0x01, 0x03}; /* -6dB, -3dB */

nas_CDMARSSIThresh    CDMARSSIThresh = {2, &cdmaRssiThresList[0]};
uint16_t              CDMARSSIDelta = 100; /* 10dBm */

nas_CDMAECIOThresh    CDMAECIOThresh = {2, &cdmaEcioThresList[0]};
uint16_t              CDMAECIODelta = 100; /* 10dBm */

nas_HDRRSSIThresh     HDRRSSIThresh = {2, &hdrRssiThresList[0]};
uint16_t              HDRRSSIDelta = 100; /* 10dBm */

nas_HDRECIOThresh     HDRECIOThresh = {2, &hdrEcioThresList[0]};
uint16_t              HDRECIODelta = 100; /* 10dBm */

nas_HDRSINRThreshold  HDRSINRThresh = {2, &hdrSinrThresList[0]};
uint16_t              HDRSINRDelta = 1;

nas_HDRIOThresh       HDRIOThresh = {2, &hdrIoThresList[0]};
uint16_t              HDRIODelta = 100; /* 10dBm */

nas_GSMRSSIThresh     GSMRSSIThresh = {2, &gsmRssiThresList[0]};
uint16_t              GSMRSSIDelta = 100; /* 10dBm */

nas_WCDMARSSIThresh   WCDMARSSIThresh = {2, &wcdmaRssiThreshList[0]};
uint16_t              WCDMARSSIDelta = 100; /* 10dBm */

nas_WCDMAECIOThresh   WCDMAECIOThresh = {2, &wcdmaEcioThreshList[0]};
uint16_t              WCDMAECIODelta = 100; /* 10dBm */

nas_LTERSSIThresh     LTERSSIThresh = {2, &lteRssiThreshList[0]};
uint16_t              LTERSSIDelta = 100; /* 10dBm */

nas_LTESNRThreshold   LTESNRThresh = {2, &lteSnrThreshList[0]};
uint16_t              LTESNRDelta = 100; /* 10dBm */

nas_LTERSRQThresh     LTERSRQThresh = {2, &lteRsrqThreshList[0]};
uint16_t              LTERSRQDelta = 100; /* 10dBm */

nas_LTERSRPThresh     LTERSRPThresh = {2, &lteRsrpThreshList[0]};
uint16_t              LTERSRPDelta = 100; /* 10dBm */

nas_LTESigRptConfig   LTESigRptConfig = {0,0}; /* report using default configuration */

nas_TDSCDMARSCPThresh TDSCDMARSCPThresh = {2, &tdscdmaRscpThreshList[0]};
uint16_t              TDSCDMARSCPDelta = 100; /* 10dBm */

nas_TDSCDMARSSIThresh TDSCDMARSSIThresh = {2, &tdscdmaRssiThreshList[0]};
float         TDSCDMARSSIDelta = 100; /* 10dBm */

nas_TDSCDMAECIOThresh TDSCDMAECIOThresh = {2, &tdscdmaEcioThreshList[0]};
float         TDSCDMAECIODelta = 100; /* 10dBm */

nas_TDSCDMASINRThresh TDSCDMASINRThresh = {2, &tdscdmaSinrThreshList[0]};
float         TDSCDMASINRDelta = 1;

pack_nas_SLQSNasConfigSigInfo2_t nasConfigSigInfo2 = {
    &CDMARSSIThresh,
    NULL, //&CDMARSSIDelta,
    &CDMAECIOThresh,
    NULL, //&CDMAECIODelta,
    NULL, //wl &HDRRSSIThresh,
    NULL, //&HDRRSSIDelta,
    NULL, //&HDRECIOThresh,
    NULL, //&HDRECIODelta,
    NULL, //&HDRSINRThresh,
    NULL, //&HDRSINRDelta,
    NULL, //&HDRIOThresh,
    NULL, //&HDRIODelta,
    NULL, //&GSMRSSIThresh,
    NULL, //&GSMRSSIDelta,
    &WCDMARSSIThresh,
    NULL, //&WCDMARSSIDelta,
    &WCDMAECIOThresh,
    NULL, //&WCDMAECIODelta,
    &LTERSSIThresh,
    NULL, //&LTERSSIDelta,
    &LTESNRThresh,
    NULL, //&LTESNRDelta,
    &LTERSRQThresh,
    NULL, //&LTERSRQDelta,
    &LTERSRPThresh,
    NULL, //&LTERSRPDelta,
    &LTESigRptConfig,
    NULL,//&TDSCDMARSCPThresh,
    NULL, //&TDSCDMARSCPDelta,
    NULL, //&TDSCDMARSSIThresh,
    NULL, //&TDSCDMARSSIDelta,
    NULL, //&TDSCDMAECIOThresh,
    NULL, //&TDSCDMAECIODelta,
    NULL, //&TDSCDMASINRThresh,
    NULL  //&TDSCDMASINRDelta
};

uint8_t mncPcsStatus = 0;
pack_nas_SLQSGetPLMNName_t tpack_nas_SLQSGetPLMNName_t = {454, 6, &mncPcsStatus};
unpack_nas_SLQSGetPLMNName_t tunpack_nas_SLQSGetPLMNName_t ;

unpack_nas_GetNetworkPreference_t GetNetworkPreferenceResp;
pack_nas_SetNetworkPreference_t   SetNetworkPreferenceReq = {
    0x00,
    0x00,
    0
};
pack_nas_SetNetworkPreference_t   SetNetworkPreferenceResp;

unpack_nas_SlqsGetLTECphyCAInfo_t SlqsGetLTECphyCAInfo;

nas_MNRInfo MNRInfoDigit= {454,0,8}; //HKCSL LTE

uint32_t  changeDurationPC = 1;
uint8_t   mncPcsDigit = 0; //true

pack_nas_SLQSInitiateNetworkRegistration_t   nasInitiateNetworkRegistration = {
    0x02, //Reg Action
    &MNRInfoDigit,
    &changeDurationPC,
    &mncPcsDigit
};

uint8_t rankInd = 0;

pack_nas_SLQSNasSwiOTAMessageCallback_t tpack_nas_SLQSNasSwiOTAMessageCallback ={
        1,1,1,1,1,1, &rankInd};

nas_GERANInfo                geranInfo;
nas_UMTSInfo                 umtsInfo;
nas_CDMAInfo                 cdmaInfo;
nas_LTEInfoIntrafreq         lteInfoIntrafreq;
nas_LTEInfoInterfreq         lteInfoInterfreq;
nas_LTEInfoNeighboringGSM    lteInfoNeighboringGSM;
nas_LTEInfoNeighboringWCDMA  lteInfoNeighboringWCDMA;
uint32_t                     UMTSCellID;
nas_WCDMAInfoLTENeighborCell WCDMAInfLTENeighborCell;

unpack_nas_SLQSNasGetCellLocationInfo_t nasgetcelllocinfo ={
        &geranInfo,
        &umtsInfo,
        &cdmaInfo,
        &lteInfoIntrafreq,
        &lteInfoInterfreq,
        &lteInfoNeighboringGSM,
        &lteInfoNeighboringWCDMA,
        &UMTSCellID,
        &WCDMAInfLTENeighborCell
};
void dump_SLQSNasIndicationRegisterExt (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSSetSignalStrengthsCallback (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SetRFInfoCallback (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SetLURejectCallback (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_GetHomeNetwork(void *ptr)
{ 
    unpack_nas_GetHomeNetwork_t *phomenw =
        (unpack_nas_GetHomeNetwork_t*) ptr;
    printf("mcc: %d\n", phomenw->mcc);
    printf("mnc: %d\n", phomenw->mnc);
    printf("home nw: %s\n", phomenw->name);
    printf("sytem id: %d\n", phomenw->sid);
    printf("network id: %d\n", phomenw->nid);


#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* mcc and mnc should not equal to 0 */
    if ((phomenw->mcc == 0) ||
       (phomenw->mnc == 0))
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_GetRFInfo(void* ptr)
{
    unpack_nas_GetRFInfo_t *prfinfo =
        (unpack_nas_GetRFInfo_t*) ptr;
    uint8_t    count;

    for(count = 0; count < prfinfo->instancesSize; count++)
    {
        printf("radioInterface[%d] : %d\n",
                count, prfinfo->RFBandInfoElements[count].radioInterface);
        printf("activeBandClass[%d] : %d\n",
                count, prfinfo->RFBandInfoElements[count].activeBandClass);
        printf("activeChannel[%d] : %d\n",
                count, prfinfo->RFBandInfoElements[count].activeChannel);
    }
#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* mcc and mnc should not equal to 0 */
    if ((prfinfo->RFBandInfoElements[0].radioInterface == 0) ||
       (prfinfo->RFBandInfoElements[0].activeBandClass == 0))
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}
void dump_SLQSNasGetSigInfo(void* ptr)
{
    unpack_nas_SLQSNasGetSigInfo_t *psiginfo =
        (unpack_nas_SLQSNasGetSigInfo_t*) ptr;

    printf("cdma ss information \n");
    printf("rssi  : %d\n", psiginfo->CDMASSInfo.rssi);
    printf("ecio  : %d\n", psiginfo->CDMASSInfo.ecio);

    printf("hdr ss information \n");
    printf("rssi  : %d\n", psiginfo->HDRSSInfo.rssi);
    printf("ecio  : %d\n", psiginfo->HDRSSInfo.ecio);
    printf("sinr  : %d\n", psiginfo->HDRSSInfo.sinr);
    printf("io    : %d\n", psiginfo->HDRSSInfo.io);

    printf("gsm sig info : %d\n", psiginfo->GSMSSInfo);

    printf("wcdma ss information \n");
    printf("rssi  : %d\n", psiginfo->WCDMASSInfo.rssi);
    printf("ecio  : %d\n", psiginfo->WCDMASSInfo.ecio);

    printf("lte ss information \n");
    printf("rssi  : %d\n", psiginfo->LTESSInfo.rssi);
    printf("rsrq  : %d\n", psiginfo->LTESSInfo.rsrq);
    printf("rsrp  : %d\n", psiginfo->LTESSInfo.rsrp);
    printf("snr   : %d\n", psiginfo->LTESSInfo.snr);

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 0;
    FILE *fp;

    /* mcc and mnc should not equal to 0 */
    if ((psiginfo->CDMASSInfo.rssi != 0) ||
       (psiginfo->HDRSSInfo.rssi != 0) ||
       (psiginfo->GSMSSInfo != 0) ||
       (psiginfo->WCDMASSInfo.rssi != 0) ||
       (psiginfo->LTESSInfo.rssi != 0))
    {
        is_matching = 1;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_SLQSSetSysSelectionPref (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSGetSysSelectionPref (void *ptr)
{
    unpack_nas_SLQSGetSysSelectionPref_t *pGetSysSelPref =
        (unpack_nas_SLQSGetSysSelectionPref_t*) ptr;
    
    printf( "Emergency Mode: 0x%x\n",               *pGetSysSelPref->pEmerMode );
    printf( "Mode Preference: 0x%x\n",              *pGetSysSelPref->pModePref );
    printf( "Band Preference: 0x%llx\n",            (unsigned long long) *pGetSysSelPref->pBandPref );
    printf( "CDMA PRL Preference : 0x%x\n",         *pGetSysSelPref->pPRLPref );
    printf( "Roaming Preference : 0x%x\n",          *pGetSysSelPref->pRoamPref );
    printf( "LTE Band Preference : 0x%llx\n",       (unsigned long long)*pGetSysSelPref->pLTEBandPref );
    printf( "Network Selection Preference: 0x%x\n", *pGetSysSelPref->pNetSelPref );
    printf( "Service Domain Preference : 0x%x\n",  *pGetSysSelPref->pSrvDomainPref );
    printf( "GSM - WCDMA Acquisition Order Preference : 0x%x\n",*pGetSysSelPref->pGWAcqOrderPref );

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 0;
    FILE *fp;

    /* mcc and mnc should not equal to 0 */
    if ((*pGetSysSelPref->pEmerMode == 0) &&
       (*pGetSysSelPref->pModePref == 0x18))
    {
        is_matching = 1;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_GetServingNetwork (void *ptr)
{
    unpack_nas_GetServingNetwork_t *pServingNW =
    (unpack_nas_GetServingNetwork_t*) ptr;
    uint8_t count;

    printf("RegistrationState  : %d\n", pServingNW->RegistrationState);
    printf("CSDomain  : %d\n", pServingNW->CSDomain);
    printf("PSDomain : %d\n", pServingNW->PSDomain);
    printf("RAN  : %d\n", pServingNW->RAN);
    printf("RadioIfacesSize  : %d\n", pServingNW->RadioIfacesSize);
    for(count = 0; count < pServingNW->RadioIfacesSize; count++)
        printf("RadioIfaces  : %d\n", pServingNW->RadioIfaces[count]);
    printf("Roaming  : %d\n", pServingNW->Roaming);
    printf("MCC  : %d\n", pServingNW->MCC);
    printf("MNC  : %d\n", pServingNW->MNC);
    printf("Name  : %s\n", pServingNW->Name);
    printf("Data Service Capability Len  : %d\n", pServingNW->DataCapsLen);
    for(count = 0; count < pServingNW->DataCapsLen; count++)
        printf("Data Capability  : 0x%02x\n", pServingNW->DataCaps[count]);
#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 0;
    FILE *fp;

    /* mcc and mnc should not equal to 0 */
    if ((pServingNW->RegistrationState == 1) &&
       (pServingNW->RadioIfacesSize > 0))
    {
        is_matching = 1;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_GetServingNetworkCapabilities (void *ptr)
{
    unpack_nas_GetServingNetworkCapabilities_t *pNwCap =
    (unpack_nas_GetServingNetworkCapabilities_t*) ptr;
    uint8_t i;

    printf("Data Service Capability Len  : %d\n", pNwCap->DataCapsLen);
    for(i = 0; i < pNwCap->DataCapsLen; i++)
        printf("Data Capability   : 0x%02x\n", pNwCap->DataCaps[i]);
#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* mcc and mnc should not equal to 0 */
    if ( pNwCap->DataCapsLen == 0) 
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif    

}

void dump_PerformNetworkScan (void *ptr)
{
    unpack_nas_PerformNetworkScan_t *pNetworkScan =
    (unpack_nas_PerformNetworkScan_t*) ptr;
    uint8_t count;

    if(ptr==NULL)
        return;
    
    if(pNetworkScan->p3GppNetworkInstanceSize)
    {
        if(pNetworkScan->p3GppNetworkInfoInstances)
        {
            printf("NetworkInfoInstances from network : %d\n",(int)*(pNetworkScan->p3GppNetworkInstanceSize));
            for(count = 0; count < *(pNetworkScan->p3GppNetworkInstanceSize); count++)
            {
                printf("\tMCC[%d] : %d\n",
                    count, pNetworkScan->p3GppNetworkInfoInstances[count].MCC);
                printf("\tMNC[%d] : %d\n",
                    count, pNetworkScan->p3GppNetworkInfoInstances[count].MNC);
                printf("\tInUse[%d] : %d\n",
                    count, pNetworkScan->p3GppNetworkInfoInstances[count].InUse);
                printf("\tRoaming[%d] : %d\n",
                    count, pNetworkScan->p3GppNetworkInfoInstances[count].Roaming);
                printf("\tForbidden[%d] : %d\n",
                    count, pNetworkScan->p3GppNetworkInfoInstances[count].Forbidden);
                printf("\tPreferred[%d] : %d\n",
                    count, pNetworkScan->p3GppNetworkInfoInstances[count].Preferred);
                printf("\tDesription[%d] : %s\n",
                    count, pNetworkScan->p3GppNetworkInfoInstances[count].Desription);
            }
        }
    }

    if(pNetworkScan->pRATInstanceSize)
    {
        if(pNetworkScan->pRATINstance)
        {
            printf("RATInstances from network : %d\n",(int)*(pNetworkScan->pRATInstanceSize));
            for(count = 0; count < *(pNetworkScan->pRATInstanceSize); count++)
            {
                printf("\tRAT-MCC[%d] : %d\n",
                    count, pNetworkScan->pRATINstance[count].MCC);
                printf("\tRAT-MNC[%d] : %d\n",
                    count, pNetworkScan->pRATINstance[count].MNC);
                printf("\tRAT-Technology[%d] : %d\n",
                    count, pNetworkScan->pRATINstance[count].RAT);
            }
        }
    }

    if(pNetworkScan->pPCSInstanceSize &&
            (*pNetworkScan->pPCSInstanceSize != NAS_MAX_NUM_NETWORKS)  )
    {
        if(pNetworkScan->pPCSInstance)
        {
            printf("PCSInfoInstances from network : %d\n",(int)*(pNetworkScan->pPCSInstanceSize));
            for(count = 0; count < *(pNetworkScan->pPCSInstanceSize); count++)
            {
                printf("\tMCC[%d] : %d\n",
                    count, pNetworkScan->pPCSInstance[count].MCC);
                printf("\tMNC[%d] : %d\n",
                    count, pNetworkScan->pPCSInstance[count].MNC);
                printf("\tPCS-Digit-included[%d] : %d\n",
                    count, pNetworkScan->pPCSInstance[count].includes_pcs_digit);
            }
        }
    }

    if(pNetworkScan->pScanResult)
    {
        printf("Scan Result : %u\n", 
            (uint32_t)*(pNetworkScan->pScanResult));
    }
#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 0;
    FILE *fp = NULL ;
    if(pNetworkScan->p3GppNetworkInstanceSize)
    {
        /* at least one network was searched, mcc and mnc should not equal to 0 */
        if(pNetworkScan->p3GppNetworkInfoInstances)
        {
            if ((*(pNetworkScan->p3GppNetworkInstanceSize) > 0) &&
                (pNetworkScan->p3GppNetworkInfoInstances[0].MCC > 0) &&
                (pNetworkScan->p3GppNetworkInfoInstances[0].MNC > 0))
            {
                is_matching = 1;
            }
        }
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_SLQSSwiGetLteCQI (void *ptr)
{
    unpack_nas_SLQSSwiGetLteCQI_t *pSwiGetLteCqi =
    (unpack_nas_SLQSSwiGetLteCQI_t*) ptr;

                printf( "Validity of cw0  : 0x%x\n", pSwiGetLteCqi->ValidityCW0 );
                printf( "CQI value of cw0 : 0x%x\n", pSwiGetLteCqi->CQIValueCW0 );
                printf( "Validity of cw1  : 0x%x\n", pSwiGetLteCqi->ValidityCW1 );
                printf( "CQI value of cw1 : 0x%x\n", pSwiGetLteCqi->CQIValueCW1 );    

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* validity should be either 0 or 1, CQI value range is 0~15 */
    if ((pSwiGetLteCqi->ValidityCW0 > 1) ||
        (pSwiGetLteCqi->CQIValueCW0 > 15) ||
        (pSwiGetLteCqi->ValidityCW1 > 1) ||
        (pSwiGetLteCqi->CQIValueCW1 > 15) )
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSNasSwiModemStatus (void *ptr)
{
    unpack_nas_SLQSNasSwiModemStatus_t *pSwiGetModSta =
    (unpack_nas_SLQSNasSwiModemStatus_t*) ptr;

    printf( "Modem Temperature : %d\n",pSwiGetModSta->commonInfo.temperature );
    printf( "Modem Mode        : 0x%02x\n",pSwiGetModSta->commonInfo.modemMode );
    printf( "System Mode       : 0x%02x\n",pSwiGetModSta->commonInfo.systemMode );
    printf( "IMS Reg State     : 0x%02x\n",pSwiGetModSta->commonInfo.imsRegState );
    printf( "PS Attach State   : 0x%02x\n",pSwiGetModSta->commonInfo.psState );

    if ( pSwiGetModSta->pLTEInfo )
    {
        printf( "Band              : 0x%02x\n",pSwiGetModSta->pLTEInfo->band );
        printf( "BandWidth         : 0x%02x\n",pSwiGetModSta->pLTEInfo->bandwidth );
        printf( "RX Channel        : 0x%02x\n",pSwiGetModSta->pLTEInfo->RXChan );
        printf( "TX Channel        : 0x%02x\n",pSwiGetModSta->pLTEInfo->TXChan );
        printf( "EMM State         : 0x%02x\n",pSwiGetModSta->pLTEInfo->emmState );
        printf( "EMM Sub State     : 0x%02x\n",pSwiGetModSta->pLTEInfo->emmSubState );
        printf( "EMM Conn State    : 0x%02x\n",pSwiGetModSta->pLTEInfo->emmConnState );
    }    

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* modem mode should not equal to 0 (power off), system mode should not be NO Service */
    if ((pSwiGetModSta->commonInfo.modemMode == 0) ||
        (pSwiGetModSta->commonInfo.systemMode == 0) ||
        (pSwiGetModSta->commonInfo.psState == 1) )
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_SLQSGetServingSystem (void *ptr)
{
    unpack_nas_SLQSGetServingSystem_t *pServingSystem =
    (unpack_nas_SLQSGetServingSystem_t*) ptr;
    uint8_t index, ctr;

    printf( "Registration state: 0x%x\n",         pServingSystem->ServingSystem.regState );
    printf( "CS Attach State: 0x%x\n",            pServingSystem->ServingSystem.csAttachState );
    printf( "PS Attach State: 0x%x\n",            pServingSystem->ServingSystem.psAttachState );
    printf( "Selected Network: 0x%x\n",           pServingSystem->ServingSystem.selNetwork );
    printf( "Number of Radio Interfaces: 0x%x\n", pServingSystem->ServingSystem.numRadioInterfaces );
    ctr = pServingSystem->ServingSystem.numRadioInterfaces;
    for( index = 0; index < ctr; index++ )
    {
        printf( "Radio Interface in use : 0x%x\n", pServingSystem->ServingSystem.radioInterface[index] );
    }
    printf( "\n" );
    printf( "Roaming Indicator value: 0x%x\n",     pServingSystem->RoamIndicatorVal );

    printf( "\n Data Service capability \n" );
    printf( "Data Capability List Length: 0x%x\n", pServingSystem->DataSrvCapabilities.dataCapabilitiesLen );
    ctr = pServingSystem->DataSrvCapabilities.dataCapabilitiesLen;
    for( index = 0; index < ctr; index++ )
    {
        printf( "Data Capability : 0x%x\n", pServingSystem->DataSrvCapabilities.dataCapabilities[index] );
    }

    printf( "\n Current PLMN Information \n" );
    printf( "Mobile Country Code: 0x%x\n",        pServingSystem->CurrentPLMN.MCC );
    printf( "Mobile Country Code: 0x%x\n",        pServingSystem->CurrentPLMN.MNC );
    printf( "Network Description Length: 0x%x\n", pServingSystem->CurrentPLMN.netDescrLength );
    ctr = pServingSystem->CurrentPLMN.netDescrLength;
    printf( "Network Description : ");
    for( index = 0; index < ctr; index++ )
    {
        printf( "%c",  (char) pServingSystem->CurrentPLMN.netDescr[index] );
    }
    printf( "\n");

    printf( "\n CDMA System ID \n" );
    printf( "System ID: 0x%x\n",                  pServingSystem->SystemID );
    printf( "Network ID: 0x%x\n",                 pServingSystem->NetworkID );

    printf( "\n CDMA Base Station Information \n" );
    printf( "Base ID: 0x%x\n",                    pServingSystem->BasestationID );
    printf( "Base Station latitude: 0x%x\n",     pServingSystem->BasestationLatitude );
    printf( "Base Station longitude: 0x%x\n",    pServingSystem->BasestationLongitude );

    printf( "\n Roaming Indicator List \n" );
    printf( "Number of Instances: 0x%x\n",        pServingSystem->RoamingIndicatorList.numInstances );
    ctr = pServingSystem->RoamingIndicatorList.numInstances;
    for( index = 0; index < ctr; index++ )
    {
        printf( "Radio Interface : 0x%x\n",   pServingSystem->RoamingIndicatorList.radioInterface[index] );
        printf( "Roaming Indicator : 0x%x\n", pServingSystem->RoamingIndicatorList.roamIndicator[index] );
    }

    printf( "\n" );
    printf( "Default Roaming Indicator: 0x%x\n",  pServingSystem->DefaultRoamInd );

    printf( "\n 3GPP2 Time Zone \n" );
    printf( "Leap Seconds: 0x%x\n",               pServingSystem->Gpp2TimeZone.leapSeconds );
    printf( "Local Time Offset: 0x%x\n",          pServingSystem->Gpp2TimeZone.localTimeOffset );
    printf( "Daylight Saving indicator: 0x%x\n",  pServingSystem->Gpp2TimeZone.daylightSavings );

    printf( "\n" );
    printf( "CDMA P_Rev in use : 0x%x\n",         pServingSystem->CDMA_P_Rev );

    printf( "3GPP Time Zone : 0x%x\n",            pServingSystem->GppTimeZone );

    printf( "3GPP NW Daylight Saving Adjustment : 0x%x\n", pServingSystem->GppNetworkDSTAdjustment );

    printf( "3GPP Location Area Code : 0x%x\n",    pServingSystem->Lac );

    printf( "Cell ID : 0x%x\n",                   pServingSystem->CellID );

    printf( "Concurrent Service Info : 0x%x\n",    pServingSystem->ConcSvcInfo );
    printf( "PRL Indicator : 0x%x\n",              pServingSystem->PRLInd );

    printf( "Dual Transfer Mode Ind : 0x%x\n",    pServingSystem->DTMInd );

    printf( "\n Detailed Service Information \n" );
    printf( "Service Status: 0x%x\n",              pServingSystem->DetailedSvcInfo.srvStatus );
    printf( "Service Capability: 0x%x\n",          pServingSystem->DetailedSvcInfo.srvCapability );
    printf( "HDR service status: 0x%x\n",         pServingSystem->DetailedSvcInfo.hdrSrvStatus );
    printf( "HDR hybrid information: 0x%x\n",     pServingSystem->DetailedSvcInfo.hdrHybrid );
    printf( "Forbidden system information: 0x%x\n", pServingSystem->DetailedSvcInfo.isSysForbidden );

    printf( "\n CDMA System Info Ext \n" );
    printf( "MCC: 0x%x\n",                         pServingSystem->CDMASystemInfoExt.MCC );
    printf( "IMSI_11_12: 0x%x\n",                  pServingSystem->CDMASystemInfoExt.imsi_11_12 );

    printf( "\n" );
    printf( "HDR Personality: 0x%x\n",             pServingSystem->HdrPersonality );
    printf( "TAC info for LTE: 0x%x\n",            pServingSystem->TrackAreaCode );

    printf( "\n Call Barring Status \n" );
    printf( "CS Bar Status: 0x%x\n",               pServingSystem->CallBarStatus.csBarStatus );
    printf( "PS Bar Status: 0x%x\n",               pServingSystem->CallBarStatus.psBarStatus );

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* the following items should not equal to 0 */
    if ((pServingSystem->ServingSystem.regState == 0) ||
        (pServingSystem->ServingSystem.csAttachState == 0) ||
        (pServingSystem->ServingSystem.psAttachState == 0) ||
        (pServingSystem->ServingSystem.selNetwork == 0) ||
        (pServingSystem->ServingSystem.numRadioInterfaces == 0))
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif

}

void dump_SLQSGetSignalStrength (void *ptr)
{
    unpack_nas_SLQSGetSignalStrength_t *pGetSigStren =
    (unpack_nas_SLQSGetSignalStrength_t*) ptr;
    uint8_t listLen, idx;

    printf( "\nSignal Strength Information:\n" );

    /* Display the current signal strength and radio inteface */
    printf( "Current Signal Strength : %d\n",
            pGetSigStren->rxSignalStrengthList[0].rxSignalStrength );
    printf( "Current Radio Interface : %d\n\n",
            pGetSigStren->rxSignalStrengthList[0].radioIf );

    /* Display Receive Signal Strength list */
    printf( "Receive Signal Strength List:\n" );
    listLen = pGetSigStren->rxSignalStrengthListLen;
    printf( "List's Length : %d\n", listLen );
    if( 0 != listLen )
    {             
        for( idx = 0; idx < listLen; idx++ )
        {
            printf( "Receive Signal Strength[%d]: %d\n",
                          idx,
                          pGetSigStren->rxSignalStrengthList[idx].rxSignalStrength );
            printf( "Radio Interface[%d]        : %d\n",
                          idx,
                          pGetSigStren->rxSignalStrengthList[idx].radioIf );
        }
    }
    printf( "\n" );
    idx = 0;
    /* Display ECIO list */
    printf( "ECIO List:\n" );
    listLen = pGetSigStren->ecioListLen;
    printf( "List's Length : %d\n", listLen );
    if( 0 != listLen )
    {
        for( idx = 0; idx < listLen; idx++ )
        {
            printf( "ECIO[%d]            : %d\n",
                          idx,
                          pGetSigStren->ecioList[idx].ecio );
            printf( "Radio Interface[%d] : %d\n",
                          idx,
                          pGetSigStren->ecioList[idx].radioIf );
        }
    }
    printf( "\n" );
    idx = 0;

    printf( "IO   : %d\n", pGetSigStren->Io );
    printf( "SINR : %d\n\n", pGetSigStren->sinr );

    /* Display Error Rate list */
    printf( "Error Rate List:\n" );
    listLen = pGetSigStren->errorRateListLen;
    printf( "List's Length : %d\n", listLen );
    if( 0 != listLen )
    {
        for( idx = 0; idx < listLen; idx++ )
        {
            printf( "Error Rate[%d]      : %d\n",
                          idx,
                          pGetSigStren->errorRateList[idx].errorRate );
            printf( "Radio Interface[%d] : %d\n",
                          idx,
                          pGetSigStren->errorRateList[idx].radioIf );
        }
    }
    printf( "\n" );

    /* Display RSRQ Information */
    printf( "RSRQ Information\n" );
    printf( "RSRQ            : %d\n",
                  pGetSigStren->rsrqInfo.rsrq );
    printf( "Radio Interface : %d\n",
                  pGetSigStren->rsrqInfo.radioIf );
    /* Display LTE SNR information */
    printf( "LTE SNR  : %d\n", pGetSigStren->ltesnr);
    /* Display LTE RSRP information*/
    printf( "LTE RSRP : %d\n\n", pGetSigStren->ltersrp);

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* the following items should not equal to 0 */
    if ((pGetSigStren->rxSignalStrengthList[0].rxSignalStrength == 0) ||
        (pGetSigStren->rxSignalStrengthList[0].radioIf == 0))
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
    
}

void dump_GetCDMANetworkParameters (void *ptr)
{
    unpack_nas_GetCDMANetworkParameters_t *pGetCDMANetPara =
    (unpack_nas_GetCDMANetworkParameters_t*) ptr;

    printf("SCI           : %d\n", pGetCDMANetPara->SCI);
    printf("SCM           : %d\n", pGetCDMANetPara->SCM);
    printf("RegHomeSID    : %d\n", pGetCDMANetPara->RegHomeSID);
    printf("RegForeignSID : %d\n", pGetCDMANetPara->RegForeignSID);
    printf("RegForeignNID : %d\n", pGetCDMANetPara->RegForeignNID);
    printf("CustomSCP     : %d\n", pGetCDMANetPara->CustomSCP);
    printf("Protocol      : %d\n", pGetCDMANetPara->Protocol);
    printf("Broadcast     : %d\n", pGetCDMANetPara->Broadcast);
    printf("Application   : %d\n", pGetCDMANetPara->Application);
    printf("Roaming       : %d\n", pGetCDMANetPara->Roaming);

#if DEBUG_LOG_TO_FILE
    FILE *fp;

    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_GetANAAAAuthenticationStatus (void *ptr)
{
    uint32_t *pStatus = (uint32_t*) ptr;

    printf("Status : %d\n", *pStatus );

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* status should be 0~2 */
    if ( *pStatus > 2) 
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_GetACCOLC (void *ptr)
{
    uint8_t *pAccolc = (uint8_t*) ptr;
    printf("ACCOLC : %d\n", *pAccolc );

#if DEBUG_LOG_TO_FILE
    uint8_t is_matching = 1;
    FILE *fp;

    /* status should be 0~15 */
    if ( *pAccolc > 15) 
    {
        is_matching = 0;
    }
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n", ((is_matching ==1) ? "Correct": "Wrong"));
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SetACCOLC (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSNasConfigSigInfo2 (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSGetPLMNName(void *ptr)
{
    unpack_nas_SLQSGetPLMNName_t *result =
            (unpack_nas_SLQSGetPLMNName_t*) ptr;
            UNUSEDPARAM(result);

        printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
        FILE *fp;
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-10s\n",  "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
#endif
    printf("%s> short name: %s\n", __func__, result->shortName);
    printf("%s> long name: %s\n", __func__, result->longName);


}

void dump_GetNetworkPreference(void *ptr)
{
    unpack_nas_GetNetworkPreference_t *result =
            (unpack_nas_GetNetworkPreference_t*) ptr;

        printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
        FILE *fp;
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-10s\n",  "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
#endif

    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tActiveTechPref: %d\n", result->ActiveTechPref);
    printf("\tDuration: %d\n", result->Duration);
    printf("\tPersistentTechPref: %d\n", result->PersistentTechPref);

}

void dump_SetNetworkPreference(void *ptr)
{
    unpack_nas_SetNetworkPreference_t *result =
            (unpack_nas_SetNetworkPreference_t*) ptr;

        printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
        FILE *fp;
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-10s\n",  "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
#endif

    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_SlqsGetLTECphyCAInfo(void *ptr)
{
    unpack_nas_SlqsGetLTECphyCAInfo_t *result =
            (unpack_nas_SlqsGetLTECphyCAInfo_t*) ptr;

        printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
        FILE *fp;
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-10s\n",  "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
#endif
    if(result->LTECphyCaInfo.PhyCaAggScellIndType.TlvPresent)
    {
        printf("Scell Indicator Type:\n");
        printf("PCI: %02X\n",result->LTECphyCaInfo.PhyCaAggScellIndType.pci);
        printf("Frequency: %d\n",result->LTECphyCaInfo.PhyCaAggScellIndType.freq);
        printf("Scell State: %02X\n",result->LTECphyCaInfo.PhyCaAggScellIndType.scell_state);
    }
    
    if(result->LTECphyCaInfo.PhyCaAggScellDlBw.TlvPresent)
        printf("Downlink Bandwidth for Scell: %02X\n",result->LTECphyCaInfo.PhyCaAggScellDlBw.dl_bw_value);

    if(result->LTECphyCaInfo.PhyCaAggScellInfo.TlvPresent)
    {
        printf("Scell Info:\n");
        printf("\tDownlink Bandwidth: %02X\n",result->LTECphyCaInfo.PhyCaAggScellInfo.dl_bw_value);
        printf("\tFrequency: %d\n",result->LTECphyCaInfo.PhyCaAggScellInfo.freq);
        printf("\tLTE Band Value: %d\n",result->LTECphyCaInfo.PhyCaAggScellInfo.iLTEbandValue);
        printf("\tPCI: %d\n",result->LTECphyCaInfo.PhyCaAggScellInfo.pci);
        printf("\tCell State: %d\n",result->LTECphyCaInfo.PhyCaAggScellInfo.scell_state);
    }

    if(result->LTECphyCaInfo.PhyCaAggPcellInfo.TlvPresent)
    {
        printf("Pcell Info\n");
        printf("\tDownlink Bandwidth: %02X\n",result->LTECphyCaInfo.PhyCaAggPcellInfo.dl_bw_value);
        printf("\trequency: %d\n",result->LTECphyCaInfo.PhyCaAggPcellInfo.freq);
        printf("\tLTE Band Value: %d\n",result->LTECphyCaInfo.PhyCaAggPcellInfo.iLTEbandValue);
        printf("\tPCI: %d\n",result->LTECphyCaInfo.PhyCaAggPcellInfo.pci);
    }

    if(result->LTECphyCaInfo.PhyCaAggScellIndex.TlvPresent)
    {
        printf("Scell Index : %d\n",(int)result->LTECphyCaInfo.PhyCaAggScellIndex.scell_idx);
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_SLQSInitiateNetworkRegistration (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSNasSwiOTAMessageCallback (void *ptr)
{
    UNUSEDPARAM(ptr);
    printf("%s Data\n",__FUNCTION__);
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-10s\n",  "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#endif
}

void dump_SLQSNasGetCellLocationInfo(void *ptr)
{
    unpack_nas_SLQSNasGetCellLocationInfo_t *result =
            (unpack_nas_SLQSNasGetCellLocationInfo_t*) ptr;
    uint16_t lC=0, lC1=0;
        printf("%s Data\n",__FUNCTION__);

        if(result->pGERANInfo)
        {
            printf( "\nGERAN Information \n" );
            nas_GERANInfo *temp = result->pGERANInfo;
            printf( "Cell Id   : %"PRIx32" \n",temp->cellID );
            printf( "PLMN info : " );
            for (lC=0;lC<PLMN_LENGTH;lC++)
            {
                printf( "%x ",temp->plmn[lC] );
            }
            printf( "\n" );
            printf( "LAC       : %x \n",temp->lac );
            printf( "ARFCN     : %x \n",temp->arfcn );
            printf( "BSIC      : %x \n",temp->bsic );
            printf( "Timing Adv: %"PRIx32" \n",temp->timingAdvance );
            printf( "RX-lev    : %x \n",temp->rxLev );
            printf( "No. of sets of following info : %x \n",temp->nmrInst );
            for (lC=0;lC<temp->nmrInst;lC++)
            {
                nas_nmrCellInfo *temp1 = &temp->insNmrCellInfo[lC];
                printf( "\tNMR Cell %d Information \n",lC+1 );
                printf( "\tNMR Cell Id   : %"PRIx32" \n",temp1->nmrCellID );
                printf( "\tNMR PLMN info : " );
                for (lC1=0;lC1<PLMN_LENGTH;lC1++)
                {
                    printf( "%x ",temp1->nmrPlmn[lC1] );
                }
                printf( "\n" );
                printf( "\tNMR LAC       : %x \n",temp1->nmrLac );
                printf( "\tNMR ARFCN     : %x \n",temp1->nmrArfcn );
                printf( "\tNMR BSIC      : %x \n",temp1->nmrBsic );
                printf( "\tNMR RX-lev    : %x \n",temp1->nmrRxLev );
            }
        }
        if ( result->pUMTSInfo )
        {
            printf("\nUMTS Information \n" );
            nas_UMTSInfo *temp = result->pUMTSInfo;
            printf( "Cell Id   : %x \n",temp->cellID );
            printf( "PLMN info : " );
            for (lC=0;lC<PLMN_LENGTH;lC++)
            {
                printf( "%x ",temp->plmn[lC] );
            }
            printf( "\n" );
            printf( "LAC       : %x \n",temp->lac );
            printf( "UARFCN    : %x \n",temp->uarfcn );
            printf( "PSC       : %x \n",temp->psc );
            printf( "RSCP      : %d \n",temp->rscp );
            printf( "ECIO      : %d \n",temp->ecio );
            printf( "No. of sets of umts instance : %x \n",temp->umtsInst );
            for (lC=0;lC<temp->umtsInst;lC++)
            {
                nas_UMTSinstInfo *temp1 = &temp->UMTSInstInfo[lC];
                printf( "\tUMTS Instance %d Information \n",lC+1 );
                printf( "\tUMTS UARFCN  : %x \n",temp1->umtsUarfcn );
                printf( "\tUMTS PSC     : %x \n",temp1->umtsPsc);
                printf( "\tUMTS RSCP    : %d \n",temp1->umtsRscp );
                printf( "\tUMTS ECIO    : %d \n",temp1->umtsEcio );
            }
            printf( "No. of sets of geran instance : %x \n",temp->geranInst );
            for (lC=0;lC<temp->geranInst;lC++)
            {
                nas_geranInstInfo *temp1 = &temp->GeranInstInfo[lC];
                printf( "\tGERAN Instance %d Information \n",lC+1 );
                printf( "\tGERAN ARFCN   : %x \n",temp1->geranArfcn );
                printf( "\tGERAN BSIC NCC: %x \n",temp1->geranBsicNcc);
                printf( "\tGERAN BSIC BCC: %x \n",temp1->geranBsicBcc );
                printf( "\tGERAN RSSI    : %d \n",temp1->geranRssi );
            }
        }
        if ( result->pCDMAInfo )
        {
             printf("\nCDMA Information \n" );
             nas_CDMAInfo *temp = result->pCDMAInfo;
             printf("System Id  : %x \n",temp->sid );
             printf("Network Id : %x \n",temp->nid );
             printf("Base Id    : %x \n",temp->baseId );
             printf("Reference PN: %x \n",temp->refpn );
             printf("Base Lat   : %"PRIx32" \n",temp->baseLat );
             printf("Base Long  : %"PRIx32" \n",temp->baseLong );
        }
        if ( result->pLTEInfoIntrafreq )
        {
            printf("\nLTE Information - INtra Frequency \n" );
            nas_LTEInfoIntrafreq *temp = result->pLTEInfoIntrafreq;
            printf( "UE in Idle    : %x \n",temp->ueInIdle );
            printf( "PLMN info     : " );
            for (lC=0;lC<PLMN_LENGTH;lC++)
            {
                printf( "%x ",temp->plmn[lC] );
            }
            printf( "\n" );
            printf( "TAC                   : %x \n",temp->tac );
            printf( "Global Cell Id        : %"PRIx32" \n",temp->globalCellId );
            printf( "EARFCN                : %x \n",temp->earfcn );
            printf( "Serving Cell Id       : %x \n",temp->servingCellId );
            printf( "Cell Resel Priority   : %x \n",temp->cellReselPriority );
            printf( "Non-Intra Search      : %x \n",temp->sNonIntraSearch );
            printf( "Serving Cell Threshold: %x \n",temp->threshServingLow );
            printf( "Intra Search          : %x \n",temp->sIntraSearch );
            printf( "No. of sets of following info : %x \n",temp->cellsLen );
            for (lC=0;lC<temp->cellsLen;lC++)
            {
                nas_cellParams *temp1 = &temp->CellParams[lC];
                printf( "\tCell Number %d Information \n",lC+1 );
                printf( "\tPhysical Cell Id: %x \n",temp1->pci );
                printf( "\tRSRQ            : %d \n",temp1->rsrq );
                printf( "\tRSRP            : %d \n",temp1->rsrp );
                printf( "\tRSSI            : %d \n",temp1->rssi );
                printf( "\tSRX-lev         : %d \n",temp1->srxlev );
            }
        }
        if ( result->pLTEInfoInterfreq )
        {
            printf("\nLTE Information - Inter Frequency \n" );
            nas_LTEInfoInterfreq *temp = result->pLTEInfoInterfreq;
            printf( "UE in Idle    : %x \n",temp->ueInIdle );
            printf( "Frequency Len : %d \n",temp->freqsLen );
            for (lC=0;lC<temp->freqsLen;lC++)
            {
                nas_infoInterFreq *t = &(temp->InfoInterfreq[lC]);
                printf( "Frequency Number %d Information \n",lC+1 );
                printf( "EARFCN            : %d \n",t->earfcn );
                printf( "Thresh X Low      : %d \n",t->threshXLow );
                printf( "Thresh X High     : %d \n",t->threshXHigh );
                printf( "Cell Resel Pty    : %d \n",t->cell_resel_priority );
                printf( "Cells Length      : %d \n",t->cells_len );
                for (lC1=0;lC1<t->cells_len;lC1++)
                {
                    nas_cellParams *temp1 = &t->cellInterFreqParams[lC1];
                    printf( "Cell Number %d Information \n",lC1+1 );
                    printf( "\tPhysical Cell Id: %x \n",temp1->pci );
                    printf( "\tRSRQ            : %d \n",temp1->rsrq );
                    printf( "\tRSRP            : %d \n",temp1->rsrp );
                    printf( "\tRSSI            : %d \n",temp1->rssi );
                    printf( "\tSRX-lev         : %d \n",temp1->srxlev );
                }
            }
        }
        if ( result->pLTEInfoNeighboringGSM )
        {
            printf("\nLTE Information - Neighboring GSM \n" );
            nas_LTEInfoNeighboringGSM *temp = result->pLTEInfoNeighboringGSM;
            printf( "UE in Idle    : %x \n",temp->ueInIdle );
            printf( "Frequency Len : %d \n",temp->freqsLen );
            for (lC=0;lC<temp->freqsLen;lC++)
            {
                nas_lteGsmCellInfo *t = &(temp->LteGsmCellInfo[lC]);
                printf( "\tFrequency Number %d Information \n",lC+1 );
                printf( "\tCell Resel Pty    : %d \n",t->cellReselPriority );
                printf( "\tThresh GSM High   : %d \n",t->threshGsmHigh );
                printf( "\tThresh GSM Low    : %d \n",t->threshGsmLow );
                printf( "\tNCC Permitted     : %x \n",t->nccPermitted );
                printf( "\tCells Length      : %d \n",t->cells_len );
                for (lC1=0;lC1<t->cells_len;lC1++)
                {
                    nas_gsmCellInfo *temp1 = &t->GsmCellInfo[lC1];
                    printf( "\tGSM Cell Number %d Information \n",lC1+1 );
                    printf( "\t\tARFCN         : %d \n",temp1->arfcn );
                    printf( "\t\tBand_1900     : %x \n",temp1->band1900 );
                    printf( "\t\tCell ID Valid : %x \n",temp1->cellIdValid );
                    printf( "\t\tBSIC ID       : %x \n",temp1->bsicId );
                    printf( "\t\tRSSI          : %d \n",temp1->rssi );
                    printf( "\t\tSRX-lev       : %d \n",temp1->srxlev );
                }
            }
        }
        if ( result->pLTEInfoNeighboringWCDMA )
        {
            printf("\nLTE Information - Neighboring WCDMA \n" );
            nas_LTEInfoNeighboringWCDMA *temp = result->pLTEInfoNeighboringWCDMA;
            printf( "UE in Idle    : %x \n",temp->ueInIdle );
            printf( "Frequency Len : %d \n",temp->freqsLen );
            for (lC=0;lC<temp->freqsLen;lC++)
            {
                nas_lteWcdmaCellInfo *t = &(temp->LTEWCDMACellInfo[lC]);
                printf( "\tFrequency Number %d Information \n",lC+1 );
                printf( "\tUARFCN          : %d \n",t->uarfcn );
                printf( "\tCell Resel Pty  : %d \n",t->cellReselPriority );
                printf( "\tThresh X High   : %d \n",t->threshXhigh );
                printf( "\tThresh X Low    : %d \n",t->threshXlow );
                printf( "\tCells Length    : %d \n",t->cellsLen );
                for (lC1=0;lC1<t->cellsLen;lC1++)
                {
                    nas_wcdmaCellInfo *temp1 = &t->WCDMACellInfo[lC1];
                    printf( "\tWCDMA Cell Number %d Information \n",lC1+1 );
                    printf( "\t\tPSC        : %d \n",temp1->psc );
                    printf( "\t\tCPICH_RSCP : %d \n",temp1->cpich_rscp );
                    printf( "\t\tCPICH_ECNO : %d \n",temp1->cpich_ecno );
                    printf( "\t\tSRX-lev    : %d \n",temp1->srxlev );
                }
            }
        }
        if ( result->pUMTSCellID )
        {
             printf("\nUMTS Cell ID \n" );
             printf( "UMTS Cell ID  : 0x%"PRIx32" \n", *result->pUMTSCellID );
        }
        if ( result->pWCDMAInfoLTENeighborCell )
        {
            printf("\nWCDMA Information - LTE Neighboring cell info \n" );
            nas_WCDMAInfoLTENeighborCell *temp = result->pWCDMAInfoLTENeighborCell;
            printf( "WCDMA RRC State            : %"PRIx32" \n",temp->wcdmaRRCState );
            printf( "UMTS LTE neighbor cell Len : %x \n",temp->umtsLTENbrCellLen );
            for (lC=0;lC<temp->umtsLTENbrCellLen;lC++)
            {
                nas_umtsLTENbrCell *t = &(temp->UMTSLTENbrCell[lC]);
                printf( "\tNumber %d Information \n",lC+1 );
                printf( "\tEARFCN           : %d \n",t->earfcn );
                printf( "\tPhysical Cell ID : %d \n",t->pci );
                printf( "\tRSRP             : %f \n",(float)t->rsrp );
                printf( "\tRSRQ             : %f \n",(float)t->rsrq );
                printf( "\tSRX Lev          : %d \n",t->srxlev );
                printf( "\tCell is TDD      : %d \n",t->cellIsTDD );
            }
        }

#if DEBUG_LOG_TO_FILE
        FILE *fp;
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-10s\n",  "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
#endif
}

testitem_t nastotest[] = {
    {
        (pack_func) pack_nas_SLQSGetPLMNName, "pack_nas_SLQSGetPLMNName",
        &tpack_nas_SLQSGetPLMNName_t,
        (unpack_func) unpack_nas_SLQSGetPLMNName, "unpack_nas_SLQSGetPLMNName",
        &tunpack_nas_SLQSGetPLMNName_t, dump_SLQSGetPLMNName
    },
    {
        (pack_func) pack_nas_GetNetworkPreference, "pack_nas_GetNetworkPreference",
        NULL,
        (unpack_func) unpack_nas_GetNetworkPreference, "unpack_nas_GetNetworkPreference",
        &GetNetworkPreferenceResp, dump_GetNetworkPreference
    },
    {
        (pack_func) pack_nas_SetNetworkPreference, "pack_nas_SetNetworkPreference",
        &SetNetworkPreferenceReq,
        (unpack_func) unpack_nas_SetNetworkPreference, "unpack_nas_SetNetworkPreference",
        &SetNetworkPreferenceResp, dump_SetNetworkPreference
    },
    {
        (pack_func) pack_nas_SLQSNasIndicationRegisterExt, "pack_nas_SLQSNasIndicationRegisterExt",
        &nasIndicationRegisterExt,
        (unpack_func) unpack_nas_SLQSNasIndicationRegisterExt, "unpack_nas_SLQSNasIndicationRegisterExt",
        NULL, dump_SLQSNasIndicationRegisterExt
    },
    {
        (pack_func) pack_nas_SLQSNasSwiOTAMessageCallback, "pack_nas_SLQSNasSwiOTAMessageCallback",
        &tpack_nas_SLQSNasSwiOTAMessageCallback,
        (unpack_func) unpack_nas_SLQSNasSwiOTAMessageCallback, "unpack_nas_SLQSNasSwiOTAMessageCallback",
        NULL, dump_SLQSNasSwiOTAMessageCallback
    },
    {
        (pack_func) pack_nas_SLQSSetSignalStrengthsCallback, "pack_nas_SLQSSetSignalStrengthsCallback",
        &setSigStrengthCallback,
        (unpack_func) unpack_nas_SLQSSetSignalStrengthsCallback, "unpack_nas_SLQSSetSignalStrengthsCallback",
        NULL, dump_SLQSSetSignalStrengthsCallback
    },
    {
        (pack_func) pack_nas_SetRFInfoCallback, "pack_nas_SetRFInfoCallback",
        &setRFInfoCallback,
        (unpack_func) unpack_nas_SetRFInfoCallback, "unpack_nas_SetRFInfoCallback",
        NULL, dump_SetRFInfoCallback
    },
    {
        (pack_func) pack_nas_SetLURejectCallback, "pack_nas_SetLURejectCallback",
        &setRFInfoCallback,
        (unpack_func) unpack_nas_SetLURejectCallback, "unpack_nas_SetLURejectCallback",
        NULL, dump_SetLURejectCallback
    },
    {
        (pack_func) pack_nas_GetHomeNetwork, "pack_nas_GetHomeNetwork",
        NULL,
        (unpack_func) unpack_nas_GetHomeNetwork, "unpack_nas_GetHomeNetwork",
        &homenw, dump_GetHomeNetwork
    },
    {
        (pack_func) pack_nas_GetServingNetwork, "pack_nas_GetServingNetwork",
        NULL,
        (unpack_func) unpack_nas_GetServingNetwork, "unpack_nas_GetServingNetwork",
        &getServingNW, dump_GetServingNetwork
    },
    {
        (pack_func) pack_nas_GetServingNetworkCapabilities, "pack_nas_GetServingNetworkCapabilities",
        NULL,
        (unpack_func) unpack_nas_GetServingNetworkCapabilities, "unpack_nas_GetServingNetworkCapabilities",
        &getServingNwCap, dump_GetServingNetworkCapabilities
    },

    {
        (pack_func) pack_nas_GetRFInfo, "pack_nas_GetRFInfo",
        NULL,
        (unpack_func) unpack_nas_GetRFInfo, "unpack_nas_GetRFInfo",
        &rfinfo, dump_GetRFInfo
    },
    {
        (pack_func) pack_nas_SLQSNasGetSigInfo, "pack_nas_SLQSNasGetSigInfo",
        NULL,
        (unpack_func) unpack_nas_SLQSNasGetSigInfo, "unpack_nas_SLQSNasGetSigInfo",
        &siginfo, dump_SLQSNasGetSigInfo
    },
    {
        (pack_func) pack_nas_SLQSSetSysSelectionPref, "pack_nas_SLQSSetSysSelectionPref",
        &setSysSelPref,
        (unpack_func) unpack_nas_SLQSSetSysSelectionPref, "unpack_nas_SLQSSetSysSelectionPref",
        NULL, dump_SLQSSetSysSelectionPref
    },
    {
        (pack_func) pack_nas_SLQSGetSysSelectionPref, "pack_nas_SLQSGetSysSelectionPref",
        NULL,
        (unpack_func) unpack_nas_SLQSGetSysSelectionPref, "unpack_nas_SLQSGetSysSelectionPref",
        &sysSelPref, dump_SLQSGetSysSelectionPref
    },
    {
        (pack_func) pack_nas_PerformNetworkScan, "pack_nas_PerformNetworkScan",
        NULL,
        (unpack_func) unpack_nas_PerformNetworkScan, "unpack_nas_PerformNetworkScan",
        &performNwScan, dump_PerformNetworkScan
    },
    {
        (pack_func) pack_nas_SLQSSwiGetLteCQI, "pack_nas_SLQSSwiGetLteCQI",
        NULL,
        (unpack_func) unpack_nas_SLQSSwiGetLteCQI, "unpack_nas_SLQSSwiGetLteCQI",
        &swiGetLTECQI, dump_SLQSSwiGetLteCQI
    },
    {
        (pack_func) pack_nas_SLQSNasSwiModemStatus, "pack_nas_SLQSNasSwiModemStatus",
        NULL,
        (unpack_func) unpack_nas_SLQSNasSwiModemStatus, "unpack_nas_SLQSNasSwiModemStatus",
        &swiGetModemStatus, dump_SLQSNasSwiModemStatus
    },
    {
        (pack_func) pack_nas_SLQSGetServingSystem, "pack_nas_SLQSGetServingSystem",
        NULL,
        (unpack_func) unpack_nas_SLQSGetServingSystem, "unpack_nas_SLQSGetServingSystem",
        &getServingSystem, dump_SLQSGetServingSystem
    },
    {
        (pack_func) pack_nas_SLQSGetSignalStrength, "pack_nas_SLQSGetSignalStrength",
        &signalStrenghMask,
        (unpack_func) unpack_nas_SLQSGetSignalStrength, "unpack_nas_SLQSGetSignalStrength",
        &getSignalStrength, dump_SLQSGetSignalStrength
    },
    {
        (pack_func) pack_nas_GetCDMANetworkParameters, "pack_nas_GetCDMANetworkParameters",
        NULL,
        (unpack_func) unpack_nas_GetCDMANetworkParameters, "unpack_nas_GetCDMANetworkParameters",
        &getCDMANetworkParameters, dump_GetCDMANetworkParameters
    },
    {
        (pack_func) pack_nas_GetANAAAAuthenticationStatus, "pack_nas_GetANAAAAuthenticationStatus",
        NULL,
        (unpack_func) unpack_nas_GetANAAAAuthenticationStatus, "unpack_nas_GetANAAAAuthenticationStatus",
        &getANAAAStatus, dump_GetANAAAAuthenticationStatus
    },
    {
        (pack_func) pack_nas_SetACCOLC, "pack_nas_SetACCOLC",
        &setACCOLC,
        (unpack_func) unpack_nas_SetACCOLC, "unpack_nas_SetACCOLC",
        NULL, dump_SetACCOLC
    },
    {
        (pack_func) pack_nas_GetACCOLC, "pack_nas_GetACCOLC",
        NULL,
        (unpack_func) unpack_nas_GetACCOLC, "unpack_nas_GetACCOLC",
        &getACCOLC, dump_GetACCOLC
    },
    {
        (pack_func) pack_nas_SLQSNasConfigSigInfo2, "pack_nas_SLQSNasConfigSigInfo2",
        &nasConfigSigInfo2,
        (unpack_func) unpack_nas_SLQSNasConfigSigInfo2, "unpack_nas_SLQSNasConfigSigInfo2",
        NULL, dump_SLQSNasConfigSigInfo2
    },
    {
        (pack_func) pack_nas_SlqsGetLTECphyCAInfo, "pack_nas_SlqsGetLTECphyCAInfo",
        NULL,
        (unpack_func) unpack_nas_SlqsGetLTECphyCAInfo, "unpack_nas_SlqsGetLTECphyCAInfo",
        &SlqsGetLTECphyCAInfo, dump_SlqsGetLTECphyCAInfo
    },
    {
        (pack_func) pack_nas_SLQSInitiateNetworkRegistration, "pack_nas_SLQSInitiateNetworkRegistration",
        &nasInitiateNetworkRegistration,
        (unpack_func) unpack_nas_SLQSInitiateNetworkRegistration, "unpack_nas_SLQSInitiateNetworkRegistration",
        NULL, dump_SLQSInitiateNetworkRegistration
    },
    {
        (pack_func) pack_nas_SLQSNasGetCellLocationInfo, "pack_nas_SLQSNasGetCellLocationInfo",
        NULL,
        (unpack_func) unpack_nas_SLQSNasGetCellLocationInfo, "unpack_nas_SLQSNasGetCellLocationInfo",
        &nasgetcelllocinfo, dump_SLQSNasGetCellLocationInfo
    },
};

void displayNasSigInfo (unpack_nas_SLQSNasSigInfoCallback_t *pInfo)
{
        printf( "NAS Signal Strength Information From SLQSNasSigInfoCallBack\n");
        if ( pInfo->pCDMASigInfo )
        {
            printf( "RSSI(CDMA) : %d\n",pInfo->pCDMASigInfo->rssi );
            printf( "ECIO(CDMA) : %d\n",pInfo->pCDMASigInfo->ecio );
        }
        if ( pInfo->pHDRSigInfo )
        {
            printf( "RSSI(HDR) : %d\n",pInfo->pHDRSigInfo->rssi );
            printf( "ECIO(HDR) : %d\n",pInfo->pHDRSigInfo->ecio );
            printf( "SINR(HDR) : %d\n",pInfo->pHDRSigInfo->sinr );
            printf( "IO(HDR)   : %d\n",pInfo->pHDRSigInfo->io );
        }
        if ( pInfo->pGSMSigInfo )
        {
            printf( "GSM Signal Info(GSM)      : %d\n",*pInfo->pGSMSigInfo );
        }
        if ( pInfo->pWCDMASigInfo )
        {
            printf( "RSSI(WCDMA)  : %d\n",pInfo->pWCDMASigInfo->rssi );
            printf( "ECIO(WCDMA)  : %d\n",pInfo->pWCDMASigInfo->ecio );
        }
        if ( pInfo->pLTESigInfo )
        {
            printf( "RSSI(LTE)  : %d\n",pInfo->pLTESigInfo->rssi );
            printf( "RSRQ(LTE)  : %d\n",pInfo->pLTESigInfo->rsrq );
            printf( "RSRP(LTE)  : %d\n",pInfo->pLTESigInfo->rsrp );
            printf( "SNR(LTE)   : %d\n",pInfo->pLTESigInfo->snr );
        }
        if ( pInfo->pRscp)
        {
            printf( "RSCP(TDSCDMA)  : %d\n",*pInfo->pRscp );
        }
        if ( pInfo->pTDSCDMASigInfoExt )
        {
            printf( "RSSI(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->rssi );
            printf( "RSCP(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->rscp );
            printf( "ECIO(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->ecio );
            printf( "SINR(TDSCDMAEXT)  : %f\n",pInfo->pTDSCDMASigInfoExt->sinr );
        }
}

void displaySysInfoCommonCB( nas_sysInfoCommon *pSys )
{
    printf( "Service Domain Valid   : %x\n",pSys->srvDomainValid );
    printf( "Service Domain         : %x\n",pSys->srvDomain );
    printf( "Service Capability Valid: %x\n",pSys->srvCapabilityValid );
    printf( "Service Capability     : %x\n",pSys->srvCapability );
    printf( "Roam Status Valid      : %x\n",pSys->roamStatusValid );
    printf( "Roam Status            : %x\n",pSys->roamStatus );
    printf( "Forbidden System Valid : %x\n",pSys->isSysForbiddenValid );
    printf( "Is Forbidden System    : %x\n",pSys->isSysForbiddenValid );
}

void displayNasSysInfo(unpack_nas_SLQSSysInfoCallback_t *pInfo)
{
        uint8_t i;

        printf( "NAS System Information From SLQSNasSysInfoCallBack\n");
        if ( pInfo->pCDMASrvStatusInfo )
        {
            printf( "Service Status(CDMA) : %x\n",pInfo->pCDMASrvStatusInfo->srvStatus );
            printf( "Is Preferred(CDMA)   : %x\n",pInfo->pCDMASrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pHDRSrvStatusInfo )
        {
            printf( "Service Status(HDR) : %x\n",pInfo->pHDRSrvStatusInfo->srvStatus );
            printf( "Is Preferred(HDR)   : %x\n",pInfo->pHDRSrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pGSMSrvStatusInfo )
        {
            printf( "Service Status(GSM)      : %x\n",pInfo->pGSMSrvStatusInfo->srvStatus );
            printf( "True Service Status(GSM) : %x\n",pInfo->pGSMSrvStatusInfo->trueSrvStatus );
            printf( "Is Preferred(GSM)        : %x\n",pInfo->pGSMSrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pWCDMASrvStatusInfo )
        {
            printf( "Service Status(WCDMA)     : %x\n",pInfo->pWCDMASrvStatusInfo->srvStatus );
            printf( "True Service Status(WCDMA): %x\n",pInfo->pWCDMASrvStatusInfo->trueSrvStatus );
            printf( "Is Preferred(WCDMA)       : %x\n",pInfo->pWCDMASrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pLTESrvStatusInfo )
        {
            printf( "Service Status(LTE)      : %x\n",pInfo->pLTESrvStatusInfo->srvStatus );
            printf( "True Service Status(LTE) : %x\n",pInfo->pLTESrvStatusInfo->trueSrvStatus );
            printf( "Is Preferred(LTE)        : %x\n",pInfo->pLTESrvStatusInfo->isPrefDataPath );
        }
        if ( pInfo->pCDMASysInfo )
        {
            printf( "\nCDMA SYSTEM INFORMATION ----\n");
            nas_CDMASysInfo *t = pInfo->pCDMASysInfo;
            displaySysInfoCommonCB( &t->sysInfoCDMA );
            printf( "System PRL Valid    : %x\n",t->isSysPrlMatchValid );
            printf( "System PRL          : %x\n",t->isSysPrlMatch );
            printf( "P_Rev Valid         : %x\n",t->pRevInUseValid );
            printf( "P_Rev In Use        : %x\n",t->pRevInUse );
            printf( "BS P_Rev Valid      : %x\n",t->bsPRevValid );
            printf( "P_Rev In Use        : %x\n",t->bsPRev );
            printf( "CCS_supp Valid      : %x\n",t->ccsSupportedValid );
            printf( "CCS_supp            : %x\n",t->ccsSupported );
            printf( "System Id           : %x\n",t->systemID );
            printf( "Network Id          : %x\n",t->networkID );
            printf( "BS Info Valid       : %x\n",t->bsInfoValid );
            printf( "Base ID             : %x\n",t->baseId );
            printf( "Base Latitude       : %x\n",t->baseLat );
            printf( "Base Longitude      : %x\n",t->baseLong );
            printf( "Packet Zone Valid   : %x\n",t->packetZoneValid );
            printf( "Packet Zone         : %x\n",t->packetZone );
            printf( "Network ID Valid    : %x\n",t->networkIdValid );
            printf( "MCC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MCC[i] );
            }
            printf( "\n" );
            printf( "MNC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MNC[i] );
            }
            printf( "\n" );
        }

        if ( pInfo->pHDRSysInfo )
        {
            printf( "\nHDR SYSTEM INFORMATION ----\n");
            nas_HDRSysInfo *t = pInfo->pHDRSysInfo;
            displaySysInfoCommonCB( &t->sysInfoHDR );
            printf( "System PRL Valid    : %x\n",t->isSysPrlMatchValid );
            printf( "System PRL          : %x\n",t->isSysPrlMatch );
            printf( "Personality Valid   : %x\n",t->hdrPersonalityValid );
            printf( "Personality         : %x\n",t->hdrPersonality );
            printf( "Active Prot Valid   : %x\n",t->hdrActiveProtValid );
            printf( "Active Protocol     : %x\n",t->hdrActiveProt );
            printf( "IS-856 Sys Valid    : %x\n",t->is856SysIdValid );
            printf( "IS-856 system ID    : " );
            for ( i = 0 ; i < 16 ; i++ )
            {
                printf( "%x ",t->is856SysId[i] );
            }
            printf( "\n" );
        }
        if ( pInfo->pGSMSysInfo )
        {
            printf( "\nGSM SYSTEM INFORMATION ----\n");
            nas_GSMSysInfo *t = pInfo->pGSMSysInfo;
            displaySysInfoCommonCB( &t->sysInfoGSM );
            printf( "LAC Valid           : %x\n",t->lacValid );
            printf( "LAC                 : %x\n",t->lac );
            printf( "Cell ID Valid       : %x\n",t->cellIdValid );
            printf( "Cell ID             : %x\n",t->cellId );
            printf( "Reg Rej Info Valid  : %x\n",t->regRejectInfoValid );
            printf( "Reject Srvc Domain  : %x\n",t->rejectSrvDomain );
            printf( "Reject Cause        : %x\n",t->rejCause );
            printf( "Network Id Valid    : %x\n",t->networkIdValid );
            printf( "MCC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MCC[i] );
            }
            printf( "\n" );
            printf( "MNC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MNC[i] );
            }
            printf( "\n" );
            printf( "EGPRS Support Valid : %x\n",t->egprsSuppValid );
            printf( "EGPRS Support       : %x\n",t->egprsSupp );
            printf( "DTM Support Valid   : %x\n",t->dtmSuppValid );
            printf( "DTM Support         : %x\n",t->dtmSupp );
        }
        if ( pInfo->pWCDMASysInfo )
        {
            printf( "\nWCDMA SYSTEM INFORMATION ----\n");
            nas_WCDMASysInfo *t = pInfo->pWCDMASysInfo;
            displaySysInfoCommonCB( &t->sysInfoWCDMA );
            printf( "LAC Valid           : %x\n",t->lacValid );
            printf( "LAC                 : %x\n",t->lac );
            printf( "Cell ID Valid       : %x\n",t->cellIdValid );
            printf( "Cell ID             : %x\n",t->cellId );
            printf( "Reg Rej Info Valid  : %x\n",t->regRejectInfoValid );
            printf( "Reject Srvc Domain  : %x\n",t->rejectSrvDomain );
            printf( "Reject Cause        : %x\n",t->rejCause );
            printf( "Network Id Valid    : %x\n",t->networkIdValid );
            printf( "MCC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MCC[i] );
            }
            printf( "\n" );
            printf( "MNC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MNC[i] );
            }
            printf( "\n" );
            printf( "HS Call Status Valid: %x\n",t->hsCallStatusValid );
            printf( "HS Call Status      : %x\n",t->hsCallStatus );
            printf( "HS Ind Valid        : %x\n",t->hsIndValid );
            printf( "HS Indication       : %x\n",t->hsInd );
            printf( "PSC Valid           : %x\n",t->pscValid );
            printf( "Primary Scrambling Code : %x\n",t->psc );
        }
        if ( pInfo->pLTESysInfo )
        {
            printf( "\nLTE SYSTEM INFORMATION ----\n");
            nas_LTESysInfo *t = pInfo->pLTESysInfo;
            displaySysInfoCommonCB( &t->sysInfoLTE );
            printf( "LAC Valid           : %x\n",t->lacValid );
            printf( "LAC                 : %x\n",t->lac );
            printf( "Cell ID Valid       : %x\n",t->cellIdValid );
            printf( "Cell ID             : %x\n",t->cellId );
            printf( "Reg Rej Info Valid  : %x\n",t->regRejectInfoValid );
            printf( "Reject Srvc Domain  : %x\n",t->rejectSrvDomain );
            printf( "Reject Cause        : %x\n",t->rejCause );
            printf( "Network Id Valid    : %x\n",t->networkIdValid );
            printf( "MCC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MCC[i] );
            }
            printf( "\n" );
            printf( "MNC info            : " );
            for ( i = 0 ; i < PLMN_LENGTH ; i++ )
            {
                printf( "%x ",t->MNC[i] );
            }
            printf( "\n" );
            printf( "TAC Valid           : %x\n",t->tacValid );
            printf( "Tracking Area Code  : %x\n",t->tac );
        }
        if ( pInfo->pAddCDMASysInfo )
        {
           printf( "Geo Sys Idx(CDMA) : %x\n", pInfo->pAddCDMASysInfo->geoSysIdx );
           printf( "Reg Period (CDMA) : %x\n", pInfo->pAddCDMASysInfo->regPrd );
        }
        IFPRINTF( "Geo Sys Idx(HDR) : %x\n", pInfo->pAddHDRSysInfo );
        if ( pInfo->pAddGSMSysInfo )
        {
            printf( "Geo Sys Idx(GSM) : %x\n", pInfo->pAddGSMSysInfo->geoSysIdx );
            printf( "Cell Br Cap(GSM) : %x\n", pInfo->pAddGSMSysInfo->cellBroadcastCap );
        }
        if ( pInfo->pAddWCDMASysInfo )
        {
            printf( "Geo Sys Idx(WCDMA) : %x\n", pInfo->pAddWCDMASysInfo->geoSysIdx );
            printf( "Cell Br Cap(WCDMA) : %x\n", pInfo->pAddWCDMASysInfo->cellBroadcastCap );
        }
        IFPRINTF( "Geo Sys Idx(LTE) : %x\n", pInfo->pAddLTESysInfo );
        if ( pInfo->pGSMCallBarringSysInfo )
        {
            printf( "CS Bar Status(GSM): %x\n", pInfo->pGSMCallBarringSysInfo->csBarStatus );
            printf( "PS Bar Status(GSM): %x\n", pInfo->pGSMCallBarringSysInfo->psBarStatus );
        }
        if ( pInfo->pWCDMACallBarringSysInfo )
        {
            printf( "CS Bar Status(WCDMA): %x\n", pInfo->pWCDMACallBarringSysInfo->csBarStatus );
            printf( "PS Bar Status(WCDMA): %x\n", pInfo->pWCDMACallBarringSysInfo->psBarStatus );
        }
        IFPRINTF( "Voice Supp on LTE: %x\n", pInfo->pLTEVoiceSupportSysInfo );
        IFPRINTF( "GSM Cipher Domain: %x\n", pInfo->pGSMCipherDomainSysInfo );
        IFPRINTF( "WCDMA Cipher Domain: %x\n", pInfo->pWCDMACipherDomainSysInfo );
        IFPRINTF( "System Info No Change Indication: %x\n", pInfo->pSysInfoNoChange );

}

void displayDataCap(unpack_nas_SetDataCapabilitiesCallback_ind_t *pDataCap)
{
   uint8_t i;
   for(i=0;i<pDataCap->dataCapsSize;i++)
      printf("\t Data Capabilities[%d] %d\n", i, pDataCap->dataCaps[i]);
}

void DisplayServingSystem(unpack_nas_SetServingSystemCallback_ind_t *pSSInfo)
{
    uint8_t i;
    printf("registrationState:%d\n",pSSInfo->SSInfo.registrationState);
    printf("csAttachState:%d\n",pSSInfo->SSInfo.csAttachState);
    printf("psAttachState:%d\n",pSSInfo->SSInfo.psAttachState) ;
    printf("selectedNetwork:%d\n",pSSInfo->SSInfo.selectedNetwork);
    printf("radioInterfaceNo:%d\n",pSSInfo->SSInfo.radioInterfaceNo );
    printf("radioInterface:\n");
    for(i=0; i < pSSInfo->SSInfo.radioInterfaceNo; i++)
    {
        printf("\t %d.%d\n",i,pSSInfo->SSInfo.radioInterfaceList[i]);
    }
    printf("hdrPersonality:%d\n",pSSInfo->SSInfo.hdrPersonality);
}
void displayNasEventInfo(unpack_nas_SetEventReportInd_t *pEventInfo)
{
    uint8_t i;

    nas_SLQSSignalStrengthsTlv *pSigStrenInfo = &pEventInfo->SLQSSSTlv;
    if (pSigStrenInfo->TlvPresent)
    {
        nas_rxSignalStrengthListElement *pSSInfo = &pSigStrenInfo->sSLQSSignalStrengthsInfo.rxSignalStrengthInfo;

        printf( "NAS Signal Strength Information From SLQSSetSignalStrengthsCallback\n");
        printf( "RSSI Information :\n" );
        printf( "Received Signal Strength : %d\n", pSSInfo->rxSignalStrength);
        printf( "Radio IF : %d\n\n", pSSInfo->radioIf);

        nas_ecioListElement *pEcioInfo = &pSigStrenInfo->sSLQSSignalStrengthsInfo.ecioInfo;
        printf( "ECIO Information :\n" );
        printf( "ECIO     : %d\n", pEcioInfo->ecio);
        printf( "Radio IF : %d\n\n", pEcioInfo->radioIf);

        printf( "IO   : %u\n", pSigStrenInfo->sSLQSSignalStrengthsInfo.io);
        printf( "SINR : %d\n\n", pSigStrenInfo->sSLQSSignalStrengthsInfo.sinr );

        nas_errorRateListElement *pERInfo = &pSigStrenInfo->sSLQSSignalStrengthsInfo.errorRateInfo;
        printf( "Error Rate Information :\n" );
        printf( "Error Rate : %d\n", pERInfo->errorRate );
        printf( "Radio IF   : %d\n\n", pERInfo->radioIf );

        nas_rsrqInformation *pRsrqInfo = &pSigStrenInfo->sSLQSSignalStrengthsInfo.rsrqInfo;
        printf( "RSRQ Information :\n" );
        printf( "RSRQ     : %d\n", pRsrqInfo->rsrq );
        printf( "Radio IF : %d\n\n", pRsrqInfo->radioIf );

        nas_lteSnrinformation *pLteSnrInfo = &pSigStrenInfo->sSLQSSignalStrengthsInfo.lteSnrinfo;
        printf( "LTE SNR LEVEL :%d dB\n\n", pLteSnrInfo->snrlevel/10 );

        nas_lteRsrpinformation *pLteRsrpInfo = &pSigStrenInfo->sSLQSSignalStrengthsInfo.lteRsrpinfo;
        printf( "LTE RSRP(-44 to -140) : %d dBm\n\n", pLteRsrpInfo->rsrplevel );
    }

    nas_RFInfoTlv *pRFInfo = &pEventInfo->RFTlv;
    if ( pRFInfo->TlvPresent)
    {
        printf("Radio Interface Size: %d\n", pRFInfo->radioInterfaceSize);
        for ( i = 0; i < pRFInfo->radioInterfaceSize; i++)
        {
            printf("Radio Interface[%d]: %u\n", i, pRFInfo->radioInterface[i]);
            printf("Active Band Class[%d]: %u\n", i, pRFInfo->activeBandClass[i] );
            printf("Active Channel[%d]: %u\n", i, pRFInfo->activeChannel[i] );
        }
    }

    nas_RejectReasonTlv *pRRInfo = &pEventInfo->RRTlv;
    if ( pRRInfo->TlvPresent)
    {
        printf("Service Domain: %u\n", pRRInfo->serviceDomain);
        printf("Reject Cause: %u\n", pRRInfo->rejectCause);
    }
}

void displayNasSystemSelectPrefInfo(unpack_nas_SLQSSetSysSelectionPrefCallBack_ind_t *pInfo)
{
    if (pInfo->Info.EMTlv.TlvPresent)
    {
        printf("Emergency Mode:%d\n",pInfo->Info.EMTlv.EmerMode);
    }
    if (pInfo->Info.MPTlv.TlvPresent)
    {
        printf("Mode Preference:%d\n",pInfo->Info.MPTlv.ModePref);
    }
    if (pInfo->Info.BPTlv.TlvPresent)
    {
        printf("Band Preference:%llu\n", (unsigned long long) pInfo->Info.BPTlv.band_pref);
    }
    if (pInfo->Info.PRLPTlv.TlvPresent)
    {
        printf("PRL Preference:%d\n",pInfo->Info.PRLPTlv.PRLPref);
    }
    if (pInfo->Info.RPTlv.TlvPresent)
    {
        printf("Roam Preference:%d\n",pInfo->Info.RPTlv.RoamPref);
    }
    if (pInfo->Info.LBPTlv.TlvPresent)
    {
        printf("LTE Band Preference:%lld\n", (unsigned long long) pInfo->Info.LBPTlv.LTEBandPref);
    }
    if (pInfo->Info.NSPTlv.TlvPresent)
    {
        printf("Net Selection Preference:%d\n",pInfo->Info.NSPTlv.NetSelPref);
    }
    if (pInfo->Info.SDPTlv.TlvPresent)
    {
        printf("Service Domain Preference:%d\n",pInfo->Info.SDPTlv.SrvDomainPref);
    }
    if (pInfo->Info.GWAOPTlv.TlvPresent)
    {
        printf("GSM/WCDMA acquisition order preference:%d\n", pInfo->Info.GWAOPTlv.GWAcqOrderPref);
    }
}

void displayNasSwiOTAMessageInfo(unpack_nas_SLQSNasSwiOTAMessageCallback_ind_t *pInfo)
{
    if(pInfo->Info.nasRelInfoTlv.TlvPresent)
    {

        printf("\nOTAMessage Major:%d",pInfo->Info.nasRelInfoTlv.nas_major);
        printf("\nOTAMessage Minor:%d",pInfo->Info.nasRelInfoTlv.nas_minor);
        printf("\nOTAMessage Release:%d",pInfo->Info.nasRelInfoTlv.nas_release); 
    }

    if(pInfo->Info.otaMsgTlv.TlvPresent)
    {
        printf("\nOTAMessage Message Type:%d",pInfo->Info.otaMsgTlv.message_type);
        printf("\nOTAMessage Message Length:%d",pInfo->Info.otaMsgTlv.data_len);
        printf("\nOTAMessage Message :%s",(char*)pInfo->Info.otaMsgTlv.data_buf);
    }

    if(pInfo->Info.timeTlv.TlvPresent)
    {
         printf("\nOTAMessage Time :%lld", (unsigned long long) pInfo->Info.timeTlv.time);
    }
    printf("\nSwiOTAMessageInfo\n");
}
void
ind_rpt_prt(const char *unpacker)
{
#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if ( fp )
    {
        fprintf(fp, "%-60s%-20s%-s\n", unpacker, "N/A", "N/A");
    }
    else
    {
        fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
    }
    if(fp)
        fclose(fp);
#else
    UNUSEDPARAM(unpacker);
#endif
}

void nas_indication_handler(uint16_t msgid, uint8_t *msg, uint32_t rlen)
{
    unpack_nas_SLQSNasSigInfoCallback_t sigInfo;
    unpack_nas_SLQSSysInfoCallback_t sysInfo;
    unpack_nas_SetEventReportInd_t eventReport;
    unpack_nas_SetDataCapabilitiesCallback_ind_t dataCap;
    unpack_nas_SetRoamingIndicatorCallback_ind_t roaming;
    unpack_nas_SetServingSystemCallback_ind_t SSinfo;
    unpack_nas_SLQSSetSysSelectionPrefCallBack_ind_t SSPInfo;
    unpack_nas_SLQSNasSwiOTAMessageCallback_ind_t SwiOtaMesInfo;
#if DEBUG_LOG_TO_FILE
    FILE *fp;
#endif

    switch(msgid)
    {
        case eQMI_NAS_SIG_INFO_IND:
            unpack_nas_SLQSNasSigInfoCallback( msg, rlen, &sigInfo);
            //it is normal that indication unpack returns eQCWWAN_ERR_INVALID_QMI_RSP(0x11)
            //which simply indicate absense of result code TLV(0x02).
            //Result code TLV is only available on Response
            displayNasSigInfo(&sigInfo);

        #if DEBUG_LOG_TO_FILE
            fp = fopen("./TestResults/testlog.txt", "a");
            if ( fp )
            {
                fprintf(fp, "%-60s%-20s%-s\n", "unpack_nas_SLQSNasSigInfoCallback", "N/A", "N/A");
            }
            else
            {
                fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
            }
            if(fp)
                fclose(fp);
        #endif
            break;
        
        case eQMI_NAS_SYS_INFO_IND:
            unpack_nas_SLQSNasSysInfoCallback( msg, rlen, &sysInfo);
            displayNasSysInfo(&sysInfo);

        #if DEBUG_LOG_TO_FILE
            fp = fopen("./TestResults/testlog.txt", "a");
            if ( fp )
            {
                fprintf(fp, "%-60s%-20s%-s\n", "unpack_nas_SLQSNasSysInfoCallback", "N/A", "N/A");
            }
            else
            {
                fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
            }
            if(fp)
                fclose(fp);
        #endif
            break;

        case eQMI_NAS_SS_INFO_IND:
            unpack_nas_SetDataCapabilitiesCallback_ind( msg, rlen, &dataCap);
            displayDataCap(&dataCap);
            ind_rpt_prt("unpack_nas_SetDataCapabilitiesCallback_ind");
            if(unpack_nas_SetRoamingIndicatorCallback_ind( msg, rlen, &roaming)==eQCWWAN_ERR_NONE)
            {
                printf("\t Roaming Indicator %d\n", roaming.roaming);
                ind_rpt_prt("unpack_nas_SetRoamingIndicatorCallback_ind");
            }
            if(unpack_nas_SetServingSystemCallback_ind( msg, rlen, &SSinfo)==eQCWWAN_ERR_NONE)
            {
                DisplayServingSystem(&SSinfo);
                ind_rpt_prt("unpack_nas_SetServingSystemCallback_ind");
            }
            break;

        case eQMI_NAS_SET_EVENT:
            unpack_nas_SetEventReportInd( msg, rlen, &eventReport);
            displayNasEventInfo(&eventReport);

        #if DEBUG_LOG_TO_FILE
            fp = fopen("./TestResults/testlog.txt", "a");
            if ( fp )
            {
                fprintf(fp, "%-60s%-20s%-s\n", "unpack_nas_SetEventReportInd", "N/A", "N/A");
            }
            else
            {
                fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
            }
            if(fp)
                fclose(fp);
        #endif
             break;
         case eQMI_NAS_SYS_SELECT_IND:
            unpack_nas_SLQSSetSysSelectionPrefCallBack_ind(msg, rlen, &SSPInfo);
            displayNasSystemSelectPrefInfo(&SSPInfo);
            #if DEBUG_LOG_TO_FILE
            fp = fopen("./TestResults/testlog.txt", "a");
            if ( fp )
            {
            fprintf(fp, "%-60s%-20s%-s\n", "UpkQmiCbkNasSystemSelPrefInd", "N/A", "N/A");
            }
            else
            {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
            }
            if(fp)
                fclose(fp);
            #endif
             break;
        case eQMI_NAS_SWI_OTA_MESSAGE_INDICATION:
            unpack_nas_SLQSNasSwiOTAMessageCallback_ind(msg, rlen, &SwiOtaMesInfo);
            displayNasSwiOTAMessageInfo(&SwiOtaMesInfo);
            #if DEBUG_LOG_TO_FILE
            fp = fopen("./TestResults/testlog.txt", "a");
            if ( fp )
            {
            fprintf(fp, "%-60s%-20s%-s\n", "UpkQmiCbkNasSwiOTAMessageInd", "N/A", "N/A");
            }
            else
            {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
            }
            if(fp)
                fclose(fp);
            #endif
             break;
    }
}

void nas_test_pack_unpack_loop()
{
    unsigned i, j;
    printf("======NAS pack/unpack test===========\n");

#if DEBUG_LOG_TO_FILE
    FILE *fp;
    fp = fopen("./TestResults/testlog.txt", "a");
    if (fp != NULL)
    {
        fprintf(fp, "\n================NAS pack/unpack test================\n\n");
        fprintf(fp, "%-60s%-20s%-s\n\n", "Pack/UnPack API Name", "Status", "Unpack Payload Parsing");
    }
    else
    {
        printf("cannot open testlog.txt\n");
    }
    if(fp)
        fclose(fp);
#endif

    unsigned xid =1;
    for(i=0; i<sizeof(nastotest)/sizeof(testitem_t); i++)
    {
        unpack_qmi_t rsp_ctx;
        int rtn;
        pack_qmi_t req_ctx;
        uint8_t rsp[QMI_MSG_MAX];
        uint8_t req[QMI_MSG_MAX];
        uint16_t rspLen, reqLen;
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid = xid;
        rtn = nastotest[i].pack(&req_ctx, req, &reqLen,nastotest[i].pack_ptr);

    #if DEBUG_LOG_TO_FILE
        FILE *fp;
        fp = fopen("./TestResults/testlog.txt", "a");
        if ( fp )
        {
            fprintf(fp, "%-60s%-20s%-s\n", nastotest[i].pack_func_name, (rtn==eQCWWAN_ERR_NONE ? "Success": "Fail"), "N/A");
        }
        else
        {
            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
        }
        if(fp)
            fclose(fp);
    #endif

        if(rtn!=eQCWWAN_ERR_NONE)
        {
            printf("pack fail %d \n", rtn);
            continue;
        }

        if(nas<0)
            nas = client_fd(eNAS);
        rtn = write(nas, req, reqLen);
        if (rtn!=reqLen)
            printf("write %d wrote %d\n", reqLen, rtn);

        while (1)
        {
            rspLen = read(nas, rsp, QMI_MSG_MAX);

            if ((rspLen > 0) && (rspLen != 0xffff))
            {
                printf("read %d\n", rspLen);
                helper_get_resp_ctx(eNAS, rsp, rspLen, &rsp_ctx);
                
                printf("<< receiving\n");
                for (j = 0; j < rspLen; j++)
                {
                    printf("%02x ", rsp[j]);
                    if ((j+1)%16 == 0)
                    {
                        printf("\n");
                    }
                }
                printf("\n");
                if (rsp_ctx.type == eRSP)
                {
                    printf("NAS RSP: ");
                    printf("msgid 0x%x\n", rsp_ctx.msgid);
                    if (rsp_ctx.xid == xid)
                    {
                        printf("run unpack %d\n",xid);
                        rtn = nastotest[i].unpack(rsp, rspLen, nastotest[i].unpack_ptr);

                    #if DEBUG_LOG_TO_FILE
                        fp = fopen("./TestResults/testlog.txt", "a");
                        if ( fp )
                        {
                            fprintf(fp, "%-60s%-20s%-s", nastotest[i].unpack_func_name, (rtn==eQCWWAN_ERR_NONE ? "Success": "Fail"), "");
                        }
                        else
                        {
                            fprintf(stderr,"[line:%d]open ./TestResults/testlog.txt failed!\n", __LINE__);
                        }
                        if(fp)
                            fclose(fp);
                    #endif

                        nastotest[i].dump(nastotest[i].unpack_ptr);
                        /* sleep 3 seconds for next write */
                        sleep(3);
                        /* skip the while loop so that the the next API can be invoked */
                        break;
                    }
                    else
                    {
                        /* the response is not belongs to this API, skip it and read again */
                        printf("xid %d\n",xid);
                        sleep(1);
                    }
                }
                else if (rsp_ctx.type == eIND)
                {
                    printf("NAS IND: msgid 0x%x\n", rsp_ctx.msgid);
                    nas_indication_handler(rsp_ctx.msgid, rsp,  rspLen);
                }
            }
            else
            {
                /* read nothing, sleep 1 second and read again */
                sleep(1);
            }            
        }
        xid++;
    }
    if(nas>=0)
        close(nas);
    nas=-1;
}

