#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>

#include "packingdemo.h"
#include "loc.h"

int loc=-1;
volatile int enLOCThread =0;
pthread_t loc_tid;
pthread_attr_t loc_attr;

pack_loc_EventRegister_t LocEventRegister[]={
    {LOCEVENTMASKPOSITIONREPORT,0},
    {LOCEVENTMASKGNSSSVINFO,0},
    {LOCEVENTMASKNMEA,0},
    {LOCEVENTMASKNINOTIFYVERIFYREQ,0},
    {LOCEVENTMASKINJECTTIMEREQ,0},
    {LOCEVENTMASKINJECTPREDICTEDORBITSREQ,0},
    {LOCEVENTMASKINJECTPOSITIONREQ,0},
    {LOCEVENTMASKENGINESTATE,0},
    {LOCEVENTMASKFIXSESSIONSTATE,0},
    {LOCEVENTMASKWIFIREQ,0},
    {LOCEVENTMASKSENSORSTREAMINGREADYSTATUS,0},
    {LOCEVENTMASKTIMESYNCREQ,0},
    {LOCEVENTMASKSETSPISTREAMINGREPORT,0},
    {LOCEVENTMASKLOCATIONSERVERCONNECTIONREQ,0},
    {LOCEVENTMASKNIGEOFENCENOTIFICATION,0},
    {LOCEVENTMASKGEOFENCEGENALERT,0},
    {LOCEVENTMASKGEOFENCEBREACHNOTIFICATION,0},
    {LOCEVENTMASKPEDOMETERCONTROL,0},
    {LOCEVENTMASKMOTIONDATACONTROL,0},
    {LOCEVENTMASKBATCHFULLNOTIFICATION,0},
    {LOCEVENTMASKLIVEBATCHEDPOSITIONREPORT,0},
    {LOCEVENTMASKINJECTWIFIAPDATAREQ,0},
    {LOCEVENTMASKGEOFENCEBATCHBREACHNOTIFICATION,0},
    {LOCEVENTMASKVEHICLEDATAREADYSTATUS,0},
    {LOCEVENTMASKGNSSMEASUREMENTREPORT,0},
    {LOCEVENTMASKINVALIDVALUE,0}
};

pack_loc_SetExtPowerState_t LocSetExtPowerState[]={
     {0,0},//Device is not connected to an external power source
     {1,0},//Device is connected to an external power source
     {2,0},//Unknown external power state
     {3,0},//Fail Case
};
uint32_t LocStartappInterval =1000;
uint8_t LocStartappProvider[] = "ABC";
uint8_t LocStartappName[]     = "XYZ";
uint8_t LocStartappVer[]      = "12";

loc_LocApplicationInfo LocStartapp ={3, LocStartappProvider,3,LocStartappName,1,2,LocStartappVer };
uint32_t   LocStartTestLocRecurrence        = 1;
uint32_t   LocStartTestLocAccuracy          = 1;
uint32_t   LocStartintermediateReportState = 1;
uint32_t   LocStartconfigAltitudeAssumed   = 1;


pack_loc_Start_t LocStart[]={
    {
        0,//SessionId
        NULL,//pRecurrenceType;
        NULL,//HorizontalAccuracyLvl;
        NULL,//IntermediateReportState;
        NULL,//MinIntervalTime;
        NULL,//ApplicationInfo;
        NULL,//ConfigAltitudeAssumed;
        0// Tlvresult;
    },
    {
        0,//SessionId
        NULL,//pRecurrenceType;
        NULL,//HorizontalAccuracyLvl;
        NULL,//IntermediateReportState;
        NULL,//MinIntervalTime;
        &LocStartapp,//ApplicationInfo;
        NULL,//ConfigAltitudeAssumed;
        0// Tlvresult;
    },
    {
        0,//SessionId
        &LocStartTestLocRecurrence,//pRecurrenceType;
        NULL,//HorizontalAccuracyLvl;
        NULL,//IntermediateReportState;
        NULL,//MinIntervalTime;
        NULL,//ApplicationInfo;
        NULL,//ConfigAltitudeAssumed;
        0// Tlvresult;
    },
    {
        0,//SessionId
        NULL,//pRecurrenceType;
        &LocStartTestLocAccuracy,//HorizontalAccuracyLvl;
        NULL,//IntermediateReportState;
        NULL,//MinIntervalTime;
        NULL,//ApplicationInfo;
        NULL,//ConfigAltitudeAssumed;
        0// Tlvresult;
    },
    {
        0,//SessionId
        NULL,//pRecurrenceType;
        NULL,//HorizontalAccuracyLvl;
        &LocStartintermediateReportState,//IntermediateReportState;
        NULL,//MinIntervalTime;
        NULL,//ApplicationInfo;
        NULL,//ConfigAltitudeAssumed;
        0// Tlvresult;
    },
     {
        0,//SessionId
        NULL,//pRecurrenceType;
        NULL,//HorizontalAccuracyLvl;
        NULL,//IntermediateReportState;
        &LocStartappInterval,//MinIntervalTime;
        NULL,//ApplicationInfo;
        NULL,//ConfigAltitudeAssumed;
        0// Tlvresult;
    },
    {
        0,//SessionId
        NULL,//pRecurrenceType;
        NULL,//HorizontalAccuracyLvl;
        NULL,//IntermediateReportState;
        NULL,//MinIntervalTime;
        NULL,//ApplicationInfo;
        &LocStartconfigAltitudeAssumed,//ConfigAltitudeAssumed;
        0// Tlvresult;
    },
};

pack_loc_Stop_t LocStop[]={
        {
        0,//SessionId
        0// Tlvresult;
    },
};

pack_loc_SetOperationMode_t LopSetOperationMode[]={
    {
        1,//Default Mode
        0// Tlvresult;
    },
    {
        2,//MS based Mode
        0// Tlvresult;
    },
    {
        3,//MS assisted Mode
        0// Tlvresult;
    },
    {
        4,//MS standalone Mode
        0// Tlvresult;
    },
    {
        5,//Use Cell ID (GSM / UMTS)
        0// Tlvresult;
    },
    {
        6,//WWAN
        0// Tlvresult;
    },
};



loc_SV LocDeleteAssistDataSVInfoSv[1] = {{1,1,1}};
loc_SVInfo LocDeleteAssistDataSVInfo={1,&LocDeleteAssistDataSVInfoSv[0]};

loc_GnssData LocDeleteAssistDataGnssData={1};
loc_CellDb LocDeleteAssistDataCellDb={1};
loc_ClkInfo LocDeleteAssistDataClkInfo= {1};

loc_BdsSV LocDeleteAssistDataBdsSVInfoBdsSV[2] = {{201,1},{301,2}};
loc_BdsSVInfo LocDeleteAssistDataBdsSVInfo ={1,&LocDeleteAssistDataBdsSVInfoBdsSV[0]};


pack_loc_Delete_Assist_Data_t LocDeleteAssistData[]={
    { //Delete All
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        0
    },
    { //Delete All
        &LocDeleteAssistDataSVInfo,
        NULL,
        NULL,
        NULL,
        NULL,
        0
    },
    { //Delete All
        NULL,
        &LocDeleteAssistDataGnssData,
        NULL,
        NULL,
        NULL,
        0
    },
    { //Delete All
        NULL,
        NULL,
        &LocDeleteAssistDataCellDb,
        NULL,
        NULL,
        0
    },
    { //Delete All
        NULL,
        NULL,
        NULL,
        &LocDeleteAssistDataClkInfo,//{1},
        NULL,
        0
    },
    { //Delete All
        NULL,
        NULL,
        NULL,
        NULL,
        &LocDeleteAssistDataBdsSVInfo,//{1,{201,1}},
        0
    },
};


unpack_loc_EventRegister_t      LocEventRegisterResp;
unpack_loc_SetExtPowerState_t   LocSetExtPowerStateResp;
unpack_loc_Start_t              LocStartResp;
unpack_loc_Stop_t               LocStopResp;
unpack_loc_SetOperationMode_t   LocSetOperationModeResp;
unpack_loc_Delete_Assist_Data_t LocDeleteAssistDataResp;


void dump_LOC_EventRegister(void * ptr)
{
    unpack_loc_EventRegister_t *result =
            (unpack_loc_EventRegister_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
     printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_LOC_SetExtPowerState(void * ptr)
{
    unpack_loc_SetExtPowerState_t *result =
            (unpack_loc_SetExtPowerState_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_LOC_Start(void * ptr)
{
    unpack_loc_Start_t *result =
            (unpack_loc_Start_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);

}

void dump_LOC_Stop(void * ptr)
{
    unpack_loc_Stop_t *result =
            (unpack_loc_Stop_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_LOC_SetOperationMode(void * ptr)
{
    unpack_loc_SetOperationMode_t *result =
            (unpack_loc_SetOperationMode_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_LOC_DeleteAssistData(void * ptr)
{
    unpack_loc_SetOperationMode_t *result =
            (unpack_loc_SetOperationMode_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}




testitem_t totestloc[] = {
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        NULL, 
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        NULL, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[0],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[1],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[2],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[3],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[4],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[5],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[6],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[7],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[8],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[9],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[10],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[11],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[12],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[13],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[14],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[15],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[16],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[17],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[18],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[19],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[20],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[21],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[22],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp,
        dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[23],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[24],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_EventRegister, "pack_loc_EventRegister",
        &LocEventRegister[25],
        (unpack_func) unpack_loc_EventRegister, "unpack_loc_EventRegister",
        &LocEventRegisterResp, dump_LOC_EventRegister
    },
    {
        (pack_func) pack_loc_SetExtPowerState, "pack_loc_SetExtPowerState",
        &LocSetExtPowerState[0],
        (unpack_func) unpack_loc_SetExtPowerState, "unpack_loc_SetExtPowerState",
        &LocSetExtPowerStateResp, dump_LOC_SetExtPowerState
    },
    {
        (pack_func) pack_loc_SetExtPowerState, "pack_loc_SetExtPowerState",
        &LocSetExtPowerState[0],
        (unpack_func) unpack_loc_SetExtPowerState, "unpack_loc_SetExtPowerState",
        &LocSetExtPowerStateResp, dump_LOC_SetExtPowerState
    },
    {
        (pack_func) pack_loc_SetExtPowerState, "pack_loc_SetExtPowerState",
        &LocSetExtPowerState[1],
        (unpack_func) unpack_loc_SetExtPowerState, "unpack_loc_SetExtPowerState",
        &LocSetExtPowerStateResp, dump_LOC_SetExtPowerState
    },
    {
        (pack_func) pack_loc_SetExtPowerState, "pack_loc_SetExtPowerState",
        &LocSetExtPowerState[2],
        (unpack_func) unpack_loc_SetExtPowerState, "unpack_loc_SetExtPowerState",
        &LocSetExtPowerStateResp,
        dump_LOC_SetExtPowerState
    },
    {
        (pack_func) pack_loc_SetExtPowerState, "pack_loc_SetExtPowerState",
        &LocSetExtPowerState[3],
        (unpack_func) unpack_loc_SetExtPowerState, "unpack_loc_SetExtPowerState",
        &LocSetExtPowerStateResp, dump_LOC_SetExtPowerState
    },
    {
        (pack_func) pack_loc_Start, "pack_loc_Start",
        &LocStart[0],
        (unpack_func) unpack_loc_Start, "unpack_loc_Start",
        &LocStartResp, dump_LOC_Start
    },
    {
        (pack_func) pack_loc_Start, "pack_loc_Start",
        &LocStart[1],
        (unpack_func) unpack_loc_Start, "unpack_loc_Start",
        &LocStartResp, dump_LOC_Start
    },
        {
        (pack_func) pack_loc_Start, "pack_loc_Start",
        &LocStart[2],
        (unpack_func) unpack_loc_Start, "unpack_loc_Start",
        &LocStartResp, dump_LOC_Start
    },
    {
        (pack_func) pack_loc_Start, "pack_loc_Start",
        &LocStart[3],
        (unpack_func) unpack_loc_Start, "unpack_loc_Start",
        &LocStartResp, dump_LOC_Start
    },
    {
        (pack_func) pack_loc_Start, "pack_loc_Start",
        &LocStart[4],
        (unpack_func) unpack_loc_Start, "unpack_loc_Start",
        &LocStartResp, dump_LOC_Start
    },
    {
        (pack_func) pack_loc_Start, "pack_loc_Start",
        &LocStart[5],
        (unpack_func) unpack_loc_Start, "unpack_loc_Start",
        &LocStartResp, dump_LOC_Start
    },
        {
        (pack_func) pack_loc_Start, "pack_loc_Start",
        &LocStart[6],
        (unpack_func) unpack_loc_Start, "unpack_loc_Start",
        &LocStartResp, dump_LOC_Start
    },
    {
        (pack_func) pack_loc_Stop, "pack_loc_Stop",
        &LocStop[0],
        (unpack_func) unpack_loc_Stop, "unpack_loc_Stop",
        &LocStopResp, dump_LOC_Stop
    },
    {
        (pack_func) pack_loc_Stop, "pack_loc_Stop",
        &LocStop[1],
        (unpack_func) unpack_loc_Stop, "unpack_loc_Stop",
        &LocStopResp, dump_LOC_Stop
    },
    {
        (pack_func) pack_loc_SetOperationMode, "pack_loc_SetOperationMode",
        &LopSetOperationMode[0],
        (unpack_func) unpack_loc_SetOperationMode, "pack_loc_SetOperationMode",
        &LocSetOperationModeResp, dump_LOC_SetOperationMode
    },
    {
        (pack_func) pack_loc_SetOperationMode, "pack_loc_SetOperationMode",
        &LopSetOperationMode[1],
        (unpack_func) unpack_loc_SetOperationMode, "unpack_loc_SetOperationMode",
        &LocSetOperationModeResp, dump_LOC_SetOperationMode
    },
    {
        (pack_func) pack_loc_SetOperationMode, "pack_loc_SetOperationMode",
        &LopSetOperationMode[2],
        (unpack_func) unpack_loc_SetOperationMode, "unpack_loc_SetOperationMode",
        &LocSetOperationModeResp, dump_LOC_SetOperationMode
    },
    {
        (pack_func) pack_loc_SetOperationMode, "pack_loc_SetOperationMode",
        &LopSetOperationMode[3],
        (unpack_func) unpack_loc_SetOperationMode, "unpack_loc_SetOperationMode",
        &LocSetOperationModeResp, dump_LOC_SetOperationMode
    },
    {
        (pack_func) pack_loc_SetOperationMode, "pack_loc_SetOperationMode",
        &LopSetOperationMode[4],
        (unpack_func) unpack_loc_SetOperationMode, "unpack_loc_SetOperationMode",
        &LocSetOperationModeResp, dump_LOC_SetOperationMode
    },
    {
        (pack_func) pack_loc_SetOperationMode, "pack_loc_SetOperationMode",
        &LopSetOperationMode[5],
        (unpack_func) unpack_loc_SetOperationMode, "unpack_loc_SetOperationMode",
        &LocSetOperationModeResp, dump_LOC_SetOperationMode
    },
    {
        (pack_func) pack_loc_DeleteAssistData, "pack_loc_DeleteAssistData",
        &LocDeleteAssistData[0],
        (unpack_func) unpack_loc_DeleteAssistData, "unpack_loc_DeleteAssistData",
        &LocDeleteAssistDataResp, dump_LOC_DeleteAssistData
    },
    {
        (pack_func) pack_loc_DeleteAssistData, "pack_loc_DeleteAssistData",
        &LocDeleteAssistData[1],
        (unpack_func) unpack_loc_DeleteAssistData, "unpack_loc_DeleteAssistData",
        &LocDeleteAssistDataResp, dump_LOC_DeleteAssistData
    },
    {
        (pack_func) pack_loc_DeleteAssistData, "pack_loc_DeleteAssistData",
        &LocDeleteAssistData[2],
        (unpack_func) unpack_loc_DeleteAssistData, "unpack_loc_DeleteAssistData",
        &LocDeleteAssistDataResp, dump_LOC_DeleteAssistData
    },
    {
        (pack_func) pack_loc_DeleteAssistData, "pack_loc_DeleteAssistData",
        &LocDeleteAssistData[3],
        (unpack_func) unpack_loc_DeleteAssistData, "unpack_loc_DeleteAssistData",
        &LocDeleteAssistDataResp, dump_LOC_DeleteAssistData
    },
    {
        (pack_func) pack_loc_DeleteAssistData, "pack_loc_DeleteAssistData",
        &LocDeleteAssistData[4],
        (unpack_func) unpack_loc_DeleteAssistData, "unpack_loc_DeleteAssistData",
        &LocDeleteAssistDataResp, dump_LOC_DeleteAssistData
    },
    {
       (pack_func) pack_loc_DeleteAssistData, "pack_loc_DeleteAssistData",
       &LocDeleteAssistData[5],
       (unpack_func) unpack_loc_DeleteAssistData, "unpack_loc_DeleteAssistData",
       &LocDeleteAssistDataResp, dump_LOC_DeleteAssistData
    },
};


void dump_PositionRpt_Ind(unpack_loc_PositionRpt_Ind_t Resp)
{
    printf("PositionRptInd\n");
    printf("\tsessionId:%d\n",Resp.sessionId);
    printf("\tsessionStatus:%d\n",(int)Resp.sessionStatus);
    if(Resp.pAltitudeAssumed!=NULL)
        printf("\tAltitudeAssumed:%d\n",(int)*(Resp.pAltitudeAssumed));
    if(Resp.pLatitude!=NULL)
        printf("\tLatitude:%lf\n", *(double*)(Resp.pLatitude));
    if(Resp.pLongitude!=NULL)
        printf("\tLongitude:%lf\n", *(double*)(Resp.pLongitude));
    if(Resp.pHorUncCircular!=NULL)
        printf("\tHorUncCircular:%"PRIu32"\n",*(Resp.pHorUncCircular));
    if(Resp.pHorUncEllipseSemiMinor!=NULL)
        printf("\tHorUncEllipseSemiMinor:%"PRIu32"\n",*(Resp.pHorUncEllipseSemiMinor));
    if(Resp.pHorUncEllipseSemiMajor!=NULL)
        printf("\tHorUncEllipseSemiMajor:%"PRIu32"\n",*(Resp.pHorUncEllipseSemiMajor));
    if(Resp.pHorUncEllipseOrientAzimuth!=NULL)
        printf("\tHorUncEllipseOrientAzimuth:%"PRIu32"\n",*(Resp.pHorUncEllipseOrientAzimuth));
    if(Resp.pHorConfidence!=NULL)
        printf("\tHorConfidence:%d\n",(int)*(Resp.pHorConfidence));
    if(Resp.pHorReliability!=NULL)
        printf("\tHorReliability:%"PRIu32"\n",*(Resp.pHorReliability));
    if(Resp.pSpeedHorizontal!=NULL)
        printf("\tSpeedHorizontal:%"PRIu32"\n",*(Resp.pSpeedHorizontal));
    if(Resp.pSpeedUnc!=NULL)
        printf("\tSpeedUnc:%"PRIu32"\n",*(Resp.pSpeedUnc));
    if(Resp.pAltitudeWrtEllipsoid!=NULL)
        printf("\tAltitudeWrtEllipsoid:%"PRIu32"\n",*(Resp.pAltitudeWrtEllipsoid));
    if(Resp.pAltitudeWrtMeanSeaLevel!=NULL)
        printf("\tAltitudeWrtMeanSeaLevel:%"PRIu32"\n",*(Resp.pAltitudeWrtMeanSeaLevel));
    if(Resp.pVertUnc!=NULL)
        printf("\tVertUnc:%"PRIu32"\n",*(Resp.pVertUnc));
    if(Resp.pVertConfidence!=NULL)
        printf("\tVertConfidence:%"PRIu32"\n",*(Resp.pVertConfidence));
    if(Resp.pVertReliability!=NULL)
        printf("\tVertReliability:%"PRIu32"\n",*(Resp.pVertReliability));
    if(Resp.pSpeedVertical!=NULL)
        printf("\tSpeedVertical:%"PRIu32"\n",*(Resp.pSpeedVertical));
    if(Resp.pHeading!=NULL)
        printf("\tHeading:%"PRIu32"\n",*(Resp.pHeading));
    if(Resp.pHeadingUnc!=NULL)
        printf("\tHeadingUnc:%"PRIu32"\n",*(Resp.pHeadingUnc));
    if(Resp.pMagneticDeviation!=NULL)
        printf("\tMagneticDeviation:%"PRIu32"\n",*(Resp.pMagneticDeviation));
    if(Resp.pTechnologyMask!=NULL)
        printf("\tTechnologyMask:%"PRIu32"\n",*(Resp.pTechnologyMask));
    if(Resp.pMagneticDeviation!=NULL)
        printf("\tMagneticDeviation:%"PRIu32"\n",*(Resp.pMagneticDeviation));
    if(Resp.pTimestampUtc!=NULL)
        printf("\tTimestampUtc:%"PRIu64"\n",*(Resp.pTimestampUtc));
    if(Resp.pLeapSeconds!=NULL)
        printf("\tLeapSeconds:%"PRIu32"\n",*(Resp.pLeapSeconds));
    if(Resp.pTimeUnc!=NULL)
        printf("\tTimeUnc:%"PRIu32"\n",*(Resp.pTimeUnc));
    if(Resp.pTimeSrc!=NULL)
        printf("\tTimeSrc:%"PRIu32"\n",*(Resp.pTimeSrc));
    if(Resp.pFixId!=NULL)
        printf("\tFixId:%"PRIu32"\n",*(Resp.pFixId));
    if(Resp.pTimeUnc!=NULL)
        printf("\tTimeUnc:%"PRIu32"\n",*(Resp.pTimeUnc));
    if(Resp.pAltitudeAssumed!=NULL)
        printf("\tAltitudeAssumed:%"PRIu32"\n",*(Resp.pAltitudeAssumed));
    if(Resp.pTimeUnc!=NULL)
        printf("\tTimeUnc:%"PRIu32"\n",*(Resp.pTimeUnc));
    if(Resp.pPrecisionDilution!=NULL)
    {
        printf("\tPrecisionDilution\n");
        printf("\tHDOP:%"PRIu32"\n",Resp.pPrecisionDilution->HDOP);
        printf("\tPDOP:%"PRIu32"\n",Resp.pPrecisionDilution->PDOP);
        printf("\tVDOP:%"PRIu32"\n",Resp.pPrecisionDilution->VDOP);
    }
    if(Resp.pGpsTime!=NULL)
    {
        printf("\tGPS Time\n");
        printf("\tgpsTimeOfWeekMs:%d\n",Resp.pGpsTime->gpsTimeOfWeekMs);
        printf("\tgpsWeek:%d\n",Resp.pGpsTime->gpsWeek);
    }
    if(Resp.pSensorDataUsage!=NULL)
    {
        printf("\tSensorDataUsage\n");
        printf("\taidingIndicatorMask:%d\n",Resp.pSensorDataUsage->aidingIndicatorMask);
        printf("\tusageMask:%d\n",Resp.pSensorDataUsage->usageMask);
    }

    if(Resp.pSvUsedforFix!=NULL)
    {
        int i = 0;
        printf("\tSvUsedforFix\n");
        printf("\tSvUsedList Length:%d\n",Resp.pSvUsedforFix->gnssSvUsedList_len);
        for(i =0;i<Resp.pSvUsedforFix->gnssSvUsedList_len;i++)
            printf("\tgnssSvUsedList(%d):%d\n",i,Resp.pSvUsedforFix->gnssSvUsedList[i]);

    }
    
}
void *loc_read_thread(void* ptr)
{
    const char *qmi_msg;
    unpack_qmi_t rsp_ctx;
    msgbuf msg;
    int rtn;

    printf("%s param %p\n", __func__, ptr);
    
    while(enLOCThread)
    {
        if(loc<1)
        {
            usleep(1000);
            printf("%s fd error\n", __func__);
            continue;
        }
        //TODO select multiple file and read them
        rtn = read(loc, msg.buf, QMI_MSG_MAX);
        if (rtn > 0)
        {
            qmi_msg = helper_get_resp_ctx(eLOC, msg.buf, 255, &rsp_ctx);
            printf("<< receiving %s\n", qmi_msg);

            if (rsp_ctx.type == eIND)
                printf("LOC IND: ");
            else if (rsp_ctx.type == eRSP)
                printf("LOC RSP: ");
            printf("msgid 0x%x, type:%x\n", rsp_ctx.msgid,rsp_ctx.type);

            switch(rsp_ctx.msgid)
            {
                case eQMI_LOC_START:
                    if (rsp_ctx.type == eIND)
                    {
                        printf("QMI_LOC_START IND result :%d\n",rtn);
                    }
                    else if (rsp_ctx.type == eRSP)
                    {
                        unpack_loc_Start_t loc_Start;
                        memset(&loc_Start,0,sizeof(unpack_loc_Start_t));
                        rtn = unpack_loc_Start( msg.buf, QMI_MSG_MAX ,&loc_Start);
                        printf("QMI_LOC_START RSP result :%d\n",rtn);
                    }
                    break;
                case eQMI_LOC_EVENT_POSITION_REPORT_IND:
                    if (rsp_ctx.type == eIND)
                    {
                        unpack_loc_PositionRpt_Ind_t Resp;
                        loc_gpsTime GpsTime;
                        loc_precisionDilution precisionDilution;
                        loc_svUsedforFix svUsedforFix;
                        loc_sensorDataUsage sensorDataUsage;
                        
                        memset(&Resp,0,sizeof(unpack_loc_PositionRpt_Ind_t));
                        Resp.pGpsTime = &GpsTime;
                        Resp.pPrecisionDilution = &precisionDilution;
                        Resp.pSvUsedforFix = &svUsedforFix;
                        Resp.pSensorDataUsage = &sensorDataUsage;
                        Resp.sessionStatus = ~0;
                        /* Unpack the WDS Event Indication */
                        rtn = unpack_loc_PositionRpt_Ind( msg.buf,QMI_MSG_MAX,&Resp );
                        if(Resp.sessionStatus <= eQMI_LOC_SESS_STATUS_IN_PROGRESS)
                        {
                            dump_PositionRpt_Ind(Resp);
                        }
                        printf("sessionStatus :%d\n",Resp.sessionStatus);
                        printf("QMI_LOC_EVENT_POSITION_REPORT_IND IND result :%d\n",rtn);
                    }
                    else if (rsp_ctx.type == eRSP)
                    {
                        printf("QMI_LOC_EVENT_POSITION_REPORT_IND RSP result :%d\n",rtn);
                    }
                    break;
                default:
                    printf("Default msgid 0x%x\n", rsp_ctx.msgid);
                    break;
            }
        }
    }
    return NULL;
}


void loc_test_pack_unpack_loop()
{
    unsigned i;
    unsigned xid =1;
    printf("======LOC pack/unpack test===========\n");
    for(i=0; i<sizeof(totestloc)/sizeof(testitem_t); i++)
    {
        unpack_qmi_t rsp_ctx;
        int rtn;
        pack_qmi_t req_ctx;
        uint8_t rsp[QMI_MSG_MAX];
        uint8_t req[QMI_MSG_MAX];
        uint16_t rspLen, reqLen;
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid = xid;
        rtn = totestloc[i].pack(&req_ctx, req, &reqLen,totestloc[i].pack_ptr);
        if(rtn!=eQCWWAN_ERR_NONE)
        {
            continue;
        }
        if(loc<0)
            loc = client_fd(eLOC);
        rtn = write(loc, req, reqLen);
        if (rtn!=reqLen)
            printf("write %d wrote %d\n", reqLen, rtn);
        rspLen = read(loc, rsp, QMI_MSG_MAX);

        helper_get_resp_ctx(eLOC, rsp, rspLen, &rsp_ctx);

        if (rsp_ctx.xid == xid)
        {
            totestloc[i].unpack(rsp, rspLen, totestloc[i].unpack_ptr);
            totestloc[i].dump(totestloc[i].unpack_ptr);
        }
        xid++;
        if(loc>=0)
            close(loc);
        loc = -1;
    }
}


void loc_test_ind()
{
    pack_qmi_t req_ctx;
    uint16_t qmi_req_len;
    uint8_t qmi_req[QMI_MSG_MAX];
    int rtn;
        
    if(loc<0)
    loc = client_fd(eLOC);
    pack_loc_EventRegister_t locReqPara;
    pack_loc_Start_t locStart;
    memset(&locReqPara,0,sizeof(pack_loc_EventRegister_t));
    memset(&locStart,0,sizeof(pack_loc_Start_t));
    req_ctx.xid = 0x100;
    memset(&loc_attr, 0, sizeof(loc_attr));
    locStart.SessionId = 0;
    locStart.pApplicationInfo = NULL;
    locStart.pConfigAltitudeAssumed = NULL;
    locStart.pHorizontalAccuracyLvl = NULL;
    locStart.pIntermediateReportState = NULL;
    locStart.pMinIntervalTime = NULL;
    locStart.pRecurrenceType = NULL;
    locStart.Tlvresult = 0;
        
    locReqPara.eventRegister = LOCEVENTMASKPOSITIONREPORT;
    rtn = pack_loc_Start(&req_ctx, qmi_req, &qmi_req_len, (void*)&locStart);
    if(rtn!=0)
    {
        printf("LOC Start Fail");
        return ;
    }
    rtn = write(loc, qmi_req, qmi_req_len);
    if(rtn<0)
    {
        printf("LOC FD Write Fail");
        return ;
    }
    rtn = pack_loc_EventRegister(&req_ctx, qmi_req, &qmi_req_len, (void*)&locReqPara);
    if(rtn!=0)
    {
        printf("LOC Event Register Pack Fail");
        return ;
    }

    rtn = write(loc, qmi_req, qmi_req_len);    
    if(rtn<0)
    {
        printf("LOC FD write Fail");
        return ;
    }
    enLOCThread = 1;
    pthread_create(&loc_tid, &loc_attr, loc_read_thread, NULL);
    
    sleep(25);
    enLOCThread = 0;
}
void loc_test_ind_exit()
{
    void *pthread_rtn_value;
    printf("\nkilling LOC read thread...\n");        
    enLOCThread = 0;
    UNUSEDPARAM(pthread_rtn_value);
    //pthread_join(loc_tid, &pthread_rtn_value);
    pthread_cancel(loc_tid);
    if(loc>=0)
    close(loc);
    loc=-1;
}


