#define __STDC_FORMAT_MACROS
#include <pthread.h>
#include <inttypes.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/msg.h>
#include <errno.h>
#include "packingdemo.h"
#include "dms.h"
#include "fms.h"

int dms=-1;
pthread_attr_t dms_attr;
pthread_t dms_tid;
volatile int enDmsThread;


void *dms_read_thread(void* ptr)
{
    const char *qmi_msg;
    unpack_qmi_t rsp_ctx;
    msgbuf msg;
    int rtn;
    UNUSEDPARAM(ptr);
    if(dms<0)
        dms = client_fd(eDMS);
    while(enDmsThread)
    {
        if(dms<1)
        {
            usleep(1000);
            printf("%s fd error\n", __func__);
            continue;
        }
        //TODO select multiple file and read them
        rtn = read(dms, msg.buf, QMI_MSG_MAX);
        if (rtn > 0)
        {
            qmi_msg = helper_get_resp_ctx(eDMS, msg.buf, 255, &rsp_ctx);
            printf("<< receiving %s\n", qmi_msg);

            if (rsp_ctx.type == eIND)
                printf("DMS IND: ");
            else if (rsp_ctx.type == eRSP)
                printf("WDS RSP: ");
            printf("msgid 0x%x, type:%x\n", rsp_ctx.msgid,rsp_ctx.type);

            switch(rsp_ctx.msgid)
            {
                case eQMI_DMS_EVENT_IND:
                    if (rsp_ctx.type == eIND)
                    {
                        unpack_dms_SetEventReport_ind_t Resp;
                        memset(&Resp,0,sizeof(unpack_dms_SetEventReport_ind_t));
                            
                        /* Set all the TLVs to be in Not-Present State */
                        Resp.ActivationStatusTlv.TlvPresent = 0;
                        Resp.OperatingModeTlv.TlvPresent = 0;

                        /* Unpack the WDS Event Indication */
                        rtn = unpack_dms_SetEventReport_ind( msg.buf,QMI_MSG_MAX,&Resp );
                        if(Resp.ActivationStatusTlv.TlvPresent!=0)
                        {
                            printf("QMI_DMS_SET_EVENT_REPORT IND activationStatus :%d\n",Resp.ActivationStatusTlv.activationStatus);
                        }
                        if(Resp.OperatingModeTlv.TlvPresent!=0)
                        {
                            printf("QMI_DMS_SET_EVENT_REPORT IND operatingMode :%d\n",Resp.OperatingModeTlv.operatingMode);
                        }
                    }
                    else if (rsp_ctx.type == eRSP)
                    {
                        unpack_dms_SetEventReport_t dms_SetEventReport;
                        memset(&dms_SetEventReport,0,sizeof(unpack_dms_SetEventReport_t));
                        rtn = unpack_dms_SetEventReport( msg.buf, QMI_MSG_MAX ,&dms_SetEventReport);
                        printf("QMI_DMS_SET_EVENT_REPORT RSP result :%d\n",rtn);
                    }
                    break;
                default:
                    printf("Default msgid 0x%x\n", rsp_ctx.msgid);
                    break;
            }
        }
    }
    return NULL;
}


/////////////////////////////////////////////////////////////

unpack_dms_GetPower_t power;
unpack_dms_GetFirmwareInfo_t fwinfo;
unpack_dms_GetModelID_t model;
unpack_dms_GetIMSI_t imsi;
unpack_dms_GetFirmwareRevisions_t FirmwareRevisions;
unpack_dms_GetFirmwareRevision_t FirmwareRevision;
unpack_dms_SLQSGetBandCapability_t bandcap;
unpack_dms_GetDeviceSerialNumbers_t DeviceSerialNumbers;
unpack_dms_GetPRLVersion_t PRLVersion;
unpack_dms_GetNetworkTime_t Time;
unpack_dms_GetVoiceNumber_t VoiceNumber;
unpack_dms_GetDeviceHardwareRev_t HardwareRev;
unpack_dms_GetFSN_t FSN;
unpack_dms_GetDeviceCap_t DeviceCap;
unpack_dms_SetPower_t SetPowerResp;
unpack_dms_GetBandCapability_t BandCapability;
unpack_dms_GetUSBComp_t GetUSBComp;
unpack_dms_SetUSBComp_t SetUSBComp;

unpack_dms_SetCustFeature_t SetCusFeatureResp;
unpack_dms_GetCustFeature_t GetCusFeatureResp;
unpack_dms_SetFirmwarePreference_t SetFirmwarePreferenceResp;
unpack_dms_GetCrashAction_t GetCrashAction;
unpack_dms_GetDeviceMfr_t  GetDeviceMfr;
unpack_dms_SetEventReport_t SetEventReportResp;
unpack_dms_UIMGetICCID_t UIMGetICCIDResp;
unpack_dms_GetActivationState_t  ActivationStateResp;

image_info_t fw_info[16];

unpack_dms_SLQSSwiGetFirmwareCurr_t cur_fw = {
        sizeof(fw_info)/sizeof(image_info_t), fw_info,
        {0}, {0},{0}, {0} };

pack_dms_SetEventReport_t SetEventReport[]={{0},{1}};

pack_dms_SetUSBComp_t SetUSBCompReq={0x06,0};

pack_dms_SetPower_t SetPowerOnline     = { DMS_PM_ONLINE, 0};

pack_dms_SetCustFeature_t SetCusFeature[]=
{
    {1,0,0,0,0,0,0,0,0},//Enable GPS=1,GPS Select = 0
    {0,0,0,0,0,0,0,0,0},//Enable GPS=0,GPS Select = 0
    {9,0,0,0,0,0,0,0,0},//Enable GPS=9,GPS Select = 0
    {0,0,0,0,0,0,0,0,0},//Voice enable = 0 True
    {0,0,0,0,0,0,2,0,0},//Voice enable = 2 False
    {0,0,0,0,0,0,0,1,0},//DHCPRelayEnabled
    {0,0,0,0,0,0,0,0,0},//DHCPRelayDisable
    {0,0,0,0,0,0,0,0,0},//GPSLPM Enable
    {0,0,0,0,0,0,0,0,1},//GPSLPM Disable
};

pack_dms_SetCustFeaturesV2_t SetCusFeaturesV2Req = 
{
    {0x57,0x41,0x4b,0x45,0x48,0x4f,0x53,0x54,0x45,0x4e},//"WAKEHOSTEN"
    1,
    {1,0},
    0
};
unpack_dms_SetCustFeaturesV2_t SetCustFeaturesV2Resp;

FMSPrefImageList fmsPrefImageList;

unpack_fms_GetImagesPreference_t getimagesPreference = {
    sizeof(FMSPrefImageList),
    &fmsPrefImageList,
    0
};

DMScustSettingInfo custSettInfo;
DMScustSettingList custSettList;
DMSgetCustomInput custSettInput;

pack_dms_GetCustFeaturesV2_t GetCusFeaturesV2Req =
{
    {0x57,0x41,0x4b,0x45,0x48,0x4f,0x53,0x54,0x45,0x4e},//"WAKEHOSTEN"
    0,
    0
};
unpack_dms_GetCustFeaturesV2_t GetCustFeaturesV2Resp =
{
    {
        &custSettInput,
        &custSettInfo,
        &custSettList
    },
    0
};

unpack_fms_GetStoredImages_t getStoredImages ;

pack_fms_SetImagesPreference_t packSetImagesPreference = {
    sizeof(FMSImageElement),
    &fmsPrefImageList,
    0,
    0xff,
    0
};

unpack_fms_SetImagesPreference_t setImagePreference ;

uint8_t SetsmsphoneNumber[SLQS_MAX_DYING_GASP_CFG_SMS_NUMBER_LENGTH]="+85224335433";
uint8_t SetsmsMessage[SLQS_MAX_DYING_GASP_CFG_SMS_CONTENT_LENGTH]="23456hello world1!";
uint8_t ModemSmsphoneNumber[SLQS_MAX_DYING_GASP_CFG_SMS_NUMBER_LENGTH]={0};
uint8_t ModemSmsMessage[SLQS_MAX_DYING_GASP_CFG_SMS_CONTENT_LENGTH]={0};
uint8_t GetSmsphoneNumber[SLQS_MAX_DYING_GASP_CFG_SMS_NUMBER_LENGTH]={0};
uint8_t GetSmsMessage[SLQS_MAX_DYING_GASP_CFG_SMS_CONTENT_LENGTH]={0};
pack_dms_SLQSSwiSetDyingGaspCfg_t packdmsSLQSSwiSetDyingGaspCfg={SetsmsphoneNumber,SetsmsMessage};
pack_dms_SLQSSwiSetDyingGaspCfg_t packModemdmsSLQSSwiSetDyingGaspCfg={ModemSmsphoneNumber,ModemSmsMessage};
packgetDyingGaspCfg pModemPackgetDyingGaspCfg={&ModemSmsphoneNumber[0],&ModemSmsMessage[0]};
packgetDyingGaspCfg pGetPackgetDyingGaspCfg={&GetSmsphoneNumber[0],&GetSmsMessage[0]};
unpack_dms_SLQSSwiGetDyingGaspCfg_t unpackModemdmsSLQSSwiGetDyingGaspCfg={&pModemPackgetDyingGaspCfg,0};
unpack_dms_SLQSSwiGetDyingGaspCfg_t unpackdmsSLQSSwiGetDyingGaspCfg={&pGetPackgetDyingGaspCfg,0};
unpack_dms_SLQSSwiSetDyingGaspCfg_t unpackdmsSLQSSwiSetDyingGaspCfg={0};
unpack_dms_SLQSSwiClearDyingGaspStatistics_t unpackdmsSLQSSwiClearDyingGaspStatistics={0};
uint32_t TimeStamp = -1;
uint8_t  SMSAttemptedFlag = -1;
packgetDyingGaspStatistics GetDyingGaspStatistics={&TimeStamp,&SMSAttemptedFlag};
unpack_dms_SLQSSwiGetDyingGaspStatistics_t unpackdmsSLQSSwiGetDyingGaspStatistics={&GetDyingGaspStatistics,0};


void dump_GetFirmwareInfo(void* ptr)
{
    unpack_dms_GetFirmwareInfo_t *pfwinfo =
        (unpack_dms_GetFirmwareInfo_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, pfwinfo->Tlvresult);
    printf("\tapp version: %s\n", pfwinfo->appversion_str);
    printf("\tCarrier Name: %s\n", pfwinfo->cur_carr_name);
    printf("\tCarrier Rev: %s\n", pfwinfo->cur_carr_rev);
}

void dump_GetPower(void* ptr)
{
    unpack_dms_GetPower_t *ppower =
        (unpack_dms_GetPower_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, ppower->Tlvresult);
    printf("\topmode: %d\n", ppower->OperationMode);
}

void dump_GetModelId(void* ptr)
{
    unpack_dms_GetModelID_t *pmodel =
        (unpack_dms_GetModelID_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, pmodel->Tlvresult);
    printf("\tmodelid: %s\n", pmodel->modelid);
}

void dump_GetIMSI(void* ptr)
{
    unpack_dms_GetIMSI_t *pimsi =
        (unpack_dms_GetIMSI_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__func__, pimsi->Tlvresult);
    printf("\timsi: %s\n", pimsi->imsi);
}

void dump_FirmwareRevisions(void* ptr)
{
    unpack_dms_GetFirmwareRevisions_t *firmwareRevisions =
            (unpack_dms_GetFirmwareRevisions_t*) ptr;
    printf("%s Result: %d\n",__FUNCTION__, firmwareRevisions->Tlvresult);
    printf("\tAMSS: %s\n", firmwareRevisions->AMSSString);
    printf("\tBoot: %s\n", firmwareRevisions->BootString);
    printf("\tPRI: %s\n", firmwareRevisions->PRIString);
}

void dump_FirmwareRevision(void* ptr)
{
    unpack_dms_GetFirmwareRevision_t *firmwareRevision =
            (unpack_dms_GetFirmwareRevision_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, firmwareRevision->Tlvresult);
    printf("\tAMSS: %s\n", firmwareRevision->AMSSString);
}

void dump_SLQSGetBandCapability(void* ptr)
{
    unpack_dms_SLQSGetBandCapability_t *pbandcap =
        (unpack_dms_SLQSGetBandCapability_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("bandcap: 0x%llX\n",  (unsigned long long) pbandcap->bandCapability);
}

void dump_GetDeviceSerialNumbers(void* ptr)
{
    unpack_dms_GetDeviceSerialNumbers_t *result =
            (unpack_dms_GetDeviceSerialNumbers_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tESN: %s\n", result->ESNString);
    printf("\tIMEI: %s\n", result->IMEIString);
    printf("\tIMEI SVN: %s\n", result->ImeiSvnString);
    printf("\tMEID: %s\n", result->MEIDString);
}

void dump_GetPRLVersion(void* ptr)
{
    unpack_dms_GetPRLVersion_t *result =
            (unpack_dms_GetPRLVersion_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tPRLPreference: %d\n", result->u8PRLPreference);
    printf("\tPRLVersion: %x\n", result->u16PRLVersion);
}

void dump_GetNetworkTime(void* ptr)
{
    unpack_dms_GetNetworkTime_t *result =
            (unpack_dms_GetNetworkTime_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tTime Source: %d\n", result->source);
    printf("\tTime Stamp: %lld\n", (unsigned long long) result->timestamp);
}

void dump_GetVoiceNumber(void* ptr)
{
    unpack_dms_GetVoiceNumber_t *result =
            (unpack_dms_GetVoiceNumber_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tMobile ID: %s\n", result->MIN);
    printf("\tVoice Number: %s\n", result->VoiceNumber);
}

void dump_GetDeviceHardwareRev(void* ptr)

{
    unpack_dms_GetDeviceHardwareRev_t *result =
            (unpack_dms_GetDeviceHardwareRev_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tHardware Revision: %s\n", result->String);
}
void dump_GetFSN(void* ptr)
{
    unpack_dms_GetFSN_t *result =
            (unpack_dms_GetFSN_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tFSN: %s\n", result->String);

}

void dump_GetDeviceCap(void* ptr)
{
    unpack_dms_GetDeviceCap_t *result =
            (unpack_dms_GetDeviceCap_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    uint32_t i = 0;
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tDataServiceCapability: %d\n", result->DataServiceCapability);
    printf("\tMaxRXChannelRate: %d\n", result->MaxRXChannelRate);
    printf("\tMaxTXChannelRate: %d\n", result->MaxTXChannelRate);
    printf("\tRadioIfacesSize: %d\n", result->RadioIfacesSize);
    for(i=0;i<result->RadioIfacesSize;i++)
        printf("\t\t%d.RadioIfaces: %d\n",i, result->RadioIfaces[i]);
    printf("\tSimCapability: %d\n", result->SimCapability);
}

void dump_SetPower(void* ptr)
{
    unpack_dms_SetPower_t *result =
            (unpack_dms_SetPower_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_GetBandCapability(void* ptr)
{
    unpack_dms_GetBandCapability_t *result =
            (unpack_dms_GetBandCapability_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tBandCapability: %x\n", result->BandCapability);

}

void dump_GetUSBComp(void * ptr)
{
    unpack_dms_GetUSBComp_t *result =
            (unpack_dms_GetUSBComp_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    int i =0;
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tCurrent USB Composition: %d\n", result->NumSupUSBComps);
    printf("\tCount of supported USB Compositions: %d\n", result->SupUSBComps);
    for(i=0;i<result->SupUSBComps ; i++)
        printf("\t\tSupported USB Compositions: %d\n", result->USBComp[i]);
}

void dump_SetUSBComp(void * ptr)
{
    unpack_dms_SetUSBComp_t *result =
            (unpack_dms_SetUSBComp_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}


void dump_SetCustFeature(void * ptr)
{
    unpack_dms_SetCustFeature_t *result =
            (unpack_dms_SetCustFeature_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_GetCustFeature(void * ptr)
{
    unpack_dms_GetCustFeature_t *result =
            (unpack_dms_GetCustFeature_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tDHCP Relay Enable: %d\n", result->DHCPRelayEnabled);
    printf("\tIMSI: %d\n", result->DisableIMSI);
    printf("\tGPS Enable: %d\n", result->GpsEnable);
    printf("\tGPS LPM Enable: %d\n", result->GPSLPM);
    printf("\tGPS Sel Enable: %d\n", result->GPSSel);
    printf("\tIP Family Support: %d\n", result->IPFamSupport);
    printf("\tVoice Enable: %d\n", result->IsVoiceEnabled);
    printf("\tRM Auto Connect: %d\n", result->RMAutoConnect);
    printf("\tSMS Support: %d\n", result->SMSSupport);
}

void dump_SetFirmwarePreference(void * ptr)
{
    unpack_dms_SetFirmwarePreference_t *result =
            (unpack_dms_SetFirmwarePreference_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_GetCrashAction(void * ptr)
{
    unpack_dms_GetCrashAction_t *result =
            (unpack_dms_GetCrashAction_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tCrash State: %d\n", result->DevCrashState);
}

void dump_GetDeviceMfr(void * ptr)
{
    unpack_dms_GetDeviceMfr_t *result =
            (unpack_dms_GetDeviceMfr_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tManufacturer: %s\n", result->String);
}

void dump_SetEventReport(void * ptr)
{
    unpack_dms_SetEventReport_t *result =
            (unpack_dms_SetEventReport_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_UIMGetICCID(void * ptr)
{
    unpack_dms_UIMGetICCID_t *result =
            (unpack_dms_UIMGetICCID_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("\tUIM ICCID: %s\n", result->String);
}

void dump_SetCustFeaturesV2(void * ptr)
{
    unpack_dms_SetCustFeaturesV2_t *result =
            (unpack_dms_SetCustFeaturesV2_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_GetCustFeaturesV2(void * ptr)
{
    unpack_dms_GetCustFeaturesV2_t *result =
            (unpack_dms_GetCustFeaturesV2_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    if(result->GetCustomFeatureV2.pCustSettingInfo)
    {
        int i = 0;
        uint8_t temp_value=0;
        uint64_t value = 0;
        printf( "Customization Setting:\n"\
                     "id length: %d\n", result->GetCustomFeatureV2.pCustSettingInfo->id_length );
        
        printf("custom id: %s \n", result->GetCustomFeatureV2.pCustSettingInfo->cust_id );
        printf("value length: %d\n", result->GetCustomFeatureV2.pCustSettingInfo->value_length );
        for ( i = 0; i < result->GetCustomFeatureV2.pCustSettingInfo->value_length; i++)
        {
            temp_value = result->GetCustomFeatureV2.pCustSettingInfo->cust_value[i];
            value = value | temp_value << (8*i);
        }
        printf(  "value id: %llu\n", (unsigned long long)  value);
        printf(  "custom attribute: %d\n", result->GetCustomFeatureV2.pCustSettingInfo->cust_attr);
    }

    if ( result->GetCustomFeatureV2.pCustSettingList != NULL)
    {
        int i = 0;
        uint8_t temp_value=0;
        uint64_t value = 0;
        
        printf("\nCustomization List:\n"\
                     "list type: %d\n",  result->GetCustomFeatureV2.pCustSettingList->list_type);
        printf("number instances: %d\n",  result->GetCustomFeatureV2.pCustSettingList->num_instances);
        for ( i = 0; i < result->GetCustomFeatureV2.pCustSettingList->num_instances; i++)
        {
            int j=0;
            /* reset custom value for every single custom filed */
            value = 0;
            printf("Instance[%i]:\n", i);
            printf("id length: %d\n",  result->GetCustomFeatureV2.pCustSettingList->custSetting[i].id_length);
            printf("custtom id: %s\n",  result->GetCustomFeatureV2.pCustSettingList->custSetting[i].cust_id);

            for ( j = 0; j < result->GetCustomFeatureV2.pCustSettingList->custSetting[i].value_length; j++ )
            {
                temp_value = result->GetCustomFeatureV2.pCustSettingList->custSetting[i].cust_value[j];
                value = value | temp_value << (8*j);
            }
            printf("custom value : %llu\n", (unsigned long long)  value);
            printf("custom attribute: %d\n", result->GetCustomFeatureV2.pCustSettingList->custSetting[i].cust_attr);
        }
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_FMS_GetImagesPreference(void * ptr)
{
    int idx = 0, i = 0;
    unpack_fms_GetImagesPreference_t *result =
            (unpack_fms_GetImagesPreference_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("GetImagesPreference Successful\n");

    printf("ImageList Size:: %d\n",
            result->ImageListSize);
    printf("Image Element Count:: %d",
                result->pImageList->listSize);
    for ( idx = 0;
          idx < result->pImageList->listSize;
          idx++ )
    {
        printf("\n\n\tImage Type:: %d\n",
                    result->pImageList->listEntries[idx].imageType);
        printf("\tImage Id::");
        for ( i = 0; i < 16; i++ )
            printf("%x",
                        result->pImageList->listEntries[idx].imageId[i]);
        printf("\n\tBuild Id Length:: %d\n",
                    result->pImageList->listEntries[idx].buildIdLength);
        printf("\tBuild Id :: ");
        for ( i = 0;
              i < result->pImageList->listEntries[idx].buildIdLength;

              i++ )
            printf("%c",
                        result->pImageList->listEntries[idx].buildId[i]);
    }
    printf("\n");
}

void  dump_FMS_GetStoredImages(void * ptr)
{
    //int idx = 0, i = 0;
    int idx1=0 , idx2 = 0, idx3 = 0;
    uint32_t rtn = 0;
    unpack_fms_GetStoredImages_t *result =
            (unpack_fms_GetStoredImages_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("Get Stored Images Successful\n");

    FMSImageList *pImageList = (FMSImageList *)&result->imageList;

    printf("Total Bytes Copied in Buf: %d\n", result->imagelistSize);
    printf("Image List Size: %d\n", pImageList->listSize );
    printf(" Image List Entries:\n" );
    for( idx1 = 0; idx1 < pImageList->listSize; idx1++ )
    {
         uint8_t imageIdEntries;
         printf("List Entry %d:\n", idx1 + 1 );
         printf("  Image Type: %d\n",
                 pImageList->imageIDEntries[idx1].imageType );
         printf("  Max Images: %d\n",
                 pImageList->imageIDEntries[idx1].maxImages );
         printf("  Executing Image Index: %x\n",
                 pImageList->imageIDEntries[idx1].executingImage );
         printf("  No. of Elements in Image ID List: %x\n",
                 pImageList->imageIDEntries[idx1].imageIDSize );
         imageIdEntries =
                 pImageList->imageIDEntries[idx1].imageIDSize ;

         printf("\tImage ID List Elements:\n" );
         for ( idx2 = 0; idx2 < imageIdEntries; idx2++ )
         {
             FMSImageIdElement *pImageIdElement = NULL;
             pImageIdElement = ( FMSImageIdElement *)
                                &pImageList->imageIDEntries[idx1].
                                imageIDElement[idx2];
              printf("\tImage ID List Element No.: %d\n",
                          idx2 + 1 );
              printf("\tStorage Index: 0x%x\n",
                          pImageIdElement->storageIndex );
              printf("\tfailure_count: 0x%x\n",
                          pImageIdElement->failureCount );
              printf("\tImage ID: " );
              for ( idx3 = 0; idx3 < 16; idx3++ )
              {
                   printf("0x%x ",
                                pImageIdElement->imageID[idx3] );
              }
              printf("\n");
              printf("\tBuild ID Length: %d\n",
                          pImageIdElement->buildIDLength );
              if( pImageIdElement->buildIDLength)
              {
                  printf("\tBuild ID:%s\n",
                              pImageIdElement->buildID );
              }
              printf("\n");
         }
         printf("\n");
    }
    printf("\n");
    CarrierImage_t sCarrierImage[50];
    uint32_t ValidCombinationSize = 50;
    uint32_t idx=0;
    memset(&sCarrierImage,0,sizeof(CarrierImage_t)*50);
    rtn = GetValidFwPriCombinations(&result->imageList,&ValidCombinationSize,sCarrierImage);
    printf("GetValidFwPriCombinations Result:%d\n",rtn);
     if (!rtn)
    {
        printf("Number of valid combibations: %d\n", ValidCombinationSize);
        printf("Combination details\n");
        for( idx = 0; idx < ValidCombinationSize; idx++ )
        {
            printf("Combination Index:: %d\n", idx);
            printf("  Carrier ID  : %u\n", sCarrierImage[idx].m_nCarrierId);
            printf("  Folder ID   : 0x%X\n", sCarrierImage[idx].m_nFolderId);
            printf("  Storage ID  : %u\n", sCarrierImage[idx].m_nStorage);
            printf("  PRI Build ID: %s\n", (char *)sCarrierImage[idx].m_PriBuildId);
            printf("  FW Build ID : %s\n", (char *)sCarrierImage[idx].m_FwBuildId);
            printf("  PRI Image ID: %s\n", (char *)sCarrierImage[idx].m_PriImageId);
            printf("  FW Image ID : %s\n", (char *)sCarrierImage[idx].m_FwImageId);
        }
    }

}


void  dump_FMS_SetImagesPreference(void * ptr)
{
    uint32_t i = 0;
     unpack_fms_SetImagesPreference_t *result =
            (unpack_fms_SetImagesPreference_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    printf("Image Type Size: %d\n", result->ImageTypesSize);
    for(i=0;i<result->ImageTypesSize;i++)
        printf("Image Type: %d:%d\n",i, result->ImageTypes[i]);

}

void dump_GetActivationState(void * ptr)
{
    unpack_dms_GetActivationState_t *result =
            (unpack_dms_GetActivationState_t*) ptr;
    if(ptr==NULL)
    {
        printf("%s NULL Data\n",__FUNCTION__);
        return;
    }
    printf("\tActivation State: %d\n", result->state);
}

void dump_SLQSSwiGetFirmwareCurr(void * ptr)
{
    int i;
    unpack_dms_SLQSSwiGetFirmwareCurr_t *pfwinfo =
        (unpack_dms_SLQSSwiGetFirmwareCurr_t*) ptr;

    for(i=0; i< pfwinfo->numEntries; i++)
    {
        printf("[%d] imageType/uniqueID/buildID: %d/%s/%s\n",
                i,
                pfwinfo->pCurrImgInfo[i].imageType,
                pfwinfo->pCurrImgInfo[i].uniqueID,
                pfwinfo->pCurrImgInfo[i].buildID);
    }
    printf("PRI Ver.: %s\n", pfwinfo->priver);
    printf("PKG Ver. : %s\n", pfwinfo->pkgver);
    printf("FW Ver. : %s\n", pfwinfo->fwvers);
    printf("Carrier : %s\n", pfwinfo->carrier);
}

void dump_SLQSSwiSetDyingGaspCfg(void * ptr)
{
    unpack_dms_SLQSSwiSetDyingGaspCfg_t *result =
        (unpack_dms_SLQSSwiSetDyingGaspCfg_t*) ptr;
    if(result)
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_SLQSSwiClearDyingGaspStatistics(void * ptr)
{
    unpack_dms_SLQSSwiClearDyingGaspStatistics_t *result =
        (unpack_dms_SLQSSwiClearDyingGaspStatistics_t*) ptr;
    if(result)
    printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
}

void dump_SLQSSwiGetDyingGaspStatistics(void * ptr)
{
    unpack_dms_SLQSSwiGetDyingGaspStatistics_t *result =
        (unpack_dms_SLQSSwiGetDyingGaspStatistics_t*) ptr;
    if(result)
    {
        if(result->pGetDyingGaspStatistics)
        {
            printf("%s SMS Attempted Flag: %d\n",__FUNCTION__, *(result->pGetDyingGaspStatistics->pSMSAttemptedFlag));
            printf("%s Time Stamp: %d\n",__FUNCTION__, *(result->pGetDyingGaspStatistics->pTimeStamp));
        }
        printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    }
}

void dump_SLQSSwiGetDyingGaspCfg(void * ptr)
{
    unpack_dms_SLQSSwiGetDyingGaspCfg_t *result =
        (unpack_dms_SLQSSwiGetDyingGaspCfg_t*) ptr;
    if(result)
    {
        if(result->pGetDyingGaspCfg)
        {
            printf("%s SMS Content: %s\n",__FUNCTION__, result->pGetDyingGaspCfg->pDestSMSContent);
            printf("%s Destination Number: %s\n",__FUNCTION__, result->pGetDyingGaspCfg->pDestSMSNum);
        }
        printf("%s Result: %d\n",__FUNCTION__, result->Tlvresult);
    }
}

testitem_t dmstotest[] = {
    {
        (pack_func) pack_dms_SLQSSwiGetFirmwareCurr, "pack_dms_SLQSSwiGetFirmwareCurr",
        NULL, 
        (unpack_func) unpack_dms_SLQSSwiGetFirmwareCurr, "unpack_dms_SLQSSwiGetFirmwareCurr",
        &cur_fw, dump_SLQSSwiGetFirmwareCurr
    },
    {
        (pack_func) pack_dms_SetEventReport, "pack_dms_SetEventReport",
        &SetEventReport[0], 
        (unpack_func) unpack_dms_SetEventReport, "unpack_dms_SetEventReport",
        &SetEventReportResp, dump_SetEventReport
    },
    {
        (pack_func) pack_dms_SetEventReport, "pack_dms_SetEventReport",
        &SetEventReport[1], 
        (unpack_func) unpack_dms_SetEventReport, "unpack_dms_SetEventReport",
        &SetEventReportResp, dump_SetEventReport
    },
    {
        (pack_func) pack_dms_SetEventReport, "pack_dms_SetEventReport",
        &SetEventReport[0], 
        (unpack_func) unpack_dms_SetEventReport, "unpack_dms_SetEventReport",
        &SetEventReportResp, dump_SetEventReport
    },
    {
        (pack_func) pack_dms_GetModelID, "pack_dms_GetModelID",
        NULL, 
        (unpack_func) unpack_dms_GetModelID, "unpack_dms_GetModelID",
        &model, dump_GetModelId
    },
    {
        (pack_func) pack_dms_GetFirmwareInfo, "pack_dms_GetFirmwareInfo",
        NULL, 
        (unpack_func) unpack_dms_GetFirmwareInfo, "unpack_dms_GetFirmwareInfo",
        &fwinfo, dump_GetFirmwareInfo
    },
    {
        (pack_func) pack_dms_GetPower, "pack_dms_GetPower",
        NULL, 
        (unpack_func) unpack_dms_GetPower, "unpack_dms_GetPower",
        &power, dump_GetPower
    },
    {
        (pack_func) pack_dms_GetFirmwareRevisions, "pack_dms_GetFirmwareRevisions",
        NULL, 
        (unpack_func) unpack_dms_GetFirmwareRevisions, "unpack_dms_GetFirmwareRevisions",
        &FirmwareRevisions, dump_FirmwareRevisions
    },
    {
        (pack_func) pack_dms_GetFirmwareRevision, "pack_dms_GetFirmwareRevision",
        NULL, 
        (unpack_func) unpack_dms_GetFirmwareRevision, "unpack_dms_GetFirmwareRevision",
        &FirmwareRevision, dump_FirmwareRevision
    },

    {
        (pack_func) pack_dms_GetDeviceSerialNumbers, "pack_dms_GetDeviceSerialNumbers",
        NULL, 
        (unpack_func) unpack_dms_GetDeviceSerialNumbers, "unpack_dms_GetDeviceSerialNumbers",
        &DeviceSerialNumbers, dump_GetDeviceSerialNumbers
    },
    {
        (pack_func) pack_dms_GetPRLVersion, "pack_dms_GetPRLVersion",
        NULL, 
        (unpack_func) unpack_dms_GetPRLVersion, "unpack_dms_GetPRLVersion",
        &PRLVersion, dump_GetPRLVersion
    },
    {
        (pack_func) pack_dms_GetNetworkTime, "pack_dms_GetNetworkTime",
        NULL, 
        (unpack_func) unpack_dms_GetNetworkTime, "unpack_dms_GetNetworkTime",
        &Time, dump_GetNetworkTime
    },
    {
        (pack_func) pack_dms_GetVoiceNumber, "pack_dms_GetVoiceNumber",
        NULL, 
        (unpack_func) unpack_dms_GetVoiceNumber, "unpack_dms_GetVoiceNumber",
        &VoiceNumber, dump_GetVoiceNumber
    },
    {
        (pack_func) pack_dms_GetDeviceHardwareRev, "pack_dms_GetDeviceHardwareRev",
        NULL, 
        (unpack_func) unpack_dms_GetDeviceHardwareRev, "unpack_dms_GetDeviceHardwareRev",
        &HardwareRev, dump_GetDeviceHardwareRev
    },

    {
        (pack_func) pack_dms_GetFSN, "pack_dms_GetFSN",
        NULL, 
        (unpack_func) unpack_dms_GetFSN, "unpack_dms_GetFSN",
        &FSN, dump_GetFSN
    },

    {
        (pack_func) pack_dms_GetDeviceCap, "pack_dms_GetDeviceCap",
        NULL, 
        (unpack_func) unpack_dms_GetDeviceCap, "unpack_dms_GetDeviceCap",
        &DeviceCap, dump_GetDeviceCap
    },
    {
        (pack_func) pack_dms_SetPower,  "pack_dms_SetPower",
        &SetPowerOnline,
        (unpack_func) unpack_dms_SetPower, "unpack_dms_SetPower",
        &SetPowerResp, dump_SetPower
    },
    {
        (pack_func) pack_dms_GetBandCapability, "pack_dms_GetBandCapability",
        NULL, 
        (unpack_func) unpack_dms_GetBandCapability, "unpack_dms_GetBandCapability",
        &BandCapability, dump_GetBandCapability
    },
    {
        (pack_func) pack_dms_GetUSBComp, "pack_dms_GetUSBComp",
        NULL, 
        (unpack_func) unpack_dms_GetUSBComp, "unpack_dms_GetUSBComp",
        &GetUSBComp, dump_GetUSBComp
    },
    {//MC/EM7455 might fail Version < SWI9X30C_02.05.07.00
        (pack_func) pack_dms_SetUSBComp, "pack_dms_SetUSBComp",
        NULL, 
        (unpack_func) unpack_dms_SetUSBComp, "unpack_dms_SetUSBComp",
        &SetUSBComp, dump_SetUSBComp
    },
    {//MC/EM7455 might fail Version < SWI9X30C_02.05.07.00
        (pack_func) pack_dms_SetUSBComp, "pack_dms_SetUSBComp",
        (void*)&SetUSBCompReq, 
        (unpack_func) unpack_dms_SetUSBComp, "unpack_dms_SetUSBComp",
        &SetUSBComp, dump_SetUSBComp
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[0], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[1], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[2], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[3], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[4], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[5], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[6], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[7], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_SetCustFeature, "pack_dms_SetCustFeature",
        (void*)&SetCusFeature[8], 
        (unpack_func) unpack_dms_SetCustFeature, "unpack_dms_SetCustFeature",
        &SetCusFeatureResp, dump_SetCustFeature
    },
    {
        (pack_func) pack_dms_GetCustFeature, "pack_dms_GetCustFeature",
        NULL, 
        (unpack_func) unpack_dms_GetCustFeature, "unpack_dms_GetCustFeature",
        &GetCusFeatureResp, dump_GetCustFeature
    },
    #if 0 // Cause modem reset
    {
        (pack_func) pack_dms_SetFirmwarePreference, "pack_dms_SetFirmwarePreference",
        NULL, 
        (unpack_func) unpack_dms_SetFirmwarePreference, "unpack_dms_SetFirmwarePreference",
        &SetFirmwarePreferenceResp, dump_SetFirmwarePreference
    },
    #endif
    {
        (pack_func) pack_dms_GetCrashAction, "pack_dms_GetCrashAction",
        NULL, 
        (unpack_func) unpack_dms_GetCrashAction, "unpack_dms_GetCrashAction",
        &GetCrashAction, dump_GetCrashAction
    },
    {
        (pack_func) pack_dms_GetDeviceMfr, "pack_dms_GetDeviceMfr",
        NULL, 
        (unpack_func) unpack_dms_GetDeviceMfr, "unpack_dms_GetDeviceMfr",
        &GetDeviceMfr, dump_GetDeviceMfr
    },
    {
        (pack_func) pack_dms_SLQSGetBandCapability, "pack_dms_SLQSGetBandCapability",
        NULL,
        (unpack_func) unpack_dms_SLQSGetBandCapability, "unpack_dms_SLQSGetBandCapability",
        &bandcap, dump_SLQSGetBandCapability
    },
    {
        (pack_func) pack_dms_UIMGetICCID, "pack_dms_UIMGetICCID",
        NULL, 
        (unpack_func) unpack_dms_UIMGetICCID, "unpack_dms_UIMGetICCID",
        &UIMGetICCIDResp, dump_UIMGetICCID
    },
    {
        (pack_func) pack_dms_SetCustFeaturesV2, "pack_dms_SetCustFeaturesV2",
        &SetCusFeaturesV2Req,
        (unpack_func) unpack_dms_SetCustFeaturesV2, "unpack_dms_SetCustFeaturesV2",
        &SetCustFeaturesV2Resp, dump_SetCustFeaturesV2
    },
    {
        (pack_func) pack_dms_GetCustFeaturesV2, "pack_dms_GetCustFeaturesV2",
        &GetCusFeaturesV2Req,
        (unpack_func) unpack_dms_GetCustFeaturesV2, "unpack_dms_GetCustFeaturesV2",
        &GetCustFeaturesV2Resp, dump_GetCustFeaturesV2
    },
    {
        (pack_func) pack_fms_GetImagesPreference, "pack_fms_GetImagesPreference",
        NULL, 
        (unpack_func) unpack_fms_GetImagesPreference, "unpack_fms_GetImagesPreference",
        &getimagesPreference, dump_FMS_GetImagesPreference
    },
    {
        (pack_func) pack_fms_GetStoredImages, "pack_fms_GetStoredImages",
        NULL, 
        (unpack_func) unpack_fms_GetStoredImages, "unpack_fms_GetStoredImages",
        &getStoredImages, dump_FMS_GetStoredImages
    },//setImagePreference using getimagesPreference information as input parameter.
    {
        (pack_func) pack_fms_SetImagesPreference, "pack_fms_SetImagesPreference",
        &packSetImagesPreference, 
        (unpack_func) unpack_fms_SetImagesPreference, "unpack_fms_SetImagesPreference",
        &setImagePreference, dump_FMS_SetImagesPreference
    },
    {
        (pack_func) pack_dms_GetActivationState, "pack_dms_GetActivationState",
        NULL, 
        (unpack_func) unpack_dms_GetActivationState, "unpack_dms_GetActivationState",
        &ActivationStateResp, dump_GetActivationState
    },
    {
        (pack_func) pack_dms_SLQSSwiGetDyingGaspCfg, "pack_dms_SLQSSwiGetDyingGaspCfg",
        NULL, 
        (unpack_func) unpack_dms_SLQSSwiGetDyingGaspCfg, "unpack_dms_SLQSSwiGetDyingGaspCfg",
        &unpackModemdmsSLQSSwiGetDyingGaspCfg, dump_SLQSSwiGetDyingGaspCfg
    },
    {
        (pack_func) pack_dms_SLQSSwiSetDyingGaspCfg, "pack_dms_SLQSSwiSetDyingGaspCfg",
        &packdmsSLQSSwiSetDyingGaspCfg, 
        (unpack_func) unpack_dms_SLQSSwiSetDyingGaspCfg, "unpack_dms_SLQSSwiSetDyingGaspCfg",
        &unpackdmsSLQSSwiSetDyingGaspCfg, dump_SLQSSwiSetDyingGaspCfg
    },
    {
        (pack_func) pack_dms_SLQSSwiGetDyingGaspCfg, "pack_dms_SLQSSwiGetDyingGaspCfg",
        NULL, 
        (unpack_func) unpack_dms_SLQSSwiGetDyingGaspCfg, "unpack_dms_SLQSSwiGetDyingGaspCfg",
        &unpackdmsSLQSSwiGetDyingGaspCfg, dump_SLQSSwiGetDyingGaspCfg
    },
    {
        (pack_func) pack_dms_SLQSSwiClearDyingGaspStatistics, "pack_dms_SLQSSwiClearDyingGaspStatistics",
        NULL, 
        (unpack_func) unpack_dms_SLQSSwiClearDyingGaspStatistics, "unpack_dms_SLQSSwiClearDyingGaspStatistics",
        &unpackdmsSLQSSwiClearDyingGaspStatistics, dump_SLQSSwiClearDyingGaspStatistics
    },
    {
        (pack_func) pack_dms_SLQSSwiGetDyingGaspStatistics, "pack_dms_SLQSSwiGetDyingGaspStatistics",
        NULL, 
        (unpack_func) unpack_dms_SLQSSwiGetDyingGaspStatistics, "unpack_dms_SLQSSwiGetDyingGaspStatistics",
        &unpackdmsSLQSSwiGetDyingGaspStatistics, dump_SLQSSwiGetDyingGaspStatistics
    },
    {
        (pack_func) pack_dms_SLQSSwiSetDyingGaspCfg, "pack_dms_SLQSSwiSetDyingGaspCfg",
        &packModemdmsSLQSSwiSetDyingGaspCfg, 
        (unpack_func) unpack_dms_SLQSSwiSetDyingGaspCfg, "unpack_dms_SLQSSwiSetDyingGaspCfg",
        &unpackdmsSLQSSwiSetDyingGaspCfg, dump_SLQSSwiSetDyingGaspCfg
    },
    {
        (pack_func) pack_dms_SLQSSwiGetDyingGaspCfg, "pack_dms_SLQSSwiGetDyingGaspCfg",
        NULL, 
        (unpack_func) unpack_dms_SLQSSwiGetDyingGaspCfg, "unpack_dms_SLQSSwiGetDyingGaspCfg",
        &unpackdmsSLQSSwiGetDyingGaspCfg, dump_SLQSSwiGetDyingGaspCfg
    },
};

/////////////////////////////////////////////////////////////

void dms_test_pack_unpack_loop()
{
    unsigned i;
    unsigned xid =1;
    printf("======DMS pack/unpack test===========\n");
    for(i=0; i<sizeof(dmstotest)/sizeof(testitem_t); i++)
    {
        unpack_qmi_t rsp_ctx;
        int rtn;
        pack_qmi_t req_ctx;
        uint8_t rsp[QMI_MSG_MAX];
        uint8_t req[QMI_MSG_MAX];
        uint16_t rspLen, reqLen;
        memset(&req_ctx, 0, sizeof(req_ctx));
        req_ctx.xid = xid;
        rtn = dmstotest[i].pack(&req_ctx, req, &reqLen,dmstotest[i].pack_ptr);
        if(rtn!=eQCWWAN_ERR_NONE)
        {
            continue;
        }
        if(dms<0)
            dms = client_fd(eDMS);
        rtn = write(dms, req, reqLen);
        if (rtn!=reqLen)
            printf("write %d wrote %d\n", reqLen, rtn);
        rspLen = read(dms, rsp, QMI_MSG_MAX);
        
        helper_get_resp_ctx(eDMS, rsp, rspLen, &rsp_ctx);

        if (rsp_ctx.xid == xid)
        {
            dmstotest[i].unpack(rsp, rspLen, dmstotest[i].unpack_ptr);
            dmstotest[i].dump(dmstotest[i].unpack_ptr);
        }
        xid++;
    }
    if(dms>=0)
        close(dms);
    dms=-1;
}

void dms_test_ind()
{
    pack_qmi_t req_ctx;
    uint8_t qmi_req[QMI_MSG_MAX];
    uint16_t qmi_req_len;
    int rtn;
    if(dms<0)
        dms = client_fd(eDMS);
    pack_dms_SetEventReport_t dmsReqPara;
    memset(&dmsReqPara,0,sizeof(pack_dms_SetEventReport_t));
    req_ctx.xid = 0x100;
    memset(&dms_attr, 0, sizeof(dms_attr));
    dmsReqPara.mode = DMS_SET_REPORT_ENABLE;
    rtn = pack_dms_SetEventReport(&req_ctx, qmi_req, &qmi_req_len, (void*)&dmsReqPara);
    if(rtn != eQCWWAN_ERR_NONE)
    {
        printf("Set Event Report Error\n");
        return ;
    }
    rtn = write(dms, qmi_req, qmi_req_len);
    if(rtn<0)
    {
        printf("Write Error Error\n");
        return ;
    }
    enDmsThread = 1;
    pthread_create(&dms_tid, &dms_attr, dms_read_thread, NULL);
    usleep(100);
    sleep(30);
}

void dms_test_ind_exit()
{
    void *pthread_rtn_value;
    enDmsThread = 0;
    printf("\nkilling DMS read thread...\n");
    UNUSEDPARAM(pthread_rtn_value);
    //pthread_join(dms_tid, &pthread_rtn_value);
    pthread_cancel(dms_tid);
    if(dms>=0)
        close(dms);
    dms = -1;
}




