#ifndef _PACKING_DEMO_H_
#define _PACKING_DEMO_H_
#include "common.h"
#include "msgid.h"
#include "qmerrno.h"

#define QMI_MSG_MAX (2048)

typedef int (* pack_func) (pack_qmi_t*, uint8_t*, uint16_t*, void*);
typedef int (* unpack_func) (uint8_t*, uint16_t, void*);
typedef void (* dump_func) (void*);

typedef struct{
    pack_func   pack;
    char pack_func_name[128];
    void*       pack_ptr;
    unpack_func unpack;
    char unpack_func_name[128];
    void*       unpack_ptr;
    dump_func   dump;
} testitem_t;

typedef struct{
    long type;
    uint8_t buf[QMI_MSG_MAX];
} msgbuf;

extern uint8_t g_qmi_req[QMI_MSG_MAX];
extern uint8_t g_rsp[QMI_MSG_MAX];
extern int client_fd(uint8_t svc);

#endif

