#*******************************************************************************
# Copyright (c) 2012 Sierra Wireless and others.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
#     Sierra Wireless - initial API and implementation
#*******************************************************************************

function(add_unit_test target sourceFile)

  foreach(_currentArg ${ARGN})

    if(${_currentArg} STREQUAL "TEST_TYPE")
      set(test_type "")
    else()
      if(DEFINED test_type AND "${test_type}" STREQUAL "")
	set(test_type ${_currentArg})
      endif()
    endif()

    if(${_currentArg} STREQUAL "TEST_DEPENDENCY")
      set(test_dependency "")
    else(${_currentArg} STREQUAL "TEST_DEPENDENCY")
      if (DEFINED test_dependency AND "${test_dependency}" STREQUAL "")
	set(test_dependency ${_currentArg})
      endif(DEFINED test_dependency AND "${test_dependency}" STREQUAL "")
    endif(${_currentArg} STREQUAL "TEST_DEPENDENCY")

    if(${_currentArg} STREQUAL "RUNTIME_DEPENDENCIES")
      set(runtime_dependencies "")
    else(${_currentArg} STREQUAL "RUNTIME_DEPENDENCIES")
      if(DEFINED runtime_dependencies)
    set(runtime_dependencies ${runtime_dependencies} ${_currentArg})
      endif(DEFINED runtime_dependencies)
    endif(${_currentArg} STREQUAL "RUNTIME_DEPENDENCIES")

  endforeach(_currentArg ${ARGN})


  if((${sourceFile} MATCHES ".c$") OR (${sourceFile} MATCHES ".cpp$"))

    add_executable(unittest_${target} EXCLUDE_FROM_ALL ${sourceFile})
    set_target_properties(unittest_${target} PROPERTIES OUTPUT_NAME ${target})


    if (SHARKS_BUILD)
      add_custom_target(unittest_${target}_upload
	COMMAND sshpass -p v3r1fym3 scp ${EMBEDDED_BINARY_DIR}/runtime/bin/${target} root@${SHARKS_IP_ADDR}:${EMBEDDED_REMOTE_TARGET_DIR}/bin
	DEPENDS unittest_${target}
      )
    endif(SHARKS_BUILD)

    foreach(dep ${runtime_dependencies})
      target_link_libraries(unittest_${target} ${dep})
    endforeach(dep ${runtime_dependencies})

    set(_target ${target})

  else()
    add_lua_library(unittest_${target} DESTINATION tests EXCLUDE_FROM_ALL ${sourceFile})

    if (SHARKS_BUILD)
      add_custom_target(unittest_${target}_upload
	COMMAND sshpass -p v3r1fym3 ssh root@${SHARKS_IP_ADDR} mkdir -p ${EMBEDDED_REMOTE_TARGET_DIR}/lua/tests
	COMMAND sshpass -p v3r1fym3 scp ${EMBEDDED_BINARY_DIR}/runtime/lua/tests/${sourceFile} root@${SHARKS_IP_ADDR}:${EMBEDDED_REMOTE_TARGET_DIR}/lua/tests/${sourceFile}
	DEPENDS unittest_${target}
      )
    endif(SHARKS_BUILD)


    set(_target ${sourceFile})
  endif((${sourceFile} MATCHES ".c$") OR (${sourceFile} MATCHES ".cpp$"))

  if (NOT DEFINED EMBEDDED_REMOTE_TARGET_DIR)
    set(EMBEDDED_REMOTE_TARGET_DIR ${EMBEDDED_BINARY_DIR}/runtime)
  endif(NOT DEFINED EMBEDDED_REMOTE_TARGET_DIR)

  if (DEFINED test_type)
    set(testwrapper_options "-t ${test_type}")
  endif()
  if (DEFINED test_dependency)
    set(testwrapper_options "${testwrapper_options} -l ${test_dependency}")
  endif(DEFINED test_dependency)

  set(test_command "ADD_TEST(${_target} ${UNITTEST_PREFIX_CMD} ${EMBEDDED_REMOTE_TARGET_DIR}/bin/lua ${EMBEDDED_REMOTE_TARGET_DIR}/racontestwrapper.lua ${testwrapper_options} ${_target})")

  if(TARGET test)
    file(APPEND ${EMBEDDED_BINARY_DIR}/DartTestfile.txt "${test_command}\n")
  else (TARGET test)
    add_custom_target(test
      COMMAND ctest -j`getconf _NPROCESSORS_ONLN` --output-on-failure --timeout 10
      WORKING_DIRECTORY ${EMBEDDED_BINARY_DIR}
    )
    if (SHARKS_BUILD)
      add_custom_target(start_dev_test_upload
      COMMAND sshpass -p v3r1fym3 scp ${CMAKE_INSTALL_PREFIX}/racontestwrapper.lua root@${SHARKS_IP_ADDR}:${EMBEDDED_REMOTE_TARGET_DIR}
      COMMAND sshpass -p v3r1fym3 scp -r ${CMAKE_INSTALL_PREFIX}/testwrapperfwk root@${SHARKS_IP_ADDR}:${EMBEDDED_REMOTE_TARGET_DIR}
      COMMAND sshpass -p v3r1fym3 scp ${CMAKE_INSTALL_PREFIX}/bin/lua root@${SHARKS_IP_ADDR}:${EMBEDDED_REMOTE_TARGET_DIR}/bin
      )
      add_dependencies(test start_dev_test_upload)
    endif (SHARKS_BUILD)
    file(WRITE ${EMBEDDED_BINARY_DIR}/DartTestfile.txt "# Don't touch this file ! It is automatically generated by cmake and will be overwritten\n")
    file(APPEND ${EMBEDDED_BINARY_DIR}/DartTestfile.txt "${test_command}\n")
  endif(TARGET test)

  add_dependencies(unittest_${target} start_dev_test)
  add_dependencies(test unittest_${target})

  if (SHARKS_BUILD)
    add_dependencies(test unittest_${target}_upload)
  endif(SHARKS_BUILD)

endfunction(add_unit_test)
