#!/bin/bash
#
# Applies all configs to the kernel, answers all new questions with enter (default)
# and updates config files.
#

rac() {
        ${1+"$@"}
        RVAL=$?
        if [ $RVAL -ne 0 ]; then
                echo "ERROR($RVAL): $@" 1>&2
                exit $RVAL
        fi
}

log() {
	echo "###################### $@ ######################"
}

export ARCH=arm

for i in config_*; do
	log "Cleaning"
	rac make distclean;
	log "Configuring for $i"
	rac cp "$i" .config
	yes "" | rac make oldconfig
	cp .config "$i"
done

log "final cleanup"
rac make distclean
