/*
 * Configuration settings for Netcomm / Bovine platform
 * Board: KEWEL
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef __CONFIG_NTC_KEWEL_H
#define __CONFIG_NTC_KEWEL_H

#define CONFIG_AM335X
#define CONFIG_TI81XX
#define CONFIG_SYS_NO_FLASH
#define CONFIG_NAND_ENV

/* Historically, all NTC TI specific code in U-Boot depends on this,
 * it's *not* Betzy board specific. */
#define CONFIG_NTC_BETZY

#include <asm/arch/cpu.h>		/* get chip and board defs */
#include <asm/arch/hardware.h>

/* Debug */
#ifndef __ASSEMBLY__
extern int debug_command_line;
extern int debug_nand_page;
#endif

#define KB *1024
#define MB KB*1024
#define GB MB*1024

#include <debug.h>

#define CDBG(...) if (debug_command_line) { DBG(__VA_ARGS__); }
#define CHEX(...) if (debug_command_line) { HEX(__VA_ARGS__); }


#define CONFIG_AM335X_HSMMC_INSTANCE	0	/* 0 - MMC0, 1 - MMC1 */

#include <config_cmd_default.h>

#define CONFIG_CMD_ASKENV

#define CONFIG_SYS_MALLOC_LEN		( 1 * 1024 * 1024 )

#define CONFIG_ENV_OVERWRITE		/* Allow change to MAC addr */
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_PROMPT		"U-Boot# "
/* Use HUSH parser to allow command parsing */
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_CMDLINE_TAG		/* enable passing of ATAGs */
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_CMDLINE_EDITING		1       /* add command line history     */
#define CONFIG_AUTO_COMPLETE		1
#define CONFIG_INITRD_TAG		/* Required for ramdisk support */
#define CONFIG_VERSION_VARIABLE 1

#if 0
#define CONFIG_CMD_NAND_TRIMFFS		1   /* Needed to skip erased pages during NAND write */
#endif

/* set to negative value for no autoboot */
#define CONFIG_BOOTDELAY		2
#define CONFIG_SILENT_CONSOLE

#define CONFIG_MMC
#define CONFIG_NAND
#define CONFIG_SPI

/* Some of these are just defaults and are overwritten during production.
 * In case of total environment meltdown, this will attempt to boot into
 * recovery. */
#define CONFIG_EXTRA_ENV_SETTINGS \
	"ethaddr=02:00:DE:AD:BE:EF\0" \
	"ipaddr=192.168.1.1\0" \
	"serverip=192.168.1.33\0" \
	"bootfile=uImage\0" \
	"loadaddr=0x82000000\0" \
	"kloadaddr=0x80007fc0\0" \
	"console=ttyO0,115200n8\0" \
	"nfsopts=nolock\0" \
	"static_ip=${ipaddr}:${serverip}:${gatewayip}:${netmask}:${hostname}" \
			"::off\0" \
	"ip_method=none\0" \
	"net_args=run bootargs_defaults;" \
		"setenv bootargs ${bootargs} " \
		"root=/dev/nfs " \
		"nfsroot=${serverip}:${rootpath},${nfsopts} rw " \
		"ip=dhcp\0" \
	"net_boot=echo Booting from network ...; " \
		"setenv autoload no; " \
		"dhcp; " \
		"tftp ${kloadaddr} ${bootfile}; " \
		"run net_args; " \
		"bootm ${kloadaddr}\0" \
	"part=if test X$mtdparts = X; then dynpart; saveenv; saveenv; fi\0" \
	"bootargs_r=console=ttyO0,115200n8 noinitrd rootwait=1 root=ubi0:rootfs rw ubi.mtd=rfs,2048 rootfstype=ubifs\0" \
	"emergency=env\0" \
	"bkern=nand read $kloadaddr $kpart; bootm $kloadaddr;\0" \
	"boot_recovery=setenv bootargs $bootargs_r emergency=$emergency $mtdparts; setenv kpart rkern; run bkern;\0" \
	"boot=run part; run boot_recovery;\0" \
	"bootcmd=run boot\0"


#define CONFIG_BOOTCOMMAND "run bootsel"

#define CONFIG_MISC_INIT_R
#define CONFIG_SYS_AUTOLOAD		"yes"
#define CONFIG_CMD_CACHE
#define CONFIG_CMD_ECHO

#define CONFIG_CMD_BOOTZ	

/* max number of command args */
#define CONFIG_SYS_MAXARGS		32
/* Console I/O Buffer Size */
#define CONFIG_SYS_CBSIZE		512
/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE \
					+ sizeof(CONFIG_SYS_PROMPT) + 16)
/* Boot Argument Buffer Size */
#define CONFIG_SYS_BARGSIZE		CONFIG_SYS_CBSIZE

/*
 * memtest works on 8 MB in DRAM after skipping 32MB from
 * start addr of ram disk
 */
#define CONFIG_SYS_MEMTEST_START	(PHYS_DRAM_1 + (64 MB))
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_MEMTEST_START + 1 MB)

#define CONFIG_SYS_LOAD_ADDR		0x81000000 /* Default load address */

 /* Physical Memory Map */
#define CONFIG_NR_DRAM_BANKS		1		/* 1 bank of DRAM */
#define PHYS_DRAM_1			0x80000000	/* DRAM Bank #1 */
#define PHYS_DRAM_1_SIZE		0x20000000	/* 512 MiB, even on boards with 128/256 fitted */

#define CONFIG_SYS_SDRAM_BASE		PHYS_DRAM_1
#define CONFIG_SYS_INIT_RAM_ADDR	SRAM0_START
#define CONFIG_SYS_INIT_RAM_SIZE	SRAM0_SIZE
#define CONFIG_SYS_INIT_SP_ADDR		(CONFIG_SYS_INIT_RAM_ADDR + \
					 CONFIG_SYS_INIT_RAM_SIZE - \
					 GENERATED_GBL_DATA_SIZE)

/* Defines for SPL */
#define CONFIG_SPL
#define CONFIG_SPL_BOARD_INIT
#define CONFIG_SPL_TEXT_BASE		0x402F0400 
/* #define CONFIG_SPL_TEXT_BASE		0x40300000 */
#define CONFIG_SPL_MAX_SIZE		(46 KB)
#define CONFIG_SPL_STACK		LOW_LEVEL_SRAM_STACK

#define CONFIG_SPL_BSS_START_ADDR	0x80000000
#define CONFIG_SPL_BSS_MAX_SIZE		0x80000		/* 512 KB */

#define CONFIG_SYS_MMCSD_RAW_MODE_U_BOOT_SECTOR	0x300 /* address 0x60000 */
#define CONFIG_SYS_U_BOOT_MAX_SIZE_SECTORS	0x200 /* 256 KB */
#define CONFIG_SYS_MMC_SD_FAT_BOOT_PARTITION	1
#define CONFIG_SPL_FAT_LOAD_PAYLOAD_NAME	"u-boot.img"
#define CONFIG_SPL_MMC_SUPPORT
#define CONFIG_SPL_FAT_SUPPORT

#define CONFIG_SPL_LIBCOMMON_SUPPORT
#define CONFIG_SPL_LIBDISK_SUPPORT
#define CONFIG_SPL_I2C_SUPPORT
#define CONFIG_SPL_LIBGENERIC_SUPPORT
#define CONFIG_SPL_SERIAL_SUPPORT
#define CONFIG_SPL_YMODEM_SUPPORT
#define CONFIG_SPL_POWER_SUPPORT
#define CONFIG_SPL_LDSCRIPT		"$(CPUDIR)/omap-common/u-boot-spl.lds"

/* NAND boot config */
#define CONFIG_SPL_NAND_SIMPLE
#define CONFIG_SPL_NAND_SUPPORT
#define CONFIG_SYS_NAND_5_ADDR_CYCLE
#define CONFIG_SYS_NAND_PAGE_COUNT	(CONFIG_SYS_NAND_BLOCK_SIZE / \
					 CONFIG_SYS_NAND_PAGE_SIZE)
#define CONFIG_SYS_NAND_PAGE_SIZE	2048
#define CONFIG_SYS_NAND_OOBSIZE		64
#define CONFIG_SYS_NAND_BLOCK_SIZE	(128*1024)
#define CONFIG_SYS_NAND_BAD_BLOCK_POS	NAND_LARGE_BADBLOCK_POS
#define CONFIG_SYS_NAND_ECCPOS		{ 2, 3, 4, 5, 6, 7, 8, 9, \
					 10, 11, 12, 13, 14, 15, 16, 17, \
					 18, 19, 20, 21, 22, 23, 24, 25, \
					 26, 27, 28, 29, 30, 31, 32, 33, \
					 34, 35, 36, 37, 38, 39, 40, 41, \
					 42, 43, 44, 45, 46, 47, 48, 49, \
					 50, 51, 52, 53, 54, 55, 56, 57, }

#define CONFIG_SYS_NAND_ECCSIZE		512
#define CONFIG_SYS_NAND_ECCBYTES	14

#define CONFIG_SYS_NAND_ECCSTEPS	4
#define	CONFIG_SYS_NAND_ECCTOTAL	(CONFIG_SYS_NAND_ECCBYTES * \
						CONFIG_SYS_NAND_ECCSTEPS)

#define	CONFIG_SYS_NAND_U_BOOT_START	CONFIG_SYS_TEXT_BASE

#define CONFIG_SYS_NAND_U_BOOT_OFFS	0x80000

#define CONFIG_DYNPART_SIZE { 3 M,      5 M,     13 M,  5 M,      48 M,   32 M,  FILL, 0 }
#define	CONFIG_DYNPART_NAMES { "S1S2EN", "rkern", "rfs", "kernel", "root", "usr", "opt", NULL }

/*
 * 8MB into the SDRAM to allow for SPL's bss at the beginning of SDRAM.
 * 64 bytes before this address should be set aside for u-boot.img's
 * header. That is 0x807FFFC0--0x80800000 should not be used for any
 * other needs.
 */
#define CONFIG_SYS_TEXT_BASE		0x80800000

#define CONFIG_DISPLAY_CPUINFO

/* Since SPL did all of this for us, we don't need to do it twice. */
#ifndef CONFIG_SPL_BUILD
#define CONFIG_SKIP_LOWLEVEL_INIT
#endif

/**
 * Clock related defines
 */
#define V_OSCK				24000000 /* Clock output from T2 */
#define V_SCLK				(V_OSCK)
#define CONFIG_SYS_TIMERBASE		0x48040000	/* Use Timer2 */
#define CONFIG_SYS_PTV			2	/* Divisor: 2^(PTV+1) => 8 */
#define CONFIG_SYS_HZ			1000

/* NS16550 Configuration */
#define CONFIG_SYS_NS16550
#define CONFIG_SYS_NS16550_SERIAL
#define CONFIG_SYS_NS16550_REG_SIZE	(-4)
#define CONFIG_SYS_NS16550_CLK		(48000000)
#define CONFIG_SYS_NS16550_COM1		0x44e09000	/* Base EVM has UART0 */
#define CONFIG_SYS_NS16550_COM4		0x481A6000	/* UART3 on IA BOard */

#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{ 110, 300, 600, 1200, 2400, \
4800, 9600, 14400, 19200, 28800, 38400, 56000, 57600, 115200 }

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1			1
#define CONFIG_CONS_INDEX		1
#define CONFIG_SYS_CONSOLE_INFO_QUIET

#if defined(CONFIG_NO_ETH)
# undef CONFIG_CMD_NET
#else
# define CONFIG_CMD_DHCP
# define CONFIG_CMD_PING
#endif

#if defined(CONFIG_CMD_NET)

# define CONFIG_DRIVER_TI_CPSW

/* The Pads on the MDIO pins have a hardware bug and cause
 * glitches, similar to I2C. We use a bit-banging MDIO implementation
 * instead. */
# define CONFIG_BITBANGMII
# define CONFIG_BITBANGMII_MULTI

# define CONFIG_MII
# define CONFIG_CMD_MII
# define CONFIG_BOOTP_DEFAULT
# define CONFIG_BOOTP_DNS
# define CONFIG_BOOTP_DNS2
# define CONFIG_BOOTP_SEND_HOSTNAME
# define CONFIG_BOOTP_GATEWAY
# define CONFIG_BOOTP_SUBNETMASK
# define CONFIG_NET_RETRY_COUNT		10
# define CONFIG_NET_MULTI

# define CONFIG_PHYLIB
# define CONFIG_PHY_GIGE

# define CONFIG_ETHTEST          /* Netcomm Ethernet testing infrastructure */
# define CONFIG_ETHTEST_QUALCOMM

#endif

#if defined(CONFIG_SYS_NO_FLASH)
# define CONFIG_ENV_IS_NOWHERE
#endif

/* bootz support for Ubuntu Snappy images */
#define CONFIG_SUPPORT_RAW_INITRD 
#define CONFIG_OF_LIBFDT		1

/* NAND support */
#ifdef CONFIG_NAND

#define CONFIG_CMD_MTDPARTS	/* Partition support */
#define CONFIG_MTD_DEVICE
#define CONFIG_CMD_MTDPARTS_SHOW_NET_SIZES
#define CONFIG_CMD_MTDPARTS_SPREAD

/* Dynamic partitions. */
#define CONFIG_NAND_DYNPART
#define MTDIDS_DEFAULT "nand0=omap2-nand.0"
#undef  MTDPARTS_DEFAULT
#define CFG_NAND_DYNPART_MTD_KERNEL_NAME "omap2-nand.0"

#define CONFIG_CMD_NAND
#define CONFIG_NAND_TI81XX
#define GPMC_NAND_ECC_LP_x16_LAYOUT	0
#define NAND_BASE			(0x08000000)
#define CONFIG_SYS_NAND_ADDR		NAND_BASE	/* physical address */
							/* to access nand */
#define CONFIG_SYS_NAND_BASE		NAND_BASE	/* physical address */
							/* to access nand at */
							/* CS0 */
#define CONFIG_SYS_MAX_NAND_DEVICE	1		/* Max number of NAND */
#endif							/* devices */

/* ENV in NAND */
#if defined(CONFIG_NAND_ENV)
#undef CONFIG_ENV_IS_NOWHERE

#if 1
	/* Netcomm high reliability format */
	#define CONFIG_ENV_IS_IN_NAND_REL	1
	#define CONFIG_ENV_OFFSET		0x200000 /* environments start here */
	#define CONFIG_ENV_SIZE			(8 KB)   /* 1-2 pages */
	#define CONFIG_ENV_PERBLOCK		4	 /* 4 envs stored per erase block */
	#define CONFIG_ENV_MAX			(1 MB)
#else
	#define CONFIG_ENV_IS_IN_NAND
	#define CONFIG_ENV_OFFSET		0x280000 /* environments start here */
	#define CONFIG_ENV_SIZE			(8 KB)   /* 1-2 pages */
	#define CONFIG_SYS_ENV_SECT_SIZE	(256 << 10)	/* 256 KiB, allowing for larger eraseblock NAND. */
	#define CONFIG_ENV_OFFSET_REDUND	(CONFIG_ENV_OFFSET + CONFIG_SYS_ENV_SECT_SIZE)
#endif
#define CONFIG_SYS_REDUNDAND_ENVIRONMENT
#define CONFIG_SYS_MAX_FLASH_SECT	520 /* max no of sectors in a chip */
#define CONFIG_SYS_MAX_FLASH_BANKS	2 /* max no of flash banks */
#define CONFIG_SYS_MONITOR_LEN		(256 << 10) /* Reserve 2 sectors */
#define CONFIG_SYS_FLASH_BASE		PISMO1_NAND_BASE
#define CONFIG_SYS_MONITOR_BASE		CONFIG_SYS_FLASH_BASE
#endif /* NAND support */


/* I2C */
#define CONFIG_I2C
#define CONFIG_CMD_I2C
#define CONFIG_HARD_I2C
#define CONFIG_SYS_I2C_SPEED		100000
#define CONFIG_SYS_I2C_SLAVE		1
#define CONFIG_I2C_MULTI_BUS
#define CONFIG_DRIVER_TI81XX_I2C

/* HSMMC support */
#ifdef CONFIG_MMC
#if (CONFIG_AM335X_HSMMC_INSTANCE == 0)
#define CONFIG_AM335X_HSMMC_BASE	0x48060100
#else
#define CONFIG_AM335X_HSMMC_BASE	0x481D8100
#endif
#define CONFIG_GENERIC_MMC
#define CONFIG_OMAP_HSMMC
#define CONFIG_CMD_MMC
#define CONFIG_DOS_PARTITION
#define CONFIG_CMD_FAT
#define CONFIG_CMD_EXT2
#endif

/* Unsupported features */
#undef CONFIG_USE_IRQ

#endif	/* ! __CONFIG_AM335X_EVM_H */
