/**
 * \ingroup voice
 *
 * \file    qaGobiApiTableCallControlReturnReasons.h
 *
 * \brief   Call Control Return Reasons table
 *
 * \section Table10 Call Control Result Reasons (Value - Name - Description)
 * \li 0x01 - QMI_VOICE_REASON_FWD_UNCONDITIONAL - Unconditional call forwarding
 * \li 0x02 - QMI_VOICE_REASON_FWD_MOBILEBUSY - Forward when the mobile is busy
 * \li 0x03 - QMI_VOICE_REASON_FWD_NOREPLY - Forward when there is no reply
 * \li 0x04 - QMI_VOICE_REASON_FWD_UNREACHABLE - Forward when the call is unreachable
 * \li 0x05 - QMI_VOICE_REASON_FWD_ALLFORWARDING - All forwarding
 * \li 0x06 - QMI_VOICE_REASON_FWD_ALLCONDITIONAL - All conditional forwarding
 * \li 0x07 - QMI_VOICE_REASON_BARR_ALLOUTGOING - All outgoing
 * \li 0x08 - QMI_VOICE_REASON_BARR_OUTGOINGINT - Outgoing internal
 * \li 0x09 - QMI_VOICE_REASON_BARR_OUTGOINGINTEXTOHOME - Outgoing external to home
 * \li 0x0A - QMI_VOICE_REASON_BARR_ALLINCOMING - All incoming
 * \li 0x0B - QMI_VOICE_REASON_BARR_INCOMINGROAMING - Roaming incoming
 * \li 0x0C - QMI_VOICE_REASON_BARR_ALLBARRING - All calls are barred
 * \li 0x0D - QMI_VOICE_REASON_BARR_ALLOUTGOINGBARRING - All outgoing calls are barred
 * \li 0x0E - QMI_VOICE_REASON_BARR_ALLINCOMINGBARRING - All incoming calls are barred
 * \li 0x0F - QMI_VOICE_REASON_CALLWAITING - Call waiting
 * \li 0x10 - VOICE_CC_SUPS_RESULT_REASON_CLIP - CLIP
 * \li 0x11 - VOICE_CC_SUPS_RESULT_REASON_CLIR - CLIR
 * \li 0x12 - VOICE_CC_SUPS_RESULT_REASON_COLP - COLP
 * \li 0x13 - VOICE_CC_SUPS_RESULT_REASON_COLR - COLR
 * \li 0x14 - VOICE_CC_SUPS_RESULT_REASON_CNAP - CNAP
 * \li 0xFF - Not Available
 *
 * Copyright: © 2012 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef __GOBI_API_CALL_CONTROL_RETURN_REASONS_H__
#define __GOBI_API_CALL_CONTROL_RETURN_REASONS_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
} /* extern "C" { */
#endif

#endif /* __GOBI_API_CALL_CONTROL_RETURN_REASONS_H__ */
