
#ifndef DEBUG_H
#define DEBUG_H

#define DBG(fmt,...) printf("[%s:%d] " fmt,__func__,__LINE__,##__VA_ARGS__)
#define DINT(var)    DBG(#var "=%ld\n",(long int)var)
#define HEX(b,s) do {\
	char *_p = (char*)b;\
	int len=s,n=0;\
	DBG(#b " [%p] ", (void*)_p ); \
	while (len--) {\
		printf("%02X ",*(_p++));\
		if (++n >= 32) { n=0; printf("\n"); DBG(#b " [%p] ", (void*)_p); }\
	}\
	printf("\n");\
} while (0)

#ifdef PARANOIA
#define ASSERT(cond) do { if (!(cond)) { \
	DBG("####### Assertion %s failed\n",#cond); \
	while(1); \
	}} while(0)
#else
#define ASSERT(cond) do { (void)(cond); } while(0)
#endif

#endif /* DEBUG_H */
