/*
 * ntc_betzy.c
 *
 * Copyright (C) 2012 NetComm Wireless Limited - http://www.netcommwireless.com/
 *
 * Based on evm.c Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#include <cdcs_variant.h>

#include <common.h>
#include <asm/cache.h>
#include <asm/omap_common.h>
#include <asm/io.h>
#include <asm/arch/cpu.h>
#include <asm/arch/ddr_defs.h>
#include <asm/arch/hardware.h>
#include <asm/arch/mmc_host_def.h>
#include <asm/arch/sys_proto.h>
#include <asm/arch/mem.h>
#include <asm/arch/nand.h>
#include <asm/arch/clock.h>
#include <linux/mtd/nand.h>
#include <nand.h>
#include <net.h>
#include <miiphy.h>
#include <netdev.h>
#include <spi_flash.h>

#include "common_def.h"
#include "pmic.h"
#include "tps65217.h"

#include <i2c.h>
#include <serial.h>

#include "mux.h"
#include "gpio.h"
#include "debug.h"

DECLARE_GLOBAL_DATA_PTR;

/* UART Defines */
#define UART_SYSCFG_OFFSET	(0x54)
#define UART_SYSSTS_OFFSET	(0x58)

#define UART_RESET		(0x1 << 1)
#define UART_CLK_RUNNING_MASK	0x1
#define UART_SMART_IDLE_EN	(0x1 << 0x3)

/* Timer Defines */
#define TSICR_REG		0x54
#define TIOCP_CFG_REG	0x10
#define TCLR_REG		0x38

/* CPLD registers */
#define CFG_REG			0x10

/*
 * I2C Address of various board
 */
#define I2C_BASE_BOARD_ADDR		0x50
#define I2C_DAUGHTER_BOARD_ADDR 0x51
#define I2C_LCD_BOARD_ADDR		0x52

#define I2C_CPLD_ADDR			0x35

/* RGMII mode define */
/* WARNING: the RGMII_MODE_ENABLE value used an unsupported
 * feature of the processor: RGMII TxCLK delay. According to
 * the datasheet, 0 in bits 4 & 5 is 'reserved' and only 1
 * (no delay) is allowed. We are now using PHY features to
 * insert an appropriate delay into the TxClk. */
#define RGMII_MODE_ENABLE		(0xA | (1<<4) | (1<<5)) /* Enables RGMII on port 1 & 2, no TxDelay */
#define RMII_MODE_ENABLE		(0x5) /* internal refclock */
#define RMII_MODE_EXTREF		(RMII_MODE_ENABLE | (1<<6) | (1<<7)) /* external refclock */
#define MII_MODE_ENABLE			0x0

#define NO_OF_MAC_ADDR          3
#define ETH_ALEN		6

/* Dynamic Partitions */
#define G *0x40000000ULL
#define M *0x100000ULL
#define FILL ( 8 G )          /* The OPT partition grows up to this. Assumes 8G max, increase if necessary. */

// patern for testing Memory Low byte and High byte in DDR3 16 bit.
#define DDR3_Pattern_7_0		0x00ff00ff
#define DDR3_Pattern_15_8		0xff00ff00
#define DDR3_Pattern_full		0xffffffff
#define DDR3_Mask_Pattern		DDR3_Pattern_full


/* The S1S2EN partition contains the boot loaders (MLO, U-Boot + env):
	0x00000000-> SPL start         (SPL copy on 1st block)
	0x0001FFFF-> SPL end

	0x00020000-> SPL.backup1 start (SPL copy on 2nd block)
	0x0003FFFF-> SPL.backup1 end

	0x00040000-> SPL.backup2 start (SPL copy on 3rd block)
	0x0005FFFF-> SPL.backup2 end

	0x00060000-> SPL.backup3 start (SPL copy on 4th block)
	0x0007FFFF-> SPL.backup3 end

	0x00080000-> U-Boot start
	0x001FFFFF-> U-Boot end

	0x00200000-> ENV start (uenv)

	0x00280000-> Omap ENV0, size blocks of 256K (1-2 eraseblocks)
	0x002C0000-> Omap ENV1, (max 2, but skips bad blocks, straight into first kernel)

	0x002FFFFF-> ENV end

We reserve some space at the end to allow for larger block NAND later,
which requires an additional 256K for redundant environment. Rounding
up to 3M.

Then we define two kernels/rootfs partition pairs, followed by a large
partition of whatever is left.
*/

#if  defined V_IOBOARD_elaine

	#define PINMUX_WORKAROUND /* Otherwise the RMII refclock breaks */

#endif

/*
 * Flash memory layout configuration has been moved to board config files in
 * include/configs
 */

#if !defined CONFIG_DYNPART_SIZE
	#error "Flash partition size configuration not set check board config file"
#endif 

#if !defined CONFIG_DYNPART_NAMES
	#error "Flash partition names configuration not set check board config file"
#endif 

loff_t dynpart_size[] = CONFIG_DYNPART_SIZE;
char *dynpart_names[] = CONFIG_DYNPART_NAMES;

/* #define DEBUG */

struct am335x_baseboard_id {
	unsigned int  magic;
	char name[8];
	char version[4];
	char serial[12];
	char config[32];
	char mac_addr[NO_OF_MAC_ADDR][ETH_ALEN];
};

extern void cpsw_eth_set_mac_addr(const u_int8_t *addr);

static volatile int board_id = BETZY_BOARD;

/* Probe memory size, 64MB to 512MB.
 * Make sure that the SDRAM controller is programmed (in SPL/MLO)
 * to support up to 512MB. This mechanism only works if the RAM
 * chips differ in row number only. */
static uint32_t probe_ramsize(void)
{
	volatile uint32_t *ram = (volatile uint32_t *)PHYS_DRAM_1;
	#define RO(M) (((unsigned)M) MB / sizeof(uint32_t))
	/* List is candidate memory locations in MB */
	const uint32_t list[] = { 0, 64, 128, 256, 512 };
	#define MAXL (sizeof(list)/sizeof(uint32_t))
	uint32_t save[MAXL];
	uint32_t rval = 0;
	int i;

	/* Save locations */
	for (i = 0; i < MAXL; i++) {
		save[i] = ram[RO(list[i])];
		//printf("ram[%d] = 0x%08x\n", list[i], save[i]);
	}

	/* Check where memory wraps */
	ram[0] = 0;
	for (i = 1; i < MAXL; i++) {
		ram[RO(list[i])] = 0xFFFFFFFF;
		rval = list[i] MB;
		if (ram[0] != 0) {
			break;
		}
	}

	/* Restore loctions */
	for (i = 0; i < MAXL; i++) {
		ram[RO(list[i])] = save[i];
	}

	return rval;
}

int dram_init(void)
{
	/* single CS only, otherwise this should be sum of all areas. */
	gd->ram_size = probe_ramsize();
	return 0;
}

void dram_init_banksize (void)
{
	/* Fill up board info. System supports only one CS */
	gd->bd->bi_dram[0].start = PHYS_DRAM_1;
	gd->bd->bi_dram[0].size = gd->ram_size;
}

#ifdef CONFIG_SPL_BUILD

static void config_vtp(void)
{
	__raw_writel(__raw_readl(VTP0_CTRL_REG) | VTP_CTRL_ENABLE, VTP0_CTRL_REG);
	__raw_writel(__raw_readl(VTP0_CTRL_REG) & (~VTP_CTRL_START_EN), VTP0_CTRL_REG);
	__raw_writel(__raw_readl(VTP0_CTRL_REG) | VTP_CTRL_START_EN, VTP0_CTRL_REG);

	/* Poll for READY */
	while ((__raw_readl(VTP0_CTRL_REG) & VTP_CTRL_READY) != VTP_CTRL_READY);

}

#ifndef V_SDRAMTYPE_DDR3 /* Configuring DDR2 RAM */

static void Data_Macro_Config(int dataMacroNum)
{
	u32 BaseAddrOffset = 0x00;;

	if (dataMacroNum == 1)
		BaseAddrOffset = 0xA4;

	__raw_writel(((DDR2_RD_DQS<<30)|(DDR2_RD_DQS<<20)
			|(DDR2_RD_DQS<<10)|(DDR2_RD_DQS<<0)),
			(DATA0_RD_DQS_SLAVE_RATIO_0 + BaseAddrOffset));
	__raw_writel(DDR2_RD_DQS>>2,
			(DATA0_RD_DQS_SLAVE_RATIO_1 + BaseAddrOffset));
	__raw_writel(((DDR2_WR_DQS<<30)|(DDR2_WR_DQS<<20)
			|(DDR2_WR_DQS<<10)|(DDR2_WR_DQS<<0)),
			(DATA0_WR_DQS_SLAVE_RATIO_0 + BaseAddrOffset));
	__raw_writel(DDR2_WR_DQS>>2,
			(DATA0_WR_DQS_SLAVE_RATIO_1 + BaseAddrOffset));
	__raw_writel(((DDR2_PHY_WRLVL<<30)|(DDR2_PHY_WRLVL<<20)
			|(DDR2_PHY_WRLVL<<10)|(DDR2_PHY_WRLVL<<0)),
			(DATA0_WRLVL_INIT_RATIO_0 + BaseAddrOffset));
	__raw_writel(DDR2_PHY_WRLVL>>2,
			(DATA0_WRLVL_INIT_RATIO_1 + BaseAddrOffset));
	__raw_writel(((DDR2_PHY_GATELVL<<30)|(DDR2_PHY_GATELVL<<20)
			|(DDR2_PHY_GATELVL<<10)|(DDR2_PHY_GATELVL<<0)),
			(DATA0_GATELVL_INIT_RATIO_0 + BaseAddrOffset));
	__raw_writel(DDR2_PHY_GATELVL>>2,
			(DATA0_GATELVL_INIT_RATIO_1 + BaseAddrOffset));
	__raw_writel(((DDR2_PHY_FIFO_WE<<30)|(DDR2_PHY_FIFO_WE<<20)
			|(DDR2_PHY_FIFO_WE<<10)|(DDR2_PHY_FIFO_WE<<0)),
			(DATA0_FIFO_WE_SLAVE_RATIO_0 + BaseAddrOffset));
	__raw_writel(DDR2_PHY_FIFO_WE>>2,
			(DATA0_FIFO_WE_SLAVE_RATIO_1 + BaseAddrOffset));
	__raw_writel(((DDR2_PHY_WR_DATA<<30)|(DDR2_PHY_WR_DATA<<20)
			|(DDR2_PHY_WR_DATA<<10)|(DDR2_PHY_WR_DATA<<0)),
			(DATA0_WR_DATA_SLAVE_RATIO_0 + BaseAddrOffset));
	__raw_writel(DDR2_PHY_WR_DATA>>2,
			(DATA0_WR_DATA_SLAVE_RATIO_1 + BaseAddrOffset));
	__raw_writel(PHY_DLL_LOCK_DIFF,
			(DATA0_DLL_LOCK_DIFF_0 + BaseAddrOffset));

}

static void Cmd_Macro_Config(void)
{

	__raw_writel(DDR2_RATIO, CMD0_CTRL_SLAVE_RATIO_0);
	__raw_writel(CMD_FORCE, CMD0_CTRL_SLAVE_FORCE_0);
	__raw_writel(CMD_DELAY, CMD0_CTRL_SLAVE_DELAY_0);
	__raw_writel(DDR2_DLL_LOCK_DIFF, CMD0_DLL_LOCK_DIFF_0);
	__raw_writel(DDR2_INVERT_CLKOUT, CMD0_INVERT_CLKOUT_0);

	__raw_writel(DDR2_RATIO, CMD1_CTRL_SLAVE_RATIO_0);
	__raw_writel(CMD_FORCE, CMD1_CTRL_SLAVE_FORCE_0);
	__raw_writel(CMD_DELAY, CMD1_CTRL_SLAVE_DELAY_0);
	__raw_writel(DDR2_DLL_LOCK_DIFF, CMD1_DLL_LOCK_DIFF_0);
	__raw_writel(DDR2_INVERT_CLKOUT, CMD1_INVERT_CLKOUT_0);

	__raw_writel(DDR2_RATIO, CMD2_CTRL_SLAVE_RATIO_0);
	__raw_writel(CMD_FORCE, CMD2_CTRL_SLAVE_FORCE_0);
	__raw_writel(CMD_DELAY, CMD2_CTRL_SLAVE_DELAY_0);
	__raw_writel(DDR2_DLL_LOCK_DIFF, CMD2_DLL_LOCK_DIFF_0);
	__raw_writel(DDR2_INVERT_CLKOUT, CMD2_INVERT_CLKOUT_0);

}

static void config_emif_dram(void)
{
	u32 i;


	/*Program EMIF0 CFG Registers*/
	__raw_writel(EMIF_READ_LATENCY, EMIF4_0_DDR_PHY_CTRL_1);
	__raw_writel(EMIF_READ_LATENCY, EMIF4_0_DDR_PHY_CTRL_1_SHADOW);
	__raw_writel(EMIF_READ_LATENCY, EMIF4_0_DDR_PHY_CTRL_2);
	__raw_writel(EMIF_TIM1, EMIF4_0_SDRAM_TIM_1);
	__raw_writel(EMIF_TIM1, EMIF4_0_SDRAM_TIM_1_SHADOW);
	__raw_writel(EMIF_TIM2, EMIF4_0_SDRAM_TIM_2);
	__raw_writel(EMIF_TIM2, EMIF4_0_SDRAM_TIM_2_SHADOW);
	__raw_writel(EMIF_TIM3, EMIF4_0_SDRAM_TIM_3);
	__raw_writel(EMIF_TIM3, EMIF4_0_SDRAM_TIM_3_SHADOW);

	__raw_writel(EMIF_SDCFG, EMIF4_0_SDRAM_CONFIG);
	__raw_writel(EMIF_SDCFG2, EMIF4_0_SDRAM_CONFIG2);

	/* __raw_writel(EMIF_SDMGT, EMIF0_0_SDRAM_MGMT_CTRL);
	__raw_writel(EMIF_SDMGT, EMIF0_0_SDRAM_MGMT_CTRL_SHD); */
	__raw_writel(0x00004650, EMIF4_0_SDRAM_REF_CTRL);
	__raw_writel(0x00004650, EMIF4_0_SDRAM_REF_CTRL_SHADOW);

	for (i = 0; i < 5000; i++) {

	}

	/* __raw_writel(EMIF_SDMGT, EMIF0_0_SDRAM_MGMT_CTRL);
	__raw_writel(EMIF_SDMGT, EMIF0_0_SDRAM_MGMT_CTRL_SHD); */
	__raw_writel(EMIF_SDREF, EMIF4_0_SDRAM_REF_CTRL);
	__raw_writel(EMIF_SDREF, EMIF4_0_SDRAM_REF_CTRL_SHADOW);

	__raw_writel(EMIF_SDCFG, EMIF4_0_SDRAM_CONFIG);
	__raw_writel(EMIF_SDCFG2, EMIF4_0_SDRAM_CONFIG2);

}



static void config_am335x_ddr(void)
{
	int data_macro_0 = 0;
	int data_macro_1 = 1;

	enable_ddr_clocks();

	config_vtp();

	Cmd_Macro_Config();

	Data_Macro_Config(data_macro_0);
	Data_Macro_Config(data_macro_1);

	__raw_writel(PHY_RANK0_DELAY, DATA0_RANK0_DELAYS_0);
	__raw_writel(PHY_RANK0_DELAY, DATA1_RANK0_DELAYS_0);

	__raw_writel(DDR_IOCTRL_VALUE, DDR_CMD0_IOCTRL);
	__raw_writel(DDR_IOCTRL_VALUE, DDR_CMD1_IOCTRL);
	__raw_writel(DDR_IOCTRL_VALUE, DDR_CMD2_IOCTRL);
	__raw_writel(DDR_IOCTRL_VALUE, DDR_DATA0_IOCTRL);
	__raw_writel(DDR_IOCTRL_VALUE, DDR_DATA1_IOCTRL);

	__raw_writel(__raw_readl(DDR_IO_CTRL) & 0xefffffff, DDR_IO_CTRL); // DDR3 = STL
	//__raw_writel(__raw_readl(DDR_IO_CTRL)  | 0x10000000, DDR_IO_CTRL); // mDDR = CMOS
	__raw_writel(__raw_readl(DDR_CKE_CTRL) | 0x00000001, DDR_CKE_CTRL);

	config_emif_dram();

}
#else /* V_SDRAMTYPE_DDR3, configuring DDR3 RAM */

/*
 * 	unsigned long datardsratio0;	//	0xc8
	unsigned long datawdsratio0;	//	0xdc
	unsigned long datawiratio0;	//	0xf0
	unsigned long datagiratio0;	//	
	unsigned long datafwsratio0;	//	0x108
	unsigned long datawrsratio0;	//	
	unsigned long datauserank0delay;//
	unsigned long datadldiff0;
 */
static const struct ddr_data ddr3_data = {
	.datardsratio0 = MT41J128MJT125_RD_DQS,
	.datawdsratio0 = MT41J128MJT125_WR_DQS,
	.datafwsratio0 = MT41J128MJT125_PHY_FIFO_WE,
	.datawrsratio0 = MT41J128MJT125_PHY_WR_DATA,
	.datadldiff0   = PHY_DLL_LOCK_DIFF,
	
	.datardsratio1 = MT41J128MJT125_RD_DQS_H,
	.datawdsratio1 = MT41J128MJT125_WR_DQS_H,
	.datafwsratio1 = MT41J128MJT125_PHY_FIFO_WE_H,
	.datawrsratio1 = MT41J128MJT125_PHY_WR_DATA_H,
	.datadldiff1   = PHY_DLL_LOCK_DIFF,
	
};

static const struct cmd_control ddr3_cmd_ctrl_data = {
	.cmd0csratio = MT41J128MJT125_RATIO,
	.cmd0dldiff = MT41J128MJT125_DLL_LOCK_DIFF,
	.cmd0iclkout = MT41J128MJT125_INVERT_CLKOUT,

	.cmd1csratio = MT41J128MJT125_RATIO,
	.cmd1dldiff = MT41J128MJT125_DLL_LOCK_DIFF,
	.cmd1iclkout = MT41J128MJT125_INVERT_CLKOUT,

	.cmd2csratio = MT41J128MJT125_RATIO,
	.cmd2dldiff = MT41J128MJT125_DLL_LOCK_DIFF,
	.cmd2iclkout = MT41J128MJT125_INVERT_CLKOUT,
};

static struct emif_regs ddr3_emif_reg_data = {
	.sdram_config = MT41J128MJT125_EMIF_SDCFG,
	.ref_ctrl = MT41J128MJT125_EMIF_SDREF,
	.sdram_tim1 = MT41J128MJT125_EMIF_TIM1,
	.sdram_tim2 = MT41J128MJT125_EMIF_TIM2,
	.sdram_tim3 = MT41J128MJT125_EMIF_TIM3,
	.zq_config = MT41J128MJT125_ZQ_CFG,
	.emif_ddr_phy_ctlr_1 = MT41J128MJT125_EMIF_READ_LATENCY |
				PHY_EN_DYN_PWRDN,
};


/* Control Status Register */
struct ctrl_stat{
	unsigned int resv1[16];
	unsigned int statusreg;		/* ofset 0x40 */
	unsigned int resv2[51];
	unsigned int secure_emif_sdram_config;	/* offset 0x0110 */
};


struct ctrl_stat *cstat = (struct ctrl_stat *)CTRL_BASE;

void config_am335x_ddr3(void)
{
//  	int data_macro_0 = 0;
//	int data_macro_1 = 1;
	enable_ddr_clocks();	// config at speed, 303 or ,,,,

	config_vtp();	// similar with ddr2

//	Cmd_Macro_Config(); ==>> config_cmd_ctrl

	__raw_writel(ddr3_cmd_ctrl_data.cmd0csratio, CMD0_CTRL_SLAVE_RATIO_0);
	__raw_writel(ddr3_cmd_ctrl_data.cmd0dldiff , CMD0_DLL_LOCK_DIFF_0);
	__raw_writel(ddr3_cmd_ctrl_data.cmd0iclkout, CMD0_INVERT_CLKOUT_0);

	__raw_writel(ddr3_cmd_ctrl_data.cmd1csratio, CMD1_CTRL_SLAVE_RATIO_0);
	__raw_writel(ddr3_cmd_ctrl_data.cmd1dldiff , CMD1_DLL_LOCK_DIFF_0);
	__raw_writel(ddr3_cmd_ctrl_data.cmd1iclkout, CMD1_INVERT_CLKOUT_0);

	__raw_writel(ddr3_cmd_ctrl_data.cmd2csratio, CMD2_CTRL_SLAVE_RATIO_0);
	__raw_writel(ddr3_cmd_ctrl_data.cmd2dldiff , CMD2_DLL_LOCK_DIFF_0);
	__raw_writel(ddr3_cmd_ctrl_data.cmd2iclkout, CMD2_INVERT_CLKOUT_0);
	
	// <<===
	
// 	config_ddr_data	()

//ddr3_data
	
	// may not se properly ????
	u32 BaseAddrOffset = 0x00;
	__raw_writel(ddr3_data.datardsratio0, 		DATA0_RD_DQS_SLAVE_RATIO_0 + BaseAddrOffset);	// MT41J128MJT125_RD_DQS
	__raw_writel(ddr3_data.datawdsratio0, 		DATA0_WR_DQS_SLAVE_RATIO_0 + BaseAddrOffset);	// MT41J128MJT125_WR_DQS
	__raw_writel(ddr3_data.datawiratio0,  		DATA0_WRLVL_INIT_RATIO_0   + BaseAddrOffset);	// 
	__raw_writel(ddr3_data.datagiratio0,  		DATA0_GATELVL_INIT_RATIO_0 + BaseAddrOffset);	// 
	__raw_writel(ddr3_data.datafwsratio0, 		DATA0_FIFO_WE_SLAVE_RATIO_0+ BaseAddrOffset);	// MT41J128MJT125_PHY_FIFO_WE
	__raw_writel(ddr3_data.datawrsratio0, 		DATA0_WR_DATA_SLAVE_RATIO_0+ BaseAddrOffset);	// MT41J128MJT125_PHY_WR_DATA
	__raw_writel(ddr3_data.datauserank0delay,	DATA0_RANK0_DELAYS_0	   + BaseAddrOffset);	// 
	__raw_writel(ddr3_data.datadldiff0,		DATA0_DLL_LOCK_DIFF_0	   + BaseAddrOffset);	// PHY_DLL_LOCK_DIFF
	
	BaseAddrOffset = 0xa4;
	__raw_writel(ddr3_data.datardsratio1, 		DATA0_RD_DQS_SLAVE_RATIO_0 + BaseAddrOffset);	// MT41J128MJT125_RD_DQS
	__raw_writel(ddr3_data.datawdsratio1, 		DATA0_WR_DQS_SLAVE_RATIO_0 + BaseAddrOffset);	// MT41J128MJT125_WR_DQS
	__raw_writel(ddr3_data.datawiratio1,  		DATA0_WRLVL_INIT_RATIO_0   + BaseAddrOffset);	// 
	__raw_writel(ddr3_data.datagiratio1,  		DATA0_GATELVL_INIT_RATIO_0 + BaseAddrOffset);	// 
	__raw_writel(ddr3_data.datafwsratio1, 		DATA0_FIFO_WE_SLAVE_RATIO_0+ BaseAddrOffset);	// MT41J128MJT125_PHY_FIFO_WE
	__raw_writel(ddr3_data.datawrsratio1, 		DATA0_WR_DATA_SLAVE_RATIO_0+ BaseAddrOffset);	// MT41J128MJT125_PHY_WR_DATA
	__raw_writel(ddr3_data.datauserank1delay,	DATA0_RANK0_DELAYS_0	   + BaseAddrOffset);	// 
	__raw_writel(ddr3_data.datadldiff1,		DATA0_DLL_LOCK_DIFF_0	   + BaseAddrOffset);	// PHY_DLL_LOCK_DIFF
		
	__raw_writel(MT41J128MJT125_IOCTRL_VALUE, DDR_CMD0_IOCTRL);
	__raw_writel(MT41J128MJT125_IOCTRL_VALUE, DDR_CMD1_IOCTRL);
	__raw_writel(MT41J128MJT125_IOCTRL_VALUE, DDR_CMD2_IOCTRL);
	__raw_writel(MT41J128MJT125_IOCTRL_VALUE, DDR_DATA0_IOCTRL);
	__raw_writel(MT41J128MJT125_IOCTRL_VALUE, DDR_DATA1_IOCTRL);

	__raw_writel(__raw_readl(DDR_IO_CTRL) & 0xefffffff, DDR_IO_CTRL); // DDR3 = STL	
	/* Set CKE to be controlled by EMIF/DDR PHY */
	__raw_writel(DDR_CKE_CTRL_NORMAL , DDR_CKE_CTRL);

	/* Program EMIF instance */
//	config_ddr_phy(regs, nr);
	__raw_writel(ddr3_emif_reg_data.emif_ddr_phy_ctlr_1, EMIF4_0_DDR_PHY_CTRL_1);
	__raw_writel(ddr3_emif_reg_data.emif_ddr_phy_ctlr_1, EMIF4_0_DDR_PHY_CTRL_1_SHADOW);
		     

//	set_sdram_timings(regs, nr);
	__raw_writel(ddr3_emif_reg_data.sdram_tim1, EMIF4_0_SDRAM_TIM_1);
	__raw_writel(ddr3_emif_reg_data.sdram_tim1, EMIF4_0_SDRAM_TIM_1_SHADOW);
	__raw_writel(ddr3_emif_reg_data.sdram_tim2, EMIF4_0_SDRAM_TIM_2);
	__raw_writel(ddr3_emif_reg_data.sdram_tim2, EMIF4_0_SDRAM_TIM_2_SHADOW);
	__raw_writel(ddr3_emif_reg_data.sdram_tim3, EMIF4_0_SDRAM_TIM_3);
	__raw_writel(ddr3_emif_reg_data.sdram_tim3, EMIF4_0_SDRAM_TIM_3_SHADOW);
	
//	config_sdram(regs, nr);
	if (ddr3_emif_reg_data.zq_config) {
		/*
		 * A value of 0x2800 for the REF CTRL will give us
		 * about 570us for a delay, which will be long enough
		 * to configure things.
		 */
		
		__raw_writel(0x2800, 				EMIF4_0_SDRAM_REF_CTRL);
		__raw_writel(ddr3_emif_reg_data.zq_config, 	EMIF4_0_ZQ_CONFIG);
		__raw_writel(ddr3_emif_reg_data.sdram_config, &cstat->secure_emif_sdram_config);	// for resume after wake up ....
		__raw_writel(ddr3_emif_reg_data.sdram_config,  	EMIF4_0_SDRAM_CONFIG);
		__raw_writel(ddr3_emif_reg_data.ref_ctrl,	EMIF4_0_SDRAM_REF_CTRL);
		__raw_writel(ddr3_emif_reg_data.ref_ctrl, 	EMIF4_0_SDRAM_REF_CTRL_SHADOW);
	}
	__raw_writel(ddr3_emif_reg_data.ref_ctrl, 	EMIF4_0_SDRAM_REF_CTRL);
	__raw_writel(ddr3_emif_reg_data.ref_ctrl, 	EMIF4_0_SDRAM_REF_CTRL_SHADOW);
	__raw_writel(ddr3_emif_reg_data.sdram_config, 	EMIF4_0_SDRAM_CONFIG);

  
}
#endif /* V_SDRAMTYPE_DDR3 */

static void init_timer(void)
{
	/* Reset the Timer */
	__raw_writel(0x2, (DM_TIMER2_BASE + TSICR_REG));

	/* Wait until the reset is done */
	while (__raw_readl(DM_TIMER2_BASE + TIOCP_CFG_REG) & 1);

	/* Start the Timer */
	__raw_writel(0x1, (DM_TIMER2_BASE + TCLR_REG));

}

#endif /* CONFIG_SPL_BUILD */


#if defined(CONFIG_SPL_BUILD) && defined(CONFIG_SPL_BOARD_INIT)

/**
 * tps65217_reg_read() - Generic function that can read a TPS65217 register
 * @src_reg:          Source register address
 * @src_val:          Address of destination variable
 */

unsigned char tps65217_reg_read(uchar src_reg, uchar *src_val)
{
	if (i2c_read(TPS65217_CHIP_PM, src_reg, 1, src_val, 1))
		return 1;
	return 0;
}

/**
 *  tps65217_reg_write() - Generic function that can write a TPS65217 PMIC
 *                         register or bit field regardless of protection
 *                         level.
 *
 *  @prot_level:        Register password protection.
 *                      use PROT_LEVEL_NONE, PROT_LEVEL_1, or PROT_LEVEL_2
 *  @dest_reg:          Register address to write.
 *  @dest_val:          Value to write.
 *  @mask:              Bit mask (8 bits) to be applied.  Function will only
 *                      change bits that are set in the bit mask.
 *
 *  @return:            0 for success, 1 for failure.
 */
int tps65217_reg_write(uchar prot_level, uchar dest_reg,
        uchar dest_val, uchar mask)
{
        uchar read_val;
        uchar xor_reg;

        /* if we are affecting only a bit field, read dest_reg and apply the mask */
        if (mask != MASK_ALL_BITS) {
                if (i2c_read(TPS65217_CHIP_PM, dest_reg, 1, &read_val, 1))
                        return 1;
                read_val &= (~mask);
                read_val |= (dest_val & mask);
                dest_val = read_val;
        }

        if (prot_level > 0) {
                xor_reg = dest_reg ^ PASSWORD_UNLOCK;
                if (i2c_write(TPS65217_CHIP_PM, TPS65217_PASSWORD, 1, &xor_reg, 1))
                        return 1;
        }

        if (i2c_write(TPS65217_CHIP_PM, dest_reg, 1, &dest_val, 1))
                return 1;

        if (prot_level == TPS65217_PROT_LEVEL_2) {
                if (i2c_write(TPS65217_CHIP_PM, TPS65217_PASSWORD, 1, &xor_reg, 1))
                        return 1;

                if (i2c_write(TPS65217_CHIP_PM, dest_reg, 1, &dest_val, 1))
                        return 1;
        }

        return 0;
}

/**
 *  tps65217_voltage_update() - Controls output voltage setting for the DCDC1,
 *       DCDC2, or DCDC3 control registers in the PMIC.
 *
 *  @dc_cntrl_reg:      DCDC Control Register address.
 *                      Must be DEFDCDC1, DEFDCDC2, or DEFDCDC3.
 *  @volt_sel:          Register value to set.  See PMIC TRM for value set.
 *
 *  @return:            0 for success, 1 for failure.
 */
int tps65217_voltage_update(unsigned char dc_cntrl_reg, unsigned char volt_sel)
{
        if ((dc_cntrl_reg != TPS65217_DEFDCDC1) && (dc_cntrl_reg != TPS65217_DEFDCDC2)
                && (dc_cntrl_reg != TPS65217_DEFDCDC3))
                return 1;

        /* set voltage level */
        if (tps65217_reg_write(TPS65217_PROT_LEVEL_2, dc_cntrl_reg, volt_sel, MASK_ALL_BITS))
                return 1;

        /* set GO bit to initiate voltage transition */
        if (tps65217_reg_write(TPS65217_PROT_LEVEL_2, TPS65217_DEFSLEW, DCDC_GO, DCDC_GO))
                return 1;

        return 0;
}

/*
 * voltage switching for MPU frequency switching.
 * @module = mpu - 0, core - 1
 * @vddx_op_vol_sel = vdd voltage to set
 */

#define MPU		0
#define CORE		1
#define VDD_DIG1_NAND	2
#define VDDIO_DDR3	3

int voltage_update(unsigned int module, unsigned char vddx_op_vol_sel)
{
	uchar buf[4];
	unsigned int reg_offset;

	if(module == MPU)
		reg_offset = PMIC_VDD1_OP_REG;
	else if(module == CORE)
		reg_offset = PMIC_VDD2_OP_REG;
	else if(module == VDD_DIG1_NAND)
		reg_offset = PMIC_VDIG1_REG;
	else if(module == VDDIO_DDR3)
		reg_offset = PMIC_VDDIO_REG;
	else
		return -1;

	/* Select VDDx OP   */
	if (i2c_read(PMIC_CTRL_I2C_ADDR, reg_offset, 1, buf, 1))
		return 1;

	buf[0] &= ~PMIC_OP_REG_CMD_MASK;

	if (i2c_write(PMIC_CTRL_I2C_ADDR, reg_offset, 1, buf, 1))
		return 1;

	/* Configure VDDx OP  Voltage */
	if (i2c_read(PMIC_CTRL_I2C_ADDR, reg_offset, 1, buf, 1))
		return 1;

	buf[0] &= ~PMIC_OP_REG_SEL_MASK;
	buf[0] |= vddx_op_vol_sel;

	if (i2c_write(PMIC_CTRL_I2C_ADDR, reg_offset, 1, buf, 1))
		return 1;

	if (i2c_read(PMIC_CTRL_I2C_ADDR, reg_offset, 1, buf, 1))
		return 1;

	if ((buf[0] & PMIC_OP_REG_SEL_MASK ) != vddx_op_vol_sel)
		return 1;

	return 0;
}

void spl_board_init(void)
{
	/* Configure the i2c0 pin mux */
	enable_i2c0_pin_mux();

	i2c_init(CONFIG_SYS_I2C_SPEED, CONFIG_SYS_I2C_SLAVE);

	/* We don't have a config eeprom, so we don't waste time trying. */
	return;
}
#endif


/*
 * early system init of muxing and clocks.
 */
void s_init(void)
{
	/* Can be removed as A8 comes up with L2 enabled */
	l2_cache_enable();

	/* WDT1 is already running when the bootloader gets control
	 * Disable it to avoid "random" resets
	 */
	__raw_writel(0xAAAA, WDT_WSPR);
	while(__raw_readl(WDT_WWPS) != 0x0);
	__raw_writel(0x5555, WDT_WSPR);
	while(__raw_readl(WDT_WWPS) != 0x0);

#ifdef CONFIG_SPL_BUILD
	/* Setup the PLLs and the clocks for the peripherals */
	pll_init();

	/* UART softreset */
	u32 regVal;
	u32 uart_base = DEFAULT_UART_BASE;

	enable_uart0_pin_mux();

	regVal = __raw_readl(uart_base + UART_SYSCFG_OFFSET);
	regVal |= UART_RESET;
	__raw_writel(regVal, (uart_base + UART_SYSCFG_OFFSET) );
	while ((__raw_readl(uart_base + UART_SYSSTS_OFFSET) &
			UART_CLK_RUNNING_MASK) != UART_CLK_RUNNING_MASK);

	/* Disable smart idle */
	regVal = __raw_readl((uart_base + UART_SYSCFG_OFFSET));
	regVal |= UART_SMART_IDLE_EN;
	__raw_writel(regVal, (uart_base + UART_SYSCFG_OFFSET));

	/* Initialize the Timer */
	init_timer();

	preloader_console_init();

#if defined V_SDRAMTYPE_DDR3
	
	/* We need to change the default supply voltages for DDR3,
	 * enabling I2C to talk to the regulator. */
		
	enable_i2c0_pin_mux();

	i2c_init(100000, CONFIG_SYS_I2C_SLAVE);

//Core
//	voltage_update(MPU, 	PMIC_OP_REG_SEL_1_2_0);	// mpu 	at 1.2V
//	voltage_update(CORE , 	PMIC_OP_REG_SEL_1_1_0);	// core at 1.1V
//IO

	if (!voltage_update(VDD_DIG1_NAND, PMIC_VDIG1_DDR3))
	{	
	  if (!voltage_update(VDDIO_DDR3, PMIC_VDDIO_DDR3))
	  {
		printf("PMIC Done, \n");
		config_am335x_ddr3();
		printf("DDR3 Done, \n");
	  }
	}
	else
	{
	  printf("Error in i2c, \n");
	  
	}

#else	
	config_am335x_ddr();
#endif

	/* We do this in SPL (as well). U-Boot does exactly the same thing later. */
#if defined V_IOBOARD_koala

	configure_evm_pin_mux(BETZY_BOARD, "0000", PROFILE_0, 1);
	configure_gpio(BETZY_BOARD, PROFILE_0);

#elif defined V_IOBOARD_elaine

	configure_evm_pin_mux(BETZY_BOARD, "0000", PROFILE_1, 1);
	configure_gpio(BETZY_BOARD, PROFILE_1);

#elif defined V_IOBOARD_newman

	configure_evm_pin_mux(BETZY_BOARD, "0000", PROFILE_2, 1);
	configure_gpio(BETZY_BOARD, PROFILE_2);

#elif defined(V_IOBOARD_nguni)

	configure_evm_pin_mux(NGUNI_BOARD, "0000", PROFILE_3, 1);
	configure_gpio(NGUNI_BOARD, PROFILE_3);

#elif defined(V_IOBOARD_kudu)

	configure_evm_pin_mux(KEWEL_BOARD, "0000", PROFILE_4, 1);
	configure_gpio(KEWEL_BOARD, PROFILE_4);

#elif defined(V_IOBOARD_hamster)

	configure_evm_pin_mux(KEWEL_BOARD, "0000", PROFILE_5, 1);
	configure_gpio(KEWEL_BOARD, PROFILE_5);

#else
	
	#error "This IOBoard is unsupported. Check V_IOBOARD"
#endif

#if 1 /* SPL Memory test */
	{
		#define RAM 0x80000000UL
		#define RAMSIZE (128UL * 1024 * 1024) /* Must be power of 2 */

		#define mwrite(a, v) do { \
			__raw_writel((v),RAM+(a)); \
		} while(0)

		#define mcheck(a, exp) do { \
			unsigned rv=__raw_readl(RAM+(a)); \
			if (rv!=(exp)) \
				printf("[%08lx]=>%08x, expected %08x\n", RAM+(a), rv, (exp)); \
		} while(0)
		uint32_t a, v, b;

		/* Walking data bit test */
		
		printf("ramdb: Test 7-0\n");
		v = 0x80000000UL;
		for (b=0; b<32; b++) {
			mwrite(0, v  & DDR3_Mask_Pattern);
			mwrite(4, ~v & DDR3_Mask_Pattern);
			mcheck(0, v  & DDR3_Mask_Pattern);
			mcheck(4, ~v & DDR3_Mask_Pattern);
			v >>= 1;
		}

		/* Walking bit address test */
		printf("ramab\n");
		v = 0;
		for (b=RAMSIZE >> 1; b>=4; b >>= 1) {
			/* Clear */
			for (a=RAMSIZE >> 1; a>=4; a >>= 1) mwrite(a, v & DDR3_Mask_Pattern);
			/* Bitwalk & check */
			mwrite(b, ~v & DDR3_Mask_Pattern);
			for (a=RAMSIZE >> 1; a>=4; a >>= 1)
				if (a==b) mcheck(a, ~v & DDR3_Mask_Pattern);
				else mcheck(a, v & DDR3_Mask_Pattern);
		}

#if 0 /* High-impact testing */
		/* Full test, takes a while */
		printf("ramft\n");
		for (a=0; a<RAMSIZE; a+=4) {
#define pt32Bit(aa)	 ((((aa + 3 ) & 0xff) << 24) | (((aa + 2 ) & 0xff) << 16) | (((aa + 1 ) & 0xff)) << 8 | ((aa + 0 ) & 0xff ))
			mwrite(a,pt32Bit(a));
			if (!(a & 0xffff)) 
			  printf("\rW%08x", a);
		}
		for (a=0; a<RAMSIZE; a+=4) {
			if (!(a & 0xffff)) printf("\rR%08x", a);
			mcheck(a,pt32Bit(a));
		}
		puts("\n");
#endif

		puts("E\n");
	}
#endif

#endif
}


/*
 * Basic board specific setup
 */
#ifndef CONFIG_SPL_BUILD
int board_evm_init(void)
{
	/* mach type passed to kernel. Netcomm boards borrow the EVM mach type. */
	gd->bd->bi_arch_number = MACH_TYPE_TIAM335EVM;

	/* address of boot parameters */
	gd->bd->bi_boot_params = PHYS_DRAM_1 + 0x100;

	return 0;
}
#endif

#ifdef PINMUX_WORKAROUND
/* It appears that the pinmux has not been implemented as a
 * real hardware multiplexer. Rather, the behaviour is consistent
 * with that of extra 'disable' controls for signals within different
 * IP blocks. The trouble with this is that some IP blocks can
 * jam the pads. So far found that GPIO (without clock) and
 * GPMC NAND does this. The later even influences unrelated pins
 * (like RMII refclk).
 *
 * To unjam the GPMC, we reset it and then restore the register
 * contents. For GPIO, it's suficient to enable GPIO clocks and
 * set a single pin, which will unjam all pads.
 *
 * Production silicon appears to have this bug fixed.
 */
static void pinmux_bug_workaround(void)
{
//#define PINMUX_DEBUG
#ifdef PINMUX_DEBUG
	const struct reg gpmc[] = {
		{ .offset = 0x0, .name = "GPMC_REVISION" },
		{ .offset = 0x10, .name = "GPMC_SYSCONFIG" },
		{ .offset = 0x14, .name = "GPMC_SYSSTATUS" },
		{ .offset = 0x18, .name = "GPMC_IRQSTATUS" },
		{ .offset = 0x1C, .name = "GPMC_IRQENABLE" },
		{ .offset = 0x40, .name = "GPMC_TIMEOUT_CONTROL" },
		{ .offset = 0x44, .name = "GPMC_ERR_ADDRESS" },
		{ .offset = 0x48, .name = "GPMC_ERR_TYPE" },
		{ .offset = 0x50, .name = "GPMC_CONFIG" },
		{ .offset = 0x54, .name = "GPMC_STATUS" },

		{ .offset = 0x60, .name = "GPMC_CONFIG1_0" },
		{ .offset = 0x64, .name = "GPMC_CONFIG2_0" },
		{ .offset = 0x68, .name = "GPMC_CONFIG3_0" },
		{ .offset = 0x6C, .name = "GPMC_CONFIG4_0" },
		{ .offset = 0x70, .name = "GPMC_CONFIG5_0" },
		{ .offset = 0x74, .name = "GPMC_CONFIG6_0" },
		{ .offset = 0x78, .name = "GPMC_CONFIG7_0" },
		//{ .offset = 0x7C, .name = "GPMC_NAND_COMMAND_0" },
		//{ .offset = 0x80, .name = "GPMC_NAND_ADDRESS_0" },
		//{ .offset = 0x84, .name = "GPMC_NAND_DATA_0" },

		{ .offset = 0x90, .name = "GPMC_CONFIG1_1" },
		{ .offset = 0x94, .name = "GPMC_CONFIG2_1" },
		{ .offset = 0x98, .name = "GPMC_CONFIG3_1" },
		{ .offset = 0x9C, .name = "GPMC_CONFIG4_1" },
		{ .offset = 0xA0, .name = "GPMC_CONFIG5_1" },
		{ .offset = 0xA4, .name = "GPMC_CONFIG6_1" },
		{ .offset = 0xA8, .name = "GPMC_CONFIG7_1" },
		//{ .offset = 0xAC, .name = "GPMC_NAND_COMMAND_1" },
		//{ .offset = 0xB0, .name = "GPMC_NAND_ADDRESS_1" },
		//{ .offset = 0xB4, .name = "GPMC_NAND_DATA_1" },

		{ .offset = 0xC0, .name = "GPMC_CONFIG1_2" },
		{ .offset = 0xC4, .name = "GPMC_CONFIG2_2" },
		{ .offset = 0xC8, .name = "GPMC_CONFIG3_2" },
		{ .offset = 0xCC, .name = "GPMC_CONFIG4_2" },
		{ .offset = 0xD0, .name = "GPMC_CONFIG5_2" },
		{ .offset = 0xD4, .name = "GPMC_CONFIG6_2" },
		{ .offset = 0xD8, .name = "GPMC_CONFIG7_2" },
		//{ .offset = 0xDC, .name = "GPMC_NAND_COMMAND_1" },
		//{ .offset = 0xE0, .name = "GPMC_NAND_ADDRESS_1" },
		//{ .offset = 0xE4, .name = "GPMC_NAND_DATA_1" },

		{ .offset = 0xF0, .name = "GPMC_CONFIG1_3" },
		{ .offset = 0xF4, .name = "GPMC_CONFIG2_3" },
		{ .offset = 0xF8, .name = "GPMC_CONFIG3_3" },
		{ .offset = 0xFC, .name = "GPMC_CONFIG4_3" },
		{ .offset = 0x100, .name = "GPMC_CONFIG5_3" },
		{ .offset = 0x104, .name = "GPMC_CONFIG6_3" },
		{ .offset = 0x108, .name = "GPMC_CONFIG7_3" },
		//{ .offset = 0x10C, .name = "GPMC_NAND_COMMAND_1" },
		//{ .offset = 0x110, .name = "GPMC_NAND_ADDRESS_1" },
		//{ .offset = 0x114, .name = "GPMC_NAND_DATA_1" },

		{ .offset = 0x120, .name = "GPMC_CONFIG1_4" },
		{ .offset = 0x124, .name = "GPMC_CONFIG2_4" },
		{ .offset = 0x128, .name = "GPMC_CONFIG3_4" },
		{ .offset = 0x12C, .name = "GPMC_CONFIG4_4" },
		{ .offset = 0x130, .name = "GPMC_CONFIG5_4" },
		{ .offset = 0x134, .name = "GPMC_CONFIG6_4" },
		{ .offset = 0x138, .name = "GPMC_CONFIG7_4" },
		//{ .offset = 0x13C, .name = "GPMC_NAND_COMMAND_1" },
		//{ .offset = 0x140, .name = "GPMC_NAND_ADDRESS_1" },
		//{ .offset = 0x144, .name = "GPMC_NAND_DATA_1" },

		{ .offset = 0x150, .name = "GPMC_CONFIG1_5" },
		{ .offset = 0x154, .name = "GPMC_CONFIG2_5" },
		{ .offset = 0x158, .name = "GPMC_CONFIG3_5" },
		{ .offset = 0x15C, .name = "GPMC_CONFIG4_5" },
		{ .offset = 0x160, .name = "GPMC_CONFIG5_5" },
		{ .offset = 0x164, .name = "GPMC_CONFIG6_5" },
		{ .offset = 0x168, .name = "GPMC_CONFIG7_5" },
		//{ .offset = 0x16C, .name = "GPMC_NAND_COMMAND_1" },
		//{ .offset = 0x170, .name = "GPMC_NAND_ADDRESS_1" },
		//{ .offset = 0x174, .name = "GPMC_NAND_DATA_1" },

		{ .offset = 0x180, .name = "GPMC_CONFIG1_6" },
		{ .offset = 0x184, .name = "GPMC_CONFIG2_6" },
		{ .offset = 0x188, .name = "GPMC_CONFIG3_6" },
		{ .offset = 0x18C, .name = "GPMC_CONFIG4_6" },
		{ .offset = 0x190, .name = "GPMC_CONFIG5_6" },
		{ .offset = 0x194, .name = "GPMC_CONFIG6_6" },
		{ .offset = 0x198, .name = "GPMC_CONFIG7_6" },
		//{ .offset = 0x19C, .name = "GPMC_NAND_COMMAND_1" },
		//{ .offset = 0x1A0, .name = "GPMC_NAND_ADDRESS_1" },
		//{ .offset = 0x1A4, .name = "GPMC_NAND_DATA_1" },

		{ .offset = 0x1E0, .name = "GPMC_PREFETCH_CONFIG1" },
		{ .offset = 0x1E4, .name = "GPMC_PREFETCH_CONFIG2" },
		{ .offset = 0x1EC, .name = "GPMC_PREFETCH_CONTROL" },
		{ .offset = 0x1F0, .name = "GPMC_PREFETCH_STATUS" },
		{ .offset = 0x1F4, .name = "GPMC_ECC_CONFIG" },
		{ .offset = 0x1F8, .name = "GPMC_ECC_CONTROL" },
		{ .offset = 0x1FC, .name = "GPMC_ECC_SIZE_CONFIG" },
		//200h + (4h  j) GPMC_ECCj_RESULT
		//240h + (10h  i) GPMC_BCH_RESULT0_i
		//244h + (10h  i) GPMC_BCH_RESULT1_i
		//248h + (10h  i) GPMC_BCH_RESULT2_i
		//24Ch + (10h  i) GPMC_BCH_RESULT3_i
		//300h + (10h  i) GPMC_BCH_RESULT4_i
		//304h + (10h  i) GPMC_BCH_RESULT5_i
		//308h + (10h  i) GPMC_BCH_RESULT6_i
		{ .offset = 0x2D0, .name = "GPMC_BCH_SWDATA" },
		{ .name = NULL }
	};
	unsigned oldv[sizeof(gpmc)/sizeof(struct reg)] = {0};
#else
	/*
	GPMC_SYSCONFIG: [50000010] -> 00000000 (old 00000008)  0000 0000 0000 0000 0000 0000 0000 0000
	GPMC_IRQENABLE: [5000001c] -> 00000000 (old 00000200)  0000 0000 0000 0000 0000 0000 0000 0000
	   GPMC_CONFIG: [50000050] -> 00000a00 (old 00000012)  0000 0000 0000 0000 0000 1010 0000 0000
	GPMC_CONFIG1_0: [50000060] -> 00400000 (old 00000800)  0000 0000 0100 0000 0000 0000 0000 0000
	GPMC_CONFIG2_0: [50000064] -> 00101001 (old 001e1e00)  0000 0000 0001 0000 0001 0000 0000 0001
	GPMC_CONFIG3_0: [50000068] -> 22060514 (old 001e1e00)  0010 0010 0000 0110 0000 0101 0001 0100
	GPMC_CONFIG4_0: [5000006c] -> 10057016 (old 16051807)  0001 0000 0000 0101 0111 0000 0001 0110
	GPMC_CONFIG5_0: [50000070] -> 010f1111 (old 00151e1e)  0000 0001 0000 1111 0001 0001 0001 0001
	GPMC_CONFIG6_0: [50000074] -> 8f070000 (old 16000f80)  1000 1111 0000 0111 0000 0000 0000 0000
	GPMC_CONFIG7_0: [50000078] -> 00000f40 (old 00000048)  0000 0000 0000 0000 0000 1111 0100 0000
	GPMC_ECC_CONFIG: [500001f4] -> 00001030 (old 00011100)  0000 0000 0000 0000 0001 0000 0011 0000
	GPMC_ECC_CONTROL: [500001f8] -> 00000000 (old 00000002)  0000 0000 0000 0000 0000 0000 0000 0000
	GPMC_ECC_SIZE_CONFIG: [500001fc] -> fffff000 (old 0081a000)  1111 1111 1111 1111 1111 0000 0000 0000
	*/
	unsigned offs[] = { 0x10, 0x1c, 0x50, 0x60, 0x64, 0x68, 0x6c, 0x70, 0x74, 0x78, 0x1f4, 0x1f8, 0x1fc, (unsigned)-1 };
	unsigned vals[sizeof(offs)/sizeof(unsigned)] = { 0 };
	unsigned i;
#endif
	const unsigned gpmc_base = 0x50000000;

	printf("Pinmux workaround\n");

#ifdef PINMUX_DEBUG
	save_regs(gpmc_base, gpmc, oldv);
#else
	/* Save the relevant register values */
	i = 0;
	while (offs[i] != (unsigned)-1) {
		vals[i] = __raw_readl(gpmc_base | offs[i]);
		i++;
	}
#endif

	/* Reset GPMC to unjam unrelated pins */
	__raw_writel(0x2, 0x50000000 | 0x10);
	printf("GPM_SY: %08x\n", __raw_readl(0x50000000 | 0x10));

#ifdef PINMUX_DEBUG
	diff_regs(gpmc_base, gpmc, oldv);
	printf("Restoring\n");
	restore_regs(gpmc_base, gpmc, oldv);
#else
	/* Restore the relevant register values */
	i = 0;
	while (offs[i] != (unsigned)-1) {
		__raw_writel(vals[i], gpmc_base | offs[i]);
		i++;
	}
#endif

	/* Sometimes GPIO may also get stuck. Any access will do. Switching on Debug LED. */

	init_gpio();

	/* LED5 on 2/28 */
	GPIO_dir(2, 21, GPIO_DIR_OUT);
	GPIO_out(2, 21, 0);
}

#endif /* PINMUX_WORKAROUND */


int board_init(void)
{
	/*
	 * PROFILE_0 configures for the Koala/Blinky daughter board (RGMII)
	 *
	 * PROFILE_1 configures for the ntc_30/elaine boards (RMII)
	 *
	 * PROFILE_2 configures for Newman board, no Ethernet, production only.
	 *
	 * PROFILE_3 configures for nguni ioboard, dual GB Ethernet
	 *
	 * PROFILE_4 configures for kudu ioboard, ETH switch
	 *
	 * PROFILE_5 configures for hamster ioboard, single Ethernet
	 */

#if defined V_IOBOARD_koala

	configure_evm_pin_mux(BETZY_BOARD, "0000", PROFILE_0, 1);
	configure_gpio(BETZY_BOARD, PROFILE_0);

#elif defined V_IOBOARD_elaine

	configure_evm_pin_mux(BETZY_BOARD, "0000", PROFILE_1, 1);
	configure_gpio(BETZY_BOARD, PROFILE_1);

#elif defined V_IOBOARD_newman

	configure_evm_pin_mux(BETZY_BOARD, "0000", PROFILE_2, 1);
	configure_gpio(BETZY_BOARD, PROFILE_2);

#elif defined(V_IOBOARD_nguni)

	configure_evm_pin_mux(NGUNI_BOARD, "0000", PROFILE_3, 1);
	configure_gpio(NGUNI_BOARD, PROFILE_3);

#elif defined(V_IOBOARD_kudu)

	configure_evm_pin_mux(KEWEL_BOARD, "0000", PROFILE_4, 1);
	configure_gpio(KEWEL_BOARD, PROFILE_4);

#elif defined(V_IOBOARD_hamster)

	configure_evm_pin_mux(KEWEL_BOARD, "0000", PROFILE_5, 1);
	configure_gpio(KEWEL_BOARD, PROFILE_5);

#else
	#error "This IOBoard is unsupported. Check V_IOBOARD"
#endif

#ifndef CONFIG_SPL_BUILD

	board_evm_init();

#endif

	gpmc_init();

	return 0;
}

int misc_init_r(void)
{
	return 0;
}

#ifdef BOARD_LATE_INIT
int board_late_init(void)
{
	return 0;
}
#endif

#ifdef CONFIG_DRIVER_TI_CPSW

#ifdef CONFIG_BITBANGMII

#define MDIO_BANK 0   /* Common pin bank */
#define MDIO_PIN_IO 0 /* MDIO line */
#define MDIO_PIN_C 1  /* MDC line */

static int mdio_init(struct bb_miiphy_bus *bus)
{
	GPIO_dir(MDIO_BANK, MDIO_PIN_IO, GPIO_DIR_IN);
	GPIO_out(MDIO_BANK, MDIO_PIN_C, 1);
	GPIO_dir(MDIO_BANK, MDIO_PIN_C, GPIO_DIR_OUT);
	return 0;
}

static int mdio_active(struct bb_miiphy_bus *bus)
{
	GPIO_dir(MDIO_BANK, MDIO_PIN_IO, GPIO_DIR_OUT);
	return 0;
}

static int mdio_tristate(struct bb_miiphy_bus *bus)
{
	GPIO_out(MDIO_BANK, MDIO_PIN_IO, 1); /* Deliberate glitch, helps with weak pull-ups. */
	GPIO_dir(MDIO_BANK, MDIO_PIN_IO, GPIO_DIR_IN);
	return 0;
}

static int set_mdio(struct bb_miiphy_bus *bus, int v)
{
	GPIO_out(MDIO_BANK, MDIO_PIN_IO, v);
	return 0;
}

static int get_mdio(struct bb_miiphy_bus *bus, int *v)
{
	*v = GPIO_in(MDIO_BANK, MDIO_PIN_IO);
	*v = GPIO_in(MDIO_BANK, MDIO_PIN_IO);
	return 0;
}

static int set_mdc(struct bb_miiphy_bus *bus, int v)
{
	GPIO_out(MDIO_BANK, MDIO_PIN_C, v);
	return 0;
}

static int mdio_delay(struct bb_miiphy_bus *bus)
{
	/* Without any delay, we get about 100KHz of MDIOC frequency */
	return 0;
}

/* The folowing is linked and referenced directly by miiphybb.c */
struct bb_miiphy_bus bb_miiphy_buses[] = {
	{
		.name = "cpsw", /* Must match MAC driver name */
		.init = mdio_init,
		.mdio_active = mdio_active,
		.mdio_tristate = mdio_tristate,
		.set_mdio = set_mdio,
		.get_mdio = get_mdio,
		.set_mdc = set_mdc,
		.delay = mdio_delay,
		.priv = NULL
	}
};
int bb_miiphy_buses_num = sizeof(bb_miiphy_buses)/sizeof(bb_miiphy_buses[0]);

#endif

#define CM_PER_BASE   0x44e00000
#define CM_PER_GPIO1  (CM_PER_BASE + 0xac)

/* The cpsw driver manages two PHYs, so we need to address them
 * individually. This function replaces TI's original half-arsed
 * phy driver here. */
static void evm_phy_init(char *name, int addr)
{
	struct mii_dev *bus;
	struct phy_device *phydev;

	printf("ph: %s, %d\n", name, addr);

	bus = miiphy_get_dev_by_name(name);

	printf("ph: bus %p\n", bus);

	phydev = get_phy_device(bus, addr, PHY_INTERFACE_MODE_NONE);

	printf("ph: phydev %p\n", phydev);

	phy_startup(phydev);

	if (phydev->link) printf("ph: Link up\n");
	else printf("ph: Link down\n");
}


static void cpsw_control(int enabled)
{
	/* nothing for now */
	printf("%s\n", __func__);
	return;
}


#if defined V_IOBOARD_koala
static struct cpsw_slave_data cpsw_slaves[] = {
	{
		.slave_reg_ofs	= 0x208,
		.sliver_reg_ofs	= 0xd80,
		.phy_id		= 0,
	},
};
#elif defined V_IOBOARD_elaine
static struct cpsw_slave_data cpsw_slaves[] = {
	{
		.slave_reg_ofs	= 0x208,
		.sliver_reg_ofs	= 0xd80,
		.phy_id		= 1,
	},
};
#elif defined V_IOBOARD_newman
static struct cpsw_slave_data cpsw_slaves[] = {
};

#elif defined(V_IOBOARD_nguni)
/* The PHY addresses rely on a GPIO / strap pin + reset maneuver in SPL */
static struct cpsw_slave_data cpsw_slaves[] = {
	{
		.slave_reg_ofs	= 0x208,
		.sliver_reg_ofs	= 0xd80,
		.phy_id		= 0,
	},
	{
		.slave_reg_ofs	= 0x308,
		.sliver_reg_ofs	= 0xdc0,
		.phy_id		= 1,
	},
};
#elif defined(V_IOBOARD_kudu)
/* TODO: This board uses a switch and should *not* link PHYs to
 * the MAC. Some sort of dummy PHY is needed, hardwired to 1GB/fd */
static struct cpsw_slave_data cpsw_slaves[] = {
	{
		.slave_reg_ofs	= 0x308,
		.sliver_reg_ofs	= 0xdc0,
		.phy_id		= 0,
	},
	{
		.slave_reg_ofs	= 0x308,
		.sliver_reg_ofs	= 0xdc0,
		.phy_id		= 1,
	},

};
#elif defined(V_IOBOARD_hamster)
static struct cpsw_slave_data cpsw_slaves[] = {
	{
		.slave_reg_ofs	= 0x208,
		.sliver_reg_ofs	= 0xd80,
		.phy_id		= 0,
	},
};
#endif

static struct cpsw_platform_data cpsw_data = {
	.mdio_base		= AM335X_CPSW_MDIO_BASE,
	.cpsw_base		= AM335X_CPSW_BASE,
	.mdio_div		= 0xff,
	.channels		= 8,
	.cpdma_reg_ofs		= 0x800,
	.slaves			= sizeof(cpsw_slaves)/sizeof(struct cpsw_slave_data),
	.slave_data		= cpsw_slaves,
	.ale_reg_ofs		= 0xd00,
	.ale_entries		= 1024,
	.host_port_reg_ofs	= 0x108,
	.hw_stats_reg_ofs	= 0x900,
	.mac_control		= (1 << 5) /* MIIEN */,
	.control		= cpsw_control,
	.phy_init		= evm_phy_init,
	.gigabit_en		= 1,
	.host_port_num		= 0,
	.version		= CPSW_CTRL_VERSION_2,
};

int board_eth_init(bd_t *bis)
{
	uint8_t mac_addr[6];
	uint32_t mac_hi, mac_lo;
	int stat;

	if (!eth_getenv_enetaddr("ethaddr", mac_addr)) {
		debug("<ethaddr> not set. Reading from E-fuse\n");
		/* try reading mac address from efuse */
		mac_lo = __raw_readl(MAC_ID0_LO);
		mac_hi = __raw_readl(MAC_ID0_HI);
		mac_addr[0] = mac_hi & 0xFF;
		mac_addr[1] = (mac_hi & 0xFF00) >> 8;
		mac_addr[2] = (mac_hi & 0xFF0000) >> 16;
		mac_addr[3] = (mac_hi & 0xFF000000) >> 24;
		mac_addr[4] = mac_lo & 0xFF;
		mac_addr[5] = (mac_lo & 0xFF00) >> 8;

		if (is_valid_ether_addr(mac_addr))
			eth_setenv_enetaddr("ethaddr", mac_addr);
		else {
			printf("Caution: Using hardcoded mac address. "
				"Set <ethaddr> variable to overcome this.\n");
		}
	}

#if defined V_IOBOARD_elaine

	printf("RMII ");
	__raw_writel(RMII_MODE_EXTREF, MAC_MII_SEL);
	cpsw_data.gigabit_en = 0;

#elif defined V_IOBOARD_koala

	printf("RGMII ");
	__raw_writel(RGMII_MODE_ENABLE, MAC_MII_SEL);

#elif defined V_IOBOARD_nguni

	printf("Dual RGMII ");
	__raw_writel(RGMII_MODE_ENABLE, MAC_MII_SEL);

#elif defined(V_IOBOARD_kudu)
	
	printf("Switch RGMII ");
	__raw_writel(RGMII_MODE_ENABLE, MAC_MII_SEL);

#elif defined(V_IOBOARD_hamster)

	printf("RGMII ");
	__raw_writel(RGMII_MODE_ENABLE, MAC_MII_SEL);

#else
	#error Unknown V_IOBOARD
#endif

#ifdef CONFIG_BITBANGMII
	bb_miiphy_init();
	miiphy_register("cpsw", bb_miiphy_read, bb_miiphy_write);
	printf("BitbangMDIO\n");
#else
	printf("CpswMDIO\n");
#endif

	stat = cpsw_register(&cpsw_data);
#ifdef 	V_IOBOARD_kudu
	if(stat == 1)
	{
		struct eth_device *eth;
		cpsw_data.phy_init("cpsw",0);
		cpsw_data.phy_init("cpsw",1);
		eth = eth_get_dev_by_name("cpsw");
		printf("%s:%d: device is '%s'\n", __func__, __LINE__, eth->name);
		//eth->init(eth,0);
		//eth_init(0);
	}
#endif

#ifdef V_IOBOARD_hamster
	if(stat == 1)
	{
		struct eth_device *eth;
		cpsw_data.phy_init("cpsw",0);
		eth = eth_get_dev_by_name("cpsw");
		printf("%s:%d: device is '%s'\n", __func__, __LINE__, eth->name);
	}
#endif

	return stat;
}
#endif

#ifndef CONFIG_SPL_BUILD
#ifdef CONFIG_GENERIC_MMC
int board_mmc_init(bd_t *bis)
{
	omap_mmc_init(0);
	return 0;
}
#endif

#endif /* !CONFIG_SPL_BUILD */
