/*
 * Very simple GPIO access for TI am335 processors
 *
 * Iwo
 */

#define GPIO_0_BASE 0x44E07000 /* This one is special, can wake up system */
#define GPIO_1_BASE 0x4804C000
#define GPIO_2_BASE 0x481AC000
#define GPIO_3_BASE 0x481AE000

static const unsigned banka[] = { GPIO_0_BASE, GPIO_1_BASE, GPIO_2_BASE, GPIO_3_BASE };

#define GPIO_REVISION 0x0
#define GPIO_SYSCONFIG 0x10
#define GPIO_IRQSTATUS_RAW_0 0x24
#define GPIO_IRQSTATUS_RAW_1 0x28
#define GPIO_IRQSTATUS_0 0x2C
#define GPIO_IRQSTATUS_1 0x30
#define GPIO_IRQSTATUS_SET_0 0x34
#define GPIO_IRQSTATUS_SET_1 0x38
#define GPIO_IRQSTATUS_CLR_0 0x3C
#define GPIO_IRQSTATUS_CLR_1 0x40
#define GPIO_IRQWAKEN_0 0x44
#define GPIO_IRQWAKEN_1 0x48
#define GPIO_SYSSTATUS 0x114
#define GPIO_CTRL 0x130
#define GPIO_OE 0x134
#define GPIO_DATAIN 0x138
#define GPIO_DATAOUT 0x13C
#define GPIO_LEVELDETECT0 0x140
#define GPIO_LEVELDETECT1 0x144
#define GPIO_RISINGDETECT 0x148
#define GPIO_FALLINGDETECT 0x14C
#define GPIO_DEBOUNCENABLE 0x150
#define GPIO_DEBOUNCINGTIME 0x154
#define GPIO_CLEARDATAOUT 0x190
#define GPIO_SETDATAOUT 0x194

#define GPIO_REGW(bank, reg, value) __raw_writel(value, banka[bank] + (reg))
#define GPIO_REGR(bank, reg) __raw_readl(banka[bank] + (reg))

extern void init_gpio(void);


#define GPIO_DIR_IN 0
#define GPIO_DIR_OUT 1
static inline void GPIO_dir(const unsigned bank, const unsigned pin, const unsigned dir)
{
	unsigned v = GPIO_REGR(bank, GPIO_OE);
	//printf("%s: %08x\n", __func__, v);
	if (dir == GPIO_DIR_OUT) v &= ~(1<<pin);
	else v |= (1<<pin);
	//printf("%s: %08x\n", __func__, v);
	GPIO_REGW(bank, GPIO_OE, v);
}

static inline int GPIO_in(const unsigned bank, const unsigned pin)
{
	return !!(GPIO_REGR(bank, GPIO_DATAIN) & (1<<pin));
}

static inline void GPIO_out(const unsigned bank, const unsigned pin, const int v)
{
	if (v) GPIO_REGW(bank, GPIO_SETDATAOUT, 1<<pin);
	else GPIO_REGW(bank, GPIO_CLEARDATAOUT, 1<<pin);
}

struct pinstate {
	unsigned pin:5;  /* Pin number within bank */
	unsigned bank:2; /* Bank numbr */
	unsigned v:1;    /* output latch value */
	unsigned oe:1;   /* output enable, dir */
	unsigned inv:1;  /* input read value */
	unsigned end:1;  /* End marker for arrays of pinstate */
};

static inline void GPIO_setstate(const struct pinstate *p)
{
	if (p->oe) {
		/* For output, we set the value first, then switch on oe */
		GPIO_out(p->bank, p->pin, p->v);
		GPIO_dir(p->bank, p->pin, GPIO_DIR_OUT);
	} else {
		GPIO_dir(p->bank, p->pin, GPIO_DIR_IN);
	}
}

static inline void GPIO_getstate(struct pinstate *p)
{
	unsigned bank=p->bank, pin=p->pin;

	p->oe = !(GPIO_REGR(bank, GPIO_OE) & (1<<pin));
	p->v  = !!(GPIO_REGR(bank, GPIO_DATAOUT) & (1<<pin));
	p->inv = GPIO_in(bank, pin);
}

extern void configure_gpio(unsigned board, unsigned profile);
