/*
 * Useful stuff for debugging
 */

#ifndef _DEBUG_H
#define _DEBUG_H

struct reg {
	unsigned offset;
	const char *name;
};

static inline void binstr(unsigned v)
{
	unsigned i = 32;
	while (i--) {
		if ( i % 4 == 3 ) printf(" ");
		if ( v & 0x80000000 ) printf("1");
		else printf("0");
		v <<= 1;
	}
}

/* dump array of registers, last one must have .name==NULL */
static inline void dump_regs(const unsigned base, const struct reg regs[])
{
	const struct reg *regp = regs;
	unsigned v;

	while (regp->name) {
		v = __raw_readl(base | regp->offset);
		printf("%20s: [%08x] -> %08x  ", regp->name, base | regp->offset, v);
		binstr(v);
		printf("\n");
		regp++;
	}
}

static inline void save_regs(const unsigned base, const struct reg regs[], unsigned values[])
{
	const struct reg *regp = regs;
	unsigned *vp = values;
	while (regp->name) {
		*vp = __raw_readl(base | regp->offset);
		regp++;
		vp++;
	}
}

static inline void restore_regs(const unsigned base, const struct reg regs[], unsigned values[])
{
	const struct reg *regp = regs;
	unsigned *vp = values;
	unsigned v;

	while (regp->name) {
		v = __raw_readl(base | regp->offset);
		if ( v != *vp ) {
			__raw_writel(*vp, base | regp->offset);
		}
		regp++;
		vp++;
	}
}

static inline void diff_regs(const unsigned base, const struct reg regs[], unsigned values[])
{
	const struct reg *regp = regs;
	unsigned *vp = values;
	unsigned v;

	while (regp->name) {
		v = __raw_readl(base | regp->offset);
		if ( v != *vp ) {
			printf("%24s: [%08x] -> %08x (old %08x) ", regp->name, base | regp->offset, v, *vp);
			binstr(v);
			printf("\n");
		}
		regp++;
		vp++;
	}
}

#endif /* _DEBUG_H */
