/*
 * (C) Copyright 2006-2008
 * Texas Instruments, <www.ti.com>
 * Richard Woodruff <r-woodruff2@ti.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR /PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#ifndef _CLOCKS_TI816X_H_
#define _CLOCKS_TI816X_H_

/*
 * In TI816x the 27MHz crystal generates various root clks (main pll, audio pll, video pll and ddr pll)
 * From these root clks the SYSCLKs are generated by making use of dividers and multipliers
 */

#define FAPLL_K			8
#define SYSCLK_2_DIV		1
#define OSC_FREQ		27
#define DDR_PLL_400	/* Values supported 400,531,675,796 */

/* Main PLL */
#define MAIN_N			64
#define MAIN_P			0x1
#define MAIN_INTFREQ1		0x8
#define MAIN_FRACFREQ1		0x800000
#define MAIN_MDIV1		0x2
#define MAIN_INTFREQ2		0xE
#define MAIN_FRACFREQ2		0x0
#define MAIN_MDIV2		0x1
#define MAIN_INTFREQ3		0x8
#define MAIN_FRACFREQ3		0xAAAAB0
#define MAIN_MDIV3		0x3
#define MAIN_INTFREQ4		0x9
#define MAIN_FRACFREQ4		0x55554F
#define MAIN_MDIV4		0x3
#define MAIN_INTFREQ5		0x9
#define MAIN_FRACFREQ5		0x374BC6
#define MAIN_MDIV5		0xC
#define MAIN_MDIV6		0x48
#define MAIN_MDIV7		0x4

/* DDR PLL */
/* For 400 MHz */
#if defined(DDR_PLL_400)
#define DDR_N			59
#define DDR_P			0x1
#define DDR_MDIV1		0x4
#define DDR_INTFREQ2		0x8
#define DDR_FRACFREQ2		0xD99999
#define DDR_MDIV2		0x1E
#define DDR_INTFREQ3		0x8
#define DDR_FRACFREQ3		0x0
#define DDR_MDIV3		0x4
#define DDR_INTFREQ4		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ4		0x0
#define DDR_MDIV4		0x4
#define DDR_INTFREQ5		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ5		0x0
#define DDR_MDIV5		0x4
#endif

/* For 531 MHz */
#if defined(DDR_PLL_531)
#define DDR_N			59
#define DDR_P			0x1
#define DDR_MDIV1		0x3
#define DDR_INTFREQ2		0x8
#define DDR_FRACFREQ2		0xD99999
#define DDR_MDIV2		0x1E
#define DDR_INTFREQ3		0x8
#define DDR_FRACFREQ3		0x0
#define DDR_MDIV3		0x4
#define DDR_INTFREQ4		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ4		0x0
#define DDR_MDIV4		0x4
#define DDR_INTFREQ5		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ5		0x0
#define DDR_MDIV5		0x4
#endif

/* For 675 MHz */
#if defined(DDR_PLL_675)
#define DDR_N			50
#define DDR_P			0x1
#define DDR_MDIV1		0x2
#define DDR_INTFREQ2		0x9
#define DDR_FRACFREQ2		0x0
#define DDR_MDIV2		0x19
#define DDR_INTFREQ3		0x13
#define DDR_FRACFREQ3		0x800000
#define DDR_MDIV3		0x2
#define DDR_INTFREQ4		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ4		0x0
#define DDR_MDIV4		0x4
#define DDR_INTFREQ5		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ5		0x0
#define DDR_MDIV5		0x4
#endif

/* For 796 MHz */
#if defined(DDR_PLL_796)
#define DDR_N			59
#define DDR_P			0x1
#define DDR_MDIV1		0x2
#define DDR_INTFREQ2		0x8
#define DDR_FRACFREQ2		0xD99999
#define DDR_MDIV2		0x1E
#define DDR_INTFREQ3		0x8
#define DDR_FRACFREQ3		0x0
#define DDR_MDIV3		0x4
#define DDR_INTFREQ4		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ4		0x0
#define DDR_MDIV4		0x4
#define DDR_INTFREQ5		0xE /* Expansion DDR clk */
#define DDR_FRACFREQ5		0x0
#define DDR_MDIV5		0x4
#endif

/* Video PLL */
#define VIDEO_N			110
#define VIDEO_P			0x2
#define VIDEO_INTFREQ1		0xB
#define VIDEO_FRACFREQ1		0x0
#define VIDEO_MDIV1		0x5
#define VIDEO_INTFREQ2		0xA
#define VIDEO_FRACFREQ2		0x0
#define VIDEO_MDIV2		0x2
#define VIDEO_INTFREQ3		0xA
#define VIDEO_FRACFREQ3		0x0
#define VIDEO_MDIV3		0x2

/* Audio PLL */
#define AUDIO_N			64
#define AUDIO_P			0x19
#define AUDIO_INTFREQ2		0xE
#define AUDIO_FRACFREQ2		0x0
#define AUDIO_MDIV2		0x4
#define AUDIO_INTFREQ3		0x9
#define AUDIO_FRACFREQ3		0x0
#define AUDIO_MDIV3		0x5
#define AUDIO_INTFREQ4		0x9
#define AUDIO_FRACFREQ4		0xCBC148
#define AUDIO_MDIV4		0x14
#define AUDIO_INTFREQ5		0xD
#define AUDIO_FRACFREQ5		0x800000
#define AUDIO_MDIV5		0x14

#endif	/* endif _CLOCKS_TI816X_H_ */

