/**
 * \ingroup nas
 *
 * \file    qaGobiApiTableBandClasses.h
 *
 * \brief   Network Access Service API Band Classes table
 *
 * \section Table6 Band Classes (Value - Description)
 * \li 0 - CDMA Band Class 0
 * \li 1 - CDMA Band Class 1
 * \li 3 - CDMA Band Class 3
 * \li 4 - CDMA Band Class 4
 * \li 5 - CDMA Band Class 5
 * \li 6 - CDMA Band Class 6
 * \li 7 - CDMA Band Class 7
 * \li 8 - CDMA Band Class 8
 * \li 9 - CDMA Band Class 9
 * \li 10 - CDMA Band Class 10
 * \li 11 - CDMA Band Class 11
 * \li 12 - CDMA Band Class 12
 * \li 13 - CDMA Band Class 13
 * \li 14 - CDMA Band Class 14
 * \li 15 - CDMA Band Class 15
 * \li 16 - CDMA Band Class 16
 * \li 40 - GSM 450
 * \li 41 - GSM 480
 * \li 42 - GSM 750
 * \li 43 - GSM 850
 * \li 44 - GSM 900 (Extended)
 * \li 45 - GSM 900 (Primary)
 * \li 46 - GSM 900 (Railways)
 * \li 47 - GSM 1800
 * \li 48 - GSM 1900
 * \li 80 - WCDMA 2100
 * \li 81 - WCDMA PCS 1900
 * \li 82 - WCDMA DCS 1800
 * \li 83 - WCDMA 1700 (US)
 * \li 84 - WCDMA 850
 * \li 85 - WCDMA 800
 * \li 86 - WCDMA 2600
 * \li 87 - WCDMA 900
 * \li 88 - WCDMA 1700 (Japan)
 * \li 89 - WCDMA BC10-1700
 * \li 90 - WCDMA 1500 band
 * \li < Reserved 91-109 for WCDMA band classes>
 * \li 110 - WLAN US 2400 MHz
 * \li 111 - WLAN JAPAN 2400 MHz
 * \li 112 - WLAN EUROPEAN 2400 MHz
 * \li 113 - WLAN FRANCE 2400 MHz
 * \li 114 - WLAN SPAIN 2400 MHz
 * \li 115 - WLAN US 5000 MHz band
 * \li 116 - WLAN JAPAN 5000 MHz
 * \li 117 - WLAN EUROPEAN 5000 MHz
 * \li 118 - WLAN FRANCE 5000 MHz
 * \li 119 - WLAN SPAIN 5000 MHz
 * \subsection LTE LTE Bands
 * \li 120 - UL:1920-1980; DL:2110-2170
 * \li 121 - UL:1850-1910; DL:1930-1990
 * \li 122 - UL:1710-1785; DL:1805-1880
 * \li 123 - UL:1710-1755; DL:2110-2155
 * \li 124 - UL: 824- 849; DL: 869- 894
 * \li 125 - UL: 830- 840; DL: 875- 885
 * \li 126 - UL:2500-2570; DL:2620-2690
 * \li 127 - UL: 880- 915; DL: 925- 960
 * \li 128 - UL:1749.9-1784.9; DL:1844.9-1879.9
 * \li 129 - UL:1710-1770; DL:2110-2170
 * \li 130 - UL:1427.9-1452.9; DL:1475.9-1500.9
 * \li 131 - UL:698-716; DL:728-746
 * \li 132 - UL: 777- 787; DL: 746-756
 * \li 133 - UL: 788- 798; DL: 758-768
 * \li Reserved for BAND 15 16
 * \li 136 - UL: 704-716; DL: 734-746
 * \li 137 - UL: 815-830; DL: 860 ?875
 * \li 138 - UL: 830-845; DL: 875 ?890
 * \li 139 - UL: 832-862; DL: 791 ?821
 * \li 140 - UL: 1447.9-1462.9; DL: 1495.9-1510.9
 * \li Reserved for BAND 22 to 32
 * \li 152 - UL: 1900-1920; DL: 1900-1920
 * \li 153 - UL: 2010-2025; DL: 2010-2025
 * \li 154 - UL: 1850-1910; DL: 1850-1910
 * \li 155 - UL: 1930-1990; DL: 1930-1990
 * \li 156 - UL: 1910-1930; DL: 1910-1930
 * \li 157 - UL: 2570-2620; DL: 2570-2620
 * \li 158 - UL: 1880-1920; DL: 1880-1920
 * \li 159 - UL: 2300-2400; DL: 2300-2400
 *
 * Copyright: © 2011 Sierra Wireless, Inc. all rights reserved
 *
 */
#ifndef __GOBI_API_BANDCLASSES_H__
 #define __GOBI_API_BANDCLASSES_H__

#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
} /* extern "C" { */
#endif

#endif /* __GOBI_API_BANDCLASSES_H__ */
