#!/bin/bash
CURR_DIR=$PWD
TOOLS_DEVTREE=../../tools/Air_Vantage_Dev_Tree_v2
TOOLS_FWUPDAT=../../tools/Air_Vantage_fwupdate 
BUILD_ARM=build.arm
BUILD_X86=build.default


CONFIG_FILE_TAG='AVA_PATH'
SLQSHOSTTYPE=`uname -m`
CONFIG_FILE_PATH_X86='../../build/bin/host'$SLQSHOSTTYPE
CONFIG_FILE_PATH_ARM='../../build/bin/arm/'
CONFIG_FILE_NAME='.sdk_config'
CONFIG_FILE_NO_AVA='NO_AVA'


echo "--------------------------"
echo "---- Building AVAgent ----"
echo "--------------------------"


BUILD_CPU=$1

if [ -z $BUILD_CPU  ] ;\
    then echo "x86" ;\
	sudo rm -rf build.default
	./avagent_r8/bin/build.sh
	pushd $TOOLS_DEVTREE; make clean; make ; popd;
	pushd $TOOLS_FWUPDAT; make clean; make ; popd;
	pushd $BUILD_X86; make devtree2_install ; make slqs_fw_update ; popd;
	echo "$CONFIG_FILE_TAG=$CURR_DIR/$BUILD_X86/runtime" > $CONFIG_FILE_PATH_X86/$CONFIG_FILE_NAME
	echo "$CONFIG_FILE_TAG=$CONFIG_FILE_NO_AVA" >> $CONFIG_FILE_PATH_X86/$CONFIG_FILE_NAME
else
	if [ $BUILD_CPU = arm  ] ;\
        then echo "arm" ;\
		sudo rm -rf build.arm
		./avagent_r8/bin/build.sh -t arm
		pushd $TOOLS_DEVTREE; make clean; make CPU=arm ; popd;
		pushd $TOOLS_FWUPDAT; make clean; make CPU=arm ; popd;
		pushd $BUILD_ARM; make devtree2_install ; make slqs_fw_update ; popd;
		echo "$CONFIG_FILE_TAG=$CURR_DIR/$BUILD_ARM/runtime" > $CONFIG_FILE_PATH_ARM/$CONFIG_FILE_NAME
		echo "$CONFIG_FILE_TAG=$CONFIG_FILE_NO_AVA" >> $CONFIG_FILE_PATH_ARM/$CONFIG_FILE_NAME
	fi;                  
fi;



