/*
 * omap_hwmod_33xx_data.c: Hardware modules present on the AM33XX chips
 *
 * Copyright (C) {2011} Texas Instruments Incorporated - http://www.ti.com/
 *
 * This file is automatically generated from the AM33XX hardware databases.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#include <linux/io.h>
#include <linux/slab.h>
#include <linux/err.h>
#include <linux/errno.h>

#include <plat/omap_hwmod.h>
#include <plat/cpu.h>
#include <plat/gpio.h>
#include <plat/dma.h>
#include <plat/mmc.h>
#include <plat/mcspi.h>
#include <plat/i2c.h>
#include <plat/clock.h>
#include <plat/prcm.h>

#include "omap_hwmod_common_data.h"
#include "control.h"
#include "cm33xx.h"
#include "prm33xx.h"
#include "common.h"
#include "wd_timer.h"

/* Backward references (IPs with Bus Master capability) */
static struct omap_hwmod am33xx_mpu_hwmod;
static struct omap_hwmod am33xx_l3_main_hwmod;
static struct omap_hwmod am33xx_l3slow_hwmod;
static struct omap_hwmod am33xx_l4wkup_hwmod;
static struct omap_hwmod am33xx_l4per_hwmod;
static struct omap_hwmod am33xx_uart1_hwmod;
static struct omap_hwmod am33xx_uart2_hwmod;
static struct omap_hwmod am33xx_uart3_hwmod;
static struct omap_hwmod am33xx_uart4_hwmod;
static struct omap_hwmod am33xx_uart5_hwmod;
static struct omap_hwmod am33xx_uart6_hwmod;
static struct omap_hwmod am33xx_timer0_hwmod;
static struct omap_hwmod am33xx_timer1_hwmod;
static struct omap_hwmod am33xx_timer2_hwmod;
static struct omap_hwmod am33xx_timer3_hwmod;
static struct omap_hwmod am33xx_timer4_hwmod;
static struct omap_hwmod am33xx_timer5_hwmod;
static struct omap_hwmod am33xx_timer6_hwmod;
static struct omap_hwmod am33xx_timer7_hwmod;
static struct omap_hwmod am33xx_wd_timer1_hwmod;
static struct omap_hwmod am33xx_tpcc_hwmod;
static struct omap_hwmod am33xx_tptc0_hwmod;
static struct omap_hwmod am33xx_tptc1_hwmod;
static struct omap_hwmod am33xx_tptc2_hwmod;
static struct omap_hwmod am33xx_dcan0_hwmod;
static struct omap_hwmod am33xx_dcan1_hwmod;
static struct omap_hwmod am33xx_gpio0_hwmod;
static struct omap_hwmod am33xx_gpio1_hwmod;
static struct omap_hwmod am33xx_gpio2_hwmod;
static struct omap_hwmod am33xx_gpio3_hwmod;
static struct omap_hwmod am33xx_i2c1_hwmod;
static struct omap_hwmod am33xx_i2c2_hwmod;
static struct omap_hwmod am33xx_i2c3_hwmod;
static struct omap_hwmod am33xx_usbss_hwmod;
static struct omap_hwmod am33xx_mmc0_hwmod;
static struct omap_hwmod am33xx_mmc1_hwmod;
static struct omap_hwmod am33xx_mmc2_hwmod;
static struct omap_hwmod am33xx_spi0_hwmod;
static struct omap_hwmod am33xx_spi1_hwmod;
static struct omap_hwmod am33xx_elm_hwmod;
static struct omap_hwmod am33xx_adc_tsc_hwmod;
static struct omap_hwmod am33xx_rtc_hwmod;
static struct omap_hwmod am33xx_mcasp0_hwmod;
static struct omap_hwmod am33xx_mcasp1_hwmod;
static struct omap_hwmod am33xx_ehrpwm0_hwmod;
static struct omap_hwmod am33xx_ehrpwm1_hwmod;
static struct omap_hwmod am33xx_ehrpwm2_hwmod;
static struct omap_hwmod am33xx_ecap0_hwmod;
static struct omap_hwmod am33xx_ecap1_hwmod;
static struct omap_hwmod am33xx_ecap2_hwmod;
static struct omap_hwmod am33xx_gpmc_hwmod;
static struct omap_hwmod am33xx_lcdc_hwmod;
static struct omap_hwmod am33xx_mailbox_hwmod;
static struct omap_hwmod am33xx_cpgmac0_hwmod;
static struct omap_hwmod am33xx_mdio_hwmod;

/*
 * ERRATA: (Yet to conform from IP team)
 * As per the observation, in order to disable the cpsw clock/module
 * from already enabled state, module level reset assertion is
 * required; without reset the clock/module won't enter into
 * idle state at all.
 * Also, as per observation (have not conformed yet), we have to
 * assert reset signal for all cpsw (4) submodules.
 */

/* OCP SYSSTATUS bit shifts/masks */
#define SOFT_RESETDONE_SHIFT		0
#define SOFT_RESETDONE_MASK		(1 << SOFT_RESETDONE_SHIFT)

#define MAX_MODULE_SOFTRESET_WAIT	10000

static int am33xx_cpgmac_reset(struct omap_hwmod *oh)
{
	int i;
	int ret = 0;

	pr_debug("%s: resetting via Module SOFTRESET bit\n", oh->name);

	for (i = 0; i < oh->slaves_cnt; i++) {
		int c = 0;
		void __iomem *va_start;
		struct omap_hwmod_ocp_if *os;
		struct omap_hwmod_addr_space *mem;

		os = oh->slaves[i];
		/* FIXME: Only first instance's OCP_RST is asserted */
		mem = &os->addr[0];

		va_start = ioremap(mem->pa_start, mem->pa_end - mem->pa_start);
		if (!va_start) {
			pr_err("%s: Could not ioremap (%x)\n",
					oh->name, mem->pa_start);
			ret = -ENOMEM;
			break;
		}
		/* Assert reset signal */
		writel(1, va_start + oh->class->sysc->rst_offs);
		omap_test_timeout(((readl(va_start + oh->class->sysc->rst_offs)
					& SOFT_RESETDONE_MASK) == 0),
				MAX_MODULE_SOFTRESET_WAIT, c);

		if (c == MAX_MODULE_SOFTRESET_WAIT) {
			pr_warning("%s: softreset failed (waited %d usec)\n",
					oh->name, MAX_MODULE_SOFTRESET_WAIT);
			ret = -ETIMEDOUT;
		}
	}

	return ret;
}

/*
 * Interconnects hwmod structures
 * hwmods that compose the global AM33XX OCP interconnect
 */

/* MPU -> L3_SLOW Peripheral interface */
static struct omap_hwmod_ocp_if am33xx_mpu__l3_slow = {
	.master 	= &am33xx_mpu_hwmod,
	.slave		= &am33xx_l3slow_hwmod,
	.user		= OCP_USER_MPU,
};

/* L3 SLOW -> L4_PER Peripheral interface */
static struct omap_hwmod_ocp_if am33xx_l3_slow__l4_per = {
	.master 	= &am33xx_l3slow_hwmod,
	.slave		= &am33xx_l4per_hwmod,
	.user		= OCP_USER_MPU,
};

/* L3 SLOW -> L4_WKUP Peripheral interface */
static struct omap_hwmod_ocp_if am33xx_l3_slow__l4_wkup = {
	.master 	= &am33xx_l3slow_hwmod,
	.slave		= &am33xx_l4wkup_hwmod,
	.user		= OCP_USER_MPU,
};

/* Master interfaces on the L4_WKUP interconnect */
static struct omap_hwmod_ocp_if *am33xx_l3_slow_masters[] = {
	&am33xx_l3_slow__l4_per,
	&am33xx_l3_slow__l4_wkup,
};

/* Slave interfaces on the L3_SLOW interconnect */
static struct omap_hwmod_ocp_if *am33xx_l3_slow_slaves[] = {
	&am33xx_mpu__l3_slow,
};

static struct omap_hwmod am33xx_l3slow_hwmod = {
	.name		= "l3_slow",
	.class		= &l3_hwmod_class,
	.clkdm_name	= "l3s_clkdm",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.masters	= am33xx_l3_slow_masters,
	.masters_cnt	= ARRAY_SIZE(am33xx_l3_slow_masters),
	.slaves		= am33xx_l3_slow_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_l3_slow_slaves),
};

/* L4 PER -> DCAN0 */
static struct omap_hwmod_addr_space am33xx_dcan0_addrs[] = {
	{
		.pa_start	= 0x481CC000,
		.pa_end		= 0x481CC000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_per__dcan0 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_dcan0_hwmod,
	.clk		= "dcan0_ick",
	.addr		= am33xx_dcan0_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* L4 PER -> DCAN1 */
static struct omap_hwmod_addr_space am33xx_dcan1_addrs[] = {
	{
		.pa_start	= 0x481D0000,
		.pa_end		= 0x481D0000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_per__dcan1 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_dcan1_hwmod,
	.clk		= "dcan1_ick",
	.addr		= am33xx_dcan1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* L4 PER -> GPIO2 */
static struct omap_hwmod_addr_space am33xx_gpio1_addrs[] = {
	{
		.pa_start	= 0x4804C000,
		.pa_end		= 0x4804C000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_per__gpio1 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_gpio1_hwmod,
	.clk		= "l4ls_gclk",
	.addr		= am33xx_gpio1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* L4 PER -> GPIO3 */
static struct omap_hwmod_addr_space am33xx_gpio2_addrs[] = {
	{
		.pa_start	= 0x481AC000,
		.pa_end		= 0x481AC000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_per__gpio2 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_gpio2_hwmod,
	.clk		= "l4ls_gclk",
	.addr		= am33xx_gpio2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* L4 PER -> GPIO4 */
static struct omap_hwmod_addr_space am33xx_gpio3_addrs[] = {
	{
		.pa_start	= 0x481AE000,
		.pa_end		= 0x481AE000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_per__gpio3 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_gpio3_hwmod,
	.clk		= "l4ls_gclk",
	.addr		= am33xx_gpio3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* Master interfaces on the L4_PER interconnect */
static struct omap_hwmod_ocp_if *am33xx_l4_per_masters[] = {
	&am33xx_l4_per__dcan0,
	&am33xx_l4_per__dcan1,
	&am33xx_l4_per__gpio1,
	&am33xx_l4_per__gpio2,
	&am33xx_l4_per__gpio3,
};

/* Slave interfaces on the L4_PER interconnect */
static struct omap_hwmod_ocp_if *am33xx_l4_per_slaves[] = {
	&am33xx_l3_slow__l4_per,
};

static struct omap_hwmod am33xx_l4per_hwmod = {
	.name		= "l4_per",
	.class		= &l4_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.masters	= am33xx_l4_per_masters,
	.masters_cnt	= ARRAY_SIZE(am33xx_l4_per_masters),
	.slaves		= am33xx_l4_per_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_l4_per_slaves),
};

/* L4 WKUP -> I2C1 */
static struct omap_hwmod_addr_space am33xx_i2c1_addr_space[] = {
	{
		.pa_start	= 0x44E0B000,
		.pa_end		= 0x44E0B000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_wkup_i2c1 = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_i2c1_hwmod,
	.addr		= am33xx_i2c1_addr_space,
	.user		= OCP_USER_MPU,
};

/* L4 WKUP -> GPIO1 */
static struct omap_hwmod_addr_space am33xx_gpio0_addrs[] = {
	{
		.pa_start	= 0x44E07000,
		.pa_end		= 0x44E07000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_wkup__gpio0 = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_gpio0_hwmod,
	.clk		= "l4ls_gclk",
	.addr		= am33xx_gpio0_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* Master interfaces on the L4_WKUP interconnect */
static struct omap_hwmod_ocp_if *am33xx_l4_wkup_masters[] = {
	&am33xx_l4_wkup__gpio0,
};
/* Slave interfaces on the L4_WKUP interconnect */
static struct omap_hwmod_ocp_if *am33xx_l4_wkup_slaves[] = {
	&am33xx_l3_slow__l4_wkup,
};

static struct omap_hwmod am33xx_l4wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &l4_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.masters	= am33xx_l4_wkup_masters,
	.masters_cnt	= ARRAY_SIZE(am33xx_l4_wkup_masters),
	.slaves		= am33xx_l4_wkup_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_l4_wkup_slaves),
};

/* adc_tsc */
static struct omap_hwmod_class_sysconfig am33xx_adc_tsc_sysc = {
	.rev_offs	= 0x00,
	.sysc_offs	= 0x10,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class am33xx_adc_tsc_hwmod_class = {
	.name		= "adc_tsc",
	.sysc		= &am33xx_adc_tsc_sysc,
};

/* L4 WKUP -> ADC_TSC */
static struct omap_hwmod_addr_space am33xx_adc_tsc_addrs[] = {
	{
		.pa_start	= 0x44E0D000,
		.pa_end		= 0x44E0D000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_wkup_adc_tsc = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_adc_tsc_hwmod,
	.clk		= "adc_tsc_ick",
	.addr		= am33xx_adc_tsc_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_adc_tsc_slaves[] = {
	&am33xx_l4_wkup_adc_tsc,
};

static struct omap_hwmod_irq_info am33xx_adc_tsc_irqs[] = {
	{ .irq = 16 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_adc_tsc_hwmod = {
	.name		= "adc_tsc",
	.class		= &am33xx_adc_tsc_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_adc_tsc_irqs,
	.main_clk	= "adc_tsc_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_ADC_TSC_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_adc_tsc_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_adc_tsc_slaves),
};

/* 'aes' class */
static struct omap_hwmod_class am33xx_aes_hwmod_class = {
	.name		= "aes",
};

/* aes0 */
static struct omap_hwmod_irq_info am33xx_aes0_irqs[] = {
	{ .irq = 102 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_aes0_hwmod = {
	.name		= "aes0",
	.class		= &am33xx_aes_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.mpu_irqs	= am33xx_aes0_irqs,
	.main_clk	= "aes0_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_AES0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* cefuse */
static struct omap_hwmod_class am33xx_cefuse_hwmod_class = {
	.name		= "cefuse",
};

static struct omap_hwmod am33xx_cefuse_hwmod = {
	.name		= "cefuse",
	.class		= &am33xx_cefuse_hwmod_class,
	.clkdm_name	= "l4_cefuse_clkdm",
	.main_clk	= "cefuse_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_CEFUSE_CEFUSE_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* clkdiv32k */
static struct omap_hwmod_class am33xx_clkdiv32k_hwmod_class = {
	.name		= "clkdiv32k",
};

static struct omap_hwmod am33xx_clkdiv32k_hwmod = {
	.name		= "clkdiv32k",
	.class		= &am33xx_clkdiv32k_hwmod_class,
	.clkdm_name	= "clk_24mhz_clkdm",
	.main_clk	= "clkdiv32k_ick",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_CLKDIV32K_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
};

/* control */
static struct omap_hwmod_class am33xx_control_hwmod_class = {
	.name		= "control",
};

static struct omap_hwmod_irq_info am33xx_control_irqs[] = {
	{ .irq = 8 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_control_hwmod = {
	.name		= "control",
	.class		= &am33xx_control_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_control_irqs,
	.main_clk	= "control_fck",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_CONTROL_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* cpgmac0 */
static struct omap_hwmod_class_sysconfig am33xx_cpgmac_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x8,
	.syss_offs	= 0x4,
	.rst_offs	= 0x8,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_MIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | MSTANDBY_FORCE |
			MSTANDBY_NO),
	.sysc_fields	= &omap_hwmod_sysc_type3,
};

static struct omap_hwmod_class am33xx_cpgmac0_hwmod_class = {
	.name		= "cpsw",
	.sysc		= &am33xx_cpgmac_sysc,
	.reset		= am33xx_cpgmac_reset,
};

/* Used by driver */
struct omap_hwmod_addr_space am33xx_cpgmac0_addr_space[] = {
	/* cpsw ss */
	{
		.pa_start	= 0x4A100000,
		.pa_end		= 0x4A100000 + SZ_2K - 1,
		.flags		= ADDR_MAP_ON_INIT,
	},
	/* cpsw wr */
	{
		.pa_start	= 0x4A101200,
		.pa_end		= 0x4A101200 + SZ_256 - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__cpgmac0 = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_cpgmac0_hwmod,
	.addr		= am33xx_cpgmac0_addr_space,
	.user		= OCP_USER_MPU,
};

struct omap_hwmod_addr_space am33xx_cpsw_sl1_addr_space[] = {
	/* cpsw sl1 */
	{
		.pa_start	= 0x4A100D84,
		.pa_end		= 0x4A100D84 + SZ_32 - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__cpsw_sl1 = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_cpgmac0_hwmod,
	.addr		= am33xx_cpsw_sl1_addr_space,
	.user		= OCP_USER_MPU,
};

struct omap_hwmod_addr_space am33xx_cpsw_sl2_addr_space[] = {
	/* cpsw sl2 */
	{
		.pa_start	= 0x4A100DC4,
		.pa_end		= 0x4A100DC4 + SZ_32 - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__cpsw_sl2 = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_cpgmac0_hwmod,
	.addr		= am33xx_cpsw_sl2_addr_space,
	.user		= OCP_USER_MPU,
};

struct omap_hwmod_addr_space am33xx_cpsw_cpdma_addr_space[] = {
	/* cpsw cpdma */
	{
		.pa_start	= 0x4A100814,
		.pa_end		= 0x4A100814 + SZ_32 - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__cpsw_cpdma = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_cpgmac0_hwmod,
	.addr		= am33xx_cpsw_cpdma_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_cpgmac0_slaves[] = {
	&am33xx_l3_main__cpgmac0,
	&am33xx_l3_main__cpsw_sl1,
	&am33xx_l3_main__cpsw_sl2,
	&am33xx_l3_main__cpsw_cpdma,
};

static struct omap_hwmod_irq_info am33xx_cpgmac0_irqs[] = {
	{ .name = "c0_rx_thresh_pend", .irq = 40 },
	{ .name = "c0_rx_pend", .irq = 93 },
	{ .name = "c0_tx_pend", .irq = 94 },
	{ .name = "c0_misc_pend", .irq = 43 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_cpgmac0_hwmod = {
	.name		= "cpgmac0",
	.class		= &am33xx_cpgmac0_hwmod_class,
	.clkdm_name	= "cpsw_125mhz_clkdm",
	.mpu_irqs	= am33xx_cpgmac0_irqs,
	.main_clk	= "cpgmac0_ick",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_CPGMAC0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_cpgmac0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_cpgmac0_slaves),
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY |
				HWMOD_SWSUP_RESET_BEFORE_IDLE),
};

/* mdio class */
static struct omap_hwmod_class am33xx_mdio_hwmod_class = {
	.name		= "davinci_mdio",
};

struct omap_hwmod_addr_space am33xx_mdio_addr_space[] = {
	{
		.pa_start	= 0x4A101000,
		.pa_end		= 0x4A101000 + SZ_256 - 1,
		.flags		= ADDR_MAP_ON_INIT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_cpgmac0__mdio = {
	.master		= &am33xx_cpgmac0_hwmod,
	.slave		= &am33xx_mdio_hwmod,
	.addr		= am33xx_mdio_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mdio_slaves[] = {
	&am33xx_cpgmac0__mdio,
};

static struct omap_hwmod am33xx_mdio_hwmod = {
	.name		= "mdio",
	.class		= &am33xx_mdio_hwmod_class,
	.clkdm_name	= "cpsw_125mhz_clkdm",
	.main_clk	= "cpgmac0_ick",
	.slaves		= am33xx_mdio_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mdio_slaves),
};

/* 'dcan' class */
static struct omap_hwmod_class am33xx_dcan_hwmod_class = {
	.name		= "d_can",
};

/* dcan0 slave ports */
static struct omap_hwmod_ocp_if *am33xx_dcan0_slaves[] = {
	&am33xx_l4_per__dcan0,
};

/* dcan0 */
static struct omap_hwmod_irq_info am33xx_dcan0_irqs[] = {
	{ .name = "d_can_ms", .irq = 52 },
	{ .name = "d_can_mo", .irq = 53 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_dcan0_hwmod = {
	.name		= "d_can0",
	.class		= &am33xx_dcan_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_dcan0_irqs,
	.main_clk	= "dcan0_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_DCAN0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_dcan0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_dcan0_slaves),
};

/* dcan1 slave ports */
static struct omap_hwmod_ocp_if *am33xx_dcan1_slaves[] = {
	&am33xx_l4_per__dcan1,
};

/* dcan1 */
static struct omap_hwmod_irq_info am33xx_dcan1_irqs[] = {
	{ .name = "d_can_ms", .irq = 55 },
	{ .name = "d_can_mo", .irq = 56 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_dcan1_hwmod = {
	.name		= "d_can1",
	.class		= &am33xx_dcan_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_dcan1_irqs,
	.main_clk	= "dcan1_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_DCAN1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_dcan1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_dcan1_slaves),
};

/* debugss */
static struct omap_hwmod_class am33xx_debugss_hwmod_class = {
	.name		= "debugss",
};

static struct omap_hwmod am33xx_debugss_hwmod = {
	.name		= "debugss",
	.class		= &am33xx_debugss_hwmod_class,
	.clkdm_name	= "l3_aon_clkdm",
	.main_clk	= "debugss_ick",
#ifdef CONFIG_DEBUG_JTAG_ENABLE
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
#endif
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_DEBUGSS_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* elm */
static struct omap_hwmod_class_sysconfig am33xx_elm_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_CLOCKACTIVITY | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_SOFTRESET | SYSC_HAS_AUTOIDLE |
			SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class am33xx_elm_hwmod_class = {
	.name		= "elm",
	.sysc		= &am33xx_elm_sysc,
};

static struct omap_hwmod_irq_info am33xx_elm_irqs[] = {
	{ .irq = 4 },
	{ .irq = -1 }
};

struct omap_hwmod_addr_space am33xx_elm_addr_space[] = {
	{
		.pa_start	= 0x48080000,
		.pa_end		= 0x48080000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__elm = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_elm_hwmod,
	.addr		= am33xx_elm_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_elm_slaves[] = {
	&am33xx_l4_core__elm,
};

static struct omap_hwmod am33xx_elm_hwmod = {
	.name		= "elm",
	.class		= &am33xx_elm_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_elm_irqs,
	.main_clk	= "elm_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_ELM_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_elm_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_elm_slaves),
};

/* emif_fw */
static struct omap_hwmod_class am33xx_emif_fw_hwmod_class = {
	.name		= "emif_fw",
};

static struct omap_hwmod am33xx_emif_fw_hwmod = {
	.name		= "emif_fw",
	.class		= &am33xx_emif_fw_hwmod_class,
	.clkdm_name	= "l4fw_clkdm",
	.main_clk	= "emif_fw_fck",
	.flags		= HWMOD_INIT_NO_RESET | HWMOD_INIT_NO_IDLE,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_EMIF_FW_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* 'epwmss' class */
static struct omap_hwmod_class_sysconfig am33xx_epwmss_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x4,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_MIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class am33xx_epwmss_hwmod_class = {
	.name		= "epwmss",
	.sysc		= &am33xx_epwmss_sysc,
};

/* ehrpwm0 */
static struct omap_hwmod_irq_info am33xx_ehrpwm0_irqs[] = {
	{ .irq		= 86 },
	{ .irq		= 58 },
	{ .irq		= -1 }
};

struct omap_hwmod_addr_space am33xx_ehrpwm0_addr_space[] = {
/*
 * Splitting the resources to handle access of PWMSS config space and module
 * specific part independently
 */
	{
		.pa_start	= 0x48300000,
		.pa_end		= 0x48300000 + SZ_16 - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT
	},
	{
		.pa_start	= 0x48300000 + SZ_512,
		.pa_end		= 0x48300000 + SZ_512 + SZ_256 - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__ehrpwm0 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_ehrpwm0_hwmod,
	.addr		= am33xx_ehrpwm0_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_ehrpwm0_slaves[] = {
	&am33xx_l4_core__ehrpwm0,
};

static struct omap_hwmod_opt_clk ehrpwm0_opt_clks[] = {
	{ .role = "tbclk", .clk = "ehrpwm0_tbclk" },
};

static struct omap_hwmod am33xx_ehrpwm0_hwmod = {
	.name		= "ehrpwm.0",
	.mpu_irqs	= am33xx_ehrpwm0_irqs,
	.class		= &am33xx_epwmss_hwmod_class,
	.main_clk	= "epwmss0_fck",
	.clkdm_name	= "l4ls_clkdm",
	.slaves		= am33xx_ehrpwm0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_ehrpwm0_slaves),
	.opt_clks	= ehrpwm0_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(ehrpwm0_opt_clks),
};

/* ehrpwm1 */
static struct omap_hwmod_irq_info am33xx_ehrpwm1_irqs[] = {
	{ .irq		= 87 },
	{ .irq		= 59 },
	{ .irq		= -1 }
};

struct omap_hwmod_addr_space am33xx_ehrpwm1_addr_space[] = {
/*
 * Splitting the resources to handle access of PWMSS config space and module
 * specific part independently
 */
	{
		.pa_start	= 0x48302000,
		.pa_end		= 0x48302000 + SZ_16 - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT
	},
	{
		.pa_start	= 0x48302000 + SZ_512,
		.pa_end		= 0x48302000 + SZ_512 + SZ_256 - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__ehrpwm1 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_ehrpwm1_hwmod,
	.addr		= am33xx_ehrpwm1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_ehrpwm1_slaves[] = {
	&am33xx_l4_core__ehrpwm1,
};

static struct omap_hwmod_opt_clk ehrpwm1_opt_clks[] = {
	{ .role = "tbclk", .clk = "ehrpwm1_tbclk" },
};

static struct omap_hwmod am33xx_ehrpwm1_hwmod = {
	.name		= "ehrpwm.1",
	.mpu_irqs	= am33xx_ehrpwm1_irqs,
	.class		= &am33xx_epwmss_hwmod_class,
	.main_clk	= "epwmss1_fck",
	.clkdm_name	= "l4ls_clkdm",
	.slaves		= am33xx_ehrpwm1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_ehrpwm1_slaves),
	.opt_clks	= ehrpwm1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(ehrpwm1_opt_clks),
};

/* ehrpwm2 */
static struct omap_hwmod_irq_info am33xx_ehrpwm2_irqs[] = {
	{ .irq		= 39 },
	{ .irq		= 60 },
	{ .irq		= -1 }
};

struct omap_hwmod_addr_space am33xx_ehrpwm2_addr_space[] = {
/*
 * Splitting the resources to handle access of PWMSS config space and module
 * specific part independently
 */
	{
		.pa_start	= 0x48304000,
		.pa_end		= 0x48304000 + SZ_16 - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT
	},
	{
		.pa_start	= 0x48304000 + SZ_512,
		.pa_end		= 0x48304000 + SZ_512 + SZ_256 - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__ehrpwm2 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_ehrpwm2_hwmod,
	.addr		= am33xx_ehrpwm2_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_ehrpwm2_slaves[] = {
	&am33xx_l4_core__ehrpwm2,
};

static struct omap_hwmod_opt_clk ehrpwm2_opt_clks[] = {
	{ .role = "tbclk", .clk = "ehrpwm2_tbclk" },
};

static struct omap_hwmod am33xx_ehrpwm2_hwmod = {
	.name		= "ehrpwm.2",
	.mpu_irqs	= am33xx_ehrpwm2_irqs,
	.class		= &am33xx_epwmss_hwmod_class,
	.main_clk	= "epwmss2_fck",
	.clkdm_name	= "l4ls_clkdm",
	.slaves		= am33xx_ehrpwm2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_ehrpwm2_slaves),
	.opt_clks	= ehrpwm2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(ehrpwm2_opt_clks),
};

/* ecap0 */
static struct omap_hwmod_irq_info am33xx_ecap0_irqs[] = {
	{ .irq		= 31 },
	{ .irq		= -1 }
};

struct omap_hwmod_addr_space am33xx_ecap0_addr_space[] = {
/*
 * Splitting the resources to handle access of PWMSS config space and module
 * specific part independently
 */
	{
		.pa_start	= 0x48300000,
		.pa_end		= 0x48300000 + SZ_16 - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT
	},
	{
		.pa_start	= 0x48300000 + SZ_256,
		.pa_end		= 0x48300000 + SZ_256 + SZ_256 - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__ecap0 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_ecap0_hwmod,
	.addr		= am33xx_ecap0_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_ecap0_slaves[] = {
	&am33xx_l4_core__ecap0,
};

static struct omap_hwmod am33xx_ecap0_hwmod = {
	.name		= "ecap.0",
	.mpu_irqs	= am33xx_ecap0_irqs,
	.class		= &am33xx_epwmss_hwmod_class,
	.main_clk	= "epwmss0_fck",
	.clkdm_name	= "l4ls_clkdm",
	.slaves		= am33xx_ecap0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_ecap0_slaves),
};

/* ecap1 */
static struct omap_hwmod_irq_info am33xx_ecap1_irqs[] = {
	{ .irq		= 47 },
	{ .irq		= -1 }
};

struct omap_hwmod_addr_space am33xx_ecap1_addr_space[] = {
/*
 * Splitting the resources to handle access of PWMSS config space and module
 * specific part independently
 */
	{
		.pa_start	= 0x48302000,
		.pa_end		= 0x48302000 + SZ_16 - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT
	},
	{
		.pa_start	= 0x48302000 + SZ_256,
		.pa_end		= 0x48302000 + SZ_256 + SZ_256 - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__ecap1 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_ecap1_hwmod,
	.addr		= am33xx_ecap1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_ecap1_slaves[] = {
	&am33xx_l4_core__ecap1,
};

static struct omap_hwmod am33xx_ecap1_hwmod = {
	.name		= "ecap.1",
	.mpu_irqs	= am33xx_ecap1_irqs,
	.class		= &am33xx_epwmss_hwmod_class,
	.main_clk	= "epwmss1_fck",
	.clkdm_name	= "l4ls_clkdm",
	.slaves		= am33xx_ecap1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_ecap1_slaves),
};

/* ecap2 */
static struct omap_hwmod_irq_info am33xx_ecap2_irqs[] = {
	{ .irq		= 61 },
	{ .irq		= -1 }
};

struct omap_hwmod_addr_space am33xx_ecap2_addr_space[] = {
/*
 * Splitting the resources to handle access of PWMSS config space and module
 * specific part independently
 */
	{
		.pa_start	= 0x48304000,
		.pa_end		= 0x48304000 + SZ_16 - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT
	},
	{
		.pa_start	= 0x48304000 + SZ_256,
		.pa_end		= 0x48304000 + SZ_256 + SZ_256 - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__ecap2 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_ecap2_hwmod,
	.addr		= am33xx_ecap2_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_ecap2_slaves[] = {
	&am33xx_l4_core__ecap2,
};

static struct omap_hwmod am33xx_ecap2_hwmod = {
	.name		= "ecap.2",
	.mpu_irqs	= am33xx_ecap2_irqs,
	.class		= &am33xx_epwmss_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.main_clk	= "epwmss2_fck",
	.slaves		= am33xx_ecap2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_ecap2_slaves),
};

static struct omap_hwmod_class_sysconfig am33xx_gpio_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0114,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

/* 'gpio' class */
static struct omap_hwmod_class am33xx_gpio_hwmod_class = {
	.name		= "gpio",
	.sysc		= &am33xx_gpio_sysc,
	.rev		= 2,
};

static struct omap_gpio_dev_attr gpio_dev_attr = {
	.bank_width	= 32,
	.dbck_flag	= true,
};

/* gpio0 */
static struct omap_hwmod_ocp_if *am33xx_gpio0_slaves[] = {
	&am33xx_l4_wkup__gpio0,
};

static struct omap_hwmod_opt_clk gpio0_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio0_dbclk" },
};

static struct omap_hwmod_irq_info am33xx_gpio0_irqs[] = {
	{ .irq = 96 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_gpio0_hwmod = {
	.name		= "gpio1",
	.class		= &am33xx_gpio_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_gpio0_irqs,
	.main_clk	= "gpio0_ick",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET | HWMOD_INIT_NO_RESET,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_GPIO0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= gpio0_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio0_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= am33xx_gpio0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_gpio0_slaves),
};

/* gpio1 */
static struct omap_hwmod_irq_info am33xx_gpio1_irqs[] = {
	{ .irq = 98 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_gpio1_slaves[] = {
	&am33xx_l4_per__gpio1,
};

static struct omap_hwmod_opt_clk gpio1_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio1_dbclk" },
};

static struct omap_hwmod am33xx_gpio1_hwmod = {
	.name		= "gpio2",
	.class		= &am33xx_gpio_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_gpio1_irqs,
	.main_clk	= "gpio1_ick",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_GPIO1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= gpio1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio1_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= am33xx_gpio1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_gpio1_slaves),
};

/* gpio2 */
static struct omap_hwmod_irq_info am33xx_gpio2_irqs[] = {
	{ .irq = 32 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_gpio2_slaves[] = {
	&am33xx_l4_per__gpio2,
};

static struct omap_hwmod_opt_clk gpio2_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio2_dbclk" },
};

static struct omap_hwmod am33xx_gpio2_hwmod = {
	.name		= "gpio3",
	.class		= &am33xx_gpio_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_gpio2_irqs,
	.main_clk	= "gpio2_ick",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_GPIO2_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= gpio2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio2_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= am33xx_gpio2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_gpio2_slaves),
};

/* gpio3 */
static struct omap_hwmod_irq_info am33xx_gpio3_irqs[] = {
	{ .irq = 62 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_gpio3_slaves[] = {
	&am33xx_l4_per__gpio3,
};

static struct omap_hwmod_opt_clk gpio3_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio3_dbclk" },
};

static struct omap_hwmod am33xx_gpio3_hwmod = {
	.name		= "gpio4",
	.class		= &am33xx_gpio_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_gpio3_irqs,
	.main_clk	= "gpio3_ick",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_GPIO3_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= gpio3_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio3_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= am33xx_gpio3_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_gpio3_slaves),
};

/* gpmc */
static struct omap_hwmod_class_sysconfig gpmc_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x10,
	.syss_offs	= 0x14,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class am33xx_gpmc_hwmod_class = {
	.name		= "gpmc",
	.sysc		= &gpmc_sysc,
};

struct omap_hwmod_addr_space am33xx_gpmc_addr_space[] = {
	{
		.pa_start	= 0x50000000,
		.pa_end		= 0x50000000 + SZ_8K - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__gpmc = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_gpmc_hwmod,
	.addr		= am33xx_gpmc_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_gpmc_slaves[] = {
	&am33xx_l3_main__gpmc,
};

static struct omap_hwmod_irq_info am33xx_gpmc_irqs[] = {
	{ .irq = 100 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_gpmc_hwmod = {
	.name		= "gpmc",
	.class		= &am33xx_gpmc_hwmod_class,
	.clkdm_name	= "l3s_clkdm",
	.mpu_irqs	= am33xx_gpmc_irqs,
	.main_clk	= "gpmc_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_GPMC_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_gpmc_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_gpmc_slaves),
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY |
				HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
};

/* 'i2c' class */
static struct omap_hwmod_class_sysconfig am33xx_i2c_sysc = {
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0090,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_i2c_dev_attr i2c_dev_attr = {
	.flags		= OMAP_I2C_FLAG_BUS_SHIFT_NONE |
					OMAP_I2C_FLAG_RESET_REGS_POSTIDLE,
};

static struct omap_hwmod_class i2c_class = {
	.name		= "i2c",
	.sysc		= &am33xx_i2c_sysc,
	.rev		= OMAP_I2C_IP_VERSION_2,
	.reset		= &omap_i2c_reset,
};

/* I2C1 */
static struct omap_hwmod_irq_info i2c1_mpu_irqs[] = {
	{ .irq = 70 },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info i2c1_edma_reqs[] = {
	{ .name = "tx", .dma_req = 0, },
	{ .name = "rx", .dma_req = 0, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_i2c1_slaves[] = {
	&am33xx_l4_wkup_i2c1,
};

static struct omap_hwmod am33xx_i2c1_hwmod = {
	.name		= "i2c1",
	.class		= &i2c_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= i2c1_mpu_irqs,
	.main_clk	= "i2c1_fck",
	.sdma_reqs	= i2c1_edma_reqs,
	.flags		= HWMOD_16BIT_REG,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_I2C0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
	.slaves		= am33xx_i2c1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_i2c1_slaves),
};

/* i2c2 */
static struct omap_hwmod_addr_space am33xx_i2c2_addr_space[] = {
	{
		.pa_start	= 0x4802A000,
		.pa_end		= 0x4802A000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am335_l4_per_i2c2 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_i2c2_hwmod,
	.addr		= am33xx_i2c2_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_irq_info i2c2_mpu_irqs[] = {
	{ .irq = 71 },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info i2c2_edma_reqs[] = {
	{ .name = "tx", .dma_req = 0, },
	{ .name = "rx", .dma_req = 0, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_i2c2_slaves[] = {
	&am335_l4_per_i2c2,
};

static struct omap_hwmod am33xx_i2c2_hwmod = {
	.name		= "i2c2",
	.class		= &i2c_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= i2c2_mpu_irqs,
	.main_clk	= "i2c2_fck",
	.sdma_reqs	= i2c2_edma_reqs,
	.flags		= HWMOD_16BIT_REG,
	.prcm		= {
		.omap4 = {
			.clkctrl_offs	= AM33XX_CM_PER_I2C1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
	.slaves		= am33xx_i2c2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_i2c2_slaves),
};

/* I2C3 */
static struct omap_hwmod_addr_space am33xx_i2c3_addr_space[] = {
	{
		.pa_start	= 0x4819C000,
		.pa_end		= 0x4819C000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am335_l4_per_i2c3 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_i2c3_hwmod,
	.addr		= am33xx_i2c3_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_i2c3_slaves[] = {
	&am335_l4_per_i2c3,
};

static struct omap_hwmod_dma_info i2c3_edma_reqs[] = {
	{ .name = "tx", .dma_req = 0, },
	{ .name = "rx", .dma_req = 0, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_irq_info i2c3_mpu_irqs[] = {
	{ .irq = 30 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_i2c3_hwmod = {
	.name		= "i2c3",
	.class		= &i2c_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= i2c3_mpu_irqs,
	.main_clk	= "i2c3_fck",
	.sdma_reqs	= i2c3_edma_reqs,
	.flags		= HWMOD_16BIT_REG,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_I2C2_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &i2c_dev_attr,
	.slaves		= am33xx_i2c3_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_i2c3_slaves),
};


/* ieee5000 */
static struct omap_hwmod_class am33xx_ieee5000_hwmod_class = {
	.name		= "ieee5000",
};

static struct omap_hwmod am33xx_ieee5000_hwmod = {
	.name		= "ieee5000",
	.class		= &am33xx_ieee5000_hwmod_class,
	.clkdm_name	= "l3s_clkdm",
	.main_clk	= "ieee5000_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_IEEE5000_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};


/* 'l3' class */
static struct omap_hwmod_class am33xx_l3_hwmod_class = {
	.name		= "l3",
};

/* l4_hs */
static struct omap_hwmod am33xx_l4_hs_hwmod = {
	.name		= "l4_hs",
	.class		= &am33xx_l3_hwmod_class,
	.clkdm_name	= "l4hs_clkdm",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_L4HS_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* l3_instr */
static struct omap_hwmod am33xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &am33xx_l3_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_L3_INSTR_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* l3_main */
static struct omap_hwmod am33xx_l3_main_hwmod = {
	.name		= "l3_main",
	.class		= &am33xx_l3_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_L3_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* 'l4fw' class */
static struct omap_hwmod_class am33xx_l4fw_hwmod_class = {
	.name		= "l4fw",
};

/* l4fw */
static struct omap_hwmod am33xx_l4fw_hwmod = {
	.name		= "l4fw",
	.class		= &am33xx_l4fw_hwmod_class,
	.clkdm_name	= "l4fw_clkdm",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_L4FW_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* 'l4ls' class */
static struct omap_hwmod_class am33xx_l4ls_hwmod_class = {
	.name		= "l4ls",
};

/* l4ls */
static struct omap_hwmod am33xx_l4ls_hwmod = {
	.name		= "l4ls",
	.class		= &am33xx_l4ls_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.main_clk	= "l4ls_gclk",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_L4LS_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* lcdc */
static struct omap_hwmod_class_sysconfig lcdc_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x54,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_MIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class am33xx_lcdc_hwmod_class = {
	.name		= "lcdc",
	.sysc		= &lcdc_sysc,
};

static struct omap_hwmod_irq_info am33xx_lcdc_irqs[] = {
	{ .irq = 36 },
	{ .irq = -1 }
};

struct omap_hwmod_addr_space am33xx_lcdc_addr_space[] = {
	{
		.pa_start	= 0x4830E000,
		.pa_end		= 0x4830E000 + SZ_8K - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__lcdc = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_lcdc_hwmod,
	.addr		= am33xx_lcdc_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_lcdc_slaves[] = {
	&am33xx_l3_main__lcdc,
};

static struct omap_hwmod am33xx_lcdc_hwmod = {
	.name		= "lcdc",
	.class		= &am33xx_lcdc_hwmod_class,
	.clkdm_name	= "lcdc_clkdm",
	.mpu_irqs	= am33xx_lcdc_irqs,
	.main_clk	= "lcdc_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_LCDC_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_lcdc_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_lcdc_slaves),
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY),
};

/*
 * 'mailbox' class
 * mailbox module allowing communication between the on-chip processors using a
 * queued mailbox-interrupt mechanism.
 */

static struct omap_hwmod_class_sysconfig am33xx_mailbox_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class am33xx_mailbox_hwmod_class = {
	.name	= "mailbox",
	.sysc	= &am33xx_mailbox_sysc,
};

static struct omap_hwmod_irq_info am33xx_mailbox_irqs[] = {
	{ .irq = 77 },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space am33xx_mailbox_addrs[] = {
	{
		.pa_start	= 0x480C8000,
		.pa_end		= 0x480C8000 + (SZ_4K - 1),
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> mailbox */
static struct omap_hwmod_ocp_if am33xx_l4_per__mailbox = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_mailbox_hwmod,
	.addr		= am33xx_mailbox_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mailbox_slaves[] = {
	&am33xx_l4_per__mailbox,
};

static struct omap_hwmod am33xx_mailbox_hwmod = {
	.name		= "mailbox",
	.class		= &am33xx_mailbox_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_mailbox_irqs,
	.main_clk	= "mailbox0_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs	= AM33XX_CM_PER_MAILBOX0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_mailbox_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mailbox_slaves),
};

/* 'mcasp' class */

static struct omap_hwmod_class_sysconfig am33xx_mcasp_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x4,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type3,
};

static struct omap_hwmod_class am33xx_mcasp_hwmod_class = {
	.name	= "mcasp",
	.sysc	= &am33xx_mcasp_sysc,
};

/* mcasp0 */
static struct omap_hwmod_irq_info am33xx_mcasp0_irqs[] = {
	{ .name = "ax", .irq = 80, },
	{ .name = "ar", .irq = 81, },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info am33xx_mcasp0_edma_reqs[] = {
	{ .name = "tx", .dma_req = AM33XX_DMA_MCASP0_X, },
	{ .name = "rx", .dma_req = AM33XX_DMA_MCASP0_R, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space am33xx_mcasp0_addr_space[] = {
	{
		.pa_start	= 0x48038000,
		.pa_end		= 0x48038000 + (SZ_1K * 12) - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l3_slow__mcasp0 = {
	.master		= &am33xx_l3slow_hwmod,
	.slave		= &am33xx_mcasp0_hwmod,
	.clk		= "mcasp0_ick",
	.addr		= am33xx_mcasp0_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mcasp0_slaves[] = {
	&am33xx_l3_slow__mcasp0,
};

static struct omap_hwmod am33xx_mcasp0_hwmod = {
	.name		= "mcasp0",
	.class		= &am33xx_mcasp_hwmod_class,
	.clkdm_name	= "l3s_clkdm",
	.mpu_irqs	= am33xx_mcasp0_irqs,
	.sdma_reqs	= am33xx_mcasp0_edma_reqs,
	.main_clk	= "mcasp0_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_MCASP0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_mcasp0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mcasp0_slaves),
};

/* mcasp1 */
static struct omap_hwmod_irq_info am33xx_mcasp1_irqs[] = {
	{ .name = "ax", .irq = 82, },
	{ .name = "ar", .irq = 83, },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info am33xx_mcasp1_edma_reqs[] = {
	{ .name = "tx", .dma_req = AM33XX_DMA_MCASP1_X, },
	{ .name = "rx", .dma_req = AM33XX_DMA_MCASP1_R, },
	{ .dma_req = -1 }
};


static struct omap_hwmod_addr_space am33xx_mcasp1_addr_space[] = {
	{
		.pa_start	= 0x4803C000,
		.pa_end		= 0x4803C000 + (SZ_1K * 12) - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l3_slow__mcasp1 = {
	.master		= &am33xx_l3slow_hwmod,
	.slave		= &am33xx_mcasp1_hwmod,
	.clk		= "mcasp1_ick",
	.addr		= am33xx_mcasp1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mcasp1_slaves[] = {
	&am33xx_l3_slow__mcasp1,
};

static struct omap_hwmod am33xx_mcasp1_hwmod = {
	.name		= "mcasp1",
	.class		= &am33xx_mcasp_hwmod_class,
	.clkdm_name	= "l3s_clkdm",
	.mpu_irqs	= am33xx_mcasp1_irqs,
	.sdma_reqs	= am33xx_mcasp1_edma_reqs,
	.main_clk	= "mcasp1_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_MCASP1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_mcasp1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mcasp1_slaves),
};

/* 'mmc' class */
static struct omap_hwmod_class_sysconfig am33xx_mmc_sysc = {
	.rev_offs	= 0x1fc,
	.sysc_offs	= 0x10,
	.syss_offs	= 0x14,
	.sysc_flags	= (SYSC_HAS_CLOCKACTIVITY | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_ENAWAKEUP | SYSC_HAS_SOFTRESET |
			SYSC_HAS_AUTOIDLE | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class am33xx_mmc_hwmod_class = {
	.name		= "mmc",
	.sysc		= &am33xx_mmc_sysc,
};

/* mmc0 */
static struct omap_hwmod_irq_info am33xx_mmc0_irqs[] = {
	{ .irq = 64 },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info am33xx_mmc0_edma_reqs[] = {
	{ .name = "tx", .dma_req = 24, },
	{ .name = "rx", .dma_req = 25, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space am33xx_mmc0_addr_space[] = {
	{
		.pa_start	= 0x48060100,
		.pa_end		= 0x48060100 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4ls__mmc0 = {
	.master		= &am33xx_l4ls_hwmod,
	.slave		= &am33xx_mmc0_hwmod,
	.clk		= "mmc0_ick",
	.addr		= am33xx_mmc0_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mmc0_slaves[] = {
	&am33xx_l4ls__mmc0,
};

static struct omap_mmc_dev_attr am33xx_mmc0_dev_attr = {
	.flags		= OMAP_HSMMC_SUPPORTS_DUAL_VOLT,
};

static struct omap_hwmod am33xx_mmc0_hwmod = {
	.name		= "mmc1",
	.class		= &am33xx_mmc_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_mmc0_irqs,
	.main_clk	= "mmc0_fck",
	.sdma_reqs	= am33xx_mmc0_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_MMC0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &am33xx_mmc0_dev_attr,
	.slaves		= am33xx_mmc0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mmc0_slaves),
};

/* mmc1 */
static struct omap_hwmod_irq_info am33xx_mmc1_irqs[] = {
	{ .irq = 28 },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info am33xx_mmc1_edma_reqs[] = {
	{ .name = "tx", .dma_req = 2, },
	{ .name = "rx", .dma_req = 3, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space am33xx_mmc1_addr_space[] = {
	{
		.pa_start	= 0x481D8100,
		.pa_end		= 0x481D8100 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4ls__mmc1 = {
	.master		= &am33xx_l4ls_hwmod,
	.slave		= &am33xx_mmc1_hwmod,
	.clk		= "mmc1_ick",
	.addr		= am33xx_mmc1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mmc1_slaves[] = {
	&am33xx_l4ls__mmc1,
};

static struct omap_mmc_dev_attr am33xx_mmc1_dev_attr = {
	.flags		= OMAP_HSMMC_SUPPORTS_DUAL_VOLT,
};

static struct omap_hwmod am33xx_mmc1_hwmod = {
	.name		= "mmc2",
	.class		= &am33xx_mmc_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_mmc1_irqs,
	.main_clk	= "mmc1_fck",
	.sdma_reqs	= am33xx_mmc1_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_MMC1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &am33xx_mmc1_dev_attr,
	.slaves		= am33xx_mmc1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mmc1_slaves),
};

/* mmc2 */
static struct omap_hwmod_irq_info am33xx_mmc2_irqs[] = {
	{ .irq = 29 },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info am33xx_mmc2_edma_reqs[] = {
	{ .name = "tx", .dma_req = 64, },
	{ .name = "rx", .dma_req = 65, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space am33xx_mmc2_addr_space[] = {
	{
		.pa_start	= 0x47810100,
		.pa_end		= 0x47810100 + SZ_64K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l3_main__mmc2 = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_mmc2_hwmod,
	.clk		= "mmc2_ick",
	.addr		= am33xx_mmc2_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mmc2_slaves[] = {
	&am33xx_l3_main__mmc2,
};

static struct omap_mmc_dev_attr am33xx_mmc2_dev_attr = {
	.flags		= OMAP_HSMMC_SUPPORTS_DUAL_VOLT,
};
static struct omap_hwmod am33xx_mmc2_hwmod = {
	.name		= "mmc3",
	.class		= &am33xx_mmc_hwmod_class,
	.clkdm_name	= "l3s_clkdm",
	.mpu_irqs	= am33xx_mmc2_irqs,
	.main_clk	= "mmc2_fck",
	.sdma_reqs	= am33xx_mmc2_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_MMC2_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &am33xx_mmc2_dev_attr,
	.slaves		= am33xx_mmc2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mmc2_slaves),
};

/* Master interfaces on the MPU interconnect */
static struct omap_hwmod_ocp_if *am33xx_l3_mpu_masters[] = {
	&am33xx_mpu__l3_slow,
};

/* mpu */
static struct omap_hwmod am33xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &mpu_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.main_clk	= "mpu_fck",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_MPU_MPU_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.masters	= am33xx_l3_mpu_masters,
	.masters_cnt	= ARRAY_SIZE(am33xx_l3_mpu_masters),
};

/* ocmcram */
static struct omap_hwmod_class am33xx_ocmcram_hwmod_class = {
	.name = "ocmcram",
};

static struct omap_hwmod am33xx_ocmcram_hwmod = {
	.name		= "ocmcram",
	.class		= &am33xx_ocmcram_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.main_clk	= "ocmcram_ick",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_OCMCRAM_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* ocpwp */
static struct omap_hwmod_class am33xx_ocpwp_hwmod_class = {
	.name		= "ocpwp",
};

static struct omap_hwmod am33xx_ocpwp_hwmod = {
	.name		= "ocpwp",
	.class		= &am33xx_ocpwp_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.main_clk	= "ocpwp_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_OCPWP_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

static struct omap_hwmod_class_sysconfig am33xx_rtc_sysc = {
	.rev_offs	= 0x74,
	.sysc_offs	= 0x78,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type3,
};

/* rtc */
static struct omap_hwmod_class am33xx_rtc_hwmod_class = {
	.name		= "rtc",
	.sysc		= &am33xx_rtc_sysc,
};

static struct omap_hwmod_irq_info am33xx_rtc_irqs[] = {
	{ .irq = 75 },
	{ .irq = 76 },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space am33xx_rtc_addrs[] = {
	{
		.pa_start	= 0x44E3E000,
		.pa_end		= 0x44E3E000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_wkup_rtc = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_rtc_hwmod,
	.clk		= "rtc_ick",
	.addr		= am33xx_rtc_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_adc_rtc_slaves[] = {
	&am33xx_l4_wkup_rtc,
};

static struct omap_hwmod am33xx_rtc_hwmod = {
	.name		= "rtc",
	.class		= &am33xx_rtc_hwmod_class,
	.clkdm_name	= "l4_rtc_clkdm",
	.mpu_irqs	= am33xx_rtc_irqs,
	.main_clk	= "rtc_fck",
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET), /* ??? */
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_RTC_RTC_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_adc_rtc_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_adc_rtc_slaves),
};

/* sha0 */
static struct omap_hwmod_class am33xx_sha0_hwmod_class = {
	.name		= "sha0",
};

static struct omap_hwmod_irq_info am33xx_sha0_irqs[] = {
	{ .irq = 108 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_sha0_hwmod = {
	.name		= "sha0",
	.class		= &am33xx_sha0_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.mpu_irqs	= am33xx_sha0_irqs,
	.main_clk	= "sha0_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_SHA0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* 'smartreflex' class */
static struct omap_hwmod_class am33xx_smartreflex_hwmod_class = {
	.name		= "smartreflex",
};

/* smartreflex0 */
static struct omap_hwmod_irq_info am33xx_smartreflex0_irqs[] = {
	{ .irq = 120 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_smartreflex0_hwmod = {
	.name		= "smartreflex0",
	.class		= &am33xx_smartreflex_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_smartreflex0_irqs,
	.main_clk	= "smartreflex0_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_SMARTREFLEX0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* smartreflex1 */
static struct omap_hwmod_irq_info am33xx_smartreflex1_irqs[] = {
	{ .irq = 121 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_smartreflex1_hwmod = {
	.name		= "smartreflex1",
	.class		= &am33xx_smartreflex_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_smartreflex1_irqs,
	.main_clk	= "smartreflex1_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_SMARTREFLEX1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* 'spi' class */
static struct omap_hwmod_class_sysconfig am33xx_mcspi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0110,
	.syss_offs	= 0x0114,
	.sysc_flags	= (SYSC_HAS_CLOCKACTIVITY | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_SOFTRESET | SYSC_HAS_AUTOIDLE |
			SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class am33xx_spi_hwmod_class = {
	.name		= "mcspi",
	.sysc		= &am33xx_mcspi_sysc,
	.rev		= OMAP4_MCSPI_REV,
};

/* spi0 */
static struct omap_hwmod_irq_info am33xx_spi0_irqs[] = {
	{ .irq = 65 },
	{ .irq = -1 }
};

struct omap_hwmod_dma_info am33xx_mcspi0_edma_reqs[] = {
	{ .name = "rx0", .dma_req = 17 },
	{ .name = "tx0", .dma_req = 16 },
	{ .name = "rx1", .dma_req = 19 },
	{ .name = "tx1", .dma_req = 18 },
	{ .dma_req = -1 }
};

struct omap_hwmod_addr_space am33xx_mcspi0_addr_space[] = {
	{
		.pa_start	= 0x48030000,
		.pa_end		= 0x48030000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__mcspi0 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_spi0_hwmod,
	.clk		= "spi0_ick",
	.addr		= am33xx_mcspi0_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mcspi0_slaves[] = {
	&am33xx_l4_core__mcspi0,
};

struct omap2_mcspi_dev_attr mcspi_attrib = {
	.num_chipselect	= 2,
};
static struct omap_hwmod am33xx_spi0_hwmod = {
	.name		= "spi0",
	.class		= &am33xx_spi_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_spi0_irqs,
	.main_clk	= "spi0_fck",
	.sdma_reqs	= am33xx_mcspi0_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_SPI0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi_attrib,
	.slaves		= am33xx_mcspi0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mcspi0_slaves),
};

/* spi1 */
static struct omap_hwmod_irq_info am33xx_spi1_irqs[] = {
	{ .irq = 125 },
	{ .irq = -1 }
};

struct omap_hwmod_dma_info am33xx_mcspi1_edma_reqs[] = {
	{ .name = "rx0", .dma_req = 43 },
	{ .name = "tx0", .dma_req = 42 },
	{ .name = "rx1", .dma_req = 45 },
	{ .name = "tx1", .dma_req = 44 },
	{ .dma_req = -1 }
};

struct omap_hwmod_addr_space am33xx_mcspi1_addr_space[] = {
	{
		.pa_start	= 0x481A0000,
		.pa_end		= 0x481A0000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l4_core__mcspi1 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_spi1_hwmod,
	.clk		= "spi1_ick",
	.addr		= am33xx_mcspi1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_mcspi1_slaves[] = {
	&am33xx_l4_core__mcspi1,
};
static struct omap_hwmod am33xx_spi1_hwmod = {
	.name		= "spi1",
	.class		= &am33xx_spi_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_spi1_irqs,
	.main_clk	= "spi1_fck",
	.sdma_reqs	= am33xx_mcspi1_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_SPI1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi_attrib,
	.slaves		= am33xx_mcspi1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_mcspi1_slaves),
};

/* spinlock */
static struct omap_hwmod_class am33xx_spinlock_hwmod_class = {
	.name		= "spinlock",
};

static struct omap_hwmod am33xx_spinlock_hwmod = {
	.name		= "spinlock",
	.class		= &am33xx_spinlock_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.main_clk	= "spinlock_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_SPINLOCK_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/* 'timer 0 & 2-7' class */
static struct omap_hwmod_class_sysconfig am33xx_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class am33xx_timer_hwmod_class = {
	.name		= "timer",
	.sysc		= &am33xx_timer_sysc,
};

/* timer0 */
/* l4 wkup -> timer0 interface */
static struct omap_hwmod_addr_space am33xx_timer0_addr_space[] = {
	{
		.pa_start	= 0x44E05000,
		.pa_end		= 0x44E05000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4wkup__timer0 = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_timer0_hwmod,
	.clk		= "timer0_ick",
	.addr		= am33xx_timer0_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer0_slaves[] = {
	&am33xx_l4wkup__timer0,
};

static struct omap_hwmod_irq_info am33xx_timer0_irqs[] = {
	{ .irq = 66 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer0_hwmod = {
	.name		= "timer0",
	.class		= &am33xx_timer_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_timer0_irqs,
	.main_clk	= "timer0_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_TIMER0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer0_slaves),
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
};

/* timer1 1ms */
static struct omap_hwmod_class_sysconfig am33xx_timer1ms_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_CLOCKACTIVITY | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_SOFTRESET | SYSC_HAS_AUTOIDLE |
			SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class am33xx_timer1ms_hwmod_class = {
	.name		= "timer",
	.sysc		= &am33xx_timer1ms_sysc,
};

/* l4 wkup -> timer1 interface */
static struct omap_hwmod_addr_space am33xx_timer1_addr_space[] = {
	{
		.pa_start	= 0x44E31000,
		.pa_end		= 0x44E31000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4wkup__timer1 = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_timer1_hwmod,
	.clk		= "timer1_ick",
	.addr		= am33xx_timer1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer1_slaves[] = {
	&am33xx_l4wkup__timer1,
};

static struct omap_hwmod_irq_info am33xx_timer1_irqs[] = {
	{ .irq = 67 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer1_hwmod = {
	.name		= "timer1",
	.class		= &am33xx_timer1ms_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_timer1_irqs,
	.main_clk	= "timer1_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_TIMER1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer1_slaves),
};

/* timer2 */
/* l4 per -> timer2 interface */
static struct omap_hwmod_addr_space am33xx_timer2_addr_space[] = {
	{
		.pa_start	= 0x48040000,
		.pa_end		= 0x48040000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4per__timer2 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_timer2_hwmod,
	.clk		= "timer2_ick",
	.addr		= am33xx_timer2_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer2_slaves[] = {
	&am33xx_l4per__timer2,
};

static struct omap_hwmod_irq_info am33xx_timer2_irqs[] = {
	{ .irq = 68 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer2_hwmod = {
	.name		= "timer2",
	.class		= &am33xx_timer_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_timer2_irqs,
	.main_clk	= "timer2_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TIMER2_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer2_slaves),
};

/* timer3 */
/* l4 per -> timer3 interface */
static struct omap_hwmod_addr_space am33xx_timer3_addr_space[] = {
	{
		.pa_start	= 0x48042000,
		.pa_end		= 0x48042000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4per__timer3 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_timer3_hwmod,
	.clk		= "timer3_ick",
	.addr		= am33xx_timer3_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer3_slaves[] = {
	&am33xx_l4per__timer3,
};

static struct omap_hwmod_irq_info am33xx_timer3_irqs[] = {
	{ .irq = 69 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer3_hwmod = {
	.name		= "timer3",
	.class		= &am33xx_timer_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_timer3_irqs,
	.main_clk	= "timer3_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TIMER3_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer3_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer3_slaves),
};

/* timer4 */
/* l4 per -> timer4 interface */
static struct omap_hwmod_addr_space am33xx_timer4_addr_space[] = {
	{
		.pa_start	= 0x48044000,
		.pa_end		= 0x48044000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4per__timer4 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_timer4_hwmod,
	.clk		= "timer4_ick",
	.addr		= am33xx_timer4_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer4_slaves[] = {
	&am33xx_l4per__timer4,
};

static struct omap_hwmod_irq_info am33xx_timer4_irqs[] = {
	{ .irq = 92 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer4_hwmod = {
	.name		= "timer4",
	.class		= &am33xx_timer_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_timer4_irqs,
	.main_clk	= "timer4_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TIMER4_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer4_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer4_slaves),
};

/* timer5 */
/* l4 per -> timer5 interface */
static struct omap_hwmod_addr_space am33xx_timer5_addr_space[] = {
	{
		.pa_start	= 0x48046000,
		.pa_end		= 0x48046000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4per__timer5 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_timer5_hwmod,
	.clk		= "timer5_ick",
	.addr		= am33xx_timer5_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer5_slaves[] = {
	&am33xx_l4per__timer5,
};

static struct omap_hwmod_irq_info am33xx_timer5_irqs[] = {
	{ .irq = 93 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer5_hwmod = {
	.name		= "timer5",
	.class		= &am33xx_timer_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_timer5_irqs,
	.main_clk	= "timer5_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TIMER5_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer5_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer5_slaves),
};

/* timer6 */
/* l4 per -> timer6 interface */
static struct omap_hwmod_addr_space am33xx_timer6_addr_space[] = {
	{
		.pa_start	= 0x48048000,
		.pa_end		= 0x48048000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4per__timer6 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_timer6_hwmod,
	.clk		= "timer6_ick",
	.addr		= am33xx_timer6_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer6_slaves[] = {
	&am33xx_l4per__timer6,
};

static struct omap_hwmod_irq_info am33xx_timer6_irqs[] = {
	{ .irq = 94 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer6_hwmod = {
	.name		= "timer6",
	.class		= &am33xx_timer_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_timer6_irqs,
	.main_clk	= "timer6_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TIMER6_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer6_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer6_slaves),
};

/* timer7 */
/* l4 per -> timer7 interface */
static struct omap_hwmod_addr_space am33xx_timer7_addr_space[] = {
	{
		.pa_start	= 0x4804A000,
		.pa_end		= 0x4804A000 + SZ_1K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4per__timer7 = {
	.master		= &am33xx_l4per_hwmod,
	.slave		= &am33xx_timer7_hwmod,
	.clk		= "timer7_ick",
	.addr		= am33xx_timer7_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_timer7_slaves[] = {
	&am33xx_l4per__timer7,
};

static struct omap_hwmod_irq_info am33xx_timer7_irqs[] = {
	{ .irq = 95 },
	{ .irq = -1 }
};

static struct omap_hwmod am33xx_timer7_hwmod = {
	.name		= "timer7",
	.class		= &am33xx_timer_hwmod_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_timer7_irqs,
	.main_clk	= "timer7_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TIMER7_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_timer7_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_timer7_slaves),
};

/* tpcc */
#define AM33XX_TPCC_BASE		0x49000000
#define AM33XX_TPTC0_BASE		0x49800000
#define AM33XX_TPTC1_BASE		0x49900000
#define AM33XX_TPTC2_BASE		0x49a00000

/* 'tpcc' class */
static struct omap_hwmod_class am33xx_tpcc_hwmod_class = {
	.name		= "tpcc",
};

static struct omap_hwmod_irq_info am33xx_tpcc_irqs[] = {
	{ .name	= "edma0", .irq = 12 },
	{ .name = "edma0_mperr", .irq = 13, },
	{ .name	= "edma0_err", .irq = 14 },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space am33xx_tpcc_addr_space[] = {
	{
		.name		= "edma_cc0",
		.pa_start	= AM33XX_TPCC_BASE,
		.pa_end		= AM33XX_TPCC_BASE + SZ_32K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l3_main__tpcc = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_tpcc_hwmod,
	.addr		= am33xx_tpcc_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_tpcc_slaves[] = {
	&am33xx_l3_main__tpcc,
};

static struct omap_hwmod am33xx_tpcc_hwmod = {
	.name		= "tpcc",
	.class		= &am33xx_tpcc_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.mpu_irqs	= am33xx_tpcc_irqs,
	.main_clk	= "tpcc_ick",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TPCC_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_tpcc_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_tpcc_slaves),
};

static struct omap_hwmod_class_sysconfig am33xx_tptc_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x10,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			SYSC_HAS_MIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_SMART | MSTANDBY_FORCE),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

/* 'tptc' class */
static struct omap_hwmod_class am33xx_tptc_hwmod_class = {
	.name		= "tptc",
	.sysc		= &am33xx_tptc_sysc,
};

/* tptc0 */
static struct omap_hwmod_irq_info am33xx_tptc0_irqs[] = {
	{ .irq = 112 },
	{ .irq = -1 }
};

struct omap_hwmod_addr_space am33xx_tptc0_addr_space[] = {
	{
		.name		= "edma_tc0",
		.pa_start	= AM33XX_TPTC0_BASE,
		.pa_end		= AM33XX_TPTC0_BASE + SZ_8K - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__tptc0 = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_tptc0_hwmod,
	.addr		= am33xx_tptc0_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_tptc0_slaves[] = {
	&am33xx_l3_main__tptc0,
};

static struct omap_hwmod am33xx_tptc0_hwmod = {
	.name		= "tptc0",
	.class		= &am33xx_tptc_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.mpu_irqs	= am33xx_tptc0_irqs,
	.main_clk	= "tptc0_ick",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TPTC0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_tptc0_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_tptc0_slaves),
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY),
};

/* tptc1 */
static struct omap_hwmod_irq_info am33xx_tptc1_irqs[] = {
	{ .irq = 113 },
	{ .irq = -1 }
};

struct omap_hwmod_addr_space am33xx_tptc1_addr_space[] = {
	{
		.name		= "edma_tc1",
		.pa_start	= AM33XX_TPTC1_BASE,
		.pa_end		= AM33XX_TPTC1_BASE + SZ_8K - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__tptc1 = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_tptc1_hwmod,
	.addr		= am33xx_tptc1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_tptc1_slaves[] = {
	&am33xx_l3_main__tptc1,
};

static struct omap_hwmod am33xx_tptc1_hwmod = {
	.name		= "tptc1",
	.class		= &am33xx_tptc_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.mpu_irqs	= am33xx_tptc1_irqs,
	.main_clk	= "tptc1_ick",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TPTC1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_tptc1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_tptc1_slaves),
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY),
};

/* tptc2 */
static struct omap_hwmod_irq_info am33xx_tptc2_irqs[] = {
	{ .irq = 114 },
	{ .irq = -1 }
};

struct omap_hwmod_addr_space am33xx_tptc2_addr_space[] = {
	{
		.name		= "edma_tc2",
		.pa_start	= AM33XX_TPTC2_BASE,
		.pa_end		= AM33XX_TPTC2_BASE + SZ_8K - 1,
		.flags		= ADDR_MAP_ON_INIT | ADDR_TYPE_RT,
	},
	{ }
};

struct omap_hwmod_ocp_if am33xx_l3_main__tptc2 = {
	.master		= &am33xx_l3_main_hwmod,
	.slave		= &am33xx_tptc2_hwmod,
	.addr		= am33xx_tptc2_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_tptc2_slaves[] = {
	&am33xx_l3_main__tptc2,
};

static struct omap_hwmod am33xx_tptc2_hwmod = {
	.name		= "tptc2",
	.class		= &am33xx_tptc_hwmod_class,
	.clkdm_name	= "l3_clkdm",
	.mpu_irqs	= am33xx_tptc2_irqs,
	.main_clk	= "tptc2_ick",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_TPTC2_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_tptc2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_tptc2_slaves),
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY),
};

/* 'uart' class */
static struct omap_hwmod_class_sysconfig uart_sysc = {
	.rev_offs	= 0x50,
	.sysc_offs	= 0x54,
	.syss_offs	= 0x58,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_ENAWAKEUP |
			SYSC_HAS_SOFTRESET | SYSC_HAS_AUTOIDLE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class uart_class = {
	.name		= "uart",
	.sysc		= &uart_sysc,
};

/* uart1 */
static struct omap_hwmod_dma_info uart1_edma_reqs[] = {
	{ .name = "tx",	.dma_req = 26, },
	{ .name = "rx",	.dma_req = 27, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space am33xx_uart1_addr_space[] = {
	{
		.pa_start	= 0x44E09000,
		.pa_end		= 0x44E09000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_wkup__uart1 = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_uart1_hwmod,
	.clk		= "uart1_ick",
	.addr		= am33xx_uart1_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_irq_info am33xx_uart1_irqs[] = {
	{ .irq = 72 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_uart1_slaves[] = {
	&am33xx_l4_wkup__uart1,
};

static struct omap_hwmod am33xx_uart1_hwmod = {
	.name		= "uart1",
	.class		= &uart_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= am33xx_uart1_irqs,
	.main_clk	= "uart1_fck",
	.sdma_reqs	= uart1_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_UART0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_uart1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_uart1_slaves),
};

/* uart2 */
static struct omap_hwmod_addr_space am33xx_uart2_addr_space[] = {
	{
		.pa_start	= 0x48022000,
		.pa_end		= 0x48022000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_ls__uart2 = {
	.slave		= &am33xx_uart2_hwmod,
	.clk		= "uart2_ick",
	.addr		= am33xx_uart2_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_irq_info am33xx_uart2_irqs[] = {
	{ .irq = 73 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_uart2_slaves[] = {
	&am33xx_l4_ls__uart2,
};

static struct omap_hwmod am33xx_uart2_hwmod = {
	.name		= "uart2",
	.class		= &uart_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_uart2_irqs,
	.main_clk	= "uart2_fck",
	.sdma_reqs	= uart1_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_UART1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_uart2_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_uart2_slaves),
};

/* uart3 */
static struct omap_hwmod_dma_info uart3_edma_reqs[] = {
	{ .name = "tx",	.dma_req = 30, },
	{ .name = "rx",	.dma_req = 31, },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space am33xx_uart3_addr_space[] = {
	{
		.pa_start	= 0x48024000,
		.pa_end		= 0x48024000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_ls__uart3 = {
	.slave		= &am33xx_uart3_hwmod,
	.clk		= "uart3_ick",
	.addr		= am33xx_uart3_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_irq_info am33xx_uart3_irqs[] = {
	{ .irq = 74 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_uart3_slaves[] = {
	&am33xx_l4_ls__uart3,
};

static struct omap_hwmod am33xx_uart3_hwmod = {
	.name		= "uart3",
	.class		= &uart_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_uart3_irqs,
	.main_clk	= "uart3_fck",
	.sdma_reqs	= uart3_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_UART2_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_uart3_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_uart3_slaves),
};

/* uart4 */
static struct omap_hwmod_addr_space am33xx_uart4_addr_space[] = {
	{
		.pa_start	= 0x481A6000,
		.pa_end		= 0x481A6000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_ls__uart4 = {
	.slave		= &am33xx_uart4_hwmod,
	.clk		= "uart4_ick",
	.addr		= am33xx_uart4_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_irq_info am33xx_uart4_irqs[] = {
	{ .irq = 44 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_uart4_slaves[] = {
	&am33xx_l4_ls__uart4,
};

static struct omap_hwmod am33xx_uart4_hwmod = {
	.name		= "uart4",
	.class		= &uart_class,
	.mpu_irqs	= am33xx_uart4_irqs,
	.main_clk	= "uart4_fck",
	.clkdm_name	= "l4ls_clkdm",
	.sdma_reqs	= uart1_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_UART3_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_uart4_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_uart4_slaves),
};

/* uart5 */
static struct omap_hwmod_addr_space am33xx_uart5_addr_space[] = {
	{
		.pa_start	= 0x481A8000,
		.pa_end		= 0x481A8000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_ls__uart5 = {
	.slave		= &am33xx_uart5_hwmod,
	.clk		= "uart5_ick",
	.addr		= am33xx_uart5_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_irq_info am33xx_uart5_irqs[] = {
	{ .irq = 45 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_uart5_slaves[] = {
	&am33xx_l4_ls__uart5,
};

static struct omap_hwmod am33xx_uart5_hwmod = {
	.name		= "uart5",
	.class		= &uart_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_uart5_irqs,
	.main_clk	= "uart5_fck",
	.sdma_reqs	= uart1_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_UART4_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_uart5_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_uart5_slaves),
};

/* uart6 */
static struct omap_hwmod_addr_space am33xx_uart6_addr_space[] = {
	{
		.pa_start	= 0x481AA000,
		.pa_end		= 0x481AA000 + SZ_8K - 1,
		.flags		= ADDR_TYPE_RT,
	},
	{ }
};

static struct omap_hwmod_ocp_if am33xx_l4_ls__uart6 = {
	.slave		= &am33xx_uart6_hwmod,
	.clk		= "uart6_ick",
	.addr		= am33xx_uart6_addr_space,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_irq_info am33xx_uart6_irqs[] = {
	{ .irq = 46 },
	{ .irq = -1 }
};

static struct omap_hwmod_ocp_if *am33xx_uart6_slaves[] = {
	&am33xx_l4_ls__uart6,
};

static struct omap_hwmod am33xx_uart6_hwmod = {
	.name		= "uart6",
	.class		= &uart_class,
	.clkdm_name	= "l4ls_clkdm",
	.mpu_irqs	= am33xx_uart6_irqs,
	.main_clk	= "uart6_fck",
	.sdma_reqs	= uart1_edma_reqs,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_UART5_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_uart6_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_uart6_slaves),
};

/* 'wd_timer' class */
static struct omap_hwmod_class_sysconfig wdt_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x10,
	.syss_offs	= 0x14,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_SIDLEMODE |
			SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class am33xx_wd_timer_hwmod_class = {
	.name		= "wd_timer",
	.sysc		= &wdt_sysc,
	.pre_shutdown	= &omap2_wd_timer_disable,
};

static struct omap_hwmod_addr_space am33xx_wd_timer1_addrs[] = {
	{
		.pa_start	= 0x44E35000,
		.pa_end		= 0x44E35000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> wd_timer1 */
static struct omap_hwmod_ocp_if am33xx_l4wkup__wd_timer1 = {
	.master		= &am33xx_l4wkup_hwmod,
	.slave		= &am33xx_wd_timer1_hwmod,
	.addr		= am33xx_wd_timer1_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *am33xx_wd_timer1_slaves[] = {
	&am33xx_l4wkup__wd_timer1,
};

/*
 * TODO: device.c file uses hardcoded name for watchdog timer
 * driver "wd_timer2, so we are also using same name as of now...
 */
static struct omap_hwmod am33xx_wd_timer1_hwmod = {
	.name		= "wd_timer2",
	.class		= &am33xx_wd_timer_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE,
	.main_clk	= "wdt1_fck",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_WDT1_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_wd_timer1_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_wd_timer1_slaves),
};

/* wkup_m3 */
static struct omap_hwmod_class am33xx_wkup_m3_hwmod_class = {
	.name		= "wkup_m3",
};

static struct omap_hwmod_rst_info am33xx_wkup_m3_resets[] = {
	{ .name = "wkup_m3", .rst_shift = 3, .st_shift = 5 },
};

static struct omap_hwmod am33xx_wkup_m3_hwmod = {
	.name		= "wkup_m3",
	.class		= &am33xx_wkup_m3_hwmod_class,
	.clkdm_name	= "l4_wkup_aon_clkdm",
	.main_clk	= "wkup_m3_fck",
	.flags		= HWMOD_INIT_NO_RESET,	/* Keep hardreset asserted */
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_WKUP_WKUP_M3_CLKCTRL_OFFSET,
			.rstctrl_offs	= AM33XX_RM_WKUP_RSTCTRL_OFFSET,
			.rstst_offs	= AM33XX_RM_WKUP_RSTST_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.rst_lines	= am33xx_wkup_m3_resets,
	.rst_lines_cnt	= ARRAY_SIZE(am33xx_wkup_m3_resets),
};

/* usbss */
/* L3 SLOW -> USBSS interface */
static struct omap_hwmod_addr_space am33xx_usbss_addr_space[] = {
	{
		.name		= "usbss",
		.pa_start	= 0x47400000,
		.pa_end		= 0x47400000 + SZ_4K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{
		.name		= "musb0",
		.pa_start	= 0x47401000,
		.pa_end		= 0x47401000 + SZ_2K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{
		.name		= "musb1",
		.pa_start	= 0x47401800,
		.pa_end		= 0x47401800 + SZ_2K - 1,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_hwmod_class_sysconfig am33xx_usbhsotg_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x10,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_MIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class am33xx_usbotg_class = {
	.name		= "usbotg",
	.sysc		= &am33xx_usbhsotg_sysc,
};

static struct omap_hwmod_irq_info am33xx_usbss_mpu_irqs[] = {
	{ .name = "usbss-irq", .irq = 17, },
	{ .name = "musb0-irq", .irq = 18, },
	{ .name = "musb1-irq", .irq = 19, },
	{ .irq = -1, },
};

static struct omap_hwmod_ocp_if am33xx_l3_slow__usbss = {
	.master		= &am33xx_l3slow_hwmod,
	.slave		= &am33xx_usbss_hwmod,
	.clk		= "usbotg_ick",
	.addr		= am33xx_usbss_addr_space,
	.user		= OCP_USER_MPU,
	.flags		= OCPIF_SWSUP_IDLE,
};

static struct omap_hwmod_ocp_if *am33xx_usbss_slaves[] = {
	&am33xx_l3_slow__usbss,
};

static struct omap_hwmod am33xx_usbss_hwmod = {
	.name		= "usb_otg_hs",
	.class		= &am33xx_usbotg_class,
	.clkdm_name	= "l3s_clkdm",
	.mpu_irqs	= am33xx_usbss_mpu_irqs,
	.main_clk	= "usbotg_fck",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_USB0_CLKCTRL_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.slaves		= am33xx_usbss_slaves,
	.slaves_cnt	= ARRAY_SIZE(am33xx_usbss_slaves),
	.class		= &am33xx_usbotg_class,
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY),
};

/* gfx */
/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod_class am33xx_gfx_hwmod_class = {
	.name	= "gfx",
};

static struct omap_hwmod_rst_info am33xx_gfx_resets[] = {
	{ .name = "gfx", .rst_shift = 0, .st_shift = 0 },
};

static struct omap_hwmod am33xx_gfx_hwmod = {
	.name		= "gfx",
	.class		= &am33xx_gfx_hwmod_class,
	.clkdm_name	= "gfx_l3_clkdm",
	.main_clk	= "gfx_fclk",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_GFX_GFX_CLKCTRL_OFFSET,
			.rstctrl_offs	= AM33XX_RM_GFX_RSTCTRL_OFFSET,
			.rstst_offs	= AM33XX_RM_GFX_RSTST_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.rst_lines	= am33xx_gfx_resets,
	.rst_lines_cnt	= ARRAY_SIZE(am33xx_gfx_resets),
};

/* PRUSS */
/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod_class am33xx_pruss_hwmod_class = {
	.name	= "pruss",
};

static struct omap_hwmod_rst_info am33xx_pruss_resets[] = {
	{ .name = "pruss", .rst_shift = 1 },
};

static struct omap_hwmod am33xx_pruss_hwmod = {
	.name		= "pruss",
	.class		= &am33xx_pruss_hwmod_class,
	.clkdm_name	= "pruss_ocp_clkdm",
	.main_clk	= "pruss_uart_gclk",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= AM33XX_CM_PER_PRUSS_CLKCTRL_OFFSET,
			.rstctrl_offs	= AM33XX_RM_PER_RSTCTRL_OFFSET,
			.rstst_offs	= AM33XX_RM_PER_RSTST_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
	.rst_lines	= am33xx_pruss_resets,
	.rst_lines_cnt	= ARRAY_SIZE(am33xx_pruss_resets),
};

static __initdata struct omap_hwmod *am33xx_hwmods[] = {
	/* l3 class */
	&am33xx_l3_instr_hwmod,
	&am33xx_l3_main_hwmod,
	/* l3s class */
	&am33xx_l3slow_hwmod,
	/* l4hs class */
	&am33xx_l4_hs_hwmod,
	/* l4fw class */
	&am33xx_l4fw_hwmod,
	/* l4ls class */
	&am33xx_l4ls_hwmod,
	/* l4per class */
	&am33xx_l4per_hwmod,
	/* l4wkup class */
	&am33xx_l4wkup_hwmod,
	/* clkdiv32k class */
	&am33xx_clkdiv32k_hwmod,
	/* mpu class */
	&am33xx_mpu_hwmod,
	/* adc_tsc class */
	&am33xx_adc_tsc_hwmod,
	/* aes class */
	&am33xx_aes0_hwmod,
	/* cefuse class */
	&am33xx_cefuse_hwmod,
	/* control class */
	&am33xx_control_hwmod,
	/* dcan class */
	&am33xx_dcan0_hwmod,
	&am33xx_dcan1_hwmod,
	/* debugss class */
	&am33xx_debugss_hwmod,
	/* elm class */
	&am33xx_elm_hwmod,
	/* emif_fw class */
	&am33xx_emif_fw_hwmod,
	/* epwmss class */
	&am33xx_ehrpwm0_hwmod,
	&am33xx_ehrpwm1_hwmod,
	&am33xx_ehrpwm2_hwmod,
	&am33xx_ecap0_hwmod,
	&am33xx_ecap1_hwmod,
	&am33xx_ecap2_hwmod,
	/* gpio class */
	&am33xx_gpio0_hwmod,
	&am33xx_gpio1_hwmod,
	&am33xx_gpio2_hwmod,
	&am33xx_gpio3_hwmod,
	/* gpmc class */
	&am33xx_gpmc_hwmod,
	/* i2c class */
	&am33xx_i2c1_hwmod,
	&am33xx_i2c2_hwmod,
	&am33xx_i2c3_hwmod,
	/* ieee5000 class */
	&am33xx_ieee5000_hwmod,
	/* mailbox class */
	&am33xx_mailbox_hwmod,
	/* mcasp class */
	&am33xx_mcasp0_hwmod,
	&am33xx_mcasp1_hwmod,
	/* mmc class */
	&am33xx_mmc0_hwmod,
	&am33xx_mmc1_hwmod,
	&am33xx_mmc2_hwmod,
	/* ocmcram class */
	&am33xx_ocmcram_hwmod,
	/* ocpwp class */
	&am33xx_ocpwp_hwmod,
	/* rtc class */
	&am33xx_rtc_hwmod,
	/* sha0 class */
	&am33xx_sha0_hwmod,
	/* smartreflex class */
	&am33xx_smartreflex0_hwmod,
	&am33xx_smartreflex1_hwmod,
	/* spi class */
	&am33xx_spi0_hwmod,
	&am33xx_spi1_hwmod,
	/* spinlock class */
	&am33xx_spinlock_hwmod,
	/* uart class */
	&am33xx_uart1_hwmod,
	&am33xx_uart2_hwmod,
	&am33xx_uart3_hwmod,
	&am33xx_uart4_hwmod,
	&am33xx_uart5_hwmod,
	&am33xx_uart6_hwmod,
	/* timer class */
	&am33xx_timer0_hwmod,
	&am33xx_timer1_hwmod,
	&am33xx_timer2_hwmod,
	&am33xx_timer3_hwmod,
	&am33xx_timer4_hwmod,
	&am33xx_timer5_hwmod,
	&am33xx_timer6_hwmod,
	&am33xx_timer7_hwmod,
	/* wkup_m3 class */
	&am33xx_wkup_m3_hwmod,
	/* wd_timer class */
	&am33xx_wd_timer1_hwmod,
	/* usbss hwmod */
	&am33xx_usbss_hwmod,
	/* cpgmac0 class */
	&am33xx_cpgmac0_hwmod,
	/* mdio class */
	&am33xx_mdio_hwmod,
	/* tptc class */
	&am33xx_tptc0_hwmod,
	&am33xx_tptc1_hwmod,
	&am33xx_tptc2_hwmod,
	/* tpcc class */
	&am33xx_tpcc_hwmod,
	/* LCDC class */
	&am33xx_lcdc_hwmod,
	/* gfx/sgx */
	&am33xx_gfx_hwmod,
	/* pruss */
	&am33xx_pruss_hwmod,
	NULL,
};

int __init am33xx_hwmod_init(void)
{
	return omap_hwmod_register(am33xx_hwmods);
}
