/*
 * Code for supporting AM335X EVM.
 *
 * Copyright (C) {2011} Texas Instruments Incorporated - http://www.ti.com/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _BOARD_AM335X_H
#define _BOARD_AM335X_H

/* Profiles can be or-ed together to state that a particular hardware
 * config/init is active for multiple profiles.
 *
 * The top 8 bits (1<<31..1<<24) are for CPU board selection,
 * the bottom 24 bits (1<<23..1<<0) are for IO Board selection.
 *
 * The board init functions are called with one of each BOARD_* and
 * IOBOARD_* flags set. The init functions may match one or both
 * flags as required.
 */

#define BOARD_NONE	0
#define BOARD_BETZY	(0x1  << 24) /* Betzy CPU Board */
#define BOARD_NGUNI	(0x1  << 25) /* Nguni CPU Board */
#define BOARD_KEWEL	(0x1  << 26) /* Kewel CPU board */
#define BOARD_ALL	(0xFF << 24) /* All CPU Boards */

#define IOBOARD_NONE	0
#define IOBOARD_KOALA	(0x1 << 0) /* NBN WNTD Betzy + koala IOBoard */
#define IOBOARD_ELAINE	(0x1 << 1) /* Bovine Betzy + elaine IOBoard */
#define IOBOARD_NEWMAN	(0x1 << 2) /* Production Betzy + newman IOBOard */
#define IOBOARD_NGUNI	(0x1 << 3) /* Nguni CPU & IO Board */
#define IOBOARD_HAMSTER (0x1 << 4) /* Kewel CPU + Hamster IOBoard */
#define IOBOARD_KUDU	(0x1 << 5) /* Kewel CPU + Kudu IOBoard */
#define IOBOARD_ALL	(0x0fffffff) /* All IOBoards */


#ifndef __ASSEMBLER__
void am335x_evm_set_id(unsigned int evmid);
int am335x_evm_get_id(void);
void am33xx_cpsw_macidfillup(char *eeprommacid0, char *eeprommacid1);
void am33xx_d_can_init(unsigned int instance);

#endif
#endif
