.\" manual page [] for diald 1.0
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH DIALD-MONITOR 5 "DIALD 1.0 - 2001.06.15"
.SH NAME
diald-monitor \- output format of the diald monitor command
.SH SYNOPSIS
Output on named pipes and TCP connections specified by monitor command.

.SH DESCRIPTION
This manual page documents the format of the output generated by
the monitor command. This output is intended to be used by
an external program to report on the state of diald.

There are five types of status updates that have a fixed
number of parameters. Each of these is issued on a fixed number of lines.
The first line contains a keyword indicating the type
of data that should be expected. The keywords are STATE,
TITLE, INTERFACE, STATUS/STATUS2 and MESSAGE.
Each of the remaining parameters is issued on a separate line.

.TP
.B STATE \fI<fsm-state>

This is issued any time the state of the FSM that controls diald changes.
The variable \fI<fsm-state>\fR gives the name of the state that diald enters.
This gives some indication of what diald is currently trying to do to the line.

.TP
.B TITLE \fI<title>
This is currently issued after the STATE message when the state
of the FSM changes.
The variable \fI<title>\fR gives the description of the link as
specified in the diald configuration and may be displayed by the
monitor for identification purposes.

.TP
.B INTERFACE \fI<interface-name> <local-ip> <remote-ip>

This is issued any time diald changes the link that it is doing its
policy monitoring on. When diald has a physical link up, this
will be the physical link, otherwise it will be the proxy link.
The string \fI<interface-name>\fR names the device being monitored,
and \fI<local-ip>\fR and \fI<remote-ip>\fR give the local and remote IP  
address that are associated with the link.

.TP
.B STATUS \fI<up> <force> <im> <im_itm> <im_tm> <im_fuzz> <im_to> <force_to> <to>
.B STATUS2 \fI<blocked> <forced>

These are issued every second. They detail the state of a variety
of diald's internal timers and state variables.

The STATUS2 line is only written to monitors that have identified
themselves as supporting the version 2 monitor protocol.

The \fI<up>\fR parameter is 0 if diald thinks the physical link
should currently be down, and 1 otherwise. This does not
indicate the actual state of the link, since it might be in transition.
The actual state of the link can be determined by the state of the FSM.

The \fI<force>\fR parameter is 1 if in the current state diald
wishes to force the link to be up constantly.
The \fI<force>\fR parameter is 2 if in the current state diald
wishes to force the link to be down constantly.
Otherwise it is 0.
The status of this parameter changes
due to "up" or "down" rule in the configuration commands.

The \fI<im>\fR parameter gives the current impulse timer mode.

The \fI<im_itm>\fR parameter gives the current primary impulse length.

The \fI<im_tm>\fR parameter gives the current secondary impulse length.

The \fI<im_fuzz>\fR parameter gives the current impulse fuzz parameter.

The \fI<im_to>\fR parameter gives the time left before the current impulse
times out.

The \fI<force_to>\fR parameter gives the time left before the next forcing timeout.

The \fI<to>\fR parameter gives the time left before the next timeout
for a connection.

.TP
.B LOAD \fI<itxtotal> <irxtotal>\fR
This is intended to be used to compute a load average over the link.
It is issued every second.
The \fI<itxtotal>\fR parameter gives the total number of bytes
transmitted in the last second.
The \fI<irxtotal>\fR parameter gives the total number of bytes
received in the last second.

.TP
.B MESSAGE \fI<message>\fR
This is issued by diald whenever it receives a message command on the
command fifo. The purpose of this is to allow external programs, such
as connect, to pass informational messages through diald to the monitoring
protocol. The most likely use of this is to allow a monitoring tool
to report on the progress of the current attempt to dial out.

.P
As well, once a second diald will issue groups of lines beginning with
a single line containing
.B QUEUE
and ending with a single line containing
.B END QUEUE
that describe the contents of its connection queue.
There will be zero or more lines between these two lines,
each describing a single connection.
Each of these lines has four parameters:
\fI<protocol> <ip-1> <ip-2> <time-to-live>\fR.
The \fI<protocol>\fR is a string naming the protocol for the connection.
\fI<ip-1> and \fI<ip-2>\fR are the two ip address/port pairs that define
the endpoints of the connection. Note that the order that these
are printed in depends on the numeric ordering of the ip addresses
and ports, and has no relationship with which is the local and
which is remote ip address.
The \fI<time-to-live>\fR parameter gives the number of seconds that 
this connection is currently scheduled to remain in the queue.

.SH SEE ALSO
.LP
diald(8), dctrl(1), diald-control(5), diald-examples(5)

.SH AUTHOR
.LP
Mike Jagdis (jaggy@purplet.demon.co.uk)
Eric Schenk (Eric.Schenk@dna.lth.se)
