#!/bin/sh

DEVICE=$1

ifconfig $DEVICE 0.0.0.0 2>/dev/null || {
    echo "$0 <subscriber-lan-device>"
    echo "create a vlan interface with:"
    echo "  vconfig add <interface> <vlan-id>"
    exit
}

[ -d  /usr/local/etc/chilli/$DEVICE ] || mkdir /usr/local/etc/chilli/$DEVICE

cat > /usr/local/etc/chilli/$DEVICE/chilli.conf <<EOF
# Generated by $0
include /usr/local/etc/chilli/$DEVICE/main.conf
include /usr/local/etc/chilli/$DEVICE/hs.conf
include /usr/local/etc/chilli/$DEVICE/local.conf

ipup=/usr/local/etc/chilli/up.sh
ipdown=/usr/local/etc/chilli/down.sh
EOF

cat /usr/local/etc/chilli/config | \
    grep -v HS_LANIF > /usr/local/etc/chilli/$DEVICE/config