#include <common.h>
#include <rtc.h>
#include <asm/io.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/sys_proto.h>
#include <watchdog.h>

#define DEFAULT_HEARTBEAT	19
#define MAX_HEARTBEAT		(0x10000000 >> 6)

#define WDOG_COUNTER_RATE	1000 /* 1 kHz clock */

#define RTC_PERSISTENT1_GENERAL_RTC_FORCE_UPDATER 0x80000000


static int heartbeat = DEFAULT_HEARTBEAT;
static int wdt_en = 1;


static void inline mxs_reg_setl(uint32_t value,struct mx28_register_32 * reg)
{
	writel(value,&reg->reg_set);
}
		
		
static void inline mxs_reg_clrl(uint32_t value,struct mx28_register_32 * reg)
{
	writel(value,&reg->reg_clr);
}
		

static void wdt_enable(u32 value)
{
	struct mx28_rtc_regs *rtc_regs = (struct mx28_rtc_regs *)MXS_RTC_BASE;
	
	writel(value, &rtc_regs->hw_rtc_watchdog);
	
	mxs_reg_setl(RTC_CTRL_WATCHDOGEN,&rtc_regs->hw_rtc_ctrl_reg);
	mxs_reg_setl(RTC_PERSISTENT1_GENERAL_RTC_FORCE_UPDATER,&rtc_regs->hw_rtc_persistent1_reg);
			
	wdt_en=1;
}

static void wdt_disable(void)
{
	struct mx28_rtc_regs *rtc_regs = (struct mx28_rtc_regs *)MXS_RTC_BASE;
	
	mxs_reg_clrl(RTC_PERSISTENT1_GENERAL_RTC_FORCE_UPDATER,&rtc_regs->hw_rtc_persistent1_reg);
	mxs_reg_clrl(RTC_CTRL_WATCHDOGEN,&rtc_regs->hw_rtc_ctrl_reg);
	
	wdt_en=0;
}

void hw_watchdog_reset(void)
{
	if(wdt_en)
		wdt_enable(heartbeat * WDOG_COUNTER_RATE);
}

void hw_watchdog_init(void)
{
	wdt_enable(heartbeat * WDOG_COUNTER_RATE);
}

#include <command.h>
			 
int cmdline_wdtoff(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	wdt_disable();
	
	printf("mxs_wdt: h/w watchdog disabled\n");
	
	return 0;
}

int cmdline_wdton(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	hw_watchdog_init();
	
	printf("h/w watchdog enabled (timer=%d sec)\n",heartbeat);
	
	return 0;
}


U_BOOT_CMD(
 	wdtoff,	4,	1,	cmdline_wdtoff,
 	"disable watchdog timer",
  	"\n"
);


U_BOOT_CMD(
 	wdton,	4,	1,	cmdline_wdton,
 	"enable watchdog timer",
	"\n"
);
