 
/*
 * GPIO command line support for MX28 series processors.
 *
 * Iwo Mergler <Iwo.Mergler@netcommwireless.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <asm/byteorder.h>

static unsigned auarts[] = {
	MXS_UARTAPP0_BASE,
	MXS_UARTAPP1_BASE,
	MXS_UARTAPP2_BASE,
	MXS_UARTAPP3_BASE,
	MXS_UARTAPP4_BASE
};

static void puts_app_uart(void *base, const char *s)
{
	int esc=0;
	while (*s) {
		if (esc) {
			switch (*s) {
				case 'n':
					send_app_uart(base, '\r');
					send_app_uart(base, '\n');
					break;
				case 'r':
					send_app_uart(base, '\r');
					break;
				case 't':
					send_app_uart(base, '\t');
					break;
				default:
					send_app_uart(base, *s);
					break;
			}
			esc=0;
		} else {
			if (*s == '\\') {
				esc=1;
			} else {
				send_app_uart(base, *s);
			}
		}
		s++;
	}
	flush_app_uart(base);
}

static int uart(cmd_tbl_t *cmdtp, int flag, int argc, char *const argv[])
{
	unsigned u;

	if (argc != 3) return -1;

	u = simple_strtol(argv[1], NULL, 0);
	if (u > 4) return -1;

	printf("Sending to AUART%d\n", u);

	init_app_uart((void*)auarts[u], 115200);
	puts_app_uart((void*)auarts[u], argv[2]);

	return 0;
}
U_BOOT_CMD(uart, CONFIG_SYS_MAXARGS, 1, uart,
	"Emit string on specified APPUART",
	"UARTNO STRING\n"
	"	UARTNO = number of uart, 0-4\n"
	"	STRING = string to send\n"
);
