/*
 * Freescale MX28EVK IOMUX setup
 *
 * Copyright (C) 2011 Marek Vasut <marek.vasut@gmail.com>
 * on behalf of DENX Software Engineering GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <common.h>
#include <config.h>
#include <asm/io.h>
#include <asm/arch/iomux-mx28.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/sys_proto.h>

#include "gpio.h"

#define	MUX_CONFIG_SSP0	(MXS_PAD_3V3 | MXS_PAD_8MA | MXS_PAD_PULLUP)
#define	MUX_CONFIG_GPMI	(MXS_PAD_1V8 | MXS_PAD_4MA | MXS_PAD_NOPULL)
#define	MUX_CONFIG_ENET	(MXS_PAD_3V3 | MXS_PAD_8MA | MXS_PAD_PULLUP)
#define	MUX_CONFIG_EMI	(MXS_PAD_1V8 | MXS_PAD_12MA | MXS_PAD_NOPULL)
#define	MUX_CONFIG_SSP2	(MXS_PAD_3V3 | MXS_PAD_4MA | MXS_PAD_PULLUP)

const iomux_cfg_t iomux_setup[] = {

#ifdef CONFIG_NAND_MXS
	/* GPMI NAND */
	MX28_PAD_GPMI_D00__GPMI_D0 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_D01__GPMI_D1 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_D02__GPMI_D2 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_D03__GPMI_D3 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_D04__GPMI_D4 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_D05__GPMI_D5 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_D06__GPMI_D6 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_D07__GPMI_D7 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_CE0N__GPMI_CE0N | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_RDY0__GPMI_READY0 | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_RDN__GPMI_RDN |
		(MXS_PAD_1V8 | MXS_PAD_4MA | MXS_PAD_PULLUP),
	MX28_PAD_GPMI_WRN__GPMI_WRN | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_ALE__GPMI_ALE | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_CLE__GPMI_CLE | MUX_CONFIG_GPMI,
	MX28_PAD_GPMI_RESETN__GPMI_RESETN | MUX_CONFIG_GPMI,
#endif

	/* FEC0 */
	MX28_PAD_ENET0_MDC__ENET0_MDC | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_MDIO__ENET0_MDIO | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_RX_EN__ENET0_RX_EN | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_TX_EN__ENET0_TX_EN | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_RXD0__ENET0_RXD0 | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_RXD1__ENET0_RXD1 | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_TXD0__ENET0_TXD0 | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_TXD1__ENET0_TXD1 | MUX_CONFIG_ENET,
	MX28_PAD_ENET_CLK__CLKCTRL_ENET | MUX_CONFIG_ENET,
	/* FEC0 Enable */
	MX28_PAD_SSP1_DATA3__GPIO_2_15 |
		(MXS_PAD_12MA | MXS_PAD_3V3),
	/* FEC0 Reset */
	MX28_PAD_ENET0_RX_CLK__GPIO_4_13 |
		(MXS_PAD_12MA | MXS_PAD_3V3 | MXS_PAD_PULLUP),

	/* FEC1 */
	MX28_PAD_ENET0_COL__ENET1_TX_EN | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_CRS__ENET1_RX_EN | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_RXD2__ENET1_RXD0 | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_RXD3__ENET1_RXD1 | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_TXD2__ENET1_TXD0 | MUX_CONFIG_ENET,
	MX28_PAD_ENET0_TXD3__ENET1_TXD1 | MUX_CONFIG_ENET,

	/* EMI */
	MX28_PAD_EMI_D00__EMI_DATA0 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D01__EMI_DATA1 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D02__EMI_DATA2 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D03__EMI_DATA3 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D04__EMI_DATA4 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D05__EMI_DATA5 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D06__EMI_DATA6 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D07__EMI_DATA7 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D08__EMI_DATA8 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D09__EMI_DATA9 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D10__EMI_DATA10 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D11__EMI_DATA11 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D12__EMI_DATA12 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D13__EMI_DATA13 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D14__EMI_DATA14 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_D15__EMI_DATA15 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_ODT0__EMI_ODT0 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_DQM0__EMI_DQM0 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_ODT1__EMI_ODT1 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_DQM1__EMI_DQM1 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_DDR_OPEN_FB__EMI_DDR_OPEN_FEEDBACK | MUX_CONFIG_EMI,
	MX28_PAD_EMI_CLK__EMI_CLK | MUX_CONFIG_EMI,
	MX28_PAD_EMI_DQS0__EMI_DQS0 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_DQS1__EMI_DQS1 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_DDR_OPEN__EMI_DDR_OPEN | MUX_CONFIG_EMI,

	MX28_PAD_EMI_A00__EMI_ADDR0 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A01__EMI_ADDR1 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A02__EMI_ADDR2 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A03__EMI_ADDR3 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A04__EMI_ADDR4 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A05__EMI_ADDR5 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A06__EMI_ADDR6 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A07__EMI_ADDR7 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A08__EMI_ADDR8 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A09__EMI_ADDR9 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A10__EMI_ADDR10 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A11__EMI_ADDR11 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A12__EMI_ADDR12 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A13__EMI_ADDR13 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_A14__EMI_ADDR14 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_BA0__EMI_BA0 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_BA1__EMI_BA1 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_BA2__EMI_BA2 | MUX_CONFIG_EMI,
	MX28_PAD_EMI_CASN__EMI_CASN | MUX_CONFIG_EMI,
	MX28_PAD_EMI_RASN__EMI_RASN | MUX_CONFIG_EMI,
	MX28_PAD_EMI_WEN__EMI_WEN | MUX_CONFIG_EMI,
	MX28_PAD_EMI_CE0N__EMI_CE0N | MUX_CONFIG_EMI,
	MX28_PAD_EMI_CE1N__EMI_CE1N | MUX_CONFIG_EMI,
	MX28_PAD_EMI_CKE__EMI_CKE | MUX_CONFIG_EMI,
};

struct gpio_preset {
	unsigned pin;
	struct pininfo v;
};

#define NOPIN ((unsigned)(-1))
#define pin(b,i) .pin = PIN(b,i)

static const struct gpio_preset gpio_presets[] = {
	/* AUART0 is on 3/0 - 3/3, mux 0 */
	{ pin(3,0), .v = { MM(0), V33, A12, PU }}, /* Rx */
	{ pin(3,1), .v = { MM(0), V33, A12, PU }},     /* Tx */
	{ pin(3,2), .v = { MM(0), V33, A12 }},     /* CTS */
	{ pin(3,3), .v = { MM(0), V33, A12 }},     /* RTS */

	/* AUART1 is on 3/4 - 3/7, mux 0 */
	{ pin(3,4), .v = { MM(0), V33, A12, PU }}, /* Rx */
	{ pin(3,5), .v = { MM(0), V33, A12, PU }},     /* Tx */
	{ pin(3,6), .v = { MM(0), V33, A12 }},     /* CTS */
	{ pin(3,7), .v = { MM(0), V33, A12 }},     /* RTS */

	/* AUART2 = NC */

	/* AUART3 is on 2/18, 2/19, mux 1 */
	{ pin(2,18), .v = { MM(1), V33, A12, PU }}, /* Rx */
	{ pin(2,19), .v = { MM(1), V33, A12, PU }}, /* Tx */

	/* AUART4 = NC */

	/* I2C1 on 3/16, 3/17 */
	{ pin(3,16), .v = { MM(1), V33, A12, PU }}, /* SCL */
	{ pin(3,17), .v = { MM(1), V33, A12, PU }}, /* SDA */

	{ .pin = NOPIN } /* Must be at end */
};

static void uart_board_init(void)
{
	struct gpio_preset *p;
	struct mx28_clkctrl_regs *clkctrl = (void*)MXS_CLKCTRL_BASE;
	/* make sure the UART clock is not gated in the clock control module, clear bit 31 */
	clkctrl->hw_clkctrl_xtal_clr = 0x80000000;

	/* Set up GPIO multiplexers and values */
	p = (struct gpio_preset *)gpio_presets;
	while (p->pin != NOPIN) {
		set_pininfo(p->pin, &p->v);
		p++;
	}
}


#define HW_DRAM_CTL29	(0x74 >> 2)
#define CS_MAP		0xf
#define COLUMN_SIZE	0x2
#define ADDR_PINS	0x2
#define BANKS		8
#define APREBIT		0xa

struct sdram_override {
	int regno;
	u32 val;
};

const struct sdram_override sdram_evk[] = {
	{ 29,  CS_MAP << 24 | COLUMN_SIZE << 16 | 2/*ADDR_PINS*/ << 8 | APREBIT},
	{ -1, 0}
};

/* We set SDRAM up for 512MB, then attempt to autodetect (see spl_mem_init.c) */
const struct sdram_override sdram_eagle[] = {
	{ 29, CS_MAP << 24 | COLUMN_SIZE << 16 | ADDR_PINS << 8 | APREBIT},
	{ 31, 0x00000101 | (!!(BANKS==8)) << 16 }, /* 4 -bank mode */
	{ 37, 0x07080403 },
	{ 41, 0x0002030c },
	{ 71, 0xf4004a27 },
	{ 72, 0xf4004a27 },
	{ 73, 0xf4004a27 },
	{ 74, 0xf4004a27 },
	{ 77, 0x07400300 },
	{ 78, 0x07400300 },
	{ 79, 0x00000005 },
	{ 163, 0x00030404 }, /* DDR2 */
	{ 164, 0x00000003 },
	{ 181, 0x04420442 },
	{ 182, 0x04420442},
	{ 189, 0xffffffff},
	{ -1, 0}
};

void mx28_adjust_memory_params(uint32_t *dram_vals)
{
	const struct sdram_override *sov = sdram_eagle;

	while (sov->regno >= 0) {
#if 1
		D("SDRAM: reg %d: [%08x] => [%08x] %s\r\n",
			sov->regno, dram_vals[sov->regno], sov->val,
			(dram_vals[sov->regno] == sov->val)?"(red)":"");
#endif
		dram_vals[sov->regno] = sov->val;
		sov++;
	}
}

static unsigned auarts[] = {
	MXS_UARTAPP0_BASE,
	MXS_UARTAPP1_BASE,
	MXS_UARTAPP2_BASE,
	MXS_UARTAPP3_BASE,
	MXS_UARTAPP4_BASE
};

#include <asm/arch/regs-power.h>

struct mx28_power_regs *pw = (struct mx28_power_regs *)MXS_POWER_BASE;

#define PREG(name) D( #name " = \t%08x\r\n", pw->name )

#if defined(CONFIG_HW_WATCHDOG) && defined(CONFIG_MXS_WATCHDOG)
static void inline mxs_reg_setl(uint32_t value,struct mx28_register_32 * reg)
{
	writel(value,&reg->reg_set);
}
		
static void wdt_enable(u32 value)
{
	struct mx28_rtc_regs *rtc_regs = (struct mx28_rtc_regs *)MXS_RTC_BASE;
	
	writel(value, &rtc_regs->hw_rtc_watchdog);
	
	mxs_reg_setl(RTC_CTRL_WATCHDOGEN,&rtc_regs->hw_rtc_ctrl_reg);
}
#endif
	 
/* TODO: The Multiplexers are not set up for all UARTs */
void board_init_ll(void)
{
	int i;
	
	#if defined(CONFIG_HW_WATCHDOG) && defined(CONFIG_MXS_WATCHDOG)
	wdt_enable(19 * 1000);
	#endif
	
	uart_board_init();
	for (i=0; i<5; i++) {
		init_app_uart((void*)auarts[i], 115200);
		//app_uartbase(auarts[i]);
		//app_printf("\r\n\nSPL " __DATE__ " " __TIME__ ", UART %d\r\n", i);
	}
	init_app_uart((void*)CONFIG_FREESCALE_UART_BASE, 115200);

#ifdef CONFIG_SPL_FUSEDATA_ADDR
	mx28_blow_fuses();
#endif

	mx28_common_spl_init(iomux_setup, ARRAY_SIZE(iomux_setup));
	uart_board_init(); /* In case the above messes things up. FIXME: merge the settings. */

	/* Power supply needs some more handholding. */
	pw->hw_power_vddioctrl &= ~POWER_VDDIOCTRL_PWDN_BRNOUT;

	mx28_dump_fuses();

	D("SPL ends\r\n");
}
