#ifndef __REG_RTC_H__
#define __REG_RTC_H__

#include <mach/mx28.h>

#define REGS_RTC_BASE		MXS_IO_ADDRESS(MX28_RTC_BASE_ADDR)
#define HW_RTC_CTRL		0x00
#define HW_RTC_WATCHDOG		0x50
#define HW_RTC_PERSISTENT1	0x70

#define BM_RTC_CTRL_WATCHDOGEN	(1<<4)

#define HW_STMP3XXX_SET         0x04
#define HW_STMP3XXX_CLR         0x08
#define HW_STMP3XXX_TOG         0x0c

#ifndef __ASSEMBLER__
static inline void stmp3xxx_clearl(u32 v, void __iomem *r)
{
	__raw_writel(v, r + HW_STMP3XXX_CLR);
}

static inline void stmp3xxx_setl(u32 v, void __iomem *r)
{
	__raw_writel(v, r + HW_STMP3XXX_SET);
}
#endif

#endif
