#ifndef __ENDIAN_H__
#define __ENDIAN_H__

#define __write_le(ptr,src) \
	do { \
		int i; \
		unsigned char* p=(char*)(ptr); \
		__typeof(src) v=(src); \
		for(i=0;i<sizeof(src);i++) {\
			*p=(char)((v>>(i*8))&0xff); \
			p++; \
		} \
	} while(0)

#define __read_le(dst,ptr) \
	do { \
		int i; \
		unsigned char* p=(char*)(ptr); \
		__typeof(dst) v=0; \
		for(i=0;i<sizeof(dst);i++) {\
			v|=((__typeof(dst))(*p))<<(i*8); \
			p++; \
		} \
		dst=v; \
	} while(0)

#endif
