/*
 * Freescale LRADC Register Definitions
 *
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.50
 * Template revision: 26195
 */

#ifndef __ARCH_ARM___LRADC_H
#define __ARCH_ARM___LRADC_H

#define LRADC_CH0		0
#define LRADC_CH1		1
#define LRADC_CH2		2
#define LRADC_CH3		3
#define LRADC_CH4		4
#define LRADC_CH5		5
#define LRADC_CH6		6
#define LRADC_CH7		7

#define LRADC0		0x0
#define LRADC1		0x1
#define LRADC2		0x2
#define LRADC3		0x3
#define LRADC4		0x4
#define LRADC5		0x5
#define LRADC6		0x6
#define LRADC7		0x7
#define LRADC8		0x8
#define LRADC9		0x9
#define LRADC10		0xA
#define LRADC11		0xB
#define LRADC12		0xC
#define LRADC13		0xD
#define LRADC14		0xE
#define LRADC15		0xF

#define REGS_LRADC_BASE MXS_IO_ADDRESS(MXS_LRADC_BASE_ADDR)

#define HW_LRADC_CTRL0	(0x00000000)
#define HW_LRADC_CTRL0_SET	(0x00000004)
#define HW_LRADC_CTRL0_CLR	(0x00000008)
#define HW_LRADC_CTRL0_TOG	(0x0000000c)

#define BM_LRADC_CTRL0_SFTRST	0x80000000
#define BM_LRADC_CTRL0_CLKGATE	0x40000000
#define BP_LRADC_CTRL0_RSRVD2	27
#define BM_LRADC_CTRL0_RSRVD2	0x38000000
#define BF_LRADC_CTRL0_RSRVD2(v)  \
		(((v) << 27) & BM_LRADC_CTRL0_RSRVD2)
#define BM_LRADC_CTRL0_ONCHIP_GROUNDREF	0x04000000
#define BV_LRADC_CTRL0_ONCHIP_GROUNDREF__OFF 0x0
#define BV_LRADC_CTRL0_ONCHIP_GROUNDREF__ON  0x1
#define BM_LRADC_CTRL0_BUTTON1_DETECT_ENABLE	0x02000000
#define BV_LRADC_CTRL0_BUTTON1_DETECT_ENABLE__OFF 0x0
#define BV_LRADC_CTRL0_BUTTON1_DETECT_ENABLE__ON  0x1
#define BM_LRADC_CTRL0_BUTTON0_DETECT_ENABLE	0x01000000
#define BV_LRADC_CTRL0_BUTTON0_DETECT_ENABLE__OFF 0x0
#define BV_LRADC_CTRL0_BUTTON0_DETECT_ENABLE__ON  0x1
#define BM_LRADC_CTRL0_TOUCH_DETECT_ENABLE	0x00800000
#define BV_LRADC_CTRL0_TOUCH_DETECT_ENABLE__OFF 0x0
#define BV_LRADC_CTRL0_TOUCH_DETECT_ENABLE__ON  0x1
#define BM_LRADC_CTRL0_TOUCH_SCREEN_TYPE	0x00400000
#define BM_LRADC_CTRL0_YNLRSW	0x00200000
#define BP_LRADC_CTRL0_YPLLSW	19
#define BM_LRADC_CTRL0_YPLLSW	0x00180000
#define BF_LRADC_CTRL0_YPLLSW(v)  \
		(((v) << 19) & BM_LRADC_CTRL0_YPLLSW)
#define BP_LRADC_CTRL0_XNURSW	17
#define BM_LRADC_CTRL0_XNURSW	0x00060000
#define BF_LRADC_CTRL0_XNURSW(v)  \
		(((v) << 17) & BM_LRADC_CTRL0_XNURSW)
#define BM_LRADC_CTRL0_XPULSW	0x00010000
#define BP_LRADC_CTRL0_RSRVD1	8
#define BM_LRADC_CTRL0_RSRVD1	0x0000FF00
#define BF_LRADC_CTRL0_RSRVD1(v)  \
		(((v) << 8) & BM_LRADC_CTRL0_RSRVD1)
#define BP_LRADC_CTRL0_SCHEDULE	0
#define BM_LRADC_CTRL0_SCHEDULE	0x000000FF
#define BF_LRADC_CTRL0_SCHEDULE(v)  \
		(((v) << 0) & BM_LRADC_CTRL0_SCHEDULE)

#define HW_LRADC_CTRL1	(0x00000010)
#define HW_LRADC_CTRL1_SET	(0x00000014)
#define HW_LRADC_CTRL1_CLR	(0x00000018)
#define HW_LRADC_CTRL1_TOG	(0x0000001c)

#define BP_LRADC_CTRL1_RSRVD2	29
#define BM_LRADC_CTRL1_RSRVD2	0xE0000000
#define BF_LRADC_CTRL1_RSRVD2(v) \
		(((v) << 29) & BM_LRADC_CTRL1_RSRVD2)
#define BM_LRADC_CTRL1_BUTTON1_DETECT_IRQ_EN	0x10000000
#define BV_LRADC_CTRL1_BUTTON1_DETECT_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_BUTTON1_DETECT_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_BUTTON0_DETECT_IRQ_EN	0x08000000
#define BV_LRADC_CTRL1_BUTTON0_DETECT_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_BUTTON0_DETECT_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_THRESHOLD1_DETECT_IRQ_EN	0x04000000
#define BV_LRADC_CTRL1_THRESHOLD1_DETECT_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_THRESHOLD1_DETECT_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_THRESHOLD0_DETECT_IRQ_EN	0x02000000
#define BV_LRADC_CTRL1_THRESHOLD0_DETECT_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_THRESHOLD0_DETECT_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN	0x01000000
#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC7_IRQ_EN	0x00800000
#define BV_LRADC_CTRL1_LRADC7_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC7_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC6_IRQ_EN	0x00400000
#define BV_LRADC_CTRL1_LRADC6_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC6_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC5_IRQ_EN	0x00200000
#define BV_LRADC_CTRL1_LRADC5_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC5_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC4_IRQ_EN	0x00100000
#define BV_LRADC_CTRL1_LRADC4_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC4_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC3_IRQ_EN	0x00080000
#define BV_LRADC_CTRL1_LRADC3_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC3_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC2_IRQ_EN	0x00040000
#define BV_LRADC_CTRL1_LRADC2_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC2_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC1_IRQ_EN	0x00020000
#define BV_LRADC_CTRL1_LRADC1_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC1_IRQ_EN__ENABLE  0x1
#define BM_LRADC_CTRL1_LRADC0_IRQ_EN	0x00010000
#define BV_LRADC_CTRL1_LRADC0_IRQ_EN__DISABLE 0x0
#define BV_LRADC_CTRL1_LRADC0_IRQ_EN__ENABLE  0x1
#define BP_LRADC_CTRL1_RSRVD1	13
#define BM_LRADC_CTRL1_RSRVD1	0x0000E000
#define BF_LRADC_CTRL1_RSRVD1(v)  \
		(((v) << 13) & BM_LRADC_CTRL1_RSRVD1)
#define BM_LRADC_CTRL1_BUTTON1_DETECT_IRQ	0x00001000
#define BV_LRADC_CTRL1_BUTTON1_DETECT_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_BUTTON1_DETECT_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_BUTTON0_DETECT_IRQ	0x00000800
#define BV_LRADC_CTRL1_BUTTON0_DETECT_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_BUTTON0_DETECT_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_THRESHOLD1_DETECT_IRQ	0x00000400
#define BV_LRADC_CTRL1_THRESHOLD1_DETECT_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_THRESHOLD1_DETECT_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_THRESHOLD0_DETECT_IRQ	0x00000200
#define BV_LRADC_CTRL1_THRESHOLD0_DETECT_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_THRESHOLD0_DETECT_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_TOUCH_DETECT_IRQ	0x00000100
#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_TOUCH_DETECT_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC7_IRQ	0x00000080
#define BV_LRADC_CTRL1_LRADC7_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC7_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC6_IRQ	0x00000040
#define BV_LRADC_CTRL1_LRADC6_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC6_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC5_IRQ	0x00000020
#define BV_LRADC_CTRL1_LRADC5_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC5_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC4_IRQ	0x00000010
#define BV_LRADC_CTRL1_LRADC4_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC4_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC3_IRQ	0x00000008
#define BV_LRADC_CTRL1_LRADC3_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC3_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC2_IRQ	0x00000004
#define BV_LRADC_CTRL1_LRADC2_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC2_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC1_IRQ	0x00000002
#define BV_LRADC_CTRL1_LRADC1_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC1_IRQ__PENDING 0x1
#define BM_LRADC_CTRL1_LRADC0_IRQ	0x00000001
#define BV_LRADC_CTRL1_LRADC0_IRQ__CLEAR   0x0
#define BV_LRADC_CTRL1_LRADC0_IRQ__PENDING 0x1

#define HW_LRADC_CTRL2	(0x00000020)
#define HW_LRADC_CTRL2_SET	(0x00000024)
#define HW_LRADC_CTRL2_CLR	(0x00000028)
#define HW_LRADC_CTRL2_TOG	(0x0000002c)

#define BP_LRADC_CTRL2_DIVIDE_BY_TWO	24
#define BM_LRADC_CTRL2_DIVIDE_BY_TWO	0xFF000000
#define BF_LRADC_CTRL2_DIVIDE_BY_TWO(v) \
		(((v) << 24) & BM_LRADC_CTRL2_DIVIDE_BY_TWO)
#define BP_LRADC_CTRL2_RSRVD3	16
#define BM_LRADC_CTRL2_RSRVD3	0x00FF0000
#define BF_LRADC_CTRL2_RSRVD3(v)  \
		(((v) << 16) & BM_LRADC_CTRL2_RSRVD3)
#define BM_LRADC_CTRL2_TEMPSENSE_PWD	0x00008000
#define BV_LRADC_CTRL2_TEMPSENSE_PWD__ENABLE  0x0
#define BV_LRADC_CTRL2_TEMPSENSE_PWD__DISABLE 0x1
#define BP_LRADC_CTRL2_VTHSENSE	13
#define BM_LRADC_CTRL2_VTHSENSE	0x00006000
#define BF_LRADC_CTRL2_VTHSENSE(v)  \
		(((v) << 13) & BM_LRADC_CTRL2_VTHSENSE)
#define BM_LRADC_CTRL2_DISABLE_MUXAMP_BYPASS	0x00001000
#define BP_LRADC_CTRL2_RSRVD2	10
#define BM_LRADC_CTRL2_RSRVD2	0x00000C00
#define BF_LRADC_CTRL2_RSRVD2(v)  \
		(((v) << 10) & BM_LRADC_CTRL2_RSRVD2)
#define BM_LRADC_CTRL2_TEMP_SENSOR_IENABLE1	0x00000200
#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE1__DISABLE 0x0
#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE1__ENABLE  0x1
#define BM_LRADC_CTRL2_TEMP_SENSOR_IENABLE0	0x00000100
#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE0__DISABLE 0x0
#define BV_LRADC_CTRL2_TEMP_SENSOR_IENABLE0__ENABLE  0x1
#define BP_LRADC_CTRL2_TEMP_ISRC1	4
#define BM_LRADC_CTRL2_TEMP_ISRC1	0x000000F0
#define BF_LRADC_CTRL2_TEMP_ISRC1(v)  \
		(((v) << 4) & BM_LRADC_CTRL2_TEMP_ISRC1)
#define BV_LRADC_CTRL2_TEMP_ISRC1__300  0xF
#define BV_LRADC_CTRL2_TEMP_ISRC1__280  0xE
#define BV_LRADC_CTRL2_TEMP_ISRC1__260  0xD
#define BV_LRADC_CTRL2_TEMP_ISRC1__240  0xC
#define BV_LRADC_CTRL2_TEMP_ISRC1__220  0xB
#define BV_LRADC_CTRL2_TEMP_ISRC1__200  0xA
#define BV_LRADC_CTRL2_TEMP_ISRC1__180  0x9
#define BV_LRADC_CTRL2_TEMP_ISRC1__160  0x8
#define BV_LRADC_CTRL2_TEMP_ISRC1__140  0x7
#define BV_LRADC_CTRL2_TEMP_ISRC1__120  0x6
#define BV_LRADC_CTRL2_TEMP_ISRC1__100  0x5
#define BV_LRADC_CTRL2_TEMP_ISRC1__80   0x4
#define BV_LRADC_CTRL2_TEMP_ISRC1__60   0x3
#define BV_LRADC_CTRL2_TEMP_ISRC1__40   0x2
#define BV_LRADC_CTRL2_TEMP_ISRC1__20   0x1
#define BV_LRADC_CTRL2_TEMP_ISRC1__ZERO 0x0
#define BP_LRADC_CTRL2_TEMP_ISRC0	0
#define BM_LRADC_CTRL2_TEMP_ISRC0	0x0000000F
#define BF_LRADC_CTRL2_TEMP_ISRC0(v)  \
		(((v) << 0) & BM_LRADC_CTRL2_TEMP_ISRC0)
#define BV_LRADC_CTRL2_TEMP_ISRC0__300  0xF
#define BV_LRADC_CTRL2_TEMP_ISRC0__280  0xE
#define BV_LRADC_CTRL2_TEMP_ISRC0__260  0xD
#define BV_LRADC_CTRL2_TEMP_ISRC0__240  0xC
#define BV_LRADC_CTRL2_TEMP_ISRC0__220  0xB
#define BV_LRADC_CTRL2_TEMP_ISRC0__200  0xA
#define BV_LRADC_CTRL2_TEMP_ISRC0__180  0x9
#define BV_LRADC_CTRL2_TEMP_ISRC0__160  0x8
#define BV_LRADC_CTRL2_TEMP_ISRC0__140  0x7
#define BV_LRADC_CTRL2_TEMP_ISRC0__120  0x6
#define BV_LRADC_CTRL2_TEMP_ISRC0__100  0x5
#define BV_LRADC_CTRL2_TEMP_ISRC0__80   0x4
#define BV_LRADC_CTRL2_TEMP_ISRC0__60   0x3
#define BV_LRADC_CTRL2_TEMP_ISRC0__40   0x2
#define BV_LRADC_CTRL2_TEMP_ISRC0__20   0x1
#define BV_LRADC_CTRL2_TEMP_ISRC0__ZERO 0x0

#define HW_LRADC_CTRL3	(0x00000030)
#define HW_LRADC_CTRL3_SET	(0x00000034)
#define HW_LRADC_CTRL3_CLR	(0x00000038)
#define HW_LRADC_CTRL3_TOG	(0x0000003c)

#define BP_LRADC_CTRL3_RSRVD5	26
#define BM_LRADC_CTRL3_RSRVD5	0xFC000000
#define BF_LRADC_CTRL3_RSRVD5(v) \
		(((v) << 26) & BM_LRADC_CTRL3_RSRVD5)
#define BP_LRADC_CTRL3_DISCARD	24
#define BM_LRADC_CTRL3_DISCARD	0x03000000
#define BF_LRADC_CTRL3_DISCARD(v)  \
		(((v) << 24) & BM_LRADC_CTRL3_DISCARD)
#define BV_LRADC_CTRL3_DISCARD__1_SAMPLE  0x1
#define BV_LRADC_CTRL3_DISCARD__2_SAMPLES 0x2
#define BV_LRADC_CTRL3_DISCARD__3_SAMPLES 0x3
#define BM_LRADC_CTRL3_FORCE_ANALOG_PWUP	0x00800000
#define BV_LRADC_CTRL3_FORCE_ANALOG_PWUP__OFF 0x0
#define BV_LRADC_CTRL3_FORCE_ANALOG_PWUP__ON  0x1
#define BM_LRADC_CTRL3_FORCE_ANALOG_PWDN	0x00400000
#define BV_LRADC_CTRL3_FORCE_ANALOG_PWDN__ON  0x0
#define BV_LRADC_CTRL3_FORCE_ANALOG_PWDN__OFF 0x1
#define BP_LRADC_CTRL3_RSRVD4	14
#define BM_LRADC_CTRL3_RSRVD4	0x003FC000
#define BF_LRADC_CTRL3_RSRVD4(v)  \
		(((v) << 14) & BM_LRADC_CTRL3_RSRVD4)
#define BP_LRADC_CTRL3_RSRVD3	10
#define BM_LRADC_CTRL3_RSRVD3	0x00003C00
#define BF_LRADC_CTRL3_RSRVD3(v)  \
		(((v) << 10) & BM_LRADC_CTRL3_RSRVD3)
#define BP_LRADC_CTRL3_CYCLE_TIME	8
#define BM_LRADC_CTRL3_CYCLE_TIME	0x00000300
#define BF_LRADC_CTRL3_CYCLE_TIME(v)  \
		(((v) << 8) & BM_LRADC_CTRL3_CYCLE_TIME)
#define BV_LRADC_CTRL3_CYCLE_TIME__6MHZ 0x0
#define BV_LRADC_CTRL3_CYCLE_TIME__4MHZ 0x1
#define BV_LRADC_CTRL3_CYCLE_TIME__3MHZ 0x2
#define BV_LRADC_CTRL3_CYCLE_TIME__2MHZ 0x3
#define BP_LRADC_CTRL3_RSRVD2	6
#define BM_LRADC_CTRL3_RSRVD2	0x000000C0
#define BF_LRADC_CTRL3_RSRVD2(v)  \
		(((v) << 6) & BM_LRADC_CTRL3_RSRVD2)
#define BP_LRADC_CTRL3_HIGH_TIME	4
#define BM_LRADC_CTRL3_HIGH_TIME	0x00000030
#define BF_LRADC_CTRL3_HIGH_TIME(v)  \
		(((v) << 4) & BM_LRADC_CTRL3_HIGH_TIME)
#define BV_LRADC_CTRL3_HIGH_TIME__42NS  0x0
#define BV_LRADC_CTRL3_HIGH_TIME__83NS  0x1
#define BV_LRADC_CTRL3_HIGH_TIME__125NS 0x2
#define BV_LRADC_CTRL3_HIGH_TIME__250NS 0x3
#define BP_LRADC_CTRL3_RSRVD1	2
#define BM_LRADC_CTRL3_RSRVD1	0x0000000C
#define BF_LRADC_CTRL3_RSRVD1(v)  \
		(((v) << 2) & BM_LRADC_CTRL3_RSRVD1)
#define BM_LRADC_CTRL3_DELAY_CLOCK	0x00000002
#define BV_LRADC_CTRL3_DELAY_CLOCK__NORMAL  0x0
#define BV_LRADC_CTRL3_DELAY_CLOCK__DELAYED 0x1
#define BM_LRADC_CTRL3_INVERT_CLOCK	0x00000001
#define BV_LRADC_CTRL3_INVERT_CLOCK__NORMAL 0x0
#define BV_LRADC_CTRL3_INVERT_CLOCK__INVERT 0x1

#define HW_LRADC_STATUS	(0x00000040)
#define HW_LRADC_STATUS_SET	(0x00000044)
#define HW_LRADC_STATUS_CLR	(0x00000048)
#define HW_LRADC_STATUS_TOG	(0x0000004c)

#define BP_LRADC_STATUS_RSRVD3	29
#define BM_LRADC_STATUS_RSRVD3	0xE0000000
#define BF_LRADC_STATUS_RSRVD3(v) \
		(((v) << 29) & BM_LRADC_STATUS_RSRVD3)
#define BM_LRADC_STATUS_BUTTON1_PRESENT	0x10000000
#define BM_LRADC_STATUS_BUTTON0_PRESENT	0x08000000
#define BM_LRADC_STATUS_TEMP1_PRESENT	0x04000000
#define BM_LRADC_STATUS_TEMP0_PRESENT	0x02000000
#define BM_LRADC_STATUS_TOUCH_PANEL_PRESENT	0x01000000
#define BM_LRADC_STATUS_CHANNEL7_PRESENT	0x00800000
#define BM_LRADC_STATUS_CHANNEL6_PRESENT	0x00400000
#define BM_LRADC_STATUS_CHANNEL5_PRESENT	0x00200000
#define BM_LRADC_STATUS_CHANNEL4_PRESENT	0x00100000
#define BM_LRADC_STATUS_CHANNEL3_PRESENT	0x00080000
#define BM_LRADC_STATUS_CHANNEL2_PRESENT	0x00040000
#define BM_LRADC_STATUS_CHANNEL1_PRESENT	0x00020000
#define BM_LRADC_STATUS_CHANNEL0_PRESENT	0x00010000
#define BP_LRADC_STATUS_RSRVD2	3
#define BM_LRADC_STATUS_RSRVD2	0x0000FFF8
#define BF_LRADC_STATUS_RSRVD2(v)  \
		(((v) << 3) & BM_LRADC_STATUS_RSRVD2)
#define BM_LRADC_STATUS_BUTTON1_DETECT_RAW	0x00000004
#define BV_LRADC_STATUS_BUTTON1_DETECT_RAW__OPEN 0x0
#define BV_LRADC_STATUS_BUTTON1_DETECT_RAW__HIT  0x1
#define BM_LRADC_STATUS_BUTTON0_DETECT_RAW	0x00000002
#define BV_LRADC_STATUS_BUTTON0_DETECT_RAW__OPEN 0x0
#define BV_LRADC_STATUS_BUTTON0_DETECT_RAW__HIT  0x1
#define BM_LRADC_STATUS_TOUCH_DETECT_RAW	0x00000001
#define BV_LRADC_STATUS_TOUCH_DETECT_RAW__OPEN 0x0
#define BV_LRADC_STATUS_TOUCH_DETECT_RAW__HIT  0x1

/*
 *  multi-register-define name HW_LRADC_CHn
 *              base 0x00000050
 *              count 6
 *              offset 0x10
 */
#define HW_LRADC_CHn(n)	(0x00000050 + (n) * 0x10)
#define HW_LRADC_CHn_SET(n)	(0x00000054 + (n) * 0x10)
#define HW_LRADC_CHn_CLR(n)	(0x00000058 + (n) * 0x10)
#define HW_LRADC_CHn_TOG(n)	(0x0000005c + (n) * 0x10)
#define BM_LRADC_CHn_TOGGLE	0x80000000
#define BM_LRADC_CHn_RSRVD2	0x40000000
#define BM_LRADC_CHn_ACCUMULATE	0x20000000
#define BP_LRADC_CHn_NUM_SAMPLES	24
#define BM_LRADC_CHn_NUM_SAMPLES	0x1F000000
#define BF_LRADC_CHn_NUM_SAMPLES(v)  \
		(((v) << 24) & BM_LRADC_CHn_NUM_SAMPLES)
#define BP_LRADC_CHn_RSRVD1	18
#define BM_LRADC_CHn_RSRVD1	0x00FC0000
#define BF_LRADC_CHn_RSRVD1(v)  \
		(((v) << 18) & BM_LRADC_CHn_RSRVD1)
#define BP_LRADC_CHn_VALUE	0
#define BM_LRADC_CHn_VALUE	0x0003FFFF
#define BF_LRADC_CHn_VALUE(v)  \
		(((v) << 0) & BM_LRADC_CHn_VALUE)

#define HW_LRADC_CH6	(0x000000b0)
#define HW_LRADC_CH6_SET	(0x000000b4)
#define HW_LRADC_CH6_CLR	(0x000000b8)
#define HW_LRADC_CH6_TOG	(0x000000bc)

#define BM_LRADC_CH6_TOGGLE	0x80000000
#define BM_LRADC_CH6_RSRVD2	0x40000000
#define BM_LRADC_CH6_ACCUMULATE	0x20000000
#define BP_LRADC_CH6_NUM_SAMPLES	24
#define BM_LRADC_CH6_NUM_SAMPLES	0x1F000000
#define BF_LRADC_CH6_NUM_SAMPLES(v)  \
		(((v) << 24) & BM_LRADC_CH6_NUM_SAMPLES)
#define BP_LRADC_CH6_RSRVD1	18
#define BM_LRADC_CH6_RSRVD1	0x00FC0000
#define BF_LRADC_CH6_RSRVD1(v)  \
		(((v) << 18) & BM_LRADC_CH6_RSRVD1)
#define BP_LRADC_CH6_VALUE	0
#define BM_LRADC_CH6_VALUE	0x0003FFFF
#define BF_LRADC_CH6_VALUE(v)  \
		(((v) << 0) & BM_LRADC_CH6_VALUE)

#define HW_LRADC_CH7	(0x000000c0)
#define HW_LRADC_CH7_SET	(0x000000c4)
#define HW_LRADC_CH7_CLR	(0x000000c8)
#define HW_LRADC_CH7_TOG	(0x000000cc)

#define BM_LRADC_CH7_TOGGLE	0x80000000
#define BM_LRADC_CH7_TESTMODE_TOGGLE	0x40000000
#define BM_LRADC_CH7_ACCUMULATE	0x20000000
#define BP_LRADC_CH7_NUM_SAMPLES	24
#define BM_LRADC_CH7_NUM_SAMPLES	0x1F000000
#define BF_LRADC_CH7_NUM_SAMPLES(v)  \
		(((v) << 24) & BM_LRADC_CH7_NUM_SAMPLES)
#define BP_LRADC_CH7_RSRVD1	18
#define BM_LRADC_CH7_RSRVD1	0x00FC0000
#define BF_LRADC_CH7_RSRVD1(v)  \
		(((v) << 18) & BM_LRADC_CH7_RSRVD1)
#define BP_LRADC_CH7_VALUE	0
#define BM_LRADC_CH7_VALUE	0x0003FFFF
#define BF_LRADC_CH7_VALUE(v)  \
		(((v) << 0) & BM_LRADC_CH7_VALUE)

/*
 *  multi-register-define name HW_LRADC_DELAYn
 *              base 0x000000D0
 *              count 4
 *              offset 0x10
 */
#define HW_LRADC_DELAYn(n)	(0x000000d0 + (n) * 0x10)
#define HW_LRADC_DELAYn_SET(n)	(0x000000d4 + (n) * 0x10)
#define HW_LRADC_DELAYn_CLR(n)	(0x000000d8 + (n) * 0x10)
#define HW_LRADC_DELAYn_TOG(n)	(0x000000dc + (n) * 0x10)
#define BP_LRADC_DELAYn_TRIGGER_LRADCS	24
#define BM_LRADC_DELAYn_TRIGGER_LRADCS	0xFF000000
#define BF_LRADC_DELAYn_TRIGGER_LRADCS(v) \
		(((v) << 24) & BM_LRADC_DELAYn_TRIGGER_LRADCS)
#define BP_LRADC_DELAYn_RSRVD2	21
#define BM_LRADC_DELAYn_RSRVD2	0x00E00000
#define BF_LRADC_DELAYn_RSRVD2(v)  \
		(((v) << 21) & BM_LRADC_DELAYn_RSRVD2)
#define BM_LRADC_DELAYn_KICK	0x00100000
#define BP_LRADC_DELAYn_TRIGGER_DELAYS	16
#define BM_LRADC_DELAYn_TRIGGER_DELAYS	0x000F0000
#define BF_LRADC_DELAYn_TRIGGER_DELAYS(v)  \
		(((v) << 16) & BM_LRADC_DELAYn_TRIGGER_DELAYS)
#define BP_LRADC_DELAYn_LOOP_COUNT	11
#define BM_LRADC_DELAYn_LOOP_COUNT	0x0000F800
#define BF_LRADC_DELAYn_LOOP_COUNT(v)  \
		(((v) << 11) & BM_LRADC_DELAYn_LOOP_COUNT)
#define BP_LRADC_DELAYn_DELAY	0
#define BM_LRADC_DELAYn_DELAY	0x000007FF
#define BF_LRADC_DELAYn_DELAY(v)  \
		(((v) << 0) & BM_LRADC_DELAYn_DELAY)

#define HW_LRADC_DEBUG0	(0x00000110)
#define HW_LRADC_DEBUG0_SET	(0x00000114)
#define HW_LRADC_DEBUG0_CLR	(0x00000118)
#define HW_LRADC_DEBUG0_TOG	(0x0000011c)

#define BP_LRADC_DEBUG0_READONLY	16
#define BM_LRADC_DEBUG0_READONLY	0xFFFF0000
#define BF_LRADC_DEBUG0_READONLY(v) \
		(((v) << 16) & BM_LRADC_DEBUG0_READONLY)
#define BP_LRADC_DEBUG0_RSRVD1	12
#define BM_LRADC_DEBUG0_RSRVD1	0x0000F000
#define BF_LRADC_DEBUG0_RSRVD1(v)  \
		(((v) << 12) & BM_LRADC_DEBUG0_RSRVD1)
#define BP_LRADC_DEBUG0_STATE	0
#define BM_LRADC_DEBUG0_STATE	0x00000FFF
#define BF_LRADC_DEBUG0_STATE(v)  \
		(((v) << 0) & BM_LRADC_DEBUG0_STATE)

#define HW_LRADC_DEBUG1	(0x00000120)
#define HW_LRADC_DEBUG1_SET	(0x00000124)
#define HW_LRADC_DEBUG1_CLR	(0x00000128)
#define HW_LRADC_DEBUG1_TOG	(0x0000012c)

#define BP_LRADC_DEBUG1_RSRVD3	24
#define BM_LRADC_DEBUG1_RSRVD3	0xFF000000
#define BF_LRADC_DEBUG1_RSRVD3(v) \
		(((v) << 24) & BM_LRADC_DEBUG1_RSRVD3)
#define BP_LRADC_DEBUG1_REQUEST	16
#define BM_LRADC_DEBUG1_REQUEST	0x00FF0000
#define BF_LRADC_DEBUG1_REQUEST(v)  \
		(((v) << 16) & BM_LRADC_DEBUG1_REQUEST)
#define BP_LRADC_DEBUG1_RSRVD2	13
#define BM_LRADC_DEBUG1_RSRVD2	0x0000E000
#define BF_LRADC_DEBUG1_RSRVD2(v)  \
		(((v) << 13) & BM_LRADC_DEBUG1_RSRVD2)
#define BP_LRADC_DEBUG1_TESTMODE_COUNT	8
#define BM_LRADC_DEBUG1_TESTMODE_COUNT	0x00001F00
#define BF_LRADC_DEBUG1_TESTMODE_COUNT(v)  \
		(((v) << 8) & BM_LRADC_DEBUG1_TESTMODE_COUNT)
#define BP_LRADC_DEBUG1_RSRVD1	3
#define BM_LRADC_DEBUG1_RSRVD1	0x000000F8
#define BF_LRADC_DEBUG1_RSRVD1(v)  \
		(((v) << 3) & BM_LRADC_DEBUG1_RSRVD1)
#define BM_LRADC_DEBUG1_TESTMODE6	0x00000004
#define BV_LRADC_DEBUG1_TESTMODE6__NORMAL 0x0
#define BV_LRADC_DEBUG1_TESTMODE6__TEST   0x1
#define BM_LRADC_DEBUG1_TESTMODE5	0x00000002
#define BV_LRADC_DEBUG1_TESTMODE5__NORMAL 0x0
#define BV_LRADC_DEBUG1_TESTMODE5__TEST   0x1
#define BM_LRADC_DEBUG1_TESTMODE	0x00000001
#define BV_LRADC_DEBUG1_TESTMODE__NORMAL 0x0
#define BV_LRADC_DEBUG1_TESTMODE__TEST   0x1

#define HW_LRADC_CONVERSION	(0x00000130)
#define HW_LRADC_CONVERSION_SET	(0x00000134)
#define HW_LRADC_CONVERSION_CLR	(0x00000138)
#define HW_LRADC_CONVERSION_TOG	(0x0000013c)

#define BP_LRADC_CONVERSION_RSRVD3	21
#define BM_LRADC_CONVERSION_RSRVD3	0xFFE00000
#define BF_LRADC_CONVERSION_RSRVD3(v) \
		(((v) << 21) & BM_LRADC_CONVERSION_RSRVD3)
#define BM_LRADC_CONVERSION_AUTOMATIC	0x00100000
#define BV_LRADC_CONVERSION_AUTOMATIC__DISABLE 0x0
#define BV_LRADC_CONVERSION_AUTOMATIC__ENABLE  0x1
#define BP_LRADC_CONVERSION_RSRVD2	18
#define BM_LRADC_CONVERSION_RSRVD2	0x000C0000
#define BF_LRADC_CONVERSION_RSRVD2(v)  \
		(((v) << 18) & BM_LRADC_CONVERSION_RSRVD2)
#define BP_LRADC_CONVERSION_SCALE_FACTOR	16
#define BM_LRADC_CONVERSION_SCALE_FACTOR	0x00030000
#define BF_LRADC_CONVERSION_SCALE_FACTOR(v)  \
		(((v) << 16) & BM_LRADC_CONVERSION_SCALE_FACTOR)
#define BV_LRADC_CONVERSION_SCALE_FACTOR__NIMH       0x0
#define BV_LRADC_CONVERSION_SCALE_FACTOR__DUAL_NIMH  0x1
#define BV_LRADC_CONVERSION_SCALE_FACTOR__LI_ION     0x2
#define BV_LRADC_CONVERSION_SCALE_FACTOR__ALT_LI_ION 0x3
#define BP_LRADC_CONVERSION_RSRVD1	10
#define BM_LRADC_CONVERSION_RSRVD1	0x0000FC00
#define BF_LRADC_CONVERSION_RSRVD1(v)  \
		(((v) << 10) & BM_LRADC_CONVERSION_RSRVD1)
#define BP_LRADC_CONVERSION_SCALED_BATT_VOLTAGE	0
#define BM_LRADC_CONVERSION_SCALED_BATT_VOLTAGE	0x000003FF
#define BF_LRADC_CONVERSION_SCALED_BATT_VOLTAGE(v)  \
		(((v) << 0) & BM_LRADC_CONVERSION_SCALED_BATT_VOLTAGE)

#define HW_LRADC_CTRL4	(0x00000140)
#define HW_LRADC_CTRL4_SET	(0x00000144)
#define HW_LRADC_CTRL4_CLR	(0x00000148)
#define HW_LRADC_CTRL4_TOG	(0x0000014c)

#define BP_LRADC_CTRL4_LRADC7SELECT	28
#define BM_LRADC_CTRL4_LRADC7SELECT	0xF0000000
#define BF_LRADC_CTRL4_LRADC7SELECT(v) \
		(((v) << 28) & BM_LRADC_CTRL4_LRADC7SELECT)
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC7SELECT__CHANNEL15 0xF
#define BP_LRADC_CTRL4_LRADC6SELECT	24
#define BM_LRADC_CTRL4_LRADC6SELECT	0x0F000000
#define BF_LRADC_CTRL4_LRADC6SELECT(v)  \
		(((v) << 24) & BM_LRADC_CTRL4_LRADC6SELECT)
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC6SELECT__CHANNEL15 0xF
#define BP_LRADC_CTRL4_LRADC5SELECT	20
#define BM_LRADC_CTRL4_LRADC5SELECT	0x00F00000
#define BF_LRADC_CTRL4_LRADC5SELECT(v)  \
		(((v) << 20) & BM_LRADC_CTRL4_LRADC5SELECT)
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC5SELECT__CHANNEL15 0xF
#define BP_LRADC_CTRL4_LRADC4SELECT	16
#define BM_LRADC_CTRL4_LRADC4SELECT	0x000F0000
#define BF_LRADC_CTRL4_LRADC4SELECT(v)  \
		(((v) << 16) & BM_LRADC_CTRL4_LRADC4SELECT)
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC4SELECT__CHANNEL15 0xF
#define BP_LRADC_CTRL4_LRADC3SELECT	12
#define BM_LRADC_CTRL4_LRADC3SELECT	0x0000F000
#define BF_LRADC_CTRL4_LRADC3SELECT(v)  \
		(((v) << 12) & BM_LRADC_CTRL4_LRADC3SELECT)
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC3SELECT__CHANNEL15 0xF
#define BP_LRADC_CTRL4_LRADC2SELECT	8
#define BM_LRADC_CTRL4_LRADC2SELECT	0x00000F00
#define BF_LRADC_CTRL4_LRADC2SELECT(v)  \
		(((v) << 8) & BM_LRADC_CTRL4_LRADC2SELECT)
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC2SELECT__CHANNEL15 0xF
#define BP_LRADC_CTRL4_LRADC1SELECT	4
#define BM_LRADC_CTRL4_LRADC1SELECT	0x000000F0
#define BF_LRADC_CTRL4_LRADC1SELECT(v)  \
		(((v) << 4) & BM_LRADC_CTRL4_LRADC1SELECT)
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC1SELECT__CHANNEL15 0xF
#define BP_LRADC_CTRL4_LRADC0SELECT	0
#define BM_LRADC_CTRL4_LRADC0SELECT	0x0000000F
#define BF_LRADC_CTRL4_LRADC0SELECT(v)  \
		(((v) << 0) & BM_LRADC_CTRL4_LRADC0SELECT)
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL0  0x0
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL1  0x1
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL2  0x2
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL3  0x3
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL4  0x4
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL5  0x5
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL6  0x6
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL7  0x7
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL8  0x8
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL9  0x9
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL10 0xA
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL11 0xB
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL12 0xC
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL13 0xD
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL14 0xE
#define BV_LRADC_CTRL4_LRADC0SELECT__CHANNEL15 0xF

/*
 *  multi-register-define name HW_LRADC_THRESHOLDn
 *              base 0x00000150
 *              count 2
 *              offset 0x10
 */
#define HW_LRADC_THRESHOLDn(n)	(0x00000150 + (n) * 0x10)
#define HW_LRADC_THRESHOLDn_SET(n)	(0x00000154 + (n) * 0x10)
#define HW_LRADC_THRESHOLDn_CLR(n)	(0x00000158 + (n) * 0x10)
#define HW_LRADC_THRESHOLDn_TOG(n)	(0x0000015c + (n) * 0x10)

#define BP_LRADC_THRESHOLDn_RSRVD1	25
#define BM_LRADC_THRESHOLDn_RSRVD1	0xFE000000
#define BF_LRADC_THRESHOLDn_RSRVD1(v) \
		(((v) << 25) & BM_LRADC_THRESHOLDn_RSRVD1)
#define BM_LRADC_THRESHOLDn_ENABLE	0x01000000
#define BM_LRADC_THRESHOLDn_BATTCHRG_DISABLE	0x00800000
#define BP_LRADC_THRESHOLDn_CHANNEL_SEL	20
#define BM_LRADC_THRESHOLDn_CHANNEL_SEL	0x00700000
#define BF_LRADC_THRESHOLDn_CHANNEL_SEL(v)  \
		(((v) << 20) & BM_LRADC_THRESHOLDn_CHANNEL_SEL)
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL0 0x0
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL1 0x1
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL2 0x2
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL3 0x3
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL4 0x4
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL5 0x5
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL6 0x6
#define BV_LRADC_THRESHOLDn_CHANNEL_SEL__CHANNEL7 0x7
#define BP_LRADC_THRESHOLDn_SETTING	18
#define BM_LRADC_THRESHOLDn_SETTING	0x000C0000
#define BF_LRADC_THRESHOLDn_SETTING(v)  \
		(((v) << 18) & BM_LRADC_THRESHOLDn_SETTING)
#define BV_LRADC_THRESHOLDn_SETTING__NO_COMPARE  0x0
#define BV_LRADC_THRESHOLDn_SETTING__DETECT_LOW  0x1
#define BV_LRADC_THRESHOLDn_SETTING__DETECT_HIGH 0x2
#define BV_LRADC_THRESHOLDn_SETTING__RESERVED    0x3
#define BP_LRADC_THRESHOLDn_VALUE	0
#define BM_LRADC_THRESHOLDn_VALUE	0x0003FFFF
#define BF_LRADC_THRESHOLDn_VALUE(v)  \
		(((v) << 0) & BM_LRADC_THRESHOLDn_VALUE)



#define HW_LRADC_THRESHOLD0	(0x00000150)
#define HW_LRADC_THRESHOLD0_SET	(0x00000154)
#define HW_LRADC_THRESHOLD0_CLR	(0x00000158)
#define HW_LRADC_THRESHOLD0_TOG	(0x0000015c)

#define BP_LRADC_THRESHOLD0_RSRVD1	25
#define BM_LRADC_THRESHOLD0_RSRVD1	0xFE000000
#define BF_LRADC_THRESHOLD0_RSRVD1(v) \
		(((v) << 25) & BM_LRADC_THRESHOLD0_RSRVD1)
#define BM_LRADC_THRESHOLD0_ENABLE	0x01000000
#define BM_LRADC_THRESHOLD0_BATTCHRG_DISABLE	0x00800000
#define BP_LRADC_THRESHOLD0_CHANNEL_SEL	20
#define BM_LRADC_THRESHOLD0_CHANNEL_SEL	0x00700000
#define BF_LRADC_THRESHOLD0_CHANNEL_SEL(v)  \
		(((v) << 20) & BM_LRADC_THRESHOLD0_CHANNEL_SEL)
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL0 0x0
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL1 0x1
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL2 0x2
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL3 0x3
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL4 0x4
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL5 0x5
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL6 0x6
#define BV_LRADC_THRESHOLD0_CHANNEL_SEL__CHANNEL7 0x7
#define BP_LRADC_THRESHOLD0_SETTING	18
#define BM_LRADC_THRESHOLD0_SETTING	0x000C0000
#define BF_LRADC_THRESHOLD0_SETTING(v)  \
		(((v) << 18) & BM_LRADC_THRESHOLD0_SETTING)
#define BV_LRADC_THRESHOLD0_SETTING__NO_COMPARE  0x0
#define BV_LRADC_THRESHOLD0_SETTING__DETECT_LOW  0x1
#define BV_LRADC_THRESHOLD0_SETTING__DETECT_HIGH 0x2
#define BV_LRADC_THRESHOLD0_SETTING__RESERVED    0x3
#define BP_LRADC_THRESHOLD0_VALUE	0
#define BM_LRADC_THRESHOLD0_VALUE	0x0003FFFF
#define BF_LRADC_THRESHOLD0_VALUE(v)  \
		(((v) << 0) & BM_LRADC_THRESHOLD0_VALUE)

#define HW_LRADC_THRESHOLD1	(0x00000160)
#define HW_LRADC_THRESHOLD1_SET	(0x00000164)
#define HW_LRADC_THRESHOLD1_CLR	(0x00000168)
#define HW_LRADC_THRESHOLD1_TOG	(0x0000016c)

#define BP_LRADC_THRESHOLD1_RSRVD1	25
#define BM_LRADC_THRESHOLD1_RSRVD1	0xFE000000
#define BF_LRADC_THRESHOLD1_RSRVD1(v) \
		(((v) << 25) & BM_LRADC_THRESHOLD1_RSRVD1)
#define BM_LRADC_THRESHOLD1_ENABLE	0x01000000
#define BM_LRADC_THRESHOLD1_BATTCHRG_DISABLE	0x00800000
#define BP_LRADC_THRESHOLD1_CHANNEL_SEL	20
#define BM_LRADC_THRESHOLD1_CHANNEL_SEL	0x00700000
#define BF_LRADC_THRESHOLD1_CHANNEL_SEL(v)  \
		(((v) << 20) & BM_LRADC_THRESHOLD1_CHANNEL_SEL)
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL0 0x0
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL1 0x1
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL2 0x2
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL3 0x3
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL4 0x4
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL5 0x5
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL6 0x6
#define BV_LRADC_THRESHOLD1_CHANNEL_SEL__CHANNEL7 0x7
#define BP_LRADC_THRESHOLD1_SETTING	18
#define BM_LRADC_THRESHOLD1_SETTING	0x000C0000
#define BF_LRADC_THRESHOLD1_SETTING(v)  \
		(((v) << 18) & BM_LRADC_THRESHOLD1_SETTING)
#define BV_LRADC_THRESHOLD1_SETTING__NO_COMPARE  0x0
#define BV_LRADC_THRESHOLD1_SETTING__DETECT_LOW  0x1
#define BV_LRADC_THRESHOLD1_SETTING__DETECT_HIGH 0x2
#define BV_LRADC_THRESHOLD1_SETTING__RESERVED    0x3
#define BP_LRADC_THRESHOLD1_VALUE	0
#define BM_LRADC_THRESHOLD1_VALUE	0x0003FFFF
#define BF_LRADC_THRESHOLD1_VALUE(v)  \
		(((v) << 0) & BM_LRADC_THRESHOLD1_VALUE)

#define HW_LRADC_VERSION	(0x00000170)

#define BP_LRADC_VERSION_MAJOR	24
#define BM_LRADC_VERSION_MAJOR	0xFF000000
#define BF_LRADC_VERSION_MAJOR(v) \
		(((v) << 24) & BM_LRADC_VERSION_MAJOR)
#define BP_LRADC_VERSION_MINOR	16
#define BM_LRADC_VERSION_MINOR	0x00FF0000
#define BF_LRADC_VERSION_MINOR(v)  \
		(((v) << 16) & BM_LRADC_VERSION_MINOR)
#define BP_LRADC_VERSION_STEP	0
#define BM_LRADC_VERSION_STEP	0x0000FFFF
#define BF_LRADC_VERSION_STEP(v)  \
		(((v) << 0) & BM_LRADC_VERSION_STEP)
#endif /* __ARCH_ARM___LRADC_H */
