///
///	@file 	charGen.cpp
/// @brief 	Generate the character lookup tables for escape / descape routines
//
/////////////////////////////////// Copyright //////////////////////////////////
//
//	@copy	default
//	
//	Copyright (c) Mbedthis Software LLC, 2003-2007. All Rights Reserved.
//	
//	This software is distributed under commercial and open source licenses.
//	You may use the GPL open source license described below or you may acquire 
//	a commercial license from Mbedthis Software. You agree to be fully bound 
//	by the terms of either license. Consult the LICENSE.TXT distributed with 
//	this software for full details.
//	
//	This software is open source; you can redistribute it and/or modify it 
//	under the terms of the GNU General Public License as published by the 
//	Free Software Foundation; either version 2 of the License, or (at your 
//	option) any later version. See the GNU General Public License for more 
//	details at: http://www.mbedthis.com/downloads/gplLicense.html
//	
//	This program is distributed WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
//	
//	This GPL license does NOT permit incorporating this software into 
//	proprietary programs. If you are unable to comply with the GPL, you must
//	acquire a commercial license to use this software. Commercial licenses 
//	for this software and support services are available from Mbedthis 
//	Software at http://www.mbedthis.com 
//	
//	@end
/////////////////////////////////// Includes ///////////////////////////////////

#include	<ctype.h>
#include	<stdio.h>
#include	<string.h>

#include	"posixRemap.h"

/////////////////////////////////// Defines ////////////////////////////////////
//
//	These must match those in http.h
//

#define MPR_HTTP_ESCAPE_HTML	0x01
#define MPR_HTTP_ESCAPE_SHELL	0x02
#define MPR_HTTP_ESCAPE_PATH	0x04

//////////////////////////////////// Code //////////////////////////////////////

int main(int argc, char *argv[])
{
    unsigned char	 flags;
    unsigned int	 c;

	printf("static uchar charMatch[256] = {\n\t 0,");

    for (c = 1; c < 256; ++c) {
		flags = 0;
		if (c % 16 == 0)
			printf("\n\t");
#if WIN
		if (strchr("&;`'\"|*?~<>^()[]{}$\\\n\r%", c)) {
			flags |= MPR_HTTP_ESCAPE_SHELL;
		}
#else
		if (strchr("&;`'\"|*?~<>^()[]{}$\\\n", c)) {
			flags |= MPR_HTTP_ESCAPE_SHELL;
		}
#endif
		//
		//	Unsafe chars in URLs are: 
		//		0x00-0x1F, 0x7F, 0x80-0xFF, <>'"#%{}|\^~[]
		//		Space, \t, \r, \n
		//	Reserved chars with special meaning are:
		//		;/?: @=&		FUTURE -- should ";?" be in the list
		//
		if (!isalnum(c) && !strchr("$-_.+!*'(),:@&=/~", c)) {
			flags |= MPR_HTTP_ESCAPE_PATH;
		}

		if (strchr("<>&()#", c) != 0) {
			flags |= MPR_HTTP_ESCAPE_HTML;
		}
		printf("%2u%c", flags, (c < 255) ? ',' : ' ');

    }
    printf("\n};\n");
    return 0;
}

//
// Local variables:
// tab-width: 4
// c-basic-offset: 4
// End:
// vim: sw=4 ts=4 
//
