# Build wget


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := wget
$(PR)_VERSION ?= 1.14

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

export CC:=$(CROSS_COMPILE)gcc
export LD:=$(CROSS_COMPILE)ld
export STRIP:=$(CROSS_COMPILE)strip

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

CONFIG_PRESETS := ac_cv_header_pcre_h=no

TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386
CONFIG_OPTS += --prefix=/ --with-ssl=openssl

# Enforce License check
ifneq ($(V_LICENSE),gpl3)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error GPLv3 software is prohibited. V_LICENSE=$(V_LICENSE))
endif
endif

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.

$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	# building the man page always fails, but we don't need it
	touch src/doc/wget.pod
	touch src/doc/wget.1
	touch $@

$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
	touch $@

$(PR).done: $(PR).configured
	echo "current Path is:$(PATH)";
	# This allows a re-install
	(cd src && $(MAKE) -j1)
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call
# 'scatter_install.sh -h' for more information.
$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && DESTDIR="$(TEMPINSTALL)" $(MAKE) -j1 install )
	scatter_install.sh -s $(TARGET)-strip -b "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)"
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
