# Build usb-utils


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := usbutils
$(PR)_VERSION ?= 0.73

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)


export CC:=$(CROSS_COMPILE)gcc
export LD:=$(CROSS_COMPILE)ld
export STRIP:=$(CROSS_COMPILE)strip

# Config settings
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#
CONFIG_PRESETS := ac_cv_func_malloc_0_nonnull=yes
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386
CONFIG_OPTS += --prefix=/usr

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

# lib USB
ifeq ($(PLATFORM),Platypus2)
LIBUSB_DIR = $(SBASE)/RT288x_SDK/source/lib/libusb-0.1.12

LIBS+=$(LIBUSB_DIR)/libusb.a

CFLAGS+=-I$(LIBUSB_DIR)

LDFLAGS+=-L$(SBASE)/RT288x_SDK/source/lib/libusb-0.1.12
endif

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xjf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@
	
$(PR).configured: $(PR).unpacked $(PR).start
	(cd src && $(CONFIG_PRESETS) CC=$(CC) LIBS=$(LIBS) ./configure $(CONFIG_OPTS) )
	touch $@
	

$(PR).done: $(PR).patched $(PR).configured
	(cd src && $(MAKE) -j$(PROCS) CC=$(CC) )
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

$(PR).install: $(PR).done
	mkdir -p "$(INSTDIR)"/usr/bin/
	# We need to remove first, since lsusb could be a hard link to busybox
	rm -f "$(INSTDIR)"/usr/bin/lsusb
	cp src/lsusb "$(INSTDIR)"/usr/bin/
	$(STRIP) "$(INSTDIR)"/usr/bin/lsusb
	
.PHONY: $(PR).clean $(PR).install
