#
# usbmount build
#


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := usbmount
$(PR)_VERSION ?= 0.0.14.1

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)


all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked $(PR).start
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

$(PR).done: $(PR).patched
	# Nothing to build, it's all scripts
	touch $@

$(PR).install: $(PR).done
	mkdir -p "$(INSTDIR)/sbin"
	cp "src/usbmount" "$(INSTDIR)/sbin/"
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
