#
# Compiling new versions of udev. Must have a toolchain with recent
# kernel header (>2.6.36).
#


# Project name, version number and tarball extension. Project name
# must match the name of the *.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := udev
$(PR)_VERSION ?= 114

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.


# Config settings, per platform
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#
CONFIG_PRESETS := BLKID_CFLAGS=-I$(CDCS_INCLUDE) BLKID_LIBS=-L$(CDCS_LIB)
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386
CONFIG_OPTS += --prefix=/ --disable-largefile --disable-shared --disable-gtk-doc-html --disable-gudev \
	--disable-introspection --disable-keymap --without-selinux \
	--with-systemdsystemunitdir=/lib/systemd/system \
	--with-usb-ids-path=../udev_usb.ids --with-pci-ids-path=../udev_pci.ids

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

ifneq ($(NEWTYPE),y)

export CC=$(CROSS_COMPILE)gcc
export LD=$(CROSS_COMPILE)ld
export AR=$(CROSS_COMPILE)ar

endif

TEMPINSTALL := $(CPATH)/install

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# Standard autotools configure. Non autotools based projects must do something
# different here.
$(PR).configured: $(PR).patched $(PR).start
ifeq ($(NEWTYPE),y)
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
else
	# Nothing to configure
endif
	touch $@

# Build the project. For projects with broken dependencies, you may need to
# replace -j$(PROCS) with -j1
$(PR).done: $(PR).configured
ifeq ($(NEWTYPE),y)
	(cd src && $(MAKE) -j$(PROCS) )
else
	# We build in install
endif
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call 'scatter_install.sh -h'
# for more information.
$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
ifeq ($(NEWTYPE),y)
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" install )
else
	# The whole build happens here. It's in a bad shape and needs -j1
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" \
		USE_LOG=true USE_SELINUX=false \
		EXTRAS="extras/usb_id extras/scsi_id extras/volume_id" \
		udevdir=/dev V=1 install )
	#udevstart is not installed by make install
	cp src/udevstart "$(TEMPINSTALL)"/sbin/
endif
	# copy libudev to install directory
	cp src/libudev.a "$(TEMPINSTALL)"/lib/
	install -d "$(TEMPINSTALL)/include/"
	( cd src/ && install udev.h list.h logging.h udev_sysdeps.h udev_version.h udevd.h "$(TEMPINSTALL)"/include/ )
	scatter_install.sh -s $(TARGET)-strip -l -b \
		"$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-D /etc/udev \
		-D /lib/udev

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
