#
# pptp build
#


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := pptp
$(PR)_VERSION ?= 1.7.0

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

export CC=$(CROSS_COMPILE)gcc
export LD=$(CROSS_COMPILE)ld

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


all:
	@echo "Don't invoke this directly!"

#
# The following rules can most likely be left alone if the
# project is based on GNU autotools. If not, modify as
# needed. Only the $(PR).start, $(PR).done and $(PR).install
# targets are mandatory.
#

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# Build the project. For projects with broken internal dependencies, you may
# need to replace -j$(PROCS) with -j1
$(PR).done: $(PR).patched $(PR).start
	# Have to override internal makefile variables
	(cd src && $(MAKE) CC=$(CC) LD=$(LD) CFLAGS='$(CFLAGS)' LDFLAGS='$(LDFLAGS)' -j$(PROCS) )
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call
# 'scatter_install.sh -h' for more information.
$(PR).install: $(PR).done
	cp "src/pptp" "$(INSTDIR)/usr/sbin/"
	$(CROSS_COMPILE)strip "$(INSTDIR)/usr/sbin/pptp"
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
