# Build openswan

# TODO: Fix the install - use temporary files and scatter_install
# The current install is full of unstriped binaries and solibs

# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := openswan
$(PR)_VERSION ?= 2.6.32

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)


#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE) -Wall -W -Wno-override-init -Wno-missing-field-initializers
export LDFLAGS := -L$(CDCS_LIB)

TEMPINSTALL := $(CPATH)/install

export CC:=$(CROSS_COMPILE)gcc
export LD:=$(CROSS_COMPILE)ld
export STRIP:=$(CROSS_COMPILE)strip

export KERNELSRC=$(KDIR)
export OSDEP=linux

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

$(PR).done: $(PR).patched $(PR).start
	echo "current Path is:$(PATH)";
	# This allows a re-install
	rm -rf "$(TEMPINSTALL)"/etc/ipsec.d
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" programs install )
	# Not sure if this is still necessary - the kernel is supposed to support ipsec already
	-(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" module minstall )
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" ipkg_strip )
	touch $@

$(PR).install: $(PR).done
	rm -rf "$(TEMPINSTALL)"/etc/ipsec.d
	mkdir "$(TEMPINSTALL)"/etc/ipsec.d
	mkdir "$(TEMPINSTALL)"/lib/
	ln -s /usr/local/cdcs/ipsec.d/aacerts "$(TEMPINSTALL)"/etc/ipsec.d/aacerts
	ln -s /usr/local/cdcs/ipsec.d/cacerts "$(TEMPINSTALL)"/etc/ipsec.d/cacerts
	ln -s /usr/local/cdcs/ipsec.d/certs "$(TEMPINSTALL)"/etc/ipsec.d/certs
	ln -s /usr/local/cdcs/ipsec.d/crls "$(TEMPINSTALL)"/etc/ipsec.d/crls
	ln -s /usr/local/cdcs/ipsec.d/ocspcerts "$(TEMPINSTALL)"/etc/ipsec.d/ocspcerts
	ln -s /usr/local/cdcs/ipsec.d/policies "$(TEMPINSTALL)"/etc/ipsec.d/policies
	ln -s /usr/local/cdcs/ipsec.d/private "$(TEMPINSTALL)"/etc/ipsec.d/private
	ln -s /usr/local/cdcs/ipsec.d/rsakey "$(TEMPINSTALL)"/etc/ipsec.d/rsakey
	# Not all platforms generate modules
	-(cd lib && cp -rv --parents modules/* "$(TEMPINSTALL)"/lib/ )
	scatter_install.sh -s $(STRIP) "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-b -l -D /etc -D /usr/netipsec -D /var

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install lib
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
