#
# Openssl build
#

# Project name, version number and tarball extension. Project name
# must match the name of the *.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := openssl
$(PR)_VERSION ?= 0.9.8y

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

# Config settings, per platform
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#
CONFIG_PRESETS :=
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := $(TARGET) zlib-dynamic

# On some systems, we have non-obvious target names, overriding

ifeq ($(PLATFORM),Arachnid)
	CONFIG_OPTS := uClinux-Arachnid no-zlib
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)
	LDFLAGS:=
	# Ubicom compiler has bugs in the code generator. Fiddling optimisation settings to bypass...
	CFLAGS += -O2
endif

ifeq ($(TARGET),mipsel-linux)
	CONFIG_OPTS := linux-mipsel zlib-dynamic
endif

# Temporary install directory
TEMPINSTALL := $(CPATH)/install

CONFIG_OPTS += --prefix=/ --openssldir=/lib/ssl --install_prefix=${TEMPINSTALL} \
	-L${TEMPINSTALL}/lib -ldl -I${TEMPINSTALL}/include  \
	threads shared no-asm no-sse2


# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
# WARNING: the source tree is full of symlinks. If you get reversed patch errors,
# the patch file contains patches to symlinks. Remove them from patch file manually.
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# This is not autotools
$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) CFLAGS='$(CFLAGS)' LDFLAGS='$(LDFLAGS)' ./Configure $(CONFIG_OPTS) )
	# Editing resulting makefile. Couldn't find a Configure incantation to set INSTALLTOP
	# *and* INSTALL_PREFIX correctly. Empty INSTALLTOP fails install target in subdirs.
	(cd src && mv Makefile Makefile.conf)
	(cd src && cat Makefile.conf | sed "s@INSTALLTOP=@INSTALLTOP=/@" >Makefile)
	touch $@

# Build the project. Some versions have broken dependencies, single
# threaded compile only. Also, the Perl-based build system gets the
# CC variable wrong and sets it to $(TARGET)-$(TARGET)-gcc. Overriding.
$(PR).done: $(PR).configured
	(cd src && $(MAKE) CC=$(CROSS_COMPILE)gcc -j1 )
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call 'scatter_install.sh -h'
# for more information.
$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && INSTDIR="$(TEMPINSTALL)" $(MAKE) -j1 install )
	chmod 777 "$(TEMPINSTALL)"/lib/lib*.so.*
	$(TARGET)-strip "$(TEMPINSTALL)"/lib/lib*.so.*
	chmod 555 "$(TEMPINSTALL)"/lib/lib*.so.*
	scatter_install.sh -s $(TARGET)-strip -f bin/openssl -l "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)"

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
