# Build openssh
# TODO: Cleanup

# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := openssh
$(PR)_VERSION ?= 7.2p2

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)
PLATFORM_PATCHES := $(wildcard $(CPATH)/patches/$(VER)/$(PLATFORM)/*.patch)


#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

# Config settings
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#
CONFIG_PRESETS :=ac_cv_path_CAT=/bin/cat ac_cv_path_AR=/usr/bin/ar ac_cv_path_KILL=/bin/kill ac_cv_path_SED=/bin/sed
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386 --with-ssh1
CONFIG_OPTS += --prefix=/usr --sysconfdir=/etc/ssh

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

# binaries to install into /usr/bin on the target
APPS := sshd ssh-keygen

STRIP:=$(CROSS_COMPILE)strip

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	(cd src && for i in $(PLATFORM_PATCHES); do patch -p1 <$$i; done )
	touch $@

$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
	touch $@

$(PR).done: $(PR).configured
	( cd src && $(MAKE) -j$(PROCS) )
	touch $@

$(PR).install: $(PR).done
	# install sshd
	install -m 0755 -d "$(INSTDIR)/usr/sbin/"
	install -m 0755 "src/sshd" "$(INSTDIR)/usr/sbin/sshd"
	$(STRIP) "$(INSTDIR)/usr/sbin/sshd"
	# install ssh-keygen
	install -m 0755 -d "$(INSTDIR)/usr/bin/"
	install -m 0755 "src/ssh-keygen" "$(INSTDIR)/usr/bin/ssh-keygen"
	$(STRIP) "$(INSTDIR)/usr/bin/ssh-keygen"
	# install startup script to init.d
	install -m 0755 -d "$(INSTDIR)/etc/init.d/rc.d/"
	install -m 0755 -d "$(INSTDIR)/etc/init.d/rc2.d/"
	install -m 0755 "src/opensshd.init" "$(INSTDIR)/bin/opensshd.init"
	# install ssh config
#	install -m 0755 -d "$(INSTDIR)/etc/ssh"
#	install -m 0644 "sshd_config" "$(INSTDIR)/etc/ssh/sshd_config"
	# install empty
ifneq ($(PLATFORM),Serpent)
	install -m 0755 -d "$(INSTDIR)/var/empty/"
else
	install -m 0755 -d "$(INSTDIR)/var_ro/empty/"
endif
ifneq ($(PLATFORM),Antelope)
	# install sftp-server
	install -m 0755 -d "$(INSTDIR)/usr/libexec/"
	install -m 0755 "src/sftp-server" "$(INSTDIR)/usr/libexec/sftp-server"
	$(STRIP) "$(INSTDIR)/usr/libexec/sftp-server"
	# install sftp
	install -m 0755 -d "$(INSTDIR)/usr/bin/"
	install -m 0755 "src/sftp" "$(INSTDIR)/usr/bin/sftp"
	$(STRIP) "$(INSTDIR)/usr/bin/sftp"
	# install ssh
	install -m 0755 -d "$(INSTDIR)/usr/bin/"
	install -m 0755 "src/ssh" "$(INSTDIR)/usr/bin/ssh"
	$(STRIP) "$(INSTDIR)/usr/bin/ssh"
	# install scp
	install -m 0755 -d "$(INSTDIR)/usr/bin/"
	install -m 0755 "src/scp" "$(INSTDIR)/usr/bin/scp"
	$(STRIP) "$(INSTDIR)/usr/bin/scp"
else
	# install sftp-server
	install -m 0755 -d "$(INSTDIR)/usr/sbin/"
	install -m 0755 "src/sftp-server" "$(INSTDIR)/usr/sbin/sftp-server"
	$(STRIP) "$(INSTDIR)/usr/sbin/sftp-server"
endif

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
