# Build ntpd

# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := ntp
$(PR)_VERSION ?= 4.2.6

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)
NBN_PATCHES :=

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

# Config settings
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#

CONFIG_PRESETS :=sc_cv_sys_crdly_shift=9 sc_cv_sys_tabdly_shift=11 sc_cv_sys_csize_shift=4 \
		sc_cv_termios_ispeed='no'
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386
CONFIG_OPTS += --prefix=/usr \
	--disable-readline --disable-libwrap --disable-fips \
	--enable-transparent-proxy --enable-upstream

ifeq ($(PLATFORM),Arachnid)
	# Arachnid is special
	CFLAGS:=-Os -pie -fPIE -fPIC -DPIC -Dfork=vfork
	LDFLAGS:=-lgcc -pie -fPIE -fPIC -DPIC
	CONFIG_OPTS := --host=ubicom32-linux --target=ubicom32-linux --build=i386
	CONFIG_OPTS += --prefix=/usr --disable-readline --disable-libwrap --disable-fips
	CONFIG_OPTS += --with-pic
	NBN_PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch.nbn)
else ifeq ($(PLATFORM),Antelope)
	NBN_PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch.nbn)	
endif

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

STRIP := $(CROSS_COMPILE)strip

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xvf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	(cd src && for i in $(NBN_PATCHES); do patch -p1 <$$i; done  )
	touch $@

$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
	touch $@
	
$(PR).done: $(PR).configured
	( cd src && $(MAKE) -j$(PROCS) )
	touch $@

$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" install )
	# Cherry-picking, to avoid installing too much
	scatter_install.sh -l -s $(CROSS_COMPILE)strip "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-f /usr/bin/ntpd \
		-f /usr/bin/ntpdate \
		-f /usr/bin/tickadj
	# Little adjust to match old buildroot arrangement
	mkdir -p "$(INSTDIR)/usr/sbin"
	mv "$(INSTDIR)/usr/bin/ntpd" "$(INSTDIR)/usr/sbin/ntpd"

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done


$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package


.PHONY: $(PR).clean $(PR).install
