#
# net-snmp build
#


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := net-snmp
$(PR)_VERSION ?= 5.7.2.1

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

# Config settings
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#

CONFIG_PRESETS :=
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --prefix=/usr --host=$(TARGET) --target=$(TARGET) --build=i386 --disable-debugging --with-security-modules="usm" --with-transports=UDP --without-kmem-usage --enable-applications --disable-manuals --enable-scripts --disable-shared --disable-mib-loading --without-perl-modules --disable-embedded-perl --with-out-mib-modules="mibII/tcpTable notification notification-log-mib target agent_mibs disman/event disman/schedule utilities host" --with-defaults --with-endianness=little --with-openssl=$(CDCS_LIBSTAGE) --with-enterprise-oid=$(V_SNMP_ENTERPRISE_OID)

ifneq ($(V_BLUETOOTH),none)
CONFIG_OPTS += --with-mib-modules="bluetoothPairedDevices"
endif

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


all:
	@echo "Don't invoke this directly!"

#
# The following rules can most likely be left alone if the
# project is based on GNU autotools. If not, modify as
# needed. Only the $(PR).start, $(PR).done and $(PR).install
# targets are mandatory.
#

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
ifneq ($(V_BLUETOOTH),none)
	cp bluetoothPairedDevices.c src/agent/mibgroup/
	cp bluetoothPairedDevices.h src/agent/mibgroup/
endif
	touch $@

# Standard autotools configure. Non autotools based projects must do something
# different here.
$(PR).configured: $(PR).patched $(PR).start
	(cd src && CFLAGS="-Os" LDFLAGS=-L$(CDCS_LIB) ./configure $(CONFIG_OPTS) )
	touch $@

# Build the project. For projects with broken internal dependencies, you may
# need to replace -j$(PROCS) with -j1
$(PR).done: $(PR).configured
ifneq ($(V_BLUETOOTH),none)
	(cd src && $(MAKE) -j1 )
else
	(cd src && $(MAKE) -j$(PROCS) )
endif
	touch $@

# snmp configuration
miboid.conf: ./gen_snmp_conf.sh
	./$^ > ./$@
	# copy mib configurations
	install -m 0755 -d $(INSTDIR)/etc/cdcs/conf
	install -m 0644 ./$@ $(INSTDIR)/etc/cdcs/conf/$@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call
# 'scatter_install.sh -h' for more information.
$(PR).install: $(PR).done miboid.conf 
	mkdir -p "$(TEMPINSTALL)"
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" install )
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
	-f /usr/sbin/snmpd -f /usr/bin/snmptrap -f /usr/bin/agentxtrap
	touch $@

# Same as install, but creates package
$(PR).package: $(PR).done netcomm-package.install
	mkdir -p "$(TEMPINSTALL)"
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" install )
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)/$(PR)" \
	"$(CDCS_LIBSTAGE)" -f /usr/local/sbin/snmpd -f /usr/local/bin/snmptrap -f /usr/bin/agentxtrap \
	--ipk CONTROL
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package miboid.conf

.PHONY: $(PR).clean $(PR).install
