#!/bin/sh

#
# !!! warning !!!
#
# The oid sequence is important and it has to be matching .MIB file.
#
# DO NOT CHANGE THE SEQUENCE IF YOU ARE NOT SURE
#


print_base_conf() {
	cat << EOF
# snmp script configuration file generated by gen_snmp_conf.sh
#
# OPT_ACT	snmp action
# OPT_OID	miboid number
# OPT_TYPE	type of miboid object
# OPT_VALUE	new value
#

# standard OIDs
.1.3.6.1.2.1.25.1.1.0       	integer	{sed "s/\..*//" /proc/uptime} # Uptime

# version
.1.3.6.1.4.1.24063.1.1.1.1.0	string	{if rdb_get uboot.hw_ver >/dev/null 2>/dev/null; then rdb_get uboot.hw_ver; else rdb_get hw.version; fi}
.1.3.6.1.4.1.24063.1.1.1.2.0	string	{if [ -f /etc/version.txt ]; then  head -n 1 /etc/version.txt; else echo "n/a"; fi}
.1.3.6.1.4.1.24063.1.1.1.3.0	string	{rdb_get uboot.sn}

# modem
.1.3.6.1.4.1.24063.1.1.2.1.0	string	{rdb_get wwan.0.model}
.1.3.6.1.4.1.24063.1.1.2.2.0	string	{rdb_get wwan.0.hardware_version}
.1.3.6.1.4.1.24063.1.1.2.3.0	string	{rdb_get wwan.0.firmware_version}
.1.3.6.1.4.1.24063.1.1.2.4.0	integer	{rdb_get wwan.0.radio.temperature}
.1.3.6.1.4.1.24063.1.1.2.5.0	string	{rdb_get wwan.0.imei}
EOF
	if [ "$V_CELL_NW" = "cdma" ]; then
		cat << EOF
.1.3.6.1.4.1.24063.1.1.2.6.0	string	{rdb_get wwan.0.module_info.cdma.MDN}
EOF
fi
	# sim status
	if [ "$V_CELL_NW" = "umts" -o "$PLATFORM" = "Platypus" ]; then
		cat << EOF
# sim
.1.3.6.1.4.1.24063.1.1.3.1.0	string	{rdb_get wwan.0.system_network_status.simICCID}			# SIM ICCID
.1.3.6.1.4.1.24063.1.1.3.2.0	string	{rdb_get wwan.0.sim.status.status}
EOF
	elif [ "$V_CELL_NW" = "cdma" ]; then
		cat << EOF
# cdma - no sim status
EOF
	else
		cat << EOF
# unknown module type for SIM card status - $V_CELL_NW
EOF
	fi

	# umts radio
	if [ "$V_CELL_NW" = "umts" -o "$PLATFORM" = "Platypus" ]; then
		cat << EOF
# radio
.1.3.6.1.4.1.24063.1.1.4.1.0	integer	{rdb_get wwan.0.system_network_status.PSCs0} 			# PSC
.1.3.6.1.4.1.24063.1.1.4.2.0	integer	{rdb_get wwan.0.system_network_status.LAC}
.1.3.6.1.4.1.24063.1.1.4.3.0	integer	{rdb_get wwan.0.system_network_status.RAC}
.1.3.6.1.4.1.24063.1.1.4.4.0	integer	{rdb_get wwan.0.system_network_status.ChannelNumber}		# ARFCN
EOF
	fi

	cat << EOF
.1.3.6.1.4.1.24063.1.1.4.5.0	integer	{rdb_get wwan.0.radio.information.signal_strength | sed s/dBm//g}
#.1.3.6.1.4.1.24063.1.1.4.6.0	string {echo "n/a"} # target band
.1.3.6.1.4.1.24063.1.1.4.7.0	string	{rdb_get wwan.0.system_network_status.current_band}

.1.3.6.1.4.1.24063.1.1.4.10.0	string  {if [ "\$(rdb_get wwan.0.system_network_status.ECN0_valid)" = "1" ]; then temp="\$(rdb_get wwan.0.system_network_status.ECN0s0)"; else temp="\$(rdb_get wwan.0.radio.information.ecio0)"; fi; if [ -n "\$temp" ]; then echo "-\$temp"; else echo 'n/a'; fi}
.1.3.6.1.4.1.24063.1.1.4.11.0	string  {if [ "\$(rdb_get wwan.0.system_network_status.ECN0_valid)" = "1" ]; then temp="\$(rdb_get wwan.0.system_network_status.ECN0s1)"; else temp="\$(rdb_get wwan.0.radio.information.ecio1)"; fi; if [ -n "\$temp" ]; then echo "-\$temp"; else echo 'n/a'; fi}
.1.3.6.1.4.1.24063.1.1.4.12.0	string  {if [ -n "\$(rdb_get wwan.0.system_network_status.RSCPs0)" ]; then temp="\$(rdb_get wwan.0.system_network_status.RSCPs0)"; else temp="\$(rdb_get wwan.0.radio.information.rscp0)"; fi; if [ -n "\$temp" ]; then echo "-\$temp"; else echo 'n/a'; fi}
.1.3.6.1.4.1.24063.1.1.4.13.0	string  {if [ -n "\$(rdb_get wwan.0.system_network_status.RSCPs1)" ]; then temp="\$(rdb_get wwan.0.system_network_status.RSCPs1)"; else temp="\$(rdb_get wwan.0.radio.information.rscp1)"; fi; if [ -n "\$temp" ]; then echo "-\$temp"; else echo 'n/a'; fi}
.1.3.6.1.4.1.24063.1.1.4.14.0	string  {rdb_get wwan.0.system_network_status.PCID}
.1.3.6.1.4.1.24063.1.1.4.15.0	string  {rdb_get wwan.0.signal.0.rsrp}
.1.3.6.1.4.1.24063.1.1.4.16.0	string  {rdb_get wwan.0.signal.rsrq}
EOF

	# cdma radio
	if [ "$V_CELL_NW" = "cdma" ]; then
		cat << EOF
# radio cdma
.1.3.6.1.4.1.24063.1.1.4.20.0	integer	{rdb_get wwan.0.system_network_status.1xrttpn}
.1.3.6.1.4.1.24063.1.1.4.21.0	integer {rdb_get wwan.0.system_network_status.1xevdopn}
.1.3.6.1.4.1.24063.1.1.4.22.0	integer	{rdb_get wwan.0.system_network_status.1xrttchannel}
.1.3.6.1.4.1.24063.1.1.4.23.0	integer {rdb_get wwan.0.system_network_status.1xevdochannel}
EOF
	fi

	if [ "$V_CELL_NW" = "umts" -o "$PLATFORM" = "Platypus" ]; then
		cat << EOF
# link
.1.3.6.1.4.1.24063.1.1.5.1.0	string	{rdb_get wwan.0.system_network_status.network.unencoded}
EOF
	fi

	cat << EOF
.1.3.6.1.4.1.24063.1.1.5.2.0	string	{rdb_get wwan.0.system_network_status.system_mode}
.1.3.6.1.4.1.24063.1.1.5.3.0	integer	{stat=\$(rdb_get wwan.0.system_network_status.pdp0_stat); if [ "\$stat" = "up" -o "\$stat" = "1" ]; then echo 1; else echo 0; fi}
#.1.3.6.1.4.1.24063.1.1.5.4.0	string {echo "n/a"} # link state reason
.1.3.6.1.4.1.24063.1.1.5.5.0	integer	{rdb_get wwan.0.system_network_status.CellID}
.1.3.6.1.4.1.24063.1.1.5.6.0	integer	{if test "\$(rdb_get link.profile.1.enable)" = 1 && test "\$(rdb_get link.profile.1.status)" = "up"; then echo 1; else echo 0; fi}
EOF
	# gps
	if [ -n "$V_GPS" -a "$V_GPS" != "none" ]; then
		cat << EOF
# gps
.1.3.6.1.4.1.24063.1.1.7.1.0	string	{netcomm_gps_coordinates 2> /dev/null}	# Latitude
.1.3.6.1.4.1.24063.1.1.7.2.0	string	{netcomm_gps_coordinates -o 2> /dev/null}	# Longitude

.1.3.6.1.4.1.24063.1.1.8.1.0	integer	{rdb_get sensors.gps.0.odometer}				# Odometer reading
.1.3.6.1.4.1.24063.1.1.8.2.0	string	{rdb_get sensors.gps.0.odometer.starttime}		# Odometer start time
.1.3.6.1.4.1.24063.1.1.8.3.0	string	{rdb_get sensors.gps.0.odometer_enable}	{rdb_set -p sensors.gps.0.odometer_enable "\$OPT_VALUE"}	# start/stop the odometer
.1.3.6.1.4.1.24063.1.1.8.4.0	integer	{rdb_get sensors.gps.0.odometer_miles}	{rdb_set -p sensors.gps.0.odometer_miles "\$OPT_VALUE"}	# display unit on UI
.1.3.6.1.4.1.24063.1.1.8.5.0	string	{rdb_get sensors.gps.0.odometer_reset} {rdb_set sensors.gps.0.odometer_reset "\$OPT_VALUE"}			# reset odometer to zero
.1.3.6.1.4.1.24063.1.1.8.6.0	integer	{rdb_get sensors.gps.0.odometer_threshold} {rdb_set -p sensors.gps.0.odometer_threshold "\$OPT_VALUE"}	# Odometer threshold
EOF
	fi

	# bluetooth
	if [ -n "$V_BLUETOOTH" -a "$V_BLUETOOTH" != "none" ]; then
		cat << EOF
.1.3.6.1.4.1.24063.1.1.9.1.0	integer	{rdb_get bluetooth.conf.enable} {if [ "\$OPT_VALUE" = "0" -o "\$OPT_VALUE" = "1" ]; then rdb_set bluetooth.conf.enable "\$OPT_VALUE";else echo "wrong-type";fi} # bluetooth enable
.1.3.6.1.4.1.24063.1.1.9.2.0	string	{rdb_get bluetooth.conf.name} {if [ -n "\$OPT_VALUE" ];then rdb_set bluetooth.conf.name "\$OPT_VALUE";rdb_set bluetooth.conf.enable \$(rdb_get bluetooth.conf.enable);else echo "wrong-type";fi} # bluetooth device name
.1.3.6.1.4.1.24063.1.1.9.3.0	integer	{rdb_get bluetooth.conf.pairable} {if [ "\$OPT_VALUE" = "0" -o "\$OPT_VALUE" = "1" ];then rdb_set bluetooth.conf.pairable "\$OPT_VALUE";rdb_set bluetooth.conf.enable \$(rdb_get bluetooth.conf.enable);else echo "wrong-type";fi} # bluetooth pairable
.1.3.6.1.4.1.24063.1.1.9.4.0    integer {rdb_get bluetooth.conf.discoverable_timeout} {local found=0;local valid_values=\$(rdb get bluetooth.conf.discoverable_timeout_options | tr "," "\\n");for i in \$valid_values; do test \$i -eq \$OPT_VALUE 2>/dev/null && found=1 && break;done;if [ "\$found" = "1" ];then rdb_set bluetooth.conf.discoverable_timeout "\$OPT_VALUE";rdb_set bluetooth.conf.enable \$(rdb_get bluetooth.conf.enable);else echo "wrong-type";fi} # bluetooth discoverable timeout
EOF
	fi

	# network quality
	if [ -n "$V_SPEED_TEST" -a "$V_SPEED_TEST" != "none" ]; then
		cat << EOF
# network quality
.1.3.6.1.4.1.24063.1.1.10.1.0	string	{rdb_get service.speedtest.datetime}				# last update date & time
.1.3.6.1.4.1.24063.1.1.10.2.0	string	{rdb_get service.speedtest.server}					# Server information
.1.3.6.1.4.1.24063.1.1.10.3.0	string	{rdb_get service.speedtest.latency}					# Network latency
.1.3.6.1.4.1.24063.1.1.10.4.0	string	{rdb_get service.speedtest.download}				# Download speed
.1.3.6.1.4.1.24063.1.1.10.5.0	string	{rdb_get service.speedtest.upload}					# Upload speed
.1.3.6.1.4.1.24063.1.1.10.6.0	integer	{rdb_get service.speedtest.trigger} {rdb_set -p service.speedtest.trigger} "\$OPT_VALUE"}	# Update network speed
EOF
	fi

		cat << EOF
# snmp trap oids
.1.3.6.1.4.1.24063.100.1.1.0    string  {echo "Use SET to trigger a heartbeat"} {/usr/sbin/cdcs_heartbeat once} # Send heartbeat
EOF
		if [ "$PLATFORM" = "Bovine" ]; then
			cat << EOF
.1.3.6.1.4.1.24063.100.1.2.0	string	{echo "Use SET to reboot"} {logger -t "snmp_script" "reboot" && rdb_set service.system.reset "1"} # REBOOT
EOF
		else
			cat << EOF
.1.3.6.1.4.1.24063.100.1.2.0	string	{echo "Use SET to reboot"} {/bin/reboot} # REBOOT
EOF
		fi
		cat << EOF
.1.3.6.1.4.1.24063.100.1.3.0	integer	{rdb_get service.snmp.trap_persist} {rdb_set -p service.snmp.trap_persist "\$OPT_VALUE"} # Trap Persistence
.1.3.6.1.4.1.24063.100.1.4.0	integer	{rdb_get service.snmp.trap_resend} {rdb_set -p service.snmp.trap_resend "\$OPT_VALUE"} # Trap Persistence
.1.3.6.1.4.1.24063.100.1.5.0	integer {rdb_get service.snmp.heartbeat_interval} {rdb_set -p service.snmp.heartbeat_interval "\$OPT_VALUE"} # How often to send heartbeat (seconds)
.1.3.6.1.4.1.24063.100.1.6.0	string	{rdb_get service.snmp.snmp_trap_dest} {rdb_set -p service.snmp.snmp_trap_dest "\$OPT_VALUE"} # Where to send traps (IP address)
EOF

	# upgrade
	if [ "$PLATFORM" = "Bovine" ]; then
		cat << EOF
# upgrade
.1.3.6.1.4.1.24063.100.2.1.0	string  {echo "Set URL to upload a config file"} {cdcs_upload -o "\$OPT_VALUE" 2> /dev/null > /dev/null &}
.1.3.6.1.4.1.24063.100.2.2.0 	string	{echo "Set a config file name to install"} {cd /opt/cdcs/upload && /usr/bin/install_file "\$OPT_VALUE" 2> /dev/null  | logger -t "snmp_script" &}
.1.3.6.1.4.1.24063.100.3.1.0	string  {echo "Set URL to upload a file"} { cdcs_upload -o "\$OPT_VALUE" 2> /dev/null > /dev/null &}
.1.3.6.1.4.1.24063.100.3.2.0	string  {echo "Set a file name to install"} {cd /opt/cdcs/upload && /usr/bin/install_file "\$OPT_VALUE" 2> /dev/null | logger -t "snmp_script" &}
.1.3.6.1.4.1.24063.100.3.3.0	string  {echo "Use SET to do a factory reset"} {schedule_at_startup_rdb_restore.sh 2>&1 && dbcfg_default -f 2>&1 | logger -t "snmp_script"; rdb_set service.system.reset "1"}
EOF
	elif [ "$PLATFORM" = "Platypus2" ]; then
		cat << EOF
# upgrade
.1.3.6.1.4.1.24063.100.2.1.0	string  {echo "Set URL to upload a config file"} {cdcs_upload "\$OPT_VALUE" 2> /dev/null > /dev/null &}
.1.3.6.1.4.1.24063.100.2.2.0 	string	{echo "Set a config file name to install"} {cd /opt/cdcs/upload && cdcs_restore_config "\$OPT_VALUE" 2> /dev/null > /dev/null &}
.1.3.6.1.4.1.24063.100.3.1.0	string  {echo "Set URL to upload a firmware file"} {cdcs_upload "\$OPT_VALUE" 2> /dev/null > /dev/null &}
.1.3.6.1.4.1.24063.100.3.2.0	string  {echo "Set a firmware file name to upgrade"} {cd /opt/cdcs/upload && /usr/sbin/cdcs_install "\$OPT_VALUE" 2> /dev/null > /dev/null &}
EOF
	fi
}

print_base_conf
