# Build mtd-utils
#
# This build currently uses the mtd-utils GIT repository
# directly. Different versions for different platforms is
# not as yet supported.
#
# When development of mtd-utils stabilises, we can extract
# a few relevant releases from git and the use the normal
# gnu_apps mechanism to select them.
#

# Not all binaries will cross-compile correctly, so we have
# to selectively invoke builds just for the binaries we need.
APPS := flash_erase flash_eraseall ubi-utils/mtdinfo flashcp mtd_debug \
	nanddump nandtest nandwrite ubi-utils/ubimkvol ubi-utils/ubiattach \
	ubi-utils/ubirmvol ubi-utils/ubiformat ubi-utils/ubidetach ubi-utils/ubiupdatevol

# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
PR := mtd-utils
$(PR)_VERSION ?= not_supported

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

# Config settings
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
TARGET := $(BUILD_TARGET)

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

export CROSS=$(CROSS_COMPILE)


all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# Build rule that deals with subdirectories / subprojects
src/%: $(PR).patched $(PR).start
	echo "Building $@"
	(cd src && $(MAKE) -j1 V=1 BUILDDIR='.' CROSS=$(CROSS_COMPILE) \
		$(patsubst src/%,%,$@ ); )

# The subdirectory build rules have concurrency issues, so we
# must invoke the builds serially
.NOTPARALLEL:
$(PR).done: $(patsubst %,src/%,$(APPS) )
	touch $@

$(PR).install: $(PR).done
	mkdir -p '$(TEMPINSTALL)/bin'
	cp $(patsubst %,'src/%',$(APPS) ) '$(TEMPINSTALL)/bin/'
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-b -l
	touch $@

$(PR).package: $(PR).done
	mkdir -p '$(TEMPINSTALL)/bin'
	cp $(patsubst %,'src/%',$(APPS) ) '$(TEMPINSTALL)/bin/'
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)/$(PR)" \
	"$(CDCS_LIBSTAGE)" -b -l --ipk CONTROL
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
