# Build lua or luajit

# ======== COMMON =========

# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := lua
$(PR)_VERSION ?= $(PR)-5.1.4

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

ARCHIVE := $(wildcard $($(PR)_VERSION).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$($(PR)_VERSION)/*.patch)

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $($(PR)_VERSION) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@


$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install $(PR).distclean
# ======== END COMMON =========

ifeq (,$(findstring JIT,$($(PR)_VERSION)))
# ======== PUC-Rio Lua only =========
TARGET := $(BUILD_TARGET)

export CFLAGS := -Wall -W -Os -I$(CDCS_INCLUDE) -fPIC
export LDFLAGS := -L$(CDCS_LIB)
CFLAGS += -DLUA_USE_LINUX
MYLDFLAGS := $(LDFLAGS)

ifeq ($(ARCH),ubicom32)
	# Arachnid is special
	export CFLAGS:=$(PLATFORM_CFLAGS) -DLUA_USE_LINUX
	MYLDFLAGS=
endif

export CC:=$(CROSS_COMPILE)gcc
export LD:=$(CROSS_COMPILE)ld
export STRIP:=$(CROSS_COMPILE)strip

$(PR).done: $(PR).patched $(PR).start
	(cd src && $(MAKE) -j$(PROCS) linux CC=$(CC) CFLAGS='$(CFLAGS)' MYLDFLAGS=$(MYLDFLAGS))
	touch $@

$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	# Lua binaries *must* be installed into /usr/bin, everything relies on that.
	# But the libraries must stay in /lib
	(cd src && $(MAKE) -j1 INSTALL_TOP="$(TEMPINSTALL)" INSTALL_BIN="$(TEMPINSTALL)/usr/bin"  install )
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-l -f /usr/bin/lua
	touch $@

# ======== END PUC-Rio Lua only =========
else
# ======== LuaJIT only =========
export CROSS:=$(CROSS_COMPILE)
# the -m32 is required for this to build correctly on a 64-bit host
export HOST_CC:=gcc -m32
export HOST_CFLAGS:=
export HOST_SYS:=Linux
export TARGET_SYS:=Linux
export DESTDIR=$(INSTDIR)
TEMPINSTALL := $(CPATH)/install

# You can override the following variables at the make command line:
#   CC       HOST_CC       STATIC_CC       DYNAMIC_CC
#   CFLAGS   HOST_CFLAGS   TARGET_CFLAGS
#   LDFLAGS  HOST_LDFLAGS  TARGET_LDFLAGS  TARGET_SHLDFLAGS
#   LIBS     HOST_LIBS     TARGET_LIBS
#   CROSS    HOST_SYS      TARGET_SYS      TARGET_FLAGS
#
# Cross-compilation examples:
#   make HOST_CC="gcc -m32" CROSS=i586-mingw32msvc- TARGET_SYS=Windows
#   make HOST_CC="gcc -m32" CROSS=powerpc-linux-gnu-

TARGET := $(BUILD_TARGET)

ifeq ($(ARCH),arm)
	export TARGET_CFLAGS:=-Wall -W -Os -mfpu=neon -funsafe-math-optimizations
	MYLDFLAGS=
else ifeq ($(ARCH),ubicom32)
	# Arachnid
	export TARGET_CFLAGS:=$(PLATFORM_CFLAGS)
	MYLDFLAGS=
else ifeq ($(ARCH),i386)
	export TARGET_CFLAGS:="-Wall -W -O2"
	MYLDFLAGS=
else
	# Platypus2
	export TARGET_CFLAGS:=-Wall -W -Os -I$(SBASE)/RT288x_SDK/source/lib/libreadline -DLUA_USE_LINUX
	MYLDFLAGS=-L$(SBASE)/RT288x_SDK/source/romfs/lib -L$(SBASE)/RT288x_SDK/source/lib/libreadline
endif

ifeq ($(PLATFORM),Platypus)
	LUALIBDIR=lib
else
	LUALIBDIR=usr/lib
endif

$(PR).done: $(PR).patched $(PR).start
	# First stage needs to know host
	hostincludes.sh enable
	(cd src && $(MAKE) -j$(PROCS) all TARGET_CFLAGS="$(TARGET_CFLAGS)" CROSS=$(CROSS) HOST_CC="$(HOST_CC)" HOST_CFLAGS="$(HOST_CFLAGS)" HOST_SYS="$(HOST_SYS)" TARGET_SYS="$(TARGET_SYS)" DESTDIR="$(DESTDIR)")
	hostincludes.sh disable
	touch $@

$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && $(MAKE) -j$(PROCS) install TARGET_CFLAGS="$(TARGET_CFLAGS)" CROSS=$(CROSS) HOST_CC="$(HOST_CC)" HOST_CFLAGS="$(HOST_CFLAGS)" HOST_SYS="$(HOST_SYS)" TARGET_SYS="$(TARGET_SYS)" DESTDIR="$(TEMPINSTALL)")
	$(RDIR)/scripts/scatter_install.sh -s $(TARGET)-strip -l -D usr/share -b "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)"
	touch $@
# ======== END LuaJIT only =========
endif
