#
# Generic recipe template, can be also used for gnu_libs
#


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := lockfile-progs
$(PR)_VERSION ?= 0.1.16

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

CROSS_COMPILE := $(BUILD_TARGET)-
export CC=$(CROSS_COMPILE)gcc
export STRIP=$(CROSS_COMPILE)strip

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


# Using CROSS_COMPILE to access tool chain

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv main src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# Build the project.
$(PR).done: $(PR).patched $(PR).start
	(cd src && $(MAKE) -j1 )
	touch $@

# This project doesn't have an install target and needs to create hard links,
# so we do the install here, manually.
$(PR).install: $(PR).done
	mkdir -p "$(INSTDIR)/bin"
	cp src/bin/lockfile-create "$(INSTDIR)/usr/bin/"
	$(STRIP) "$(INSTDIR)/usr/bin/lockfile-create"
	ln -fs "lockfile-create" "$(INSTDIR)/usr/bin/lockfile-remove"
	ln -fs "lockfile-create" "$(INSTDIR)/usr/bin/lockfile-check"
	ln -fs "lockfile-create" "$(INSTDIR)/usr/bin/lockfile-touch"

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
