#
# libusb build
#


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := libusb
$(PR)_VERSION ?= 0.1.12

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)


# Config settings
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#

CONFIG_PRESETS :=
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386
CONFIG_OPTS += --prefix=/
CONFIG_OPTS += --disable-build-docs

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

all:
	@echo "Don't invoke this directly!"

#
# The following rules can most likely be left alone if the
# project is based on GNU autotools. If not, modify as
# needed. Only the $(PR).start, $(PR).done and $(PR).install
# targets are mandatory.
#

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# Standard autotools configure. Non autotools based projects must do something
# different here.
$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
	touch $@

# Build the project. For projects with broken internal dependencies, you may
# need to replace -j$(PROCS) with -j1
$(PR).done: $(PR).configured
	(cd src && $(MAKE) -j$(PROCS) )
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call
# 'scatter_install.sh -h' for more information.
$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && DESTDIR="$(TEMPINSTALL)" $(MAKE) -j1 install )
	scatter_install.sh -s $(TARGET)-strip -l "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)"
	ln -s -f "$(CDCS_LIBSTAGE)/bin/libusb-config" "$(CDCS_LIBSTAGE)/bin/$(TARGET)-libusb-config"
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
