#
# libcap build
#


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := libcap
$(PR)_VERSION ?= 2.22

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

TARGET := $(BUILD_TARGET)

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


all:
	@echo "Don't invoke this directly!"


# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	# Overwriting original file
	cp Make.Rules src/
	touch $@

export FAKEROOT := $(TEMPINSTALL)
export IPATH:=-I$(CDCS_INCLUDE)
export LPATH:=-L$(CDCS_LIB)
export CROSS_COMPILE

# Build the project. For projects with broken internal dependencies, you may
# need to replace -j$(PROCS) with -j1
$(PR).done: $(PR).patched $(PR).start
	# The build builds a host binary to extract capabilities from kernel includes
	hostincludes.sh enable
	(cd src && $(MAKE) -j$(PROCS) )
	hostincludes.sh disable
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call
# 'scatter_install.sh -h' for more information.
$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	# We have to ignore errors here, the installer attempts
	# to run binaries after installation
	-(cd src && $(MAKE) -j1 install )
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-b -l
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call
# 'scatter_install.sh -h' for more information.
$(PR).package: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" install )
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)/$(PR)" \
	"$(CDCS_LIBSTAGE)" -b -l --ipk CONTROL
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
